/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectDoubleBufferRU;
import java.nio.DoubleBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectDoubleBufferU
extends DoubleBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    private static final long arrayBaseOffset = unsafe.arrayBaseOffset(double[].class);
    protected static final boolean unaligned = Bits.unaligned();
    private final Object att;

    @Override
    public Object attachment() {
        return this.att;
    }

    @Override
    public Cleaner cleaner() {
        return null;
    }

    DirectDoubleBufferU(DirectBuffer db, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap);
        this.address = db.address() + (long)off;
        this.att = db;
    }

    @Override
    public DoubleBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = pos << 3;
        assert (off >= 0);
        return new DirectDoubleBufferU(this, -1, 0, rem, rem, off);
    }

    @Override
    public DoubleBuffer duplicate() {
        return new DirectDoubleBufferU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public DoubleBuffer asReadOnlyBuffer() {
        return new DirectDoubleBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public long address() {
        return this.address;
    }

    private long ix(int i) {
        return this.address + (long)(i << 3);
    }

    @Override
    public double get() {
        return unsafe.getDouble(this.ix(this.nextGetIndex()));
    }

    @Override
    public double get(int i) {
        return unsafe.getDouble(this.ix(this.checkIndex(i)));
    }

    @Override
    public DoubleBuffer get(double[] dst, int offset, int length) {
        if (length << 3 > 6) {
            int rem;
            DirectDoubleBufferU.checkBounds(offset, length, dst.length);
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (length > rem) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToLongArray(this.ix(pos), dst, offset << 3, length << 3);
            } else {
                Bits.copyToArray(this.ix(pos), dst, arrayBaseOffset, offset << 3, length << 3);
            }
            this.position(pos + length);
        } else {
            super.get(dst, offset, length);
        }
        return this;
    }

    @Override
    public DoubleBuffer put(double x) {
        unsafe.putDouble(this.ix(this.nextPutIndex()), x);
        return this;
    }

    @Override
    public DoubleBuffer put(int i, double x) {
        unsafe.putDouble(this.ix(this.checkIndex(i)), x);
        return this;
    }

    @Override
    public DoubleBuffer put(DoubleBuffer src) {
        if (src instanceof DirectDoubleBufferU) {
            int rem;
            if (src == this) {
                throw new IllegalArgumentException();
            }
            DirectDoubleBufferU sb = (DirectDoubleBufferU)src;
            int spos = sb.position();
            int slim = sb.limit();
            assert (spos <= slim);
            int srem = spos <= slim ? slim - spos : 0;
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (srem > rem) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(sb.ix(spos), this.ix(pos), srem << 3);
            sb.position(spos + srem);
            this.position(pos + srem);
        } else if (src.hb != null) {
            int spos = src.position();
            int slim = src.limit();
            assert (spos <= slim);
            int srem = spos <= slim ? slim - spos : 0;
            this.put(src.hb, src.offset + spos, srem);
            src.position(spos + srem);
        } else {
            super.put(src);
        }
        return this;
    }

    @Override
    public DoubleBuffer put(double[] src, int offset, int length) {
        if (length << 3 > 6) {
            int rem;
            DirectDoubleBufferU.checkBounds(offset, length, src.length);
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (length > rem) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromLongArray(src, offset << 3, this.ix(pos), length << 3);
            } else {
                Bits.copyFromArray(src, arrayBaseOffset, offset << 3, this.ix(pos), length << 3);
            }
            this.position(pos + length);
        } else {
            super.put(src, offset, length);
        }
        return this;
    }

    @Override
    public DoubleBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        unsafe.copyMemory(this.ix(pos), this.ix(0), rem << 3);
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

