/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DirectCharBufferRS;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectCharBufferS
extends CharBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    private static final long arrayBaseOffset = unsafe.arrayBaseOffset(char[].class);
    protected static final boolean unaligned = Bits.unaligned();
    private final Object att;

    @Override
    public Object attachment() {
        return this.att;
    }

    @Override
    public Cleaner cleaner() {
        return null;
    }

    DirectCharBufferS(DirectBuffer db, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap);
        this.address = db.address() + (long)off;
        this.att = db;
    }

    @Override
    public CharBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = pos << 1;
        assert (off >= 0);
        return new DirectCharBufferS(this, -1, 0, rem, rem, off);
    }

    @Override
    public CharBuffer duplicate() {
        return new DirectCharBufferS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        return new DirectCharBufferRS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public long address() {
        return this.address;
    }

    private long ix(int i) {
        return this.address + (long)(i << 1);
    }

    @Override
    public char get() {
        return Bits.swap(unsafe.getChar(this.ix(this.nextGetIndex())));
    }

    @Override
    public char get(int i) {
        return Bits.swap(unsafe.getChar(this.ix(this.checkIndex(i))));
    }

    @Override
    public CharBuffer get(char[] dst, int offset, int length) {
        if (length << 1 > 6) {
            int rem;
            DirectCharBufferS.checkBounds(offset, length, dst.length);
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (length > rem) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToCharArray(this.ix(pos), dst, offset << 1, length << 1);
            } else {
                Bits.copyToArray(this.ix(pos), dst, arrayBaseOffset, offset << 1, length << 1);
            }
            this.position(pos + length);
        } else {
            super.get(dst, offset, length);
        }
        return this;
    }

    @Override
    public CharBuffer put(char x) {
        unsafe.putChar(this.ix(this.nextPutIndex()), Bits.swap(x));
        return this;
    }

    @Override
    public CharBuffer put(int i, char x) {
        unsafe.putChar(this.ix(this.checkIndex(i)), Bits.swap(x));
        return this;
    }

    @Override
    public CharBuffer put(CharBuffer src) {
        if (src instanceof DirectCharBufferS) {
            int rem;
            if (src == this) {
                throw new IllegalArgumentException();
            }
            DirectCharBufferS sb = (DirectCharBufferS)src;
            int spos = sb.position();
            int slim = sb.limit();
            assert (spos <= slim);
            int srem = spos <= slim ? slim - spos : 0;
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (srem > rem) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(sb.ix(spos), this.ix(pos), srem << 1);
            sb.position(spos + srem);
            this.position(pos + srem);
        } else if (src.hb != null) {
            int spos = src.position();
            int slim = src.limit();
            assert (spos <= slim);
            int srem = spos <= slim ? slim - spos : 0;
            this.put(src.hb, src.offset + spos, srem);
            src.position(spos + srem);
        } else {
            super.put(src);
        }
        return this;
    }

    @Override
    public CharBuffer put(char[] src, int offset, int length) {
        if (length << 1 > 6) {
            int rem;
            DirectCharBufferS.checkBounds(offset, length, src.length);
            int pos = this.position();
            int lim = this.limit();
            assert (pos <= lim);
            int n = rem = pos <= lim ? lim - pos : 0;
            if (length > rem) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromCharArray(src, offset << 1, this.ix(pos), length << 1);
            } else {
                Bits.copyFromArray(src, arrayBaseOffset, offset << 1, this.ix(pos), length << 1);
            }
            this.position(pos + length);
        } else {
            super.put(src, offset, length);
        }
        return this;
    }

    @Override
    public CharBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        unsafe.copyMemory(this.ix(pos), this.ix(0), rem << 1);
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String toString(int start, int end) {
        if (end > this.limit() || start > end) {
            throw new IndexOutOfBoundsException();
        }
        try {
            int len = end - start;
            char[] ca = new char[len];
            CharBuffer cb = CharBuffer.wrap(ca);
            CharBuffer db = this.duplicate();
            db.position(start);
            db.limit(end);
            cb.put(db);
            return new String(ca);
        }
        catch (StringIndexOutOfBoundsException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public CharBuffer subSequence(int start, int end) {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        pos = pos <= lim ? pos : lim;
        int len = lim - pos;
        if (start < 0 || end > len || start > end) {
            throw new IndexOutOfBoundsException();
        }
        return new DirectCharBufferS(this, -1, pos + start, pos + end, this.capacity(), this.offset);
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

