/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.AbstractPlainSocketImpl;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.FileChannel;
import sun.misc.IoTrace;
import sun.net.ConnectionResetException;

class SocketInputStream
extends FileInputStream {
    private boolean eof;
    private AbstractPlainSocketImpl impl = null;
    private byte[] temp;
    private Socket socket = null;
    private boolean closing = false;

    SocketInputStream(AbstractPlainSocketImpl impl) throws IOException {
        super(impl.getFileDescriptor());
        this.impl = impl;
        this.socket = impl.getSocket();
    }

    @Override
    public final FileChannel getChannel() {
        return null;
    }

    private native int socketRead0(FileDescriptor var1, byte[] var2, int var3, int var4, int var5) throws IOException;

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int length) throws IOException {
        return this.read(b, off, length, this.impl.getTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    int read(byte[] b, int off, int length, int timeout) throws IOException {
        FileDescriptor fd;
        Object traceContext;
        boolean gotReset;
        int n;
        block16: {
            int n2;
            n = 0;
            if (this.eof) {
                return -1;
            }
            if (this.impl.isConnectionReset()) {
                throw new SocketException("Connection reset");
            }
            if (length <= 0 || off < 0 || off + length > b.length) {
                if (length == 0) {
                    return 0;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            gotReset = false;
            traceContext = IoTrace.socketReadBegin();
            fd = this.impl.acquireFD();
            try {
                n = this.socketRead0(fd, b, off, length, timeout);
                if (n <= 0) break block16;
                n2 = n;
                this.impl.releaseFD();
                IoTrace.socketReadEnd(traceContext, this.impl.address, this.impl.port, timeout, n > 0 ? (long)n : 0L);
            }
            catch (ConnectionResetException rstExc) {
                try {
                    gotReset = true;
                    this.impl.releaseFD();
                    IoTrace.socketReadEnd(traceContext, this.impl.address, this.impl.port, timeout, n > 0 ? (long)n : 0L);
                }
                catch (Throwable throwable) {
                    this.impl.releaseFD();
                    IoTrace.socketReadEnd(traceContext, this.impl.address, this.impl.port, timeout, n > 0 ? (long)n : 0L);
                    throw throwable;
                }
            }
            return n2;
        }
        this.impl.releaseFD();
        IoTrace.socketReadEnd(traceContext, this.impl.address, this.impl.port, timeout, n > 0 ? (long)n : 0L);
        if (gotReset) {
            block17: {
                traceContext = IoTrace.socketReadBegin();
                this.impl.setConnectionResetPending();
                this.impl.acquireFD();
                try {
                    n = this.socketRead0(fd, b, off, length, timeout);
                    if (n <= 0) break block17;
                    int rstExc = n;
                    this.impl.releaseFD();
                    IoTrace.socketReadEnd(traceContext, this.impl.address, this.impl.port, timeout, n > 0 ? (long)n : 0L);
                }
                catch (ConnectionResetException rstExc) {
                    this.impl.releaseFD();
                    IoTrace.socketReadEnd(traceContext, this.impl.address, this.impl.port, timeout, n > 0 ? (long)n : 0L);
                    catch (Throwable throwable) {
                        this.impl.releaseFD();
                        IoTrace.socketReadEnd(traceContext, this.impl.address, this.impl.port, timeout, n > 0 ? (long)n : 0L);
                        throw throwable;
                    }
                }
                return rstExc;
            }
            this.impl.releaseFD();
            IoTrace.socketReadEnd(traceContext, this.impl.address, this.impl.port, timeout, n > 0 ? (long)n : 0L);
        }
        if (this.impl.isClosedOrPending()) {
            throw new SocketException("Socket closed");
        }
        if (this.impl.isConnectionResetPending()) {
            this.impl.setConnectionReset();
        }
        if (this.impl.isConnectionReset()) {
            throw new SocketException("Connection reset");
        }
        this.eof = true;
        return -1;
    }

    @Override
    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        this.temp = new byte[1];
        int n = this.read(this.temp, 0, 1);
        if (n <= 0) {
            return -1;
        }
        return this.temp[0] & 0xFF;
    }

    @Override
    public long skip(long numbytes) throws IOException {
        int r;
        long n;
        if (numbytes <= 0L) {
            return 0L;
        }
        int buflen = (int)Math.min(1024L, n);
        byte[] data = new byte[buflen];
        for (n = numbytes; n > 0L && (r = this.read(data, 0, (int)Math.min((long)buflen, n))) >= 0; n -= (long)r) {
        }
        return numbytes - n;
    }

    @Override
    public int available() throws IOException {
        return this.impl.available();
    }

    @Override
    public void close() throws IOException {
        if (this.closing) {
            return;
        }
        this.closing = true;
        if (this.socket != null) {
            if (!this.socket.isClosed()) {
                this.socket.close();
            }
        } else {
            this.impl.close();
        }
        this.closing = false;
    }

    void setEOF(boolean eof) {
        this.eof = eof;
    }

    @Override
    protected void finalize() {
    }

    private static native void init();

    static {
        SocketInputStream.init();
    }
}

