/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.ntlm;

import com.sun.security.ntlm.Client;
import com.sun.security.ntlm.NTLMException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Random;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

final class NTLMClient
implements SaslClient {
    private static final String NTLM_VERSION = "com.sun.security.sasl.ntlm.version";
    private static final String NTLM_RANDOM = "com.sun.security.sasl.ntlm.random";
    private static final String NTLM_DOMAIN = "com.sun.security.sasl.ntlm.domain";
    private static final String NTLM_HOSTNAME = "com.sun.security.sasl.ntlm.hostname";
    private final Client client;
    private final String mech;
    private final Random random;
    private int step = 0;

    NTLMClient(String mech, String authzid, String protocol, String serverName, Map props, CallbackHandler cbh) throws SaslException {
        this.mech = mech;
        String version = null;
        Random rtmp = null;
        String hostname = null;
        if (props != null) {
            String qop = (String)props.get("javax.security.sasl.qop");
            if (qop != null && !qop.equals("auth")) {
                throw new SaslException("NTLM only support auth");
            }
            version = (String)props.get(NTLM_VERSION);
            rtmp = (Random)props.get(NTLM_RANDOM);
            hostname = (String)props.get(NTLM_HOSTNAME);
        }
        Random random = this.random = rtmp != null ? rtmp : new Random();
        if (version == null) {
            version = System.getProperty("ntlm.version");
        }
        RealmCallback dcb = serverName != null && !serverName.isEmpty() ? new RealmCallback("Realm: ", serverName) : new RealmCallback("Realm: ");
        NameCallback ncb = authzid != null && !authzid.isEmpty() ? new NameCallback("User name: ", authzid) : new NameCallback("User name: ");
        PasswordCallback pcb = new PasswordCallback("Password: ", false);
        try {
            cbh.handle(new Callback[]{dcb, ncb, pcb});
        }
        catch (UnsupportedCallbackException e) {
            throw new SaslException("NTLM: Cannot perform callback to acquire realm, username or password", e);
        }
        catch (IOException e) {
            throw new SaslException("NTLM: Error acquiring realm, username or password", e);
        }
        if (hostname == null) {
            try {
                hostname = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                hostname = "localhost";
            }
        }
        try {
            this.client = new Client(version, hostname, ncb.getName(), dcb.getText(), pcb.getPassword());
        }
        catch (NTLMException ne) {
            throw new SaslException("NTLM: client creation failure", ne);
        }
    }

    @Override
    public String getMechanismName() {
        return this.mech;
    }

    @Override
    public boolean isComplete() {
        return this.step >= 2;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        throw new IllegalStateException("Not supported.");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        throw new IllegalStateException("Not supported.");
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (!this.isComplete()) {
            throw new IllegalStateException("authentication not complete");
        }
        if (propName.equals("javax.security.sasl.qop")) {
            return "auth";
        }
        if (propName.equals(NTLM_DOMAIN)) {
            return this.client.getDomain();
        }
        return null;
    }

    @Override
    public void dispose() throws SaslException {
        this.client.dispose();
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        ++this.step;
        if (this.step == 1) {
            return this.client.type1();
        }
        try {
            byte[] nonce = new byte[8];
            this.random.nextBytes(nonce);
            return this.client.type3(challenge, nonce);
        }
        catch (NTLMException ex) {
            throw new SaslException("Type3 creation failed", ex);
        }
    }
}

