/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class WindowsSliderUI
extends BasicSliderUI {
    private boolean rollover = false;
    private boolean pressed = false;

    public WindowsSliderUI(JSlider b) {
        super(b);
    }

    public static ComponentUI createUI(JComponent b) {
        return new WindowsSliderUI((JSlider)b);
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new WindowsTrackListener();
    }

    @Override
    public void paintTrack(Graphics g) {
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            boolean vertical = this.slider.getOrientation() == 1;
            TMSchema.Part part = vertical ? TMSchema.Part.TKP_TRACKVERT : TMSchema.Part.TKP_TRACK;
            XPStyle.Skin skin = xp.getSkin(this.slider, part);
            if (vertical) {
                int x = (this.trackRect.width - skin.getWidth()) / 2;
                skin.paintSkin(g, this.trackRect.x + x, this.trackRect.y, skin.getWidth(), this.trackRect.height, null);
            } else {
                int y = (this.trackRect.height - skin.getHeight()) / 2;
                skin.paintSkin(g, this.trackRect.x, this.trackRect.y + y, this.trackRect.width, skin.getHeight(), null);
            }
        } else {
            super.paintTrack(g);
        }
    }

    @Override
    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            g.setColor(xp.getColor(this.slider, TMSchema.Part.TKP_TICS, null, TMSchema.Prop.COLOR, Color.black));
        }
        super.paintMinorTickForHorizSlider(g, tickBounds, x);
    }

    @Override
    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            g.setColor(xp.getColor(this.slider, TMSchema.Part.TKP_TICS, null, TMSchema.Prop.COLOR, Color.black));
        }
        super.paintMajorTickForHorizSlider(g, tickBounds, x);
    }

    @Override
    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            g.setColor(xp.getColor(this.slider, TMSchema.Part.TKP_TICSVERT, null, TMSchema.Prop.COLOR, Color.black));
        }
        super.paintMinorTickForVertSlider(g, tickBounds, y);
    }

    @Override
    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            g.setColor(xp.getColor(this.slider, TMSchema.Part.TKP_TICSVERT, null, TMSchema.Prop.COLOR, Color.black));
        }
        super.paintMajorTickForVertSlider(g, tickBounds, y);
    }

    @Override
    public void paintThumb(Graphics g) {
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            TMSchema.Part part = this.getXPThumbPart();
            TMSchema.State state = TMSchema.State.NORMAL;
            if (this.slider.hasFocus()) {
                state = TMSchema.State.FOCUSED;
            }
            if (this.rollover) {
                state = TMSchema.State.HOT;
            }
            if (this.pressed) {
                state = TMSchema.State.PRESSED;
            }
            if (!this.slider.isEnabled()) {
                state = TMSchema.State.DISABLED;
            }
            xp.getSkin(this.slider, part).paintSkin(g, this.thumbRect.x, this.thumbRect.y, state);
        } else {
            super.paintThumb(g);
        }
    }

    @Override
    protected Dimension getThumbSize() {
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            Dimension size = new Dimension();
            XPStyle.Skin s = xp.getSkin(this.slider, this.getXPThumbPart());
            size.width = s.getWidth();
            size.height = s.getHeight();
            return size;
        }
        return super.getThumbSize();
    }

    private TMSchema.Part getXPThumbPart() {
        XPStyle xp = XPStyle.getXP();
        boolean vertical = this.slider.getOrientation() == 1;
        boolean leftToRight = this.slider.getComponentOrientation().isLeftToRight();
        Boolean paintThumbArrowShape = (Boolean)this.slider.getClientProperty("Slider.paintThumbArrowShape");
        TMSchema.Part part = !this.slider.getPaintTicks() && paintThumbArrowShape == null || paintThumbArrowShape == Boolean.FALSE ? (vertical ? TMSchema.Part.TKP_THUMBVERT : TMSchema.Part.TKP_THUMB) : (vertical ? (leftToRight ? TMSchema.Part.TKP_THUMBRIGHT : TMSchema.Part.TKP_THUMBLEFT) : TMSchema.Part.TKP_THUMBBOTTOM);
        return part;
    }

    private class WindowsTrackListener
    extends BasicSliderUI.TrackListener {
        private WindowsTrackListener() {
            super(WindowsSliderUI.this);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.updateRollover(WindowsSliderUI.this.thumbRect.contains(e.getX(), e.getY()));
            super.mouseMoved(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.updateRollover(WindowsSliderUI.this.thumbRect.contains(e.getX(), e.getY()));
            super.mouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.updateRollover(false);
            super.mouseExited(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.updatePressed(WindowsSliderUI.this.thumbRect.contains(e.getX(), e.getY()));
            super.mousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.updatePressed(false);
            super.mouseReleased(e);
        }

        public void updatePressed(boolean newPressed) {
            if (!WindowsSliderUI.this.slider.isEnabled()) {
                return;
            }
            if (WindowsSliderUI.this.pressed != newPressed) {
                WindowsSliderUI.this.pressed = newPressed;
                WindowsSliderUI.this.slider.repaint(WindowsSliderUI.this.thumbRect);
            }
        }

        public void updateRollover(boolean newRollover) {
            if (!WindowsSliderUI.this.slider.isEnabled()) {
                return;
            }
            if (WindowsSliderUI.this.rollover != newRollover) {
                WindowsSliderUI.this.rollover = newRollover;
                WindowsSliderUI.this.slider.repaint(WindowsSliderUI.this.thumbRect);
            }
        }
    }
}

