/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.KeyEventPostProcessor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;
import javax.swing.plaf.basic.ComboPopup;
import sun.awt.SunToolkit;

public class WindowsRootPaneUI
extends BasicRootPaneUI {
    private static final WindowsRootPaneUI windowsRootPaneUI = new WindowsRootPaneUI();
    static final AltProcessor altProcessor = new AltProcessor();

    public static ComponentUI createUI(JComponent c) {
        return windowsRootPaneUI;
    }

    static class AltProcessor
    implements KeyEventPostProcessor {
        static boolean altKeyPressed = false;
        static boolean menuCanceledOnPress = false;
        static JRootPane root = null;
        static Window winAncestor = null;

        AltProcessor() {
        }

        void altPressed(KeyEvent ev) {
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            MenuElement[] path = msm.getSelectedPath();
            if (path.length > 0 && !(path[0] instanceof ComboPopup)) {
                msm.clearSelectedPath();
                menuCanceledOnPress = true;
                ev.consume();
            } else if (path.length > 0) {
                menuCanceledOnPress = false;
                WindowsLookAndFeel.setMnemonicHidden(false);
                WindowsGraphicsUtils.repaintMnemonicsInWindow(winAncestor);
                ev.consume();
            } else {
                JMenu menu;
                JMenuBar mbar;
                menuCanceledOnPress = false;
                WindowsLookAndFeel.setMnemonicHidden(false);
                WindowsGraphicsUtils.repaintMnemonicsInWindow(winAncestor);
                JMenuBar jMenuBar = mbar = root != null ? root.getJMenuBar() : null;
                if (mbar == null && winAncestor instanceof JFrame) {
                    mbar = ((JFrame)winAncestor).getJMenuBar();
                }
                JMenu jMenu = menu = mbar != null ? mbar.getMenu(0) : null;
                if (menu != null) {
                    ev.consume();
                }
            }
        }

        void altReleased(KeyEvent ev) {
            if (menuCanceledOnPress) {
                WindowsLookAndFeel.setMnemonicHidden(true);
                WindowsGraphicsUtils.repaintMnemonicsInWindow(winAncestor);
                return;
            }
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            if (msm.getSelectedPath().length == 0) {
                JMenuBar mbar;
                JMenuBar jMenuBar = mbar = root != null ? root.getJMenuBar() : null;
                if (mbar == null && winAncestor instanceof JFrame) {
                    mbar = ((JFrame)winAncestor).getJMenuBar();
                }
                JMenu menu = mbar != null ? mbar.getMenu(0) : null;
                boolean skip = false;
                Toolkit tk = Toolkit.getDefaultToolkit();
                if (tk instanceof SunToolkit) {
                    boolean bl = skip = ev.getWhen() <= ((SunToolkit)tk).getWindowDeactivationTime(winAncestor);
                }
                if (menu != null && !skip) {
                    MenuElement[] path = new MenuElement[]{mbar, menu};
                    msm.setSelectedPath(path);
                } else if (!WindowsLookAndFeel.isMnemonicHidden()) {
                    WindowsLookAndFeel.setMnemonicHidden(true);
                    WindowsGraphicsUtils.repaintMnemonicsInWindow(winAncestor);
                }
            } else if (msm.getSelectedPath()[0] instanceof ComboPopup) {
                WindowsLookAndFeel.setMnemonicHidden(true);
                WindowsGraphicsUtils.repaintMnemonicsInWindow(winAncestor);
            }
        }

        @Override
        public boolean postProcessKeyEvent(KeyEvent ev) {
            if (ev.isConsumed()) {
                return false;
            }
            if (ev.getKeyCode() == 18) {
                root = SwingUtilities.getRootPane(ev.getComponent());
                Window window = winAncestor = root == null ? null : SwingUtilities.getWindowAncestor(root);
                if (ev.getID() == 401) {
                    if (!altKeyPressed) {
                        this.altPressed(ev);
                    }
                    altKeyPressed = true;
                    return true;
                }
                if (ev.getID() == 402) {
                    if (altKeyPressed) {
                        this.altReleased(ev);
                    } else {
                        MenuSelectionManager msm = MenuSelectionManager.defaultManager();
                        MenuElement[] path = msm.getSelectedPath();
                        if (path.length <= 0) {
                            WindowsLookAndFeel.setMnemonicHidden(true);
                            WindowsGraphicsUtils.repaintMnemonicsInWindow(winAncestor);
                        }
                    }
                    altKeyPressed = false;
                }
                root = null;
                winAncestor = null;
            } else {
                altKeyPressed = false;
            }
            return false;
        }
    }
}

