/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.activation;

import com.sun.corba.se.impl.activation.CommandHandler;
import com.sun.corba.se.impl.orbutil.CorbaResourceUtil;
import com.sun.corba.se.spi.activation.Repository;
import com.sun.corba.se.spi.activation.RepositoryHelper;
import com.sun.corba.se.spi.activation.RepositoryPackage.ServerDef;
import com.sun.corba.se.spi.activation.ServerNotRegistered;
import java.io.PrintStream;
import org.omg.CORBA.ORB;

class ListServers
implements CommandHandler {
    static final int illegalServerId = -1;

    ListServers() {
    }

    @Override
    public String getCommandName() {
        return "list";
    }

    @Override
    public void printCommandHelp(PrintStream out, boolean helpType) {
        if (!helpType) {
            out.println(CorbaResourceUtil.getText("servertool.list"));
        } else {
            out.println(CorbaResourceUtil.getText("servertool.list1"));
        }
    }

    @Override
    public boolean processCommand(String[] cmdArgs, ORB orb, PrintStream out) {
        int serverId = -1;
        boolean listOneServer = false;
        boolean bl = listOneServer = cmdArgs.length != 0;
        if (cmdArgs.length == 2 && cmdArgs[0].equals("-serverid")) {
            serverId = Integer.valueOf(cmdArgs[1]);
        }
        if (serverId == -1 && listOneServer) {
            return true;
        }
        try {
            Repository repository = RepositoryHelper.narrow(orb.resolve_initial_references("ServerRepository"));
            if (listOneServer) {
                try {
                    ServerDef serverDef = repository.getServer(serverId);
                    out.println();
                    ListServers.printServerDef(serverDef, serverId, out);
                    out.println();
                }
                catch (ServerNotRegistered e) {
                    out.println(CorbaResourceUtil.getText("servertool.nosuchserver"));
                }
            } else {
                int[] servers = repository.listRegisteredServers();
                out.println(CorbaResourceUtil.getText("servertool.list2"));
                ListServers.sortServers(servers);
                for (int i = 0; i < servers.length; ++i) {
                    try {
                        ServerDef serverDef = repository.getServer(servers[i]);
                        out.println("\t   " + servers[i] + "\t\t" + serverDef.serverName + "\t\t" + serverDef.applicationName);
                        continue;
                    }
                    catch (ServerNotRegistered e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    static void printServerDef(ServerDef serverDef, int serverId, PrintStream out) {
        out.println(CorbaResourceUtil.getText("servertool.appname", serverDef.applicationName));
        out.println(CorbaResourceUtil.getText("servertool.name", serverDef.serverName));
        out.println(CorbaResourceUtil.getText("servertool.classpath", serverDef.serverClassPath));
        out.println(CorbaResourceUtil.getText("servertool.args", serverDef.serverArgs));
        out.println(CorbaResourceUtil.getText("servertool.vmargs", serverDef.serverVmArgs));
        out.println(CorbaResourceUtil.getText("servertool.serverid", serverId));
    }

    static void sortServers(int[] serverIds) {
        int size = serverIds.length;
        for (int i = 0; i < size; ++i) {
            int lowest = i;
            for (int j = i + 1; j < size; ++j) {
                if (serverIds[j] >= serverIds[lowest]) continue;
                lowest = j;
            }
            if (lowest == i) continue;
            int temp = serverIds[i];
            serverIds[i] = serverIds[lowest];
            serverIds[lowest] = temp;
        }
    }
}

