/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

abstract class DoubleByteDecoder
extends CharsetDecoder {
    private short[] index1;
    private String[] index2;
    protected int start;
    protected int end;
    protected static final char REPLACE_CHAR = '\ufffd';
    protected char highSurrogate;
    protected char lowSurrogate;

    protected DoubleByteDecoder(Charset cs, short[] index1, String[] index2, int start, int end) {
        super(cs, 0.5f, 1.0f);
        this.index1 = index1;
        this.index2 = index2;
        this.start = start;
        this.end = end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
        byte[] sa = src.array();
        int sp = src.arrayOffset() + src.position();
        int sl = src.arrayOffset() + src.limit();
        assert (sp <= sl);
        char[] da = dst.array();
        int dp = dst.arrayOffset() + dst.position();
        int dl = dst.arrayOffset() + dst.limit();
        assert (dp <= dl);
        dp = dp <= dl ? dp : dl;
        try {
            int inputSize;
            for (sp = sp <= sl ? sp : sl; sp < sl; sp += inputSize) {
                int b1 = sa[sp];
                inputSize = 1;
                int outputSize = 1;
                this.lowSurrogate = '\u0000';
                this.highSurrogate = '\u0000';
                char c = this.decodeSingle(b1);
                if (c == '\ufffd') {
                    b1 &= 0xFF;
                    if (sl - sp < 2) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    int b2 = sa[sp + 1] & 0xFF;
                    c = this.decodeDouble(b1, b2);
                    inputSize = 2;
                    if (c == '\ufffd') {
                        CoderResult coderResult = CoderResult.unmappableForLength(inputSize);
                        return coderResult;
                    }
                    int n = outputSize = this.highSurrogate > '\u0000' ? 2 : 1;
                }
                if (dl - dp < outputSize) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (outputSize == 2) {
                    da[dp++] = this.highSurrogate;
                    da[dp++] = this.lowSurrogate;
                    continue;
                }
                da[dp++] = c;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            src.position(sp - src.arrayOffset());
            dst.position(dp - dst.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
        int mark = src.position();
        int inputSize = 0;
        int outputSize = 0;
        try {
            while (src.hasRemaining()) {
                int b1 = src.get();
                inputSize = 1;
                outputSize = 1;
                this.lowSurrogate = '\u0000';
                this.highSurrogate = '\u0000';
                char c = this.decodeSingle(b1);
                if (c == '\ufffd') {
                    if (src.remaining() < 1) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    int b2 = src.get() & 0xFF;
                    inputSize = 2;
                    c = this.decodeDouble(b1 &= 0xFF, b2);
                    if (c == '\ufffd') {
                        CoderResult coderResult = CoderResult.unmappableForLength(2);
                        return coderResult;
                    }
                    int n = outputSize = this.highSurrogate > '\u0000' ? 2 : 1;
                }
                if (dst.remaining() < outputSize) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                mark += inputSize;
                if (outputSize == 2) {
                    dst.put(this.highSurrogate);
                    dst.put(this.lowSurrogate);
                    continue;
                }
                dst.put(c);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            src.position(mark);
        }
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
        if (src.hasArray() && dst.hasArray()) {
            return this.decodeArrayLoop(src, dst);
        }
        return this.decodeBufferLoop(src, dst);
    }

    protected char decodeSingle(int b) {
        if (b >= 0) {
            return (char)b;
        }
        return '\ufffd';
    }

    protected char decodeDouble(int byte1, int byte2) {
        if (byte1 < 0 || byte1 > this.index1.length || byte2 < this.start || byte2 > this.end) {
            return '\ufffd';
        }
        int n = (this.index1[byte1] & 0xF) * (this.end - this.start + 1) + (byte2 - this.start);
        return this.index2[this.index1[byte1] >> 4].charAt(n);
    }
}

