/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.swing.CellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import sun.tools.jconsole.inspector.XObject;
import sun.tools.jconsole.inspector.XTextField;

public class Utils {
    private static Set<Integer> tableNavigationKeys;
    private static final Set<Class<?>> primitiveWrappers;
    private static final Set<Class<?>> primitives;
    private static final Map<String, Class<?>> primitiveMap;
    private static final Map<String, Class<?>> primitiveToWrapper;
    private static final Set<String> editableTypes;
    private static final Set<Class<?>> extraEditableClasses;
    private static final Set<String> numericalTypes;
    private static final Set<String> extraNumericalTypes;
    private static final Set<String> booleanTypes;

    private Utils() {
    }

    public static Class<?> getClass(String className) throws ClassNotFoundException {
        Class<?> c = primitiveMap.get(className);
        if (c != null) {
            return c;
        }
        return Class.forName(className);
    }

    public static boolean isUniformCollection(Collection<?> c, Class<?> e) {
        if (e == null) {
            throw new IllegalArgumentException("Null reference type");
        }
        if (c == null) {
            throw new IllegalArgumentException("Null collection");
        }
        if (c.isEmpty()) {
            return false;
        }
        for (Object o : c) {
            if (o != null && e.isAssignableFrom(o.getClass())) continue;
            return false;
        }
        return true;
    }

    public static boolean canBeRenderedAsArray(Object elem) {
        if (Utils.isSupportedArray(elem)) {
            return true;
        }
        if (elem instanceof Collection) {
            Collection c = (Collection)elem;
            if (c.isEmpty()) {
                return false;
            }
            return !Utils.isUniformCollection(c, CompositeData.class) && !Utils.isUniformCollection(c, TabularData.class);
        }
        if (elem instanceof Map) {
            return !(elem instanceof TabularData);
        }
        return false;
    }

    public static boolean isSupportedArray(Object elem) {
        if (elem == null || !elem.getClass().isArray()) {
            return false;
        }
        Class<?> ct = elem.getClass().getComponentType();
        if (ct.isArray()) {
            return false;
        }
        return Array.getLength(elem) <= 0 || !CompositeData.class.isAssignableFrom(ct) && !TabularData.class.isAssignableFrom(ct);
    }

    public static String getArrayClassName(String name) {
        String className = null;
        if (name.startsWith("[")) {
            int index = name.lastIndexOf("[");
            className = name.substring(index, name.length());
            if (className.startsWith("[L")) {
                className = className.substring(2, className.length() - 1);
            } else {
                try {
                    Class<?> c = Class.forName(className);
                    className = c.getComponentType().getName();
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Bad class name " + name, e);
                }
            }
        }
        return className;
    }

    public static String getReadableClassName(String name) {
        String className = Utils.getArrayClassName(name);
        if (className == null) {
            return name;
        }
        int index = name.lastIndexOf("[");
        StringBuilder brackets = new StringBuilder(className);
        for (int i = 0; i <= index; ++i) {
            brackets.append("[]");
        }
        return brackets.toString();
    }

    public static boolean isEditableType(String type) {
        return editableTypes.contains(type);
    }

    public static String getDefaultValue(String type) {
        if (numericalTypes.contains(type) || extraNumericalTypes.contains(type)) {
            return "0";
        }
        if (booleanTypes.contains(type)) {
            return "true";
        }
        int i = (type = Utils.getReadableClassName(type)).lastIndexOf(46);
        if (i > 0) {
            return type.substring(i + 1, type.length());
        }
        return type;
    }

    public static Object newStringConstructor(String type, String param) throws Exception {
        Constructor<?> c = Utils.getClass(type).getConstructor(String.class);
        try {
            return c.newInstance(param);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw e;
        }
    }

    private static Number createNumberFromStringValue(String value) throws NumberFormatException {
        String suffix = value.substring(value.length() - 1);
        if ("L".equalsIgnoreCase(suffix)) {
            return Long.valueOf(value.substring(0, value.length() - 1));
        }
        if ("F".equalsIgnoreCase(suffix)) {
            return Float.valueOf(value.substring(0, value.length() - 1));
        }
        if ("D".equalsIgnoreCase(suffix)) {
            return Double.valueOf(value.substring(0, value.length() - 1));
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e1) {
                try {
                    return Double.valueOf(value);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NumberFormatException("Cannot convert string value '" + value + "' into a numerical value");
                }
            }
        }
    }

    public static Object createObjectFromString(String type, String value) throws Exception {
        Object result = primitiveToWrapper.containsKey(type) ? (type.equals(Character.TYPE.getName()) ? new Character(value.charAt(0)) : Utils.newStringConstructor(primitiveToWrapper.get(type).getName(), value)) : (type.equals(Character.class.getName()) ? new Character(value.charAt(0)) : (Number.class.isAssignableFrom(Utils.getClass(type)) ? Utils.createNumberFromStringValue(value) : (value == null || value.toString().equals("null") ? null : Utils.newStringConstructor(type, value))));
        return result;
    }

    public static Object[] getParameters(XTextField[] inputs, String[] params) throws Exception {
        Object[] result = new Object[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            Object userInput = inputs[i].getValue();
            result[i] = userInput instanceof XObject ? ((XObject)userInput).getObject() : Utils.createObjectFromString(params[i].toString(), (String)userInput);
        }
        return result;
    }

    public static Throwable getActualException(Throwable e) {
        Throwable t;
        if (e instanceof ExecutionException) {
            e = e.getCause();
        }
        if ((e instanceof MBeanException || e instanceof RuntimeMBeanException || e instanceof RuntimeOperationsException || e instanceof ReflectionException) && (t = e.getCause()) != null) {
            return t;
        }
        return e;
    }

    static {
        String name;
        tableNavigationKeys = new HashSet<Integer>(Arrays.asList(9, 10, 36, 35, 37, 39, 38, 40, 33, 34));
        primitiveWrappers = new HashSet<Class>(Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, Boolean.class));
        primitives = new HashSet();
        primitiveMap = new HashMap();
        primitiveToWrapper = new HashMap();
        editableTypes = new HashSet<String>();
        extraEditableClasses = new HashSet<Class>(Arrays.asList(BigDecimal.class, BigInteger.class, Number.class, String.class, ObjectName.class));
        numericalTypes = new HashSet<String>();
        extraNumericalTypes = new HashSet<String>(Arrays.asList(BigDecimal.class.getName(), BigInteger.class.getName(), Number.class.getName()));
        booleanTypes = new HashSet<String>(Arrays.asList(Boolean.TYPE.getName(), Boolean.class.getName()));
        for (Class<?> c : primitiveWrappers) {
            try {
                Field f = c.getField("TYPE");
                Class p = (Class)f.get(null);
                primitives.add(p);
                primitiveMap.put(p.getName(), p);
                primitiveToWrapper.put(p.getName(), c);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        for (Class<?> c : primitives) {
            editableTypes.add(c.getName());
        }
        for (Class<?> c : primitiveWrappers) {
            editableTypes.add(c.getName());
        }
        for (Class<?> c : extraEditableClasses) {
            editableTypes.add(c.getName());
        }
        for (Class<?> c : primitives) {
            name = c.getName();
            if (name.equals(Boolean.TYPE.getName())) continue;
            numericalTypes.add(name);
        }
        for (Class<?> c : primitiveWrappers) {
            name = c.getName();
            if (name.equals(Boolean.class.getName())) continue;
            numericalTypes.add(name);
        }
    }

    public static class CopyKeyAdapter
    extends KeyAdapter {
        private static final String defaultEditorKitCopyActionName = "copy-to-clipboard";
        private static final String transferHandlerCopyActionName = (String)TransferHandler.getCopyAction().getValue("Name");

        @Override
        public void keyPressed(KeyEvent e) {
            KeyStroke ks = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
            JComponent comp = (JComponent)e.getSource();
            for (int i = 0; i < 3; ++i) {
                InputMap im = comp.getInputMap(i);
                Object key = im.get(ks);
                if (!defaultEditorKitCopyActionName.equals(key) && !transferHandlerCopyActionName.equals(key)) continue;
                return;
            }
            if (!tableNavigationKeys.contains(e.getKeyCode())) {
                e.consume();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            e.consume();
        }
    }

    public static class EditFocusAdapter
    extends FocusAdapter {
        private CellEditor editor;

        public EditFocusAdapter(CellEditor editor) {
            this.editor = editor;
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.editor.stopCellEditing();
        }
    }

    public static class ReadOnlyTableCellEditor
    extends DefaultCellEditor {
        public ReadOnlyTableCellEditor(JTextField tf) {
            super(tf);
            tf.addFocusListener(new EditFocusAdapter(this));
            tf.addKeyListener(new CopyKeyAdapter());
        }
    }
}

