/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;
import sun.management.ConnectorAddressLink;
import sun.tools.jconsole.JConsole;

public class LocalVirtualMachine {
    private String address;
    private String commandLine;
    private String displayName;
    private int vmid;
    private boolean isAttachSupported;
    private static final String LOCAL_CONNECTOR_ADDRESS_PROP = "com.sun.management.jmxremote.localConnectorAddress";

    public LocalVirtualMachine(int vmid, String commandLine, boolean canAttach, String connectorAddress) {
        this.vmid = vmid;
        this.commandLine = commandLine;
        this.address = connectorAddress;
        this.isAttachSupported = canAttach;
        this.displayName = LocalVirtualMachine.getDisplayName(commandLine);
    }

    private static String getDisplayName(String commandLine) {
        String[] res = commandLine.split(" ", 2);
        if (res[0].endsWith(".jar")) {
            File jarfile = new File(res[0]);
            String displayName = jarfile.getName();
            if (res.length == 2) {
                displayName = displayName + " " + res[1];
            }
            return displayName;
        }
        return commandLine;
    }

    public int vmid() {
        return this.vmid;
    }

    public boolean isManageable() {
        return this.address != null;
    }

    public boolean isAttachable() {
        return this.isAttachSupported;
    }

    public void startManagementAgent() throws IOException {
        if (this.address != null) {
            return;
        }
        if (!this.isAttachable()) {
            throw new IOException("This virtual machine \"" + this.vmid + "\" does not support dynamic attach.");
        }
        this.loadManagementAgent();
        if (this.address == null) {
            throw new IOException("Fails to find connector address");
        }
    }

    public String connectorAddress() {
        return this.address;
    }

    public String displayName() {
        return this.displayName;
    }

    public String toString() {
        return this.commandLine;
    }

    public static Map<Integer, LocalVirtualMachine> getAllVirtualMachines() {
        HashMap<Integer, LocalVirtualMachine> map = new HashMap<Integer, LocalVirtualMachine>();
        LocalVirtualMachine.getMonitoredVMs(map);
        LocalVirtualMachine.getAttachableVMs(map);
        return map;
    }

    private static void getMonitoredVMs(Map<Integer, LocalVirtualMachine> map) {
        Set<Integer> vms;
        MonitoredHost host;
        try {
            host = MonitoredHost.getMonitoredHost(new HostIdentifier((String)null));
            vms = host.activeVms();
        }
        catch (URISyntaxException sx) {
            throw new InternalError(sx.getMessage());
        }
        catch (MonitorException mx) {
            throw new InternalError(mx.getMessage());
        }
        for (Integer vmid : vms) {
            if (!(vmid instanceof Integer)) continue;
            int pid = vmid;
            String name = ((Object)vmid).toString();
            boolean attachable = false;
            String address = null;
            try {
                MonitoredVm mvm = host.getMonitoredVm(new VmIdentifier(name));
                name = MonitoredVmUtil.commandLine(mvm);
                attachable = MonitoredVmUtil.isAttachable(mvm);
                address = ConnectorAddressLink.importFrom((int)pid);
                mvm.detach();
            }
            catch (Exception x) {
                // empty catch block
            }
            map.put(vmid, new LocalVirtualMachine(pid, name, attachable, address));
        }
    }

    private static void getAttachableVMs(Map<Integer, LocalVirtualMachine> map) {
        List<VirtualMachineDescriptor> vms = VirtualMachine.list();
        for (VirtualMachineDescriptor vmd : vms) {
            try {
                Integer vmid = Integer.valueOf(vmd.id());
                if (map.containsKey(vmid)) continue;
                boolean attachable = false;
                String address = null;
                try {
                    VirtualMachine vm = VirtualMachine.attach(vmd);
                    attachable = true;
                    Properties agentProps = vm.getAgentProperties();
                    address = (String)agentProps.get(LOCAL_CONNECTOR_ADDRESS_PROP);
                    vm.detach();
                }
                catch (AttachNotSupportedException x) {
                }
                catch (IOException x) {
                    // empty catch block
                }
                map.put(vmid, new LocalVirtualMachine(vmid, vmd.displayName(), attachable, address));
            }
            catch (NumberFormatException e) {}
        }
    }

    public static LocalVirtualMachine getLocalVirtualMachine(int vmid) {
        LocalVirtualMachine lvm;
        block5: {
            Map<Integer, LocalVirtualMachine> map = LocalVirtualMachine.getAllVirtualMachines();
            lvm = map.get(vmid);
            if (lvm == null) {
                boolean attachable = false;
                String address = null;
                String name = String.valueOf(vmid);
                try {
                    VirtualMachine vm = VirtualMachine.attach(name);
                    attachable = true;
                    Properties agentProps = vm.getAgentProperties();
                    address = (String)agentProps.get(LOCAL_CONNECTOR_ADDRESS_PROP);
                    vm.detach();
                    lvm = new LocalVirtualMachine(vmid, name, attachable, address);
                }
                catch (AttachNotSupportedException x) {
                    if (JConsole.isDebug()) {
                        x.printStackTrace();
                    }
                }
                catch (IOException x) {
                    if (!JConsole.isDebug()) break block5;
                    x.printStackTrace();
                }
            }
        }
        return lvm;
    }

    private void loadManagementAgent() throws IOException {
        VirtualMachine vm = null;
        String name = String.valueOf(this.vmid);
        try {
            vm = VirtualMachine.attach(name);
        }
        catch (AttachNotSupportedException x) {
            IOException ioe = new IOException(x.getMessage());
            ioe.initCause(x);
            throw ioe;
        }
        String home = vm.getSystemProperties().getProperty("java.home");
        String agent = home + File.separator + "jre" + File.separator + "lib" + File.separator + "management-agent.jar";
        File f = new File(agent);
        if (!f.exists() && !(f = new File(agent = home + File.separator + "lib" + File.separator + "management-agent.jar")).exists()) {
            throw new IOException("Management agent not found");
        }
        agent = f.getCanonicalPath();
        try {
            vm.loadAgent(agent, "com.sun.management.jmxremote");
        }
        catch (AgentLoadException x) {
            IOException ioe = new IOException(x.getMessage());
            ioe.initCause(x);
            throw ioe;
        }
        catch (AgentInitializationException x) {
            IOException ioe = new IOException(x.getMessage());
            ioe.initCause(x);
            throw ioe;
        }
        Properties agentProps = vm.getAgentProperties();
        this.address = (String)agentProps.get(LOCAL_CONNECTOR_ADDRESS_PROP);
        vm.detach();
    }
}

