/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.MalformedURLException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class FullThreadDump {
    private MBeanServerConnection server;
    private JMXConnector jmxc;

    public FullThreadDump(String hostname, int port) {
        System.out.println("Connecting to " + hostname + ":" + port);
        String urlPath = "/jndi/rmi://" + hostname + ":" + port + "/jmxrmi";
        this.connect(urlPath);
    }

    public void dump() {
        try {
            ThreadMonitor monitor = new ThreadMonitor(this.server);
            monitor.threadDump();
            if (!monitor.findDeadlock()) {
                System.out.println("No deadlock found.");
            }
        }
        catch (IOException e) {
            System.err.println("\nCommunication error: " + e.getMessage());
            System.exit(1);
        }
    }

    private void connect(String urlPath) {
        try {
            JMXServiceURL url = new JMXServiceURL("rmi", "", 0, urlPath);
            this.jmxc = JMXConnectorFactory.connect(url);
            this.server = this.jmxc.getMBeanServerConnection();
        }
        catch (MalformedURLException e) {
        }
        catch (IOException e) {
            System.err.println("\nCommunication error: " + e.getMessage());
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        String[] arg2;
        if (args.length != 1) {
            FullThreadDump.usage();
        }
        if ((arg2 = args[0].split(":")).length != 2) {
            FullThreadDump.usage();
        }
        String hostname = arg2[0];
        int port = -1;
        try {
            port = Integer.parseInt(arg2[1]);
        }
        catch (NumberFormatException x) {
            FullThreadDump.usage();
        }
        if (port < 0) {
            FullThreadDump.usage();
        }
        FullThreadDump ftd = new FullThreadDump(hostname, port);
        ftd.dump();
    }

    private static void usage() {
        System.out.println("Usage: java FullThreadDump <hostname>:<port>");
    }
}

