/* main.c generated by valac 0.20.1, the Vala compiler
 * generated from main.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2013 Peng Huang <shawn.p.huang@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ibus.h>
#include <config.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <locale.h>
#include <gobject/gvaluecollector.h>


#define TYPE_ENGINE_LIST (engine_list_get_type ())
#define ENGINE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENGINE_LIST, EngineList))
#define ENGINE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENGINE_LIST, EngineListClass))
#define IS_ENGINE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENGINE_LIST))
#define IS_ENGINE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENGINE_LIST))
#define ENGINE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENGINE_LIST, EngineListClass))

typedef struct _EngineList EngineList;
typedef struct _EngineListClass EngineListClass;
typedef struct _EngineListPrivate EngineListPrivate;
typedef struct _ParamSpecEngineList ParamSpecEngineList;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _engine_list_unref0(var) ((var == NULL) ? NULL : (var = (engine_list_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TYPE_COMMAND_ENTRY (command_entry_get_type ())
typedef struct _CommandEntry CommandEntry;

struct _EngineList {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EngineListPrivate * priv;
	IBusEngineDesc** data;
	gint data_length1;
	gint _data_size_;
};

struct _EngineListClass {
	GTypeClass parent_class;
	void (*finalize) (EngineList *self);
};

struct _ParamSpecEngineList {
	GParamSpec parent_instance;
};

typedef gint (*EntryFunc) (gchar** argv, int argv_length1, void* user_data);
struct _CommandEntry {
	const gchar* name;
	const gchar* description;
	EntryFunc entry;
	gpointer entry_target;
};


extern gboolean name_only;
gboolean name_only = FALSE;
extern gboolean is_system;
gboolean is_system = FALSE;
extern gchar* cache_file;
gchar* cache_file = NULL;
static gpointer engine_list_parent_class = NULL;
extern gchar* program_name;
gchar* program_name = NULL;

gpointer engine_list_ref (gpointer instance);
void engine_list_unref (gpointer instance);
GParamSpec* param_spec_engine_list (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_engine_list (GValue* value, gpointer v_object);
void value_take_engine_list (GValue* value, gpointer v_object);
gpointer value_get_engine_list (const GValue* value);
GType engine_list_get_type (void) G_GNUC_CONST;
enum  {
	ENGINE_LIST_DUMMY_PROPERTY
};
EngineList* engine_list_new (void);
EngineList* engine_list_construct (GType object_type);
static void engine_list_finalize (EngineList* obj);
IBusBus* get_bus (void);
gint list_engine (gchar** argv, int argv_length1);
static void _g_free0_ (gpointer var);
static void _engine_list_unref0_ (gpointer var);
static void _vala_array_add1 (IBusEngineDesc*** array, int* length, int* size, IBusEngineDesc* value);
gint exec_setxkbmap (IBusEngineDesc* engine);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value);
gint get_set_engine (gchar** argv, int argv_length1);
gint message_watch (gchar** argv, int argv_length1);
gint restart_daemon (gchar** argv, int argv_length1);
gint exit_daemon (gchar** argv, int argv_length1);
gint print_version (gchar** argv, int argv_length1);
gint read_cache (gchar** argv, int argv_length1);
gint write_cache (gchar** argv, int argv_length1);
gint print_address (gchar** argv, int argv_length1);
gint print_help (gchar** argv, int argv_length1);
void print_usage (FILE* stream);
GType command_entry_get_type (void) G_GNUC_CONST;
CommandEntry* command_entry_dup (const CommandEntry* self);
void command_entry_free (CommandEntry* self);
static gint _get_set_engine_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _exit_daemon_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _list_engine_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _message_watch_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _restart_daemon_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _print_version_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _read_cache_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _write_cache_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _print_address_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _print_help_entry_func (gchar** argv, int argv_length1, gpointer self);
gint _vala_main (gchar** argv, int argv_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const CommandEntry commands[10] = {{"engine", "Set or get engine", _get_set_engine_entry_func}, {"exit", "Exit ibus-daemon", _exit_daemon_entry_func}, {"list-engine", "Show available engines", _list_engine_entry_func}, {"watch", "(Not implemented)", _message_watch_entry_func}, {"restart", "Restart ibus-daemon", _restart_daemon_entry_func}, {"version", "Show version", _print_version_entry_func}, {"read-cache", "Show the content of registry cache", _read_cache_entry_func}, {"write-cache", "Create registry cache", _write_cache_entry_func}, {"address", "Print the D-Bus address of ibus-daemon", _print_address_entry_func}, {"help", "Show this information", _print_help_entry_func}};

EngineList* engine_list_construct (GType object_type) {
	EngineList* self = NULL;
	self = (EngineList*) g_type_create_instance (object_type);
	return self;
}


EngineList* engine_list_new (void) {
	return engine_list_construct (TYPE_ENGINE_LIST);
}


static void value_engine_list_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_engine_list_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		engine_list_unref (value->data[0].v_pointer);
	}
}


static void value_engine_list_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = engine_list_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_engine_list_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_engine_list_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		EngineList* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = engine_list_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_engine_list_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	EngineList** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = engine_list_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_engine_list (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecEngineList* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ENGINE_LIST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_engine_list (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENGINE_LIST), NULL);
	return value->data[0].v_pointer;
}


void value_set_engine_list (GValue* value, gpointer v_object) {
	EngineList* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENGINE_LIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENGINE_LIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		engine_list_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		engine_list_unref (old);
	}
}


void value_take_engine_list (GValue* value, gpointer v_object) {
	EngineList* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENGINE_LIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENGINE_LIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		engine_list_unref (old);
	}
}


static void engine_list_class_init (EngineListClass * klass) {
	engine_list_parent_class = g_type_class_peek_parent (klass);
	ENGINE_LIST_CLASS (klass)->finalize = engine_list_finalize;
}


static void engine_list_instance_init (EngineList * self) {
	IBusEngineDesc** _tmp0_ = NULL;
	_tmp0_ = g_new0 (IBusEngineDesc*, 0 + 1);
	self->data = _tmp0_;
	self->data_length1 = 0;
	self->_data_size_ = self->data_length1;
	self->ref_count = 1;
}


static void engine_list_finalize (EngineList* obj) {
	EngineList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENGINE_LIST, EngineList);
	self->data = (_vala_array_free (self->data, self->data_length1, (GDestroyNotify) g_object_unref), NULL);
}


GType engine_list_get_type (void) {
	static volatile gsize engine_list_type_id__volatile = 0;
	if (g_once_init_enter (&engine_list_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_engine_list_init, value_engine_list_free_value, value_engine_list_copy_value, value_engine_list_peek_pointer, "p", value_engine_list_collect_value, "p", value_engine_list_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (EngineListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) engine_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EngineList), 0, (GInstanceInitFunc) engine_list_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType engine_list_type_id;
		engine_list_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EngineList", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&engine_list_type_id__volatile, engine_list_type_id);
	}
	return engine_list_type_id__volatile;
}


gpointer engine_list_ref (gpointer instance) {
	EngineList* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void engine_list_unref (gpointer instance) {
	EngineList* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ENGINE_LIST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


IBusBus* get_bus (void) {
	IBusBus* result = NULL;
	IBusBus* _tmp0_;
	IBusBus* bus;
	IBusBus* _tmp1_;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = ibus_bus_new ();
	g_object_ref_sink (_tmp0_);
	bus = _tmp0_;
	_tmp1_ = bus;
	_tmp2_ = ibus_bus_is_connected (_tmp1_);
	if (!_tmp2_) {
		result = NULL;
		_g_object_unref0 (bus);
		return result;
	}
	result = bus;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _engine_list_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (engine_list_unref (var), NULL));
}


static gpointer _engine_list_ref0 (gpointer self) {
	return self ? engine_list_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add1 (IBusEngineDesc*** array, int* length, int* size, IBusEngineDesc* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IBusEngineDesc*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gint list_engine (gchar** argv, int argv_length1) {
	gint result = 0;
	static const GOptionEntry options[] = {{"name-only", (gchar) 0, 0, G_OPTION_ARG_NONE, &name_only, "List engine name only", NULL}, {NULL}};
	GOptionContext* _tmp0_;
	GOptionContext* option;
	GOptionContext* _tmp1_;
	IBusBus* _tmp6_ = NULL;
	IBusBus* bus;
	IBusBus* _tmp7_;
	IBusBus* _tmp10_;
	GList* _tmp11_ = NULL;
	GList* engines;
	gboolean _tmp12_;
	GHashFunc _tmp16_;
	GEqualFunc _tmp17_;
	GHashTable* _tmp18_;
	GHashTable* map;
	GList* _tmp19_;
	GHashTable* _tmp38_;
	GList* _tmp39_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new (NULL);
	option = _tmp0_;
	_tmp1_ = option;
	g_option_context_add_main_entries (_tmp1_, options, GETTEXT_PACKAGE);
	{
		GOptionContext* _tmp2_;
		_tmp2_ = option;
		g_option_context_parse (_tmp2_, &argv_length1, &argv, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (option);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		fprintf (_tmp3_, "%s\n", _tmp5_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (option);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (option);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp6_ = get_bus ();
	bus = _tmp6_;
	_tmp7_ = bus;
	if (_tmp7_ == NULL) {
		FILE* _tmp8_;
		const gchar* _tmp9_ = NULL;
		_tmp8_ = stderr;
		_tmp9_ = _ ("Can't connect to IBus.\n");
		fprintf (_tmp8_, "%s", _tmp9_);
		result = EXIT_FAILURE;
		_g_object_unref0 (bus);
		_g_option_context_free0 (option);
		return result;
	}
	_tmp10_ = bus;
	_tmp11_ = ibus_bus_list_engines (_tmp10_);
	engines = _tmp11_;
	_tmp12_ = name_only;
	if (_tmp12_) {
		GList* _tmp13_;
		_tmp13_ = engines;
		{
			GList* engine_collection = NULL;
			GList* engine_it = NULL;
			engine_collection = _tmp13_;
			for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
				IBusEngineDesc* engine = NULL;
				engine = (IBusEngineDesc*) engine_it->data;
				{
					IBusEngineDesc* _tmp14_;
					const gchar* _tmp15_ = NULL;
					_tmp14_ = engine;
					_tmp15_ = ibus_engine_desc_get_name (_tmp14_);
					g_print ("%s\n", _tmp15_);
				}
			}
		}
		result = EXIT_SUCCESS;
		_g_list_free0 (engines);
		_g_object_unref0 (bus);
		_g_option_context_free0 (option);
		return result;
	}
	_tmp16_ = g_str_hash;
	_tmp17_ = g_str_equal;
	_tmp18_ = g_hash_table_new_full (_tmp16_, _tmp17_, _g_free0_, _engine_list_unref0_);
	map = _tmp18_;
	_tmp19_ = engines;
	{
		GList* engine_collection = NULL;
		GList* engine_it = NULL;
		engine_collection = _tmp19_;
		for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
			IBusEngineDesc* engine = NULL;
			engine = (IBusEngineDesc*) engine_it->data;
			{
				GHashTable* _tmp20_;
				IBusEngineDesc* _tmp21_;
				const gchar* _tmp22_ = NULL;
				gconstpointer _tmp23_ = NULL;
				EngineList* _tmp24_;
				EngineList* list;
				EngineList* _tmp25_;
				EngineList* _tmp33_;
				EngineList* _tmp34_;
				IBusEngineDesc** _tmp35_;
				gint _tmp35__length1;
				IBusEngineDesc* _tmp36_;
				IBusEngineDesc* _tmp37_;
				_tmp20_ = map;
				_tmp21_ = engine;
				_tmp22_ = ibus_engine_desc_get_language (_tmp21_);
				_tmp23_ = g_hash_table_lookup (_tmp20_, _tmp22_);
				_tmp24_ = _engine_list_ref0 ((EngineList*) _tmp23_);
				list = _tmp24_;
				_tmp25_ = list;
				if (_tmp25_ == NULL) {
					EngineList* _tmp26_;
					GHashTable* _tmp27_;
					IBusEngineDesc* _tmp28_;
					const gchar* _tmp29_ = NULL;
					gchar* _tmp30_;
					EngineList* _tmp31_;
					EngineList* _tmp32_;
					_tmp26_ = engine_list_new ();
					_engine_list_unref0 (list);
					list = _tmp26_;
					_tmp27_ = map;
					_tmp28_ = engine;
					_tmp29_ = ibus_engine_desc_get_language (_tmp28_);
					_tmp30_ = g_strdup (_tmp29_);
					_tmp31_ = list;
					_tmp32_ = _engine_list_ref0 (_tmp31_);
					g_hash_table_insert (_tmp27_, _tmp30_, _tmp32_);
				}
				_tmp33_ = list;
				_tmp34_ = list;
				_tmp35_ = _tmp34_->data;
				_tmp35__length1 = _tmp34_->data_length1;
				_tmp36_ = engine;
				_tmp37_ = _g_object_ref0 (_tmp36_);
				_vala_array_add1 (&_tmp33_->data, &_tmp33_->data_length1, &_tmp33_->_data_size_, _tmp37_);
				_engine_list_unref0 (list);
			}
		}
	}
	_tmp38_ = map;
	_tmp39_ = g_hash_table_get_keys (_tmp38_);
	{
		GList* language_collection = NULL;
		GList* language_it = NULL;
		language_collection = _tmp39_;
		for (language_it = language_collection; language_it != NULL; language_it = language_it->next) {
			const gchar* language = NULL;
			language = (const gchar*) language_it->data;
			{
				GHashTable* _tmp40_;
				const gchar* _tmp41_;
				gconstpointer _tmp42_ = NULL;
				EngineList* _tmp43_;
				EngineList* list;
				const gchar* _tmp44_ = NULL;
				const gchar* _tmp45_;
				const gchar* _tmp46_ = NULL;
				EngineList* _tmp47_;
				IBusEngineDesc** _tmp48_;
				gint _tmp48__length1;
				_tmp40_ = map;
				_tmp41_ = language;
				_tmp42_ = g_hash_table_lookup (_tmp40_, _tmp41_);
				_tmp43_ = _engine_list_ref0 ((EngineList*) _tmp42_);
				list = _tmp43_;
				_tmp44_ = _ ("language: %s\n");
				_tmp45_ = language;
				_tmp46_ = ibus_get_language_name (_tmp45_);
				g_print (_tmp44_, _tmp46_);
				_tmp47_ = list;
				_tmp48_ = _tmp47_->data;
				_tmp48__length1 = _tmp47_->data_length1;
				{
					IBusEngineDesc** engine_collection = NULL;
					gint engine_collection_length1 = 0;
					gint _engine_collection_size_ = 0;
					gint engine_it = 0;
					engine_collection = _tmp48_;
					engine_collection_length1 = _tmp48__length1;
					for (engine_it = 0; engine_it < _tmp48__length1; engine_it = engine_it + 1) {
						IBusEngineDesc* _tmp49_;
						IBusEngineDesc* engine = NULL;
						_tmp49_ = _g_object_ref0 (engine_collection[engine_it]);
						engine = _tmp49_;
						{
							IBusEngineDesc* _tmp50_;
							const gchar* _tmp51_ = NULL;
							IBusEngineDesc* _tmp52_;
							const gchar* _tmp53_ = NULL;
							_tmp50_ = engine;
							_tmp51_ = ibus_engine_desc_get_name (_tmp50_);
							_tmp52_ = engine;
							_tmp53_ = ibus_engine_desc_get_longname (_tmp52_);
							g_print ("  %s - %s\n", _tmp51_, _tmp53_);
							_g_object_unref0 (engine);
						}
					}
				}
				_engine_list_unref0 (list);
			}
		}
		_g_list_free0 (language_collection);
	}
	result = EXIT_SUCCESS;
	_g_hash_table_unref0 (map);
	_g_list_free0 (engines);
	_g_object_unref0 (bus);
	_g_option_context_free0 (option);
	return result;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gint exec_setxkbmap (IBusEngineDesc* engine) {
	gint result = 0;
	IBusEngineDesc* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* layout;
	IBusEngineDesc* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* variant;
	IBusEngineDesc* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* option;
	gchar* standard_error;
	gint exit_status;
	gchar* _tmp9_;
	gchar** _tmp10_ = NULL;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	gboolean _tmp15_;
	gboolean _tmp17_;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp25_;
	gboolean _tmp27_;
	gboolean _tmp29_;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	const gchar* _tmp37_;
	gboolean _tmp39_;
	gboolean _tmp41_;
	gchar** _tmp49_;
	gint _tmp49__length1;
	gint _tmp59_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (engine != NULL, 0);
	_tmp0_ = engine;
	_tmp1_ = ibus_engine_desc_get_layout (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	layout = _tmp2_;
	_tmp3_ = engine;
	_tmp4_ = ibus_engine_desc_get_layout_variant (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	variant = _tmp5_;
	_tmp6_ = engine;
	_tmp7_ = ibus_engine_desc_get_layout_option (_tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	option = _tmp8_;
	standard_error = NULL;
	exit_status = 0;
	_tmp9_ = g_strdup ("setxkbmap");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	args = _tmp10_;
	args_length1 = 1;
	_args_size_ = args_length1;
	_tmp13_ = layout;
	if (_tmp13_ != NULL) {
		const gchar* _tmp14_;
		_tmp14_ = layout;
		_tmp12_ = g_strcmp0 (_tmp14_, "") != 0;
	} else {
		_tmp12_ = FALSE;
	}
	_tmp15_ = _tmp12_;
	if (_tmp15_) {
		const gchar* _tmp16_;
		_tmp16_ = layout;
		_tmp11_ = g_strcmp0 (_tmp16_, "default") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	_tmp17_ = _tmp11_;
	if (_tmp17_) {
		gchar** _tmp18_;
		gint _tmp18__length1;
		gchar* _tmp19_;
		gchar** _tmp20_;
		gint _tmp20__length1;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp18_ = args;
		_tmp18__length1 = args_length1;
		_tmp19_ = g_strdup ("-layout");
		_vala_array_add2 (&args, &args_length1, &_args_size_, _tmp19_);
		_tmp20_ = args;
		_tmp20__length1 = args_length1;
		_tmp21_ = layout;
		_tmp22_ = g_strdup (_tmp21_);
		_vala_array_add3 (&args, &args_length1, &_args_size_, _tmp22_);
	}
	_tmp25_ = variant;
	if (_tmp25_ != NULL) {
		const gchar* _tmp26_;
		_tmp26_ = variant;
		_tmp24_ = g_strcmp0 (_tmp26_, "") != 0;
	} else {
		_tmp24_ = FALSE;
	}
	_tmp27_ = _tmp24_;
	if (_tmp27_) {
		const gchar* _tmp28_;
		_tmp28_ = variant;
		_tmp23_ = g_strcmp0 (_tmp28_, "default") != 0;
	} else {
		_tmp23_ = FALSE;
	}
	_tmp29_ = _tmp23_;
	if (_tmp29_) {
		gchar** _tmp30_;
		gint _tmp30__length1;
		gchar* _tmp31_;
		gchar** _tmp32_;
		gint _tmp32__length1;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp30_ = args;
		_tmp30__length1 = args_length1;
		_tmp31_ = g_strdup ("-variant");
		_vala_array_add4 (&args, &args_length1, &_args_size_, _tmp31_);
		_tmp32_ = args;
		_tmp32__length1 = args_length1;
		_tmp33_ = variant;
		_tmp34_ = g_strdup (_tmp33_);
		_vala_array_add5 (&args, &args_length1, &_args_size_, _tmp34_);
	}
	_tmp37_ = option;
	if (_tmp37_ != NULL) {
		const gchar* _tmp38_;
		_tmp38_ = option;
		_tmp36_ = g_strcmp0 (_tmp38_, "") != 0;
	} else {
		_tmp36_ = FALSE;
	}
	_tmp39_ = _tmp36_;
	if (_tmp39_) {
		const gchar* _tmp40_;
		_tmp40_ = option;
		_tmp35_ = g_strcmp0 (_tmp40_, "default") != 0;
	} else {
		_tmp35_ = FALSE;
	}
	_tmp41_ = _tmp35_;
	if (_tmp41_) {
		gchar** _tmp42_;
		gint _tmp42__length1;
		gchar* _tmp43_;
		gchar** _tmp44_;
		gint _tmp44__length1;
		gchar* _tmp45_;
		gchar** _tmp46_;
		gint _tmp46__length1;
		const gchar* _tmp47_;
		gchar* _tmp48_;
		_tmp42_ = args;
		_tmp42__length1 = args_length1;
		_tmp43_ = g_strdup ("-option");
		_vala_array_add6 (&args, &args_length1, &_args_size_, _tmp43_);
		_tmp44_ = args;
		_tmp44__length1 = args_length1;
		_tmp45_ = g_strdup ("-option");
		_vala_array_add7 (&args, &args_length1, &_args_size_, _tmp45_);
		_tmp46_ = args;
		_tmp46__length1 = args_length1;
		_tmp47_ = option;
		_tmp48_ = g_strdup (_tmp47_);
		_vala_array_add8 (&args, &args_length1, &_args_size_, _tmp48_);
	}
	_tmp49_ = args;
	_tmp49__length1 = args_length1;
	if (_tmp49__length1 == 1) {
		result = EXIT_FAILURE;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return result;
	}
	{
		gchar** _tmp50_;
		gint _tmp50__length1;
		gchar* _tmp51_ = NULL;
		gint _tmp52_ = 0;
		gboolean _tmp53_ = FALSE;
		gboolean _tmp54_;
		_tmp50_ = args;
		_tmp50__length1 = args_length1;
		_tmp53_ = g_spawn_sync (NULL, _tmp50_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_tmp51_, &_tmp52_, &_inner_error_);
		_g_free0 (standard_error);
		standard_error = _tmp51_;
		exit_status = _tmp52_;
		_tmp54_ = _tmp53_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (standard_error);
			_g_free0 (option);
			_g_free0 (variant);
			_g_free0 (layout);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		if (!_tmp54_) {
			IBusEngineDesc* _tmp55_;
			const gchar* _tmp56_ = NULL;
			_tmp55_ = engine;
			_tmp56_ = ibus_engine_desc_get_layout (_tmp55_);
			g_warning ("main.vala:126: Switch xkb layout to %s failed.", _tmp56_);
			result = EXIT_FAILURE;
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (standard_error);
			_g_free0 (option);
			_g_free0 (variant);
			_g_free0 (layout);
			return result;
		}
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp57_;
		const gchar* _tmp58_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp57_ = e;
		_tmp58_ = _tmp57_->message;
		g_warning ("main.vala:131: Execute setxkbmap failed: %s", _tmp58_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return result;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp59_ = exit_status;
	if (_tmp59_ != 0) {
		const gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		const gchar* _tmp63_;
		const gchar* _tmp65_;
		_tmp60_ = standard_error;
		_tmp61_ = g_strdup (_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = _tmp62_;
		if (_tmp63_ == NULL) {
			gchar* _tmp64_;
			_tmp64_ = g_strdup ("(null)");
			_g_free0 (_tmp62_);
			_tmp62_ = _tmp64_;
		}
		_tmp65_ = _tmp62_;
		g_warning ("main.vala:136: Execute setxkbmap failed: %s", _tmp65_);
		result = EXIT_FAILURE;
		_g_free0 (_tmp62_);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return result;
	}
	result = EXIT_SUCCESS;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (standard_error);
	_g_free0 (option);
	_g_free0 (variant);
	_g_free0 (layout);
	return result;
}


gint get_set_engine (gchar** argv, int argv_length1) {
	gint result = 0;
	IBusBus* _tmp0_ = NULL;
	IBusBus* bus;
	gchar* engine;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp5_;
	IBusBus* _tmp14_;
	const gchar* _tmp15_;
	gboolean _tmp16_ = FALSE;
	IBusBus* _tmp19_;
	IBusEngineDesc* _tmp20_ = NULL;
	IBusEngineDesc* _tmp21_;
	IBusEngineDesc* desc;
	IBusEngineDesc* _tmp22_;
	IBusEngineDesc* _tmp25_;
	gint _tmp26_ = 0;
	_tmp0_ = get_bus ();
	bus = _tmp0_;
	engine = NULL;
	_tmp1_ = argv;
	_tmp1__length1 = argv_length1;
	if (_tmp1__length1 > 1) {
		gchar** _tmp2_;
		gint _tmp2__length1;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = argv;
		_tmp2__length1 = argv_length1;
		_tmp3_ = _tmp2_[1];
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (engine);
		engine = _tmp4_;
	}
	_tmp5_ = engine;
	if (_tmp5_ == NULL) {
		IBusBus* _tmp6_;
		IBusEngineDesc* _tmp7_ = NULL;
		IBusEngineDesc* _tmp8_;
		IBusEngineDesc* desc;
		IBusEngineDesc* _tmp9_;
		IBusEngineDesc* _tmp12_;
		const gchar* _tmp13_ = NULL;
		_tmp6_ = bus;
		_tmp7_ = ibus_bus_get_global_engine (_tmp6_);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		desc = _tmp8_;
		_tmp9_ = desc;
		if (_tmp9_ == NULL) {
			FILE* _tmp10_;
			const gchar* _tmp11_ = NULL;
			_tmp10_ = stderr;
			_tmp11_ = _ ("No engine is set.\n");
			fprintf (_tmp10_, "%s", _tmp11_);
			result = EXIT_FAILURE;
			_g_object_unref0 (desc);
			_g_free0 (engine);
			_g_object_unref0 (bus);
			return result;
		}
		_tmp12_ = desc;
		_tmp13_ = ibus_engine_desc_get_name (_tmp12_);
		g_print ("%s\n", _tmp13_);
		result = EXIT_SUCCESS;
		_g_object_unref0 (desc);
		_g_free0 (engine);
		_g_object_unref0 (bus);
		return result;
	}
	_tmp14_ = bus;
	_tmp15_ = engine;
	_tmp16_ = ibus_bus_set_global_engine (_tmp14_, _tmp15_);
	if (!_tmp16_) {
		FILE* _tmp17_;
		const gchar* _tmp18_ = NULL;
		_tmp17_ = stderr;
		_tmp18_ = _ ("Set global engine failed.\n");
		fprintf (_tmp17_, "%s", _tmp18_);
		result = EXIT_FAILURE;
		_g_free0 (engine);
		_g_object_unref0 (bus);
		return result;
	}
	_tmp19_ = bus;
	_tmp20_ = ibus_bus_get_global_engine (_tmp19_);
	_tmp21_ = _g_object_ref0 (_tmp20_);
	desc = _tmp21_;
	_tmp22_ = desc;
	if (_tmp22_ == NULL) {
		FILE* _tmp23_;
		const gchar* _tmp24_ = NULL;
		_tmp23_ = stderr;
		_tmp24_ = _ ("Get global engine failed.\n");
		fprintf (_tmp23_, "%s", _tmp24_);
		result = EXIT_FAILURE;
		_g_object_unref0 (desc);
		_g_free0 (engine);
		_g_object_unref0 (bus);
		return result;
	}
	_tmp25_ = desc;
	_tmp26_ = exec_setxkbmap (_tmp25_);
	result = _tmp26_;
	_g_object_unref0 (desc);
	_g_free0 (engine);
	_g_object_unref0 (bus);
	return result;
}


gint message_watch (gchar** argv, int argv_length1) {
	gint result = 0;
	result = EXIT_SUCCESS;
	return result;
}


gint restart_daemon (gchar** argv, int argv_length1) {
	gint result = 0;
	IBusBus* _tmp0_ = NULL;
	IBusBus* bus;
	IBusBus* _tmp1_;
	IBusBus* _tmp4_;
	_tmp0_ = get_bus ();
	bus = _tmp0_;
	_tmp1_ = bus;
	if (_tmp1_ == NULL) {
		FILE* _tmp2_;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = stderr;
		_tmp3_ = _ ("Can't connect to IBus.\n");
		fprintf (_tmp2_, "%s", _tmp3_);
		result = EXIT_FAILURE;
		_g_object_unref0 (bus);
		return result;
	}
	_tmp4_ = bus;
	ibus_bus_exit (_tmp4_, TRUE);
	result = EXIT_SUCCESS;
	_g_object_unref0 (bus);
	return result;
}


gint exit_daemon (gchar** argv, int argv_length1) {
	gint result = 0;
	IBusBus* _tmp0_ = NULL;
	IBusBus* bus;
	IBusBus* _tmp1_;
	IBusBus* _tmp4_;
	_tmp0_ = get_bus ();
	bus = _tmp0_;
	_tmp1_ = bus;
	if (_tmp1_ == NULL) {
		FILE* _tmp2_;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = stderr;
		_tmp3_ = _ ("Can't connect to IBus.\n");
		fprintf (_tmp2_, "%s", _tmp3_);
		result = EXIT_FAILURE;
		_g_object_unref0 (bus);
		return result;
	}
	_tmp4_ = bus;
	ibus_bus_exit (_tmp4_, FALSE);
	result = EXIT_SUCCESS;
	_g_object_unref0 (bus);
	return result;
}


gint print_version (gchar** argv, int argv_length1) {
	gint result = 0;
	g_print ("IBus %s\n", PACKAGE_VERSION);
	result = EXIT_SUCCESS;
	return result;
}


gint read_cache (gchar** argv, int argv_length1) {
	gint result = 0;
	static const GOptionEntry options[] = {{"system", (gchar) 0, 0, G_OPTION_ARG_NONE, &is_system, "Read the system registry cache.", NULL}, {"file", (gchar) 0, 0, G_OPTION_ARG_STRING, &cache_file, "Read the registry cache FILE.", "FILE"}, {NULL}};
	GOptionContext* _tmp0_;
	GOptionContext* option;
	GOptionContext* _tmp1_;
	IBusRegistry* _tmp6_;
	IBusRegistry* registry;
	const gchar* _tmp7_;
	GString* _tmp18_;
	GString* output;
	IBusRegistry* _tmp19_;
	GString* _tmp20_;
	GString* _tmp21_;
	const gchar* _tmp22_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new (NULL);
	option = _tmp0_;
	_tmp1_ = option;
	g_option_context_add_main_entries (_tmp1_, options, GETTEXT_PACKAGE);
	{
		GOptionContext* _tmp2_;
		_tmp2_ = option;
		g_option_context_parse (_tmp2_, &argv_length1, &argv, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			_g_option_context_free0 (option);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		fprintf (_tmp3_, "%s\n", _tmp5_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (option);
		return result;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (option);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp6_ = ibus_registry_new ();
	g_object_ref_sink (_tmp6_);
	registry = _tmp6_;
	_tmp7_ = cache_file;
	if (_tmp7_ != NULL) {
		IBusRegistry* _tmp8_;
		const gchar* _tmp9_;
		gboolean _tmp10_ = FALSE;
		_tmp8_ = registry;
		_tmp9_ = cache_file;
		_tmp10_ = ibus_registry_load_cache_file (_tmp8_, _tmp9_);
		if (!_tmp10_) {
			FILE* _tmp11_;
			const gchar* _tmp12_ = NULL;
			_tmp11_ = stderr;
			_tmp12_ = _ ("The registry cache is invalid.\n");
			fprintf (_tmp11_, "%s", _tmp12_);
			result = EXIT_FAILURE;
			_g_object_unref0 (registry);
			_g_option_context_free0 (option);
			return result;
		}
	} else {
		IBusRegistry* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_ = FALSE;
		_tmp13_ = registry;
		_tmp14_ = is_system;
		_tmp15_ = ibus_registry_load_cache (_tmp13_, !_tmp14_);
		if (!_tmp15_) {
			FILE* _tmp16_;
			const gchar* _tmp17_ = NULL;
			_tmp16_ = stderr;
			_tmp17_ = _ ("The registry cache is invalid.\n");
			fprintf (_tmp16_, "%s", _tmp17_);
			result = EXIT_FAILURE;
			_g_object_unref0 (registry);
			_g_option_context_free0 (option);
			return result;
		}
	}
	_tmp18_ = g_string_new ("");
	output = _tmp18_;
	_tmp19_ = registry;
	_tmp20_ = output;
	ibus_registry_output (_tmp19_, _tmp20_, 1);
	_tmp21_ = output;
	_tmp22_ = _tmp21_->str;
	g_print ("%s\n", _tmp22_);
	result = EXIT_SUCCESS;
	_g_string_free0 (output);
	_g_object_unref0 (registry);
	_g_option_context_free0 (option);
	return result;
}


gint write_cache (gchar** argv, int argv_length1) {
	gint result = 0;
	static const GOptionEntry options[] = {{"system", (gchar) 0, 0, G_OPTION_ARG_NONE, &is_system, "Write the system registry cache.", NULL}, {"file", (gchar) 0, 0, G_OPTION_ARG_STRING, &cache_file, "Write the registry cache FILE.", "FILE"}, {NULL}};
	GOptionContext* _tmp0_;
	GOptionContext* option;
	GOptionContext* _tmp1_;
	IBusRegistry* _tmp6_;
	IBusRegistry* registry;
	IBusRegistry* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp14_ = 0;
	IBusRegistry* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_ = FALSE;
	gint _tmp18_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new (NULL);
	option = _tmp0_;
	_tmp1_ = option;
	g_option_context_add_main_entries (_tmp1_, options, GETTEXT_PACKAGE);
	{
		GOptionContext* _tmp2_;
		_tmp2_ = option;
		g_option_context_parse (_tmp2_, &argv_length1, &argv, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch3_g_option_error;
			}
			_g_option_context_free0 (option);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally3;
	__catch3_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		fprintf (_tmp3_, "%s\n", _tmp5_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (option);
		return result;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (option);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp6_ = ibus_registry_new ();
	g_object_ref_sink (_tmp6_);
	registry = _tmp6_;
	_tmp7_ = registry;
	ibus_registry_load (_tmp7_);
	_tmp8_ = cache_file;
	if (_tmp8_ != NULL) {
		gint _tmp9_ = 0;
		IBusRegistry* _tmp10_;
		const gchar* _tmp11_;
		gboolean _tmp12_ = FALSE;
		gint _tmp13_;
		_tmp10_ = registry;
		_tmp11_ = cache_file;
		_tmp12_ = ibus_registry_save_cache_file (_tmp10_, _tmp11_);
		if (_tmp12_) {
			_tmp9_ = EXIT_SUCCESS;
		} else {
			_tmp9_ = EXIT_FAILURE;
		}
		_tmp13_ = _tmp9_;
		result = _tmp13_;
		_g_object_unref0 (registry);
		_g_option_context_free0 (option);
		return result;
	}
	_tmp15_ = registry;
	_tmp16_ = is_system;
	_tmp17_ = ibus_registry_save_cache (_tmp15_, !_tmp16_);
	if (_tmp17_) {
		_tmp14_ = EXIT_SUCCESS;
	} else {
		_tmp14_ = EXIT_FAILURE;
	}
	_tmp18_ = _tmp14_;
	result = _tmp18_;
	_g_object_unref0 (registry);
	_g_option_context_free0 (option);
	return result;
}


gint print_address (gchar** argv, int argv_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = ibus_get_address ();
	g_print ("%s\n", _tmp0_);
	result = EXIT_SUCCESS;
	return result;
}


gint print_help (gchar** argv, int argv_length1) {
	gint result = 0;
	FILE* _tmp0_;
	_tmp0_ = stdout;
	print_usage (_tmp0_);
	result = EXIT_SUCCESS;
	return result;
}


CommandEntry* command_entry_dup (const CommandEntry* self) {
	CommandEntry* dup;
	dup = g_new0 (CommandEntry, 1);
	memcpy (dup, self, sizeof (CommandEntry));
	return dup;
}


void command_entry_free (CommandEntry* self) {
	g_free (self);
}


GType command_entry_get_type (void) {
	static volatile gsize command_entry_type_id__volatile = 0;
	if (g_once_init_enter (&command_entry_type_id__volatile)) {
		GType command_entry_type_id;
		command_entry_type_id = g_boxed_type_register_static ("CommandEntry", (GBoxedCopyFunc) command_entry_dup, (GBoxedFreeFunc) command_entry_free);
		g_once_init_leave (&command_entry_type_id__volatile, command_entry_type_id);
	}
	return command_entry_type_id__volatile;
}


static gint _get_set_engine_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = get_set_engine (argv, argv_length1);
	return result;
}


static gint _exit_daemon_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = exit_daemon (argv, argv_length1);
	return result;
}


static gint _list_engine_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = list_engine (argv, argv_length1);
	return result;
}


static gint _message_watch_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = message_watch (argv, argv_length1);
	return result;
}


static gint _restart_daemon_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = restart_daemon (argv, argv_length1);
	return result;
}


static gint _print_version_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = print_version (argv, argv_length1);
	return result;
}


static gint _read_cache_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = read_cache (argv, argv_length1);
	return result;
}


static gint _write_cache_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = write_cache (argv, argv_length1);
	return result;
}


static gint _print_address_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = print_address (argv, argv_length1);
	return result;
}


static gint _print_help_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = print_help (argv, argv_length1);
	return result;
}


void print_usage (FILE* stream) {
	FILE* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	FILE* _tmp3_;
	const gchar* _tmp4_ = NULL;
	g_return_if_fail (stream != NULL);
	_tmp0_ = stream;
	_tmp1_ = _ ("Usage: %s COMMAND [OPTION...]\n\n");
	_tmp2_ = program_name;
	fprintf (_tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = stream;
	_tmp4_ = _ ("Commands:\n");
	fprintf (_tmp3_, "%s", _tmp4_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_;
				gint _tmp8_;
				FILE* _tmp9_;
				gint _tmp10_;
				CommandEntry _tmp11_;
				const gchar* _tmp12_;
				gint _tmp13_;
				CommandEntry _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_ = NULL;
				_tmp6_ = _tmp5_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp8_ = i;
				if (!(_tmp8_ < G_N_ELEMENTS (commands))) {
					break;
				}
				_tmp9_ = stream;
				_tmp10_ = i;
				_tmp11_ = commands[_tmp10_];
				_tmp12_ = _tmp11_.name;
				_tmp13_ = i;
				_tmp14_ = commands[_tmp13_];
				_tmp15_ = _tmp14_.description;
				_tmp16_ = g_dgettext (NULL, _tmp15_);
				fprintf (_tmp9_, "  %-11s    %s\n", _tmp12_, _tmp16_);
			}
		}
	}
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gint _vala_main (gchar** argv, int argv_length1) {
	gint result = 0;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** new_argv;
	gint new_argv_length1;
	gint _new_argv_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	FILE* _tmp28_;
	const gchar* _tmp29_ = NULL;
	gchar** _tmp30_;
	gint _tmp30__length1;
	const gchar* _tmp31_;
	FILE* _tmp32_;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, GLIB_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	ibus_init ();
	_tmp0_ = argv;
	_tmp0__length1 = argv_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = g_path_get_basename (_tmp1_);
	_g_free0 (program_name);
	program_name = _tmp2_;
	_tmp3_ = argv;
	_tmp3__length1 = argv_length1;
	if (_tmp3__length1 < 2) {
		FILE* _tmp4_;
		_tmp4_ = stderr;
		print_usage (_tmp4_);
		result = EXIT_FAILURE;
		return result;
	}
	_tmp5_ = argv;
	_tmp5__length1 = argv_length1;
	_tmp6_ = argv;
	_tmp6__length1 = argv_length1;
	_tmp7_ = ((_tmp5_ + 1) != NULL) ? _vala_array_dup1 (_tmp5_ + 1, _tmp6__length1 - 1) : ((gpointer) (_tmp5_ + 1));
	_tmp7__length1 = _tmp6__length1 - 1;
	new_argv = _tmp7_;
	new_argv_length1 = _tmp7__length1;
	_new_argv_size_ = new_argv_length1;
	_tmp8_ = new_argv;
	_tmp8__length1 = new_argv_length1;
	_tmp9_ = program_name;
	_tmp10_ = new_argv;
	_tmp10__length1 = new_argv_length1;
	_tmp11_ = _tmp10_[0];
	_tmp12_ = g_strdup_printf ("%s %s", _tmp9_, _tmp11_);
	_g_free0 (_tmp8_[0]);
	_tmp8_[0] = _tmp12_;
	_tmp13_ = _tmp8_[0];
	{
		gint i;
		i = 0;
		{
			gboolean _tmp14_;
			_tmp14_ = TRUE;
			while (TRUE) {
				gboolean _tmp15_;
				gint _tmp17_;
				gint _tmp18_;
				CommandEntry _tmp19_;
				const gchar* _tmp20_;
				gchar** _tmp21_;
				gint _tmp21__length1;
				const gchar* _tmp22_;
				_tmp15_ = _tmp14_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp14_ = FALSE;
				_tmp17_ = i;
				if (!(_tmp17_ < G_N_ELEMENTS (commands))) {
					break;
				}
				_tmp18_ = i;
				_tmp19_ = commands[_tmp18_];
				_tmp20_ = _tmp19_.name;
				_tmp21_ = argv;
				_tmp21__length1 = argv_length1;
				_tmp22_ = _tmp21_[1];
				if (g_strcmp0 (_tmp20_, _tmp22_) == 0) {
					gint _tmp23_;
					CommandEntry _tmp24_;
					EntryFunc _tmp25_;
					void* _tmp25__target;
					gchar** _tmp26_;
					gint _tmp26__length1;
					gint _tmp27_ = 0;
					_tmp23_ = i;
					_tmp24_ = commands[_tmp23_];
					_tmp25_ = _tmp24_.entry;
					_tmp25__target = _tmp24_.entry_target;
					_tmp26_ = new_argv;
					_tmp26__length1 = new_argv_length1;
					_tmp27_ = _tmp25_ (_tmp26_, _tmp26__length1, _tmp25__target);
					result = _tmp27_;
					new_argv = (_vala_array_free (new_argv, new_argv_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
	}
	_tmp28_ = stderr;
	_tmp29_ = _ ("%s is unknown command!\n");
	_tmp30_ = argv;
	_tmp30__length1 = argv_length1;
	_tmp31_ = _tmp30_[1];
	fprintf (_tmp28_, _tmp29_, _tmp31_);
	_tmp32_ = stderr;
	print_usage (_tmp32_);
	result = EXIT_FAILURE;
	new_argv = (_vala_array_free (new_argv, new_argv_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



