/* potential-match.c generated by valac 0.17.6.4-590d, the Vala compiler
 * generated from potential-match.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>


#define FOLKS_TYPE_MATCH_RESULT (folks_match_result_get_type ())

#define FOLKS_TYPE_POTENTIAL_MATCH (folks_potential_match_get_type ())
#define FOLKS_POTENTIAL_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatch))
#define FOLKS_POTENTIAL_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatchClass))
#define FOLKS_IS_POTENTIAL_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_POTENTIAL_MATCH))
#define FOLKS_IS_POTENTIAL_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_POTENTIAL_MATCH))
#define FOLKS_POTENTIAL_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatchClass))

typedef struct _FolksPotentialMatch FolksPotentialMatch;
typedef struct _FolksPotentialMatchClass FolksPotentialMatchClass;
typedef struct _FolksPotentialMatchPrivate FolksPotentialMatchPrivate;

#define FOLKS_TYPE_INDIVIDUAL (folks_individual_get_type ())
#define FOLKS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividual))
#define FOLKS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))
#define FOLKS_IS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_IS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_INDIVIDUAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))

typedef struct _FolksIndividual FolksIndividual;
typedef struct _FolksIndividualClass FolksIndividualClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FOLKS_TYPE_TRUST_LEVEL (folks_trust_level_get_type ())

#define FOLKS_TYPE_GENDER_DETAILS (folks_gender_details_get_type ())
#define FOLKS_GENDER_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_GENDER_DETAILS, FolksGenderDetails))
#define FOLKS_IS_GENDER_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_GENDER_DETAILS))
#define FOLKS_GENDER_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_GENDER_DETAILS, FolksGenderDetailsIface))

typedef struct _FolksGenderDetails FolksGenderDetails;
typedef struct _FolksGenderDetailsIface FolksGenderDetailsIface;

#define FOLKS_TYPE_GENDER (folks_gender_get_type ())

#define FOLKS_TYPE_PHONE_DETAILS (folks_phone_details_get_type ())
#define FOLKS_PHONE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PHONE_DETAILS, FolksPhoneDetails))
#define FOLKS_IS_PHONE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PHONE_DETAILS))
#define FOLKS_PHONE_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_PHONE_DETAILS, FolksPhoneDetailsIface))

typedef struct _FolksPhoneDetails FolksPhoneDetails;
typedef struct _FolksPhoneDetailsIface FolksPhoneDetailsIface;

#define FOLKS_TYPE_ABSTRACT_FIELD_DETAILS (folks_abstract_field_details_get_type ())
#define FOLKS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails))
#define FOLKS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))

typedef struct _FolksAbstractFieldDetails FolksAbstractFieldDetails;
typedef struct _FolksAbstractFieldDetailsClass FolksAbstractFieldDetailsClass;

#define FOLKS_TYPE_PHONE_FIELD_DETAILS (folks_phone_field_details_get_type ())
#define FOLKS_PHONE_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PHONE_FIELD_DETAILS, FolksPhoneFieldDetails))
#define FOLKS_PHONE_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PHONE_FIELD_DETAILS, FolksPhoneFieldDetailsClass))
#define FOLKS_IS_PHONE_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PHONE_FIELD_DETAILS))
#define FOLKS_IS_PHONE_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PHONE_FIELD_DETAILS))
#define FOLKS_PHONE_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PHONE_FIELD_DETAILS, FolksPhoneFieldDetailsClass))

typedef struct _FolksPhoneFieldDetails FolksPhoneFieldDetails;
typedef struct _FolksPhoneFieldDetailsClass FolksPhoneFieldDetailsClass;

#define FOLKS_TYPE_NAME_DETAILS (folks_name_details_get_type ())
#define FOLKS_NAME_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_NAME_DETAILS, FolksNameDetails))
#define FOLKS_IS_NAME_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_NAME_DETAILS))
#define FOLKS_NAME_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_NAME_DETAILS, FolksNameDetailsIface))

typedef struct _FolksNameDetails FolksNameDetails;
typedef struct _FolksNameDetailsIface FolksNameDetailsIface;

#define FOLKS_TYPE_STRUCTURED_NAME (folks_structured_name_get_type ())
#define FOLKS_STRUCTURED_NAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName))
#define FOLKS_STRUCTURED_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredNameClass))
#define FOLKS_IS_STRUCTURED_NAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_STRUCTURED_NAME))
#define FOLKS_IS_STRUCTURED_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_STRUCTURED_NAME))
#define FOLKS_STRUCTURED_NAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredNameClass))

typedef struct _FolksStructuredName FolksStructuredName;
typedef struct _FolksStructuredNameClass FolksStructuredNameClass;

#define FOLKS_TYPE_ALIAS_DETAILS (folks_alias_details_get_type ())
#define FOLKS_ALIAS_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ALIAS_DETAILS, FolksAliasDetails))
#define FOLKS_IS_ALIAS_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ALIAS_DETAILS))
#define FOLKS_ALIAS_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_ALIAS_DETAILS, FolksAliasDetailsIface))

typedef struct _FolksAliasDetails FolksAliasDetails;
typedef struct _FolksAliasDetailsIface FolksAliasDetailsIface;

#define FOLKS_TYPE_IM_DETAILS (folks_im_details_get_type ())
#define FOLKS_IM_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IM_DETAILS, FolksImDetails))
#define FOLKS_IS_IM_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IM_DETAILS))
#define FOLKS_IM_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_IM_DETAILS, FolksImDetailsIface))

typedef struct _FolksImDetails FolksImDetails;
typedef struct _FolksImDetailsIface FolksImDetailsIface;

#define FOLKS_TYPE_IM_FIELD_DETAILS (folks_im_field_details_get_type ())
#define FOLKS_IM_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IM_FIELD_DETAILS, FolksImFieldDetails))
#define FOLKS_IM_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_IM_FIELD_DETAILS, FolksImFieldDetailsClass))
#define FOLKS_IS_IM_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IM_FIELD_DETAILS))
#define FOLKS_IS_IM_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_IM_FIELD_DETAILS))
#define FOLKS_IM_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_IM_FIELD_DETAILS, FolksImFieldDetailsClass))

typedef struct _FolksImFieldDetails FolksImFieldDetails;
typedef struct _FolksImFieldDetailsClass FolksImFieldDetailsClass;

#define FOLKS_TYPE_EMAIL_DETAILS (folks_email_details_get_type ())
#define FOLKS_EMAIL_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_EMAIL_DETAILS, FolksEmailDetails))
#define FOLKS_IS_EMAIL_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_EMAIL_DETAILS))
#define FOLKS_EMAIL_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_EMAIL_DETAILS, FolksEmailDetailsIface))

typedef struct _FolksEmailDetails FolksEmailDetails;
typedef struct _FolksEmailDetailsIface FolksEmailDetailsIface;

#define FOLKS_TYPE_EMAIL_FIELD_DETAILS (folks_email_field_details_get_type ())
#define FOLKS_EMAIL_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_EMAIL_FIELD_DETAILS, FolksEmailFieldDetails))
#define FOLKS_EMAIL_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_EMAIL_FIELD_DETAILS, FolksEmailFieldDetailsClass))
#define FOLKS_IS_EMAIL_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_EMAIL_FIELD_DETAILS))
#define FOLKS_IS_EMAIL_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_EMAIL_FIELD_DETAILS))
#define FOLKS_EMAIL_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_EMAIL_FIELD_DETAILS, FolksEmailFieldDetailsClass))

typedef struct _FolksEmailFieldDetails FolksEmailFieldDetails;
typedef struct _FolksEmailFieldDetailsClass FolksEmailFieldDetailsClass;

typedef enum  {
	FOLKS_MATCH_RESULT_NONE = -1,
	FOLKS_MATCH_RESULT_VERY_LOW = 0,
	FOLKS_MATCH_RESULT_LOW = 1,
	FOLKS_MATCH_RESULT_MEDIUM = 2,
	FOLKS_MATCH_RESULT_HIGH = 3,
	FOLKS_MATCH_RESULT_VERY_HIGH = 4,
	FOLKS_MATCH_RESULT_MIN = FOLKS_MATCH_RESULT_NONE,
	FOLKS_MATCH_RESULT_MAX = FOLKS_MATCH_RESULT_VERY_HIGH
} FolksMatchResult;

struct _FolksPotentialMatch {
	GObject parent_instance;
	FolksPotentialMatchPrivate * priv;
};

struct _FolksPotentialMatchClass {
	GObjectClass parent_class;
};

struct _FolksPotentialMatchPrivate {
	FolksIndividual* _individual_a;
	FolksIndividual* _individual_b;
};

typedef enum  {
	FOLKS_TRUST_LEVEL_NONE,
	FOLKS_TRUST_LEVEL_PERSONAS
} FolksTrustLevel;

typedef enum  {
	FOLKS_GENDER_UNSPECIFIED,
	FOLKS_GENDER_MALE,
	FOLKS_GENDER_FEMALE
} FolksGender;

typedef enum  {
	FOLKS_PROPERTY_ERROR_NOT_WRITEABLE,
	FOLKS_PROPERTY_ERROR_INVALID_VALUE,
	FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR,
	FOLKS_PROPERTY_ERROR_UNAVAILABLE
} FolksPropertyError;
#define FOLKS_PROPERTY_ERROR folks_property_error_quark ()
struct _FolksGenderDetailsIface {
	GTypeInterface parent_iface;
	void (*change_gender) (FolksGenderDetails* self, FolksGender gender, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_gender_finish) (FolksGenderDetails* self, GAsyncResult* _res_, GError** error);
	FolksGender (*get_gender) (FolksGenderDetails* self);
	void (*set_gender) (FolksGenderDetails* self, FolksGender value);
};

struct _FolksPhoneDetailsIface {
	GTypeInterface parent_iface;
	void (*change_phone_numbers) (FolksPhoneDetails* self, GeeSet* phone_numbers, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_phone_numbers_finish) (FolksPhoneDetails* self, GAsyncResult* _res_, GError** error);
	GeeSet* (*get_phone_numbers) (FolksPhoneDetails* self);
	void (*set_phone_numbers) (FolksPhoneDetails* self, GeeSet* value);
};

struct _FolksNameDetailsIface {
	GTypeInterface parent_iface;
	void (*change_structured_name) (FolksNameDetails* self, FolksStructuredName* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_structured_name_finish) (FolksNameDetails* self, GAsyncResult* _res_, GError** error);
	void (*change_full_name) (FolksNameDetails* self, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_full_name_finish) (FolksNameDetails* self, GAsyncResult* _res_, GError** error);
	void (*change_nickname) (FolksNameDetails* self, const gchar* nickname, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_nickname_finish) (FolksNameDetails* self, GAsyncResult* _res_, GError** error);
	FolksStructuredName* (*get_structured_name) (FolksNameDetails* self);
	void (*set_structured_name) (FolksNameDetails* self, FolksStructuredName* value);
	const gchar* (*get_full_name) (FolksNameDetails* self);
	void (*set_full_name) (FolksNameDetails* self, const gchar* value);
	const gchar* (*get_nickname) (FolksNameDetails* self);
	void (*set_nickname) (FolksNameDetails* self, const gchar* value);
};

struct _FolksAliasDetailsIface {
	GTypeInterface parent_iface;
	void (*change_alias) (FolksAliasDetails* self, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_alias_finish) (FolksAliasDetails* self, GAsyncResult* _res_, GError** error);
	const gchar* (*get_alias) (FolksAliasDetails* self);
	void (*set_alias) (FolksAliasDetails* self, const gchar* value);
};

struct _FolksImDetailsIface {
	GTypeInterface parent_iface;
	void (*change_im_addresses) (FolksImDetails* self, GeeMultiMap* im_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_im_addresses_finish) (FolksImDetails* self, GAsyncResult* _res_, GError** error);
	GeeMultiMap* (*get_im_addresses) (FolksImDetails* self);
	void (*set_im_addresses) (FolksImDetails* self, GeeMultiMap* value);
};

struct _FolksEmailDetailsIface {
	GTypeInterface parent_iface;
	void (*change_email_addresses) (FolksEmailDetails* self, GeeSet* email_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_email_addresses_finish) (FolksEmailDetails* self, GAsyncResult* _res_, GError** error);
	GeeSet* (*get_email_addresses) (FolksEmailDetails* self);
	void (*set_email_addresses) (FolksEmailDetails* self, GeeSet* value);
};


static gpointer folks_potential_match_parent_class = NULL;
extern GeeSet* folks_potential_match_known_email_aliases;
GeeSet* folks_potential_match_known_email_aliases = NULL;
static gdouble folks_potential_match__DIST_THRESHOLD;
static gdouble folks_potential_match__DIST_THRESHOLD = 0.70;

GType folks_match_result_get_type (void) G_GNUC_CONST;
GType folks_potential_match_get_type (void) G_GNUC_CONST;
GType folks_individual_get_type (void) G_GNUC_CONST;
#define FOLKS_POTENTIAL_MATCH_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatchPrivate))
enum  {
	FOLKS_POTENTIAL_MATCH_DUMMY_PROPERTY
};
#define FOLKS_POTENTIAL_MATCH__SEPARATORS "._-+"
FolksPotentialMatch* folks_potential_match_new (void);
FolksPotentialMatch* folks_potential_match_construct (GType object_type);
FolksMatchResult folks_potential_match_potential_match (FolksPotentialMatch* self, FolksIndividual* a, FolksIndividual* b);
GType folks_trust_level_get_type (void) G_GNUC_CONST;
FolksTrustLevel folks_individual_get_trust_level (FolksIndividual* self);
gboolean folks_individual_has_anti_link_with_individual (FolksIndividual* self, FolksIndividual* i);
GType folks_gender_get_type (void) G_GNUC_CONST;
GQuark folks_property_error_quark (void);
GType folks_gender_details_get_type (void) G_GNUC_CONST;
FolksGender folks_gender_details_get_gender (FolksGenderDetails* self);
static FolksMatchResult _folks_potential_match_inspect_im_addresses (FolksPotentialMatch* self, FolksMatchResult old_result);
static FolksMatchResult _folks_potential_match_inspect_emails (FolksPotentialMatch* self, FolksMatchResult old_result);
static FolksMatchResult _folks_potential_match_inspect_phone_numbers (FolksPotentialMatch* self, FolksMatchResult old_result);
static FolksMatchResult _folks_potential_match_name_similarity (FolksPotentialMatch* self, FolksMatchResult old_result);
GType folks_abstract_field_details_get_type (void) G_GNUC_CONST;
GType folks_phone_field_details_get_type (void) G_GNUC_CONST;
GType folks_phone_details_get_type (void) G_GNUC_CONST;
GeeSet* folks_phone_details_get_phone_numbers (FolksPhoneDetails* self);
gboolean folks_abstract_field_details_values_equal (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
static gboolean _folks_potential_match_look_alike (FolksPotentialMatch* self, const gchar* a, const gchar* b);
GType folks_structured_name_get_type (void) G_GNUC_CONST;
GType folks_name_details_get_type (void) G_GNUC_CONST;
const gchar* folks_name_details_get_nickname (FolksNameDetails* self);
static gboolean _folks_potential_match_look_alike_or_identical (FolksPotentialMatch* self, const gchar* a, const gchar* b, gboolean* exact);
const gchar* folks_name_details_get_full_name (FolksNameDetails* self);
GType folks_alias_details_get_type (void) G_GNUC_CONST;
const gchar* folks_alias_details_get_alias (FolksAliasDetails* self);
FolksStructuredName* folks_name_details_get_structured_name (FolksNameDetails* self);
gboolean folks_structured_name_is_empty (FolksStructuredName* self);
gboolean folks_structured_name_equal (FolksStructuredName* self, FolksStructuredName* other);
gboolean _folks_utils_str_equal_safe (const gchar* a, const gchar* b);
const gchar* folks_structured_name_get_given_name (FolksStructuredName* self);
const gchar* folks_structured_name_get_family_name (FolksStructuredName* self);
const gchar* folks_structured_name_get_additional_names (FolksStructuredName* self);
const gchar* folks_structured_name_get_prefixes (FolksStructuredName* self);
const gchar* folks_structured_name_get_suffixes (FolksStructuredName* self);
static FolksMatchResult _folks_potential_match_inc_match_level (FolksPotentialMatch* self, FolksMatchResult current_level, gint times);
GType folks_im_field_details_get_type (void) G_GNUC_CONST;
GType folks_im_details_get_type (void) G_GNUC_CONST;
GeeMultiMap* folks_im_details_get_im_addresses (FolksImDetails* self);
gconstpointer folks_abstract_field_details_get_value (FolksAbstractFieldDetails* self);
GType folks_email_field_details_get_type (void) G_GNUC_CONST;
GType folks_email_details_get_type (void) G_GNUC_CONST;
GeeSet* folks_email_details_get_email_addresses (FolksEmailDetails* self);
static gboolean _folks_potential_match_check_initials_expansion (FolksPotentialMatch* self, gchar** tokens_a, int tokens_a_length1, gchar** tokens_b, int tokens_b_length1);
static gboolean _folks_potential_match_match_tokens (FolksPotentialMatch* self, gchar** tokens_a, int tokens_a_length1, gchar** tokens_b, int tokens_b_length1);
static gboolean _folks_potential_match_do_check_initials_expansion (FolksPotentialMatch* self, gchar** expanded_name, int expanded_name_length1, const gchar* initials);
static gboolean _folks_potential_match_do_match_tokens (FolksPotentialMatch* self, gchar** bigger_set, int bigger_set_length1, gchar** smaller_set, int smaller_set_length1);
static gunichar* _folks_potential_match_strip_string (FolksPotentialMatch* self, const gchar* s, int* result_length1);
static gdouble _folks_potential_match_jaro_dist (FolksPotentialMatch* self, gunichar* s1, int s1_length1, gunichar* s2, int s2_length1);
static gint _folks_potential_match_matches (FolksPotentialMatch* self, gunichar* s1, int s1_length1, gunichar* s2, int s2_length1, gint max_dist, gdouble* t);
static gunichar _folks_potential_match_stripped_char (FolksPotentialMatch* self, gunichar ch);
static gint _folks_potential_match_contains (FolksPotentialMatch* self, gunichar* haystack, int haystack_length1, gunichar c, guint pos, guint max_dist);
static void folks_potential_match_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * Likely-ness of a potential match.
 *
 * Note that the order should be maintained.
 *
 * @since 0.5.0
 */
GType folks_match_result_get_type (void) {
	static volatile gsize folks_match_result_type_id__volatile = 0;
	if (g_once_init_enter (&folks_match_result_type_id__volatile)) {
		static const GEnumValue values[] = {{FOLKS_MATCH_RESULT_NONE, "FOLKS_MATCH_RESULT_NONE", "none"}, {FOLKS_MATCH_RESULT_VERY_LOW, "FOLKS_MATCH_RESULT_VERY_LOW", "very-low"}, {FOLKS_MATCH_RESULT_LOW, "FOLKS_MATCH_RESULT_LOW", "low"}, {FOLKS_MATCH_RESULT_MEDIUM, "FOLKS_MATCH_RESULT_MEDIUM", "medium"}, {FOLKS_MATCH_RESULT_HIGH, "FOLKS_MATCH_RESULT_HIGH", "high"}, {FOLKS_MATCH_RESULT_VERY_HIGH, "FOLKS_MATCH_RESULT_VERY_HIGH", "very-high"}, {FOLKS_MATCH_RESULT_MIN, "FOLKS_MATCH_RESULT_MIN", "min"}, {FOLKS_MATCH_RESULT_MAX, "FOLKS_MATCH_RESULT_MAX", "max"}, {0, NULL, NULL}};
		GType folks_match_result_type_id;
		folks_match_result_type_id = g_enum_register_static ("FolksMatchResult", values);
		g_once_init_leave (&folks_match_result_type_id__volatile, folks_match_result_type_id);
	}
	return folks_match_result_type_id__volatile;
}


/**
   * Create a new PotentialMatch.
   *
   * @return a new PotentialMatch
   *
   * @since 0.5.0
   */
FolksPotentialMatch* folks_potential_match_construct (GType object_type) {
	FolksPotentialMatch * self = NULL;
	self = (FolksPotentialMatch*) g_object_new (object_type, NULL);
	return self;
}


FolksPotentialMatch* folks_potential_match_new (void) {
	return folks_potential_match_construct (FOLKS_TYPE_POTENTIAL_MATCH);
}


/**
   * Whether two individuals are likely to be the same person.
   *
   * @param a an individual to compare
   * @param b another individual to compare
   *
   * @since 0.5.0
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


FolksMatchResult folks_potential_match_potential_match (FolksPotentialMatch* self, FolksIndividual* a, FolksIndividual* b) {
	FolksMatchResult result = 0;
	FolksIndividual* _tmp0_;
	FolksIndividual* _tmp1_;
	FolksIndividual* _tmp2_;
	FolksIndividual* _tmp3_;
	FolksMatchResult _result_;
	gboolean _tmp4_ = FALSE;
	FolksIndividual* _tmp5_;
	FolksTrustLevel _tmp6_;
	FolksTrustLevel _tmp7_;
	gboolean _tmp11_;
	FolksIndividual* _tmp12_;
	FolksIndividual* _tmp13_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	FolksIndividual* _tmp17_;
	FolksGender _tmp18_;
	FolksGender _tmp19_;
	gboolean _tmp23_;
	gboolean _tmp30_;
	FolksMatchResult _tmp31_;
	FolksMatchResult _tmp32_ = 0;
	FolksMatchResult _tmp33_;
	FolksMatchResult _tmp34_;
	FolksMatchResult _tmp35_ = 0;
	FolksMatchResult _tmp36_;
	FolksMatchResult _tmp37_;
	FolksMatchResult _tmp38_ = 0;
	FolksMatchResult _tmp39_;
	FolksMatchResult _tmp40_;
	FolksMatchResult _tmp41_ = 0;
	FolksMatchResult _tmp42_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_individual_a);
	self->priv->_individual_a = _tmp1_;
	_tmp2_ = b;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->_individual_b);
	self->priv->_individual_b = _tmp3_;
	_result_ = FOLKS_MATCH_RESULT_MIN;
	_tmp5_ = a;
	_tmp6_ = folks_individual_get_trust_level (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == FOLKS_TRUST_LEVEL_NONE) {
		_tmp4_ = TRUE;
	} else {
		FolksIndividual* _tmp8_;
		FolksTrustLevel _tmp9_;
		FolksTrustLevel _tmp10_;
		_tmp8_ = b;
		_tmp9_ = folks_individual_get_trust_level (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = _tmp10_ == FOLKS_TRUST_LEVEL_NONE;
	}
	_tmp11_ = _tmp4_;
	if (_tmp11_) {
		result = _result_;
		return result;
	}
	_tmp12_ = a;
	_tmp13_ = b;
	_tmp14_ = folks_individual_has_anti_link_with_individual (_tmp12_, _tmp13_);
	if (_tmp14_) {
		result = _result_;
		return result;
	}
	_result_ = FOLKS_MATCH_RESULT_VERY_LOW;
	_tmp17_ = self->priv->_individual_a;
	_tmp18_ = folks_gender_details_get_gender ((FolksGenderDetails*) _tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != FOLKS_GENDER_UNSPECIFIED) {
		FolksIndividual* _tmp20_;
		FolksGender _tmp21_;
		FolksGender _tmp22_;
		_tmp20_ = self->priv->_individual_b;
		_tmp21_ = folks_gender_details_get_gender ((FolksGenderDetails*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp16_ = _tmp22_ != FOLKS_GENDER_UNSPECIFIED;
	} else {
		_tmp16_ = FALSE;
	}
	_tmp23_ = _tmp16_;
	if (_tmp23_) {
		FolksIndividual* _tmp24_;
		FolksGender _tmp25_;
		FolksGender _tmp26_;
		FolksIndividual* _tmp27_;
		FolksGender _tmp28_;
		FolksGender _tmp29_;
		_tmp24_ = self->priv->_individual_a;
		_tmp25_ = folks_gender_details_get_gender ((FolksGenderDetails*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = self->priv->_individual_b;
		_tmp28_ = folks_gender_details_get_gender ((FolksGenderDetails*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp15_ = _tmp26_ != _tmp29_;
	} else {
		_tmp15_ = FALSE;
	}
	_tmp30_ = _tmp15_;
	if (_tmp30_) {
		result = _result_;
		return result;
	}
	_tmp31_ = _result_;
	_tmp32_ = _folks_potential_match_inspect_im_addresses (self, _tmp31_);
	_result_ = _tmp32_;
	_tmp33_ = _result_;
	if (_tmp33_ == FOLKS_MATCH_RESULT_MAX) {
		result = _result_;
		return result;
	}
	_tmp34_ = _result_;
	_tmp35_ = _folks_potential_match_inspect_emails (self, _tmp34_);
	_result_ = _tmp35_;
	_tmp36_ = _result_;
	if (_tmp36_ == FOLKS_MATCH_RESULT_MAX) {
		result = _result_;
		return result;
	}
	_tmp37_ = _result_;
	_tmp38_ = _folks_potential_match_inspect_phone_numbers (self, _tmp37_);
	_result_ = _tmp38_;
	_tmp39_ = _result_;
	if (_tmp39_ == FOLKS_MATCH_RESULT_MAX) {
		result = _result_;
		return result;
	}
	_tmp40_ = _result_;
	_tmp41_ = _folks_potential_match_name_similarity (self, _tmp40_);
	_result_ = _tmp41_;
	_tmp42_ = _result_;
	if (_tmp42_ == FOLKS_MATCH_RESULT_MAX) {
		result = _result_;
		return result;
	}
	result = _result_;
	return result;
}


static FolksMatchResult _folks_potential_match_inspect_phone_numbers (FolksPotentialMatch* self, FolksMatchResult old_result) {
	FolksMatchResult result = 0;
	FolksIndividual* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* set_a;
	FolksIndividual* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	GeeSet* _tmp7_;
	GeeSet* set_b;
	FolksMatchResult _tmp23_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_individual_a;
	_tmp1_ = folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	set_a = _tmp3_;
	_tmp4_ = self->priv->_individual_b;
	_tmp5_ = folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	set_b = _tmp7_;
	{
		GeeSet* _tmp8_;
		GeeIterator* _tmp9_ = NULL;
		GeeIterator* _phone_fd_a_it;
		_tmp8_ = set_a;
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
		_phone_fd_a_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			gboolean _tmp11_ = FALSE;
			GeeIterator* _tmp12_;
			gpointer _tmp13_ = NULL;
			FolksPhoneFieldDetails* phone_fd_a;
			_tmp10_ = _phone_fd_a_it;
			_tmp11_ = gee_iterator_next (_tmp10_);
			if (!_tmp11_) {
				break;
			}
			_tmp12_ = _phone_fd_a_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			phone_fd_a = (FolksPhoneFieldDetails*) _tmp13_;
			{
				GeeSet* _tmp14_;
				GeeIterator* _tmp15_ = NULL;
				GeeIterator* _phone_fd_b_it;
				_tmp14_ = set_b;
				_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
				_phone_fd_b_it = _tmp15_;
				while (TRUE) {
					GeeIterator* _tmp16_;
					gboolean _tmp17_ = FALSE;
					GeeIterator* _tmp18_;
					gpointer _tmp19_ = NULL;
					FolksPhoneFieldDetails* phone_fd_b;
					FolksPhoneFieldDetails* _tmp20_;
					FolksPhoneFieldDetails* _tmp21_;
					gboolean _tmp22_ = FALSE;
					_tmp16_ = _phone_fd_b_it;
					_tmp17_ = gee_iterator_next (_tmp16_);
					if (!_tmp17_) {
						break;
					}
					_tmp18_ = _phone_fd_b_it;
					_tmp19_ = gee_iterator_get (_tmp18_);
					phone_fd_b = (FolksPhoneFieldDetails*) _tmp19_;
					_tmp20_ = phone_fd_a;
					_tmp21_ = phone_fd_b;
					_tmp22_ = folks_abstract_field_details_values_equal ((FolksAbstractFieldDetails*) _tmp20_, (FolksAbstractFieldDetails*) _tmp21_);
					if (_tmp22_) {
						result = FOLKS_MATCH_RESULT_HIGH;
						_g_object_unref0 (phone_fd_b);
						_g_object_unref0 (_phone_fd_b_it);
						_g_object_unref0 (phone_fd_a);
						_g_object_unref0 (_phone_fd_a_it);
						_g_object_unref0 (set_b);
						_g_object_unref0 (set_a);
						return result;
					}
					_g_object_unref0 (phone_fd_b);
				}
				_g_object_unref0 (_phone_fd_b_it);
			}
			_g_object_unref0 (phone_fd_a);
		}
		_g_object_unref0 (_phone_fd_a_it);
	}
	_tmp23_ = old_result;
	result = _tmp23_;
	_g_object_unref0 (set_b);
	_g_object_unref0 (set_a);
	return result;
}


static FolksMatchResult _folks_potential_match_name_similarity (FolksPotentialMatch* self, FolksMatchResult old_result) {
	FolksMatchResult result = 0;
	gdouble similarity;
	gboolean exact_match;
	FolksIndividual* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	FolksIndividual* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	FolksIndividual* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	FolksIndividual* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp27_;
	gboolean _tmp36_;
	gboolean _tmp45_;
	FolksIndividual* _tmp47_;
	FolksStructuredName* _tmp48_;
	FolksStructuredName* _tmp49_;
	FolksStructuredName* _tmp50_;
	FolksStructuredName* _a;
	FolksIndividual* _tmp51_;
	FolksStructuredName* _tmp52_;
	FolksStructuredName* _tmp53_;
	FolksStructuredName* _tmp54_;
	FolksStructuredName* _b;
	gboolean _tmp55_ = FALSE;
	FolksStructuredName* _tmp56_;
	gboolean _tmp58_;
	gdouble _tmp119_;
	gdouble _tmp120_;
	gdouble _tmp121_;
	FolksMatchResult _tmp127_;
	g_return_val_if_fail (self != NULL, 0);
	similarity = 0.0;
	exact_match = FALSE;
	_tmp0_ = self->priv->_individual_a;
	_tmp1_ = folks_name_details_get_nickname ((FolksNameDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_individual_b;
	_tmp4_ = folks_name_details_get_nickname ((FolksNameDetails*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _folks_potential_match_look_alike (self, _tmp2_, _tmp5_);
	if (_tmp6_) {
		gdouble _tmp7_;
		_tmp7_ = similarity;
		similarity = _tmp7_ + 0.20;
	}
	_tmp11_ = self->priv->_individual_a;
	_tmp12_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->_individual_b;
	_tmp15_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp18_ = _folks_potential_match_look_alike_or_identical (self, _tmp13_, _tmp16_, &_tmp17_);
	exact_match = _tmp17_;
	if (_tmp18_) {
		_tmp10_ = TRUE;
	} else {
		FolksIndividual* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		FolksIndividual* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_ = FALSE;
		_tmp19_ = self->priv->_individual_a;
		_tmp20_ = folks_alias_details_get_alias ((FolksAliasDetails*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = self->priv->_individual_b;
		_tmp23_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp26_ = _folks_potential_match_look_alike_or_identical (self, _tmp21_, _tmp24_, &_tmp25_);
		exact_match = _tmp25_;
		_tmp10_ = _tmp26_;
	}
	_tmp27_ = _tmp10_;
	if (_tmp27_) {
		_tmp9_ = TRUE;
	} else {
		FolksIndividual* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		FolksIndividual* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		_tmp28_ = self->priv->_individual_a;
		_tmp29_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = self->priv->_individual_b;
		_tmp32_ = folks_alias_details_get_alias ((FolksAliasDetails*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp35_ = _folks_potential_match_look_alike_or_identical (self, _tmp30_, _tmp33_, &_tmp34_);
		exact_match = _tmp34_;
		_tmp9_ = _tmp35_;
	}
	_tmp36_ = _tmp9_;
	if (_tmp36_) {
		_tmp8_ = TRUE;
	} else {
		FolksIndividual* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		FolksIndividual* _tmp40_;
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		gboolean _tmp43_ = FALSE;
		gboolean _tmp44_ = FALSE;
		_tmp37_ = self->priv->_individual_a;
		_tmp38_ = folks_alias_details_get_alias ((FolksAliasDetails*) _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = self->priv->_individual_b;
		_tmp41_ = folks_alias_details_get_alias ((FolksAliasDetails*) _tmp40_);
		_tmp42_ = _tmp41_;
		_tmp44_ = _folks_potential_match_look_alike_or_identical (self, _tmp39_, _tmp42_, &_tmp43_);
		exact_match = _tmp43_;
		_tmp8_ = _tmp44_;
	}
	_tmp45_ = _tmp8_;
	if (_tmp45_) {
		gdouble _tmp46_;
		_tmp46_ = similarity;
		similarity = _tmp46_ + 0.70;
	}
	_tmp47_ = self->priv->_individual_a;
	_tmp48_ = folks_name_details_get_structured_name ((FolksNameDetails*) _tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = _g_object_ref0 (_tmp49_);
	_a = _tmp50_;
	_tmp51_ = self->priv->_individual_b;
	_tmp52_ = folks_name_details_get_structured_name ((FolksNameDetails*) _tmp51_);
	_tmp53_ = _tmp52_;
	_tmp54_ = _g_object_ref0 (_tmp53_);
	_b = _tmp54_;
	_tmp56_ = _a;
	if (_tmp56_ != NULL) {
		FolksStructuredName* _tmp57_;
		_tmp57_ = _b;
		_tmp55_ = _tmp57_ != NULL;
	} else {
		_tmp55_ = FALSE;
	}
	_tmp58_ = _tmp55_;
	if (_tmp58_) {
		FolksStructuredName* _tmp59_;
		FolksStructuredName* _tmp60_;
		FolksStructuredName* a;
		FolksStructuredName* _tmp61_;
		FolksStructuredName* _tmp62_;
		FolksStructuredName* b;
		gboolean _tmp63_ = FALSE;
		FolksStructuredName* _tmp64_;
		gboolean _tmp65_ = FALSE;
		gboolean _tmp69_;
		FolksStructuredName* _tmp70_;
		const gchar* _tmp71_;
		const gchar* _tmp72_;
		FolksStructuredName* _tmp73_;
		const gchar* _tmp74_;
		const gchar* _tmp75_;
		gboolean _tmp76_ = FALSE;
		gboolean _tmp78_ = FALSE;
		FolksStructuredName* _tmp79_;
		const gchar* _tmp80_;
		const gchar* _tmp81_;
		FolksStructuredName* _tmp82_;
		const gchar* _tmp83_;
		const gchar* _tmp84_;
		gboolean _tmp85_ = FALSE;
		gboolean _tmp93_;
		FolksStructuredName* _tmp95_;
		const gchar* _tmp96_;
		const gchar* _tmp97_;
		FolksStructuredName* _tmp98_;
		const gchar* _tmp99_;
		const gchar* _tmp100_;
		gboolean _tmp101_ = FALSE;
		FolksStructuredName* _tmp103_;
		const gchar* _tmp104_;
		const gchar* _tmp105_;
		FolksStructuredName* _tmp106_;
		const gchar* _tmp107_;
		const gchar* _tmp108_;
		gboolean _tmp109_ = FALSE;
		FolksStructuredName* _tmp111_;
		const gchar* _tmp112_;
		const gchar* _tmp113_;
		FolksStructuredName* _tmp114_;
		const gchar* _tmp115_;
		const gchar* _tmp116_;
		gboolean _tmp117_ = FALSE;
		_tmp59_ = _a;
		_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName));
		a = _tmp60_;
		_tmp61_ = _b;
		_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName));
		b = _tmp62_;
		_tmp64_ = a;
		_tmp65_ = folks_structured_name_is_empty (_tmp64_);
		if (_tmp65_ == FALSE) {
			FolksStructuredName* _tmp66_;
			FolksStructuredName* _tmp67_;
			gboolean _tmp68_ = FALSE;
			_tmp66_ = a;
			_tmp67_ = b;
			_tmp68_ = folks_structured_name_equal (_tmp66_, _tmp67_);
			_tmp63_ = _tmp68_;
		} else {
			_tmp63_ = FALSE;
		}
		_tmp69_ = _tmp63_;
		if (_tmp69_) {
			result = FOLKS_MATCH_RESULT_HIGH;
			_g_object_unref0 (b);
			_g_object_unref0 (a);
			_g_object_unref0 (_b);
			_g_object_unref0 (_a);
			return result;
		}
		_tmp70_ = a;
		_tmp71_ = folks_structured_name_get_given_name (_tmp70_);
		_tmp72_ = _tmp71_;
		_tmp73_ = b;
		_tmp74_ = folks_structured_name_get_given_name (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = _folks_utils_str_equal_safe (_tmp72_, _tmp75_);
		if (_tmp76_) {
			gdouble _tmp77_;
			_tmp77_ = similarity;
			similarity = _tmp77_ + 0.20;
		}
		_tmp79_ = a;
		_tmp80_ = folks_structured_name_get_family_name (_tmp79_);
		_tmp81_ = _tmp80_;
		_tmp82_ = b;
		_tmp83_ = folks_structured_name_get_family_name (_tmp82_);
		_tmp84_ = _tmp83_;
		_tmp85_ = _folks_potential_match_look_alike (self, _tmp81_, _tmp84_);
		if (_tmp85_) {
			FolksStructuredName* _tmp86_;
			const gchar* _tmp87_;
			const gchar* _tmp88_;
			FolksStructuredName* _tmp89_;
			const gchar* _tmp90_;
			const gchar* _tmp91_;
			gboolean _tmp92_ = FALSE;
			_tmp86_ = a;
			_tmp87_ = folks_structured_name_get_given_name (_tmp86_);
			_tmp88_ = _tmp87_;
			_tmp89_ = b;
			_tmp90_ = folks_structured_name_get_given_name (_tmp89_);
			_tmp91_ = _tmp90_;
			_tmp92_ = _folks_potential_match_look_alike (self, _tmp88_, _tmp91_);
			_tmp78_ = _tmp92_;
		} else {
			_tmp78_ = FALSE;
		}
		_tmp93_ = _tmp78_;
		if (_tmp93_) {
			gdouble _tmp94_;
			_tmp94_ = similarity;
			similarity = _tmp94_ + 0.40;
		}
		_tmp95_ = a;
		_tmp96_ = folks_structured_name_get_additional_names (_tmp95_);
		_tmp97_ = _tmp96_;
		_tmp98_ = b;
		_tmp99_ = folks_structured_name_get_additional_names (_tmp98_);
		_tmp100_ = _tmp99_;
		_tmp101_ = _folks_utils_str_equal_safe (_tmp97_, _tmp100_);
		if (_tmp101_) {
			gdouble _tmp102_;
			_tmp102_ = similarity;
			similarity = _tmp102_ + 0.5;
		}
		_tmp103_ = a;
		_tmp104_ = folks_structured_name_get_prefixes (_tmp103_);
		_tmp105_ = _tmp104_;
		_tmp106_ = b;
		_tmp107_ = folks_structured_name_get_prefixes (_tmp106_);
		_tmp108_ = _tmp107_;
		_tmp109_ = _folks_utils_str_equal_safe (_tmp105_, _tmp108_);
		if (_tmp109_) {
			gdouble _tmp110_;
			_tmp110_ = similarity;
			similarity = _tmp110_ + 0.5;
		}
		_tmp111_ = a;
		_tmp112_ = folks_structured_name_get_suffixes (_tmp111_);
		_tmp113_ = _tmp112_;
		_tmp114_ = b;
		_tmp115_ = folks_structured_name_get_suffixes (_tmp114_);
		_tmp116_ = _tmp115_;
		_tmp117_ = _folks_utils_str_equal_safe (_tmp113_, _tmp116_);
		if (_tmp117_) {
			gdouble _tmp118_;
			_tmp118_ = similarity;
			similarity = _tmp118_ + 0.5;
		}
		_g_object_unref0 (b);
		_g_object_unref0 (a);
	}
	_tmp119_ = similarity;
	g_debug ("potential-match.vala:276: [name_similarity] Got %f\n", _tmp119_);
	_tmp120_ = similarity;
	_tmp121_ = folks_potential_match__DIST_THRESHOLD;
	if (_tmp120_ >= _tmp121_) {
		gint inc;
		gboolean _tmp122_;
		FolksMatchResult _tmp124_;
		gint _tmp125_;
		FolksMatchResult _tmp126_ = 0;
		inc = 2;
		_tmp122_ = exact_match;
		if (_tmp122_) {
			gint _tmp123_;
			_tmp123_ = inc;
			inc = _tmp123_ + 1;
		}
		_tmp124_ = old_result;
		_tmp125_ = inc;
		_tmp126_ = _folks_potential_match_inc_match_level (self, _tmp124_, _tmp125_);
		result = _tmp126_;
		_g_object_unref0 (_b);
		_g_object_unref0 (_a);
		return result;
	}
	_tmp127_ = old_result;
	result = _tmp127_;
	_g_object_unref0 (_b);
	_g_object_unref0 (_a);
	return result;
}


/**
   * Number of equal IM addresses between two individuals.
   *
   * This compares the addresses without comparing their associated protocols.
   *
   * @since 0.5.0
   */
static FolksMatchResult _folks_potential_match_inspect_im_addresses (FolksPotentialMatch* self, FolksMatchResult old_result) {
	FolksMatchResult result = 0;
	GeeHashSet* _tmp0_;
	GeeHashSet* addrs;
	FolksMatchResult _tmp32_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	addrs = _tmp0_;
	{
		FolksIndividual* _tmp1_;
		GeeMultiMap* _tmp2_;
		GeeMultiMap* _tmp3_;
		GeeCollection* _tmp4_ = NULL;
		GeeCollection* _tmp5_;
		GeeIterator* _tmp6_ = NULL;
		GeeIterator* _tmp7_;
		GeeIterator* _im_a_it;
		_tmp1_ = self->priv->_individual_a;
		_tmp2_ = folks_im_details_get_im_addresses ((FolksImDetails*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_multi_map_get_values (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_im_a_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			gboolean _tmp9_ = FALSE;
			GeeIterator* _tmp10_;
			gpointer _tmp11_ = NULL;
			FolksImFieldDetails* im_a;
			GeeHashSet* _tmp12_;
			FolksImFieldDetails* _tmp13_;
			gconstpointer _tmp14_;
			const gchar* _tmp15_;
			_tmp8_ = _im_a_it;
			_tmp9_ = gee_iterator_next (_tmp8_);
			if (!_tmp9_) {
				break;
			}
			_tmp10_ = _im_a_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			im_a = (FolksImFieldDetails*) _tmp11_;
			_tmp12_ = addrs;
			_tmp13_ = im_a;
			_tmp14_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp13_);
			_tmp15_ = _tmp14_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, (const gchar*) _tmp15_);
			_g_object_unref0 (im_a);
		}
		_g_object_unref0 (_im_a_it);
	}
	{
		FolksIndividual* _tmp16_;
		GeeMultiMap* _tmp17_;
		GeeMultiMap* _tmp18_;
		GeeCollection* _tmp19_ = NULL;
		GeeCollection* _tmp20_;
		GeeIterator* _tmp21_ = NULL;
		GeeIterator* _tmp22_;
		GeeIterator* _im_b_it;
		_tmp16_ = self->priv->_individual_b;
		_tmp17_ = folks_im_details_get_im_addresses ((FolksImDetails*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = gee_multi_map_get_values (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = gee_iterable_iterator ((GeeIterable*) _tmp20_);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp20_);
		_im_b_it = _tmp22_;
		while (TRUE) {
			GeeIterator* _tmp23_;
			gboolean _tmp24_ = FALSE;
			GeeIterator* _tmp25_;
			gpointer _tmp26_ = NULL;
			FolksImFieldDetails* im_b;
			GeeHashSet* _tmp27_;
			FolksImFieldDetails* _tmp28_;
			gconstpointer _tmp29_;
			const gchar* _tmp30_;
			gboolean _tmp31_ = FALSE;
			_tmp23_ = _im_b_it;
			_tmp24_ = gee_iterator_next (_tmp23_);
			if (!_tmp24_) {
				break;
			}
			_tmp25_ = _im_b_it;
			_tmp26_ = gee_iterator_get (_tmp25_);
			im_b = (FolksImFieldDetails*) _tmp26_;
			_tmp27_ = addrs;
			_tmp28_ = im_b;
			_tmp29_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp27_, (const gchar*) _tmp30_);
			if (_tmp31_ == TRUE) {
				result = FOLKS_MATCH_RESULT_HIGH;
				_g_object_unref0 (im_b);
				_g_object_unref0 (_im_b_it);
				_g_object_unref0 (addrs);
				return result;
			}
			_g_object_unref0 (im_b);
		}
		_g_object_unref0 (_im_b_it);
	}
	_tmp32_ = old_result;
	result = _tmp32_;
	_g_object_unref0 (addrs);
	return result;
}


/**
   * Inspect email addresses.
   *
   * @since 0.5.0
   */
static FolksMatchResult _folks_potential_match_inspect_emails (FolksPotentialMatch* self, FolksMatchResult old_result) {
	FolksMatchResult result = 0;
	FolksIndividual* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* set_a;
	FolksIndividual* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	GeeSet* _tmp7_;
	GeeSet* set_b;
	FolksMatchResult _tmp8_;
	FolksMatchResult _result_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_individual_a;
	_tmp1_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	set_a = _tmp3_;
	_tmp4_ = self->priv->_individual_b;
	_tmp5_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	set_b = _tmp7_;
	_tmp8_ = old_result;
	_result_ = _tmp8_;
	{
		GeeSet* _tmp9_;
		GeeIterator* _tmp10_ = NULL;
		GeeIterator* _fd_a_it;
		_tmp9_ = set_a;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_fd_a_it = _tmp10_;
		while (TRUE) {
			GeeIterator* _tmp11_;
			gboolean _tmp12_ = FALSE;
			GeeIterator* _tmp13_;
			gpointer _tmp14_ = NULL;
			FolksEmailFieldDetails* fd_a;
			FolksEmailFieldDetails* _tmp15_;
			gconstpointer _tmp16_;
			const gchar* _tmp17_;
			gchar** _tmp18_;
			gchar** _tmp19_ = NULL;
			gchar** email_split_a;
			gint email_split_a_length1;
			gint _email_split_a_size_;
			gchar** _tmp20_;
			gint _tmp20__length1;
			gchar** _tmp24_;
			gint _tmp24__length1;
			const gchar* _tmp25_;
			gchar** _tmp26_;
			gchar** _tmp27_ = NULL;
			gchar** tokens_a;
			gint tokens_a_length1;
			gint _tokens_a_size_;
			_tmp11_ = _fd_a_it;
			_tmp12_ = gee_iterator_next (_tmp11_);
			if (!_tmp12_) {
				break;
			}
			_tmp13_ = _fd_a_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			fd_a = (FolksEmailFieldDetails*) _tmp14_;
			_tmp15_ = fd_a;
			_tmp16_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp19_ = _tmp18_ = g_strsplit ((const gchar*) _tmp17_, "@", 0);
			email_split_a = _tmp19_;
			email_split_a_length1 = _vala_array_length (_tmp18_);
			_email_split_a_size_ = email_split_a_length1;
			_tmp20_ = email_split_a;
			_tmp20__length1 = email_split_a_length1;
			if (_tmp20__length1 < 2) {
				FolksEmailFieldDetails* _tmp21_;
				gconstpointer _tmp22_;
				const gchar* _tmp23_;
				_tmp21_ = fd_a;
				_tmp22_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp21_);
				_tmp23_ = _tmp22_;
				g_warning ("Invalid e-mail address when looking for potential " "match: %s", (const gchar*) _tmp23_);
				email_split_a = (_vala_array_free (email_split_a, email_split_a_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (fd_a);
				continue;
			}
			_tmp24_ = email_split_a;
			_tmp24__length1 = email_split_a_length1;
			_tmp25_ = _tmp24_[0];
			_tmp27_ = _tmp26_ = g_strsplit_set (_tmp25_, FOLKS_POTENTIAL_MATCH__SEPARATORS, 0);
			tokens_a = _tmp27_;
			tokens_a_length1 = _vala_array_length (_tmp26_);
			_tokens_a_size_ = tokens_a_length1;
			{
				GeeSet* _tmp28_;
				GeeIterator* _tmp29_ = NULL;
				GeeIterator* _fd_b_it;
				_tmp28_ = set_b;
				_tmp29_ = gee_iterable_iterator ((GeeIterable*) _tmp28_);
				_fd_b_it = _tmp29_;
				while (TRUE) {
					GeeIterator* _tmp30_;
					gboolean _tmp31_ = FALSE;
					GeeIterator* _tmp32_;
					gpointer _tmp33_ = NULL;
					FolksEmailFieldDetails* fd_b;
					FolksEmailFieldDetails* _tmp34_;
					gconstpointer _tmp35_;
					const gchar* _tmp36_;
					gchar** _tmp37_;
					gchar** _tmp38_ = NULL;
					gchar** email_split_b;
					gint email_split_b_length1;
					gint _email_split_b_size_;
					gchar** _tmp39_;
					gint _tmp39__length1;
					FolksEmailFieldDetails* _tmp43_;
					gconstpointer _tmp44_;
					const gchar* _tmp45_;
					FolksEmailFieldDetails* _tmp46_;
					gconstpointer _tmp47_;
					const gchar* _tmp48_;
					_tmp30_ = _fd_b_it;
					_tmp31_ = gee_iterator_next (_tmp30_);
					if (!_tmp31_) {
						break;
					}
					_tmp32_ = _fd_b_it;
					_tmp33_ = gee_iterator_get (_tmp32_);
					fd_b = (FolksEmailFieldDetails*) _tmp33_;
					_tmp34_ = fd_b;
					_tmp35_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp34_);
					_tmp36_ = _tmp35_;
					_tmp38_ = _tmp37_ = g_strsplit ((const gchar*) _tmp36_, "@", 0);
					email_split_b = _tmp38_;
					email_split_b_length1 = _vala_array_length (_tmp37_);
					_email_split_b_size_ = email_split_b_length1;
					_tmp39_ = email_split_b;
					_tmp39__length1 = email_split_b_length1;
					if (_tmp39__length1 < 2) {
						FolksEmailFieldDetails* _tmp40_;
						gconstpointer _tmp41_;
						const gchar* _tmp42_;
						_tmp40_ = fd_b;
						_tmp41_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp40_);
						_tmp42_ = _tmp41_;
						g_warning ("Invalid e-mail address when looking for " "potential match: %s", (const gchar*) _tmp42_);
						email_split_b = (_vala_array_free (email_split_b, email_split_b_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (fd_b);
						continue;
					}
					_tmp43_ = fd_a;
					_tmp44_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp43_);
					_tmp45_ = _tmp44_;
					_tmp46_ = fd_b;
					_tmp47_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp46_);
					_tmp48_ = _tmp47_;
					if (g_strcmp0 ((const gchar*) _tmp45_, (const gchar*) _tmp48_) == 0) {
						GeeSet* _tmp49_;
						gchar** _tmp50_;
						gint _tmp50__length1;
						const gchar* _tmp51_;
						gboolean _tmp52_ = FALSE;
						_tmp49_ = folks_potential_match_known_email_aliases;
						_tmp50_ = email_split_a;
						_tmp50__length1 = email_split_a_length1;
						_tmp51_ = _tmp50_[0];
						_tmp52_ = gee_collection_contains ((GeeCollection*) _tmp49_, _tmp51_);
						if (_tmp52_ == TRUE) {
							FolksMatchResult _tmp53_;
							_tmp53_ = _result_;
							if (_tmp53_ < FOLKS_MATCH_RESULT_HIGH) {
								_result_ = FOLKS_MATCH_RESULT_LOW;
							}
						} else {
							result = FOLKS_MATCH_RESULT_HIGH;
							email_split_b = (_vala_array_free (email_split_b, email_split_b_length1, (GDestroyNotify) g_free), NULL);
							_g_object_unref0 (fd_b);
							_g_object_unref0 (_fd_b_it);
							tokens_a = (_vala_array_free (tokens_a, tokens_a_length1, (GDestroyNotify) g_free), NULL);
							email_split_a = (_vala_array_free (email_split_a, email_split_a_length1, (GDestroyNotify) g_free), NULL);
							_g_object_unref0 (fd_a);
							_g_object_unref0 (_fd_a_it);
							_g_object_unref0 (set_b);
							_g_object_unref0 (set_a);
							return result;
						}
					} else {
						gchar** _tmp54_;
						gint _tmp54__length1;
						const gchar* _tmp55_;
						gchar** _tmp56_;
						gchar** _tmp57_ = NULL;
						gchar** tokens_b;
						gint tokens_b_length1;
						gint _tokens_b_size_;
						gchar** _tmp58_;
						gint _tmp58__length1;
						gchar** _tmp59_;
						gint _tmp59__length1;
						gboolean _tmp60_ = FALSE;
						_tmp54_ = email_split_b;
						_tmp54__length1 = email_split_b_length1;
						_tmp55_ = _tmp54_[0];
						_tmp57_ = _tmp56_ = g_strsplit_set (_tmp55_, FOLKS_POTENTIAL_MATCH__SEPARATORS, 0);
						tokens_b = _tmp57_;
						tokens_b_length1 = _vala_array_length (_tmp56_);
						_tokens_b_size_ = tokens_b_length1;
						_tmp58_ = tokens_a;
						_tmp58__length1 = tokens_a_length1;
						_tmp59_ = tokens_b;
						_tmp59__length1 = tokens_b_length1;
						_tmp60_ = _folks_potential_match_check_initials_expansion (self, _tmp58_, _tmp58__length1, _tmp59_, _tmp59__length1);
						if (_tmp60_) {
							_result_ = FOLKS_MATCH_RESULT_MEDIUM;
						} else {
							gchar** _tmp61_;
							gint _tmp61__length1;
							gchar** _tmp62_;
							gint _tmp62__length1;
							gboolean _tmp63_ = FALSE;
							_tmp61_ = tokens_a;
							_tmp61__length1 = tokens_a_length1;
							_tmp62_ = tokens_b;
							_tmp62__length1 = tokens_b_length1;
							_tmp63_ = _folks_potential_match_match_tokens (self, _tmp61_, _tmp61__length1, _tmp62_, _tmp62__length1);
							if (_tmp63_) {
								_result_ = FOLKS_MATCH_RESULT_MEDIUM;
							}
						}
						tokens_b = (_vala_array_free (tokens_b, tokens_b_length1, (GDestroyNotify) g_free), NULL);
					}
					email_split_b = (_vala_array_free (email_split_b, email_split_b_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (fd_b);
				}
				_g_object_unref0 (_fd_b_it);
			}
			tokens_a = (_vala_array_free (tokens_a, tokens_a_length1, (GDestroyNotify) g_free), NULL);
			email_split_a = (_vala_array_free (email_split_a, email_split_a_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (fd_a);
		}
		_g_object_unref0 (_fd_a_it);
	}
	result = _result_;
	_g_object_unref0 (set_b);
	_g_object_unref0 (set_a);
	return result;
}


static gboolean _folks_potential_match_check_initials_expansion (FolksPotentialMatch* self, gchar** tokens_a, int tokens_a_length1, gchar** tokens_b, int tokens_b_length1) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = tokens_a;
	_tmp1__length1 = tokens_a_length1;
	_tmp2_ = tokens_b;
	_tmp2__length1 = tokens_b_length1;
	if (_tmp1__length1 > _tmp2__length1) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = tokens_b;
		_tmp3__length1 = tokens_b_length1;
		_tmp0_ = _tmp3__length1 == 1;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = tokens_a;
		_tmp5__length1 = tokens_a_length1;
		_tmp6_ = tokens_b;
		_tmp6__length1 = tokens_b_length1;
		_tmp7_ = _tmp6_[0];
		_tmp8_ = _folks_potential_match_do_check_initials_expansion (self, _tmp5_, _tmp5__length1, _tmp7_);
		result = _tmp8_;
		return result;
	} else {
		gboolean _tmp9_ = FALSE;
		gchar** _tmp10_;
		gint _tmp10__length1;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gboolean _tmp13_;
		_tmp10_ = tokens_b;
		_tmp10__length1 = tokens_b_length1;
		_tmp11_ = tokens_a;
		_tmp11__length1 = tokens_a_length1;
		if (_tmp10__length1 > _tmp11__length1) {
			gchar** _tmp12_;
			gint _tmp12__length1;
			_tmp12_ = tokens_a;
			_tmp12__length1 = tokens_a_length1;
			_tmp9_ = _tmp12__length1 == 1;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp13_ = _tmp9_;
		if (_tmp13_) {
			gchar** _tmp14_;
			gint _tmp14__length1;
			gchar** _tmp15_;
			gint _tmp15__length1;
			const gchar* _tmp16_;
			gboolean _tmp17_ = FALSE;
			_tmp14_ = tokens_b;
			_tmp14__length1 = tokens_b_length1;
			_tmp15_ = tokens_a;
			_tmp15__length1 = tokens_a_length1;
			_tmp16_ = _tmp15_[0];
			_tmp17_ = _folks_potential_match_do_check_initials_expansion (self, _tmp14_, _tmp14__length1, _tmp16_);
			result = _tmp17_;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean _folks_potential_match_do_check_initials_expansion (FolksPotentialMatch* self, gchar** expanded_name, int expanded_name_length1, const gchar* initials) {
	gboolean result = FALSE;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (initials != NULL, FALSE);
	_tmp0_ = expanded_name;
	_tmp0__length1 = expanded_name_length1;
	_tmp1_ = initials;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp0__length1 != _tmp3_) {
		result = FALSE;
		return result;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				gchar** _tmp8_;
				gint _tmp8__length1;
				gchar** _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				const gchar* _tmp11_;
				gchar _tmp12_ = '\0';
				const gchar* _tmp13_;
				gint _tmp14_;
				gchar _tmp15_ = '\0';
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = expanded_name;
				_tmp8__length1 = expanded_name_length1;
				if (!(_tmp7_ < _tmp8__length1)) {
					break;
				}
				_tmp9_ = expanded_name;
				_tmp9__length1 = expanded_name_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				_tmp12_ = string_get (_tmp11_, (glong) 0);
				_tmp13_ = initials;
				_tmp14_ = i;
				_tmp15_ = string_get (_tmp13_, (glong) _tmp14_);
				if (_tmp12_ != _tmp15_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean _folks_potential_match_match_tokens (FolksPotentialMatch* self, gchar** tokens_a, int tokens_a_length1, gchar** tokens_b, int tokens_b_length1) {
	gboolean result = FALSE;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tokens_a;
	_tmp0__length1 = tokens_a_length1;
	_tmp1_ = tokens_b;
	_tmp1__length1 = tokens_b_length1;
	if (_tmp0__length1 > _tmp1__length1) {
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar** _tmp3_;
		gint _tmp3__length1;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = tokens_a;
		_tmp2__length1 = tokens_a_length1;
		_tmp3_ = tokens_b;
		_tmp3__length1 = tokens_b_length1;
		_tmp4_ = _folks_potential_match_do_match_tokens (self, _tmp2_, _tmp2__length1, _tmp3_, _tmp3__length1);
		result = _tmp4_;
		return result;
	} else {
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = tokens_b;
		_tmp5__length1 = tokens_b_length1;
		_tmp6_ = tokens_a;
		_tmp6__length1 = tokens_a_length1;
		_tmp7_ = _folks_potential_match_do_match_tokens (self, _tmp5_, _tmp5__length1, _tmp6_, _tmp6__length1);
		result = _tmp7_;
		return result;
	}
}


static gboolean _folks_potential_match_do_match_tokens (FolksPotentialMatch* self, gchar** bigger_set, int bigger_set_length1, gchar** smaller_set, int smaller_set_length1) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gchar** _tmp4_;
				gint _tmp4__length1;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = smaller_set;
				_tmp4__length1 = smaller_set_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				{
					gint j;
					j = 0;
					{
						gboolean _tmp5_;
						_tmp5_ = TRUE;
						while (TRUE) {
							gboolean _tmp6_;
							gint _tmp8_;
							gchar** _tmp9_;
							gint _tmp9__length1;
							gchar** _tmp10_;
							gint _tmp10__length1;
							gint _tmp11_;
							const gchar* _tmp12_;
							gchar** _tmp13_;
							gint _tmp13__length1;
							gint _tmp14_;
							const gchar* _tmp15_;
							_tmp6_ = _tmp5_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = j;
								j = _tmp7_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp8_ = j;
							_tmp9_ = bigger_set;
							_tmp9__length1 = bigger_set_length1;
							if (!(_tmp8_ < _tmp9__length1)) {
								break;
							}
							_tmp10_ = smaller_set;
							_tmp10__length1 = smaller_set_length1;
							_tmp11_ = i;
							_tmp12_ = _tmp10_[_tmp11_];
							_tmp13_ = bigger_set;
							_tmp13__length1 = bigger_set_length1;
							_tmp14_ = j;
							_tmp15_ = _tmp13_[_tmp14_];
							if (g_strcmp0 (_tmp12_, _tmp15_) == 0) {
								result = TRUE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}


static FolksMatchResult _folks_potential_match_inc_match_level (FolksPotentialMatch* self, FolksMatchResult current_level, gint times) {
	FolksMatchResult result = 0;
	FolksMatchResult _tmp0_;
	gint _tmp1_;
	FolksMatchResult ret;
	FolksMatchResult _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = current_level;
	_tmp1_ = times;
	ret = _tmp0_ + _tmp1_;
	_tmp2_ = ret;
	if (_tmp2_ > FOLKS_MATCH_RESULT_MAX) {
		ret = FOLKS_MATCH_RESULT_MAX;
	}
	result = ret;
	return result;
}


static gboolean _folks_potential_match_look_alike_or_identical (FolksPotentialMatch* self, const gchar* a, const gchar* b, gboolean* exact) {
	gboolean _vala_exact = FALSE;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	gint _tmp15_ = 0;
	gunichar* _tmp16_ = NULL;
	gunichar* a_stripped;
	gint a_stripped_length1;
	gint _a_stripped_size_;
	const gchar* _tmp17_;
	gint _tmp18_ = 0;
	gunichar* _tmp19_ = NULL;
	gunichar* b_stripped;
	gint b_stripped_length1;
	gint _b_stripped_size_;
	gunichar* _tmp20_;
	gint _tmp20__length1;
	gunichar* _tmp21_;
	gint _tmp21__length1;
	gdouble _tmp22_ = 0.0;
	gdouble jaro_dist;
	gdouble _tmp23_;
	gdouble _tmp24_;
	gdouble _tmp25_;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_exact = FALSE;
	_tmp3_ = a;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = a;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = b;
		_tmp1_ = _tmp6_ == NULL;
	}
	_tmp7_ = _tmp1_;
	if (_tmp7_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = b;
		_tmp0_ = g_strcmp0 (_tmp8_, "") == 0;
	}
	_tmp9_ = _tmp0_;
	if (_tmp9_) {
		result = FALSE;
		if (exact) {
			*exact = _vala_exact;
		}
		return result;
	}
	_tmp10_ = a;
	_tmp11_ = g_utf8_validate (_tmp10_, (gssize) (-1), NULL);
	g_return_val_if_fail (_tmp11_, FALSE);
	_tmp12_ = b;
	_tmp13_ = g_utf8_validate (_tmp12_, (gssize) (-1), NULL);
	g_return_val_if_fail (_tmp13_, FALSE);
	_tmp14_ = a;
	_tmp16_ = _folks_potential_match_strip_string (self, (const gchar*) _tmp14_, &_tmp15_);
	a_stripped = _tmp16_;
	a_stripped_length1 = _tmp15_;
	_a_stripped_size_ = a_stripped_length1;
	_tmp17_ = b;
	_tmp19_ = _folks_potential_match_strip_string (self, (const gchar*) _tmp17_, &_tmp18_);
	b_stripped = _tmp19_;
	b_stripped_length1 = _tmp18_;
	_b_stripped_size_ = b_stripped_length1;
	_tmp20_ = a_stripped;
	_tmp20__length1 = a_stripped_length1;
	_tmp21_ = b_stripped;
	_tmp21__length1 = b_stripped_length1;
	_tmp22_ = _folks_potential_match_jaro_dist (self, _tmp20_, _tmp20__length1, _tmp21_, _tmp21__length1);
	jaro_dist = _tmp22_;
	_tmp23_ = jaro_dist;
	if (_tmp23_ == 1.0) {
		_vala_exact = TRUE;
		result = TRUE;
		b_stripped = (g_free (b_stripped), NULL);
		a_stripped = (g_free (a_stripped), NULL);
		if (exact) {
			*exact = _vala_exact;
		}
		return result;
	}
	_tmp24_ = jaro_dist;
	_tmp25_ = folks_potential_match__DIST_THRESHOLD;
	result = _tmp24_ >= _tmp25_;
	b_stripped = (g_free (b_stripped), NULL);
	a_stripped = (g_free (a_stripped), NULL);
	if (exact) {
		*exact = _vala_exact;
	}
	return result;
}


static gboolean _folks_potential_match_look_alike (FolksPotentialMatch* self, const gchar* a, const gchar* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	gint _tmp15_ = 0;
	gunichar* _tmp16_ = NULL;
	gunichar* a_stripped;
	gint a_stripped_length1;
	gint _a_stripped_size_;
	const gchar* _tmp17_;
	gint _tmp18_ = 0;
	gunichar* _tmp19_ = NULL;
	gunichar* b_stripped;
	gint b_stripped_length1;
	gint _b_stripped_size_;
	gunichar* _tmp20_;
	gint _tmp20__length1;
	gunichar* _tmp21_;
	gint _tmp21__length1;
	gdouble _tmp22_ = 0.0;
	gdouble _tmp23_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = a;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = a;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = b;
		_tmp1_ = _tmp6_ == NULL;
	}
	_tmp7_ = _tmp1_;
	if (_tmp7_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = b;
		_tmp0_ = g_strcmp0 (_tmp8_, "") == 0;
	}
	_tmp9_ = _tmp0_;
	if (_tmp9_) {
		result = FALSE;
		return result;
	}
	_tmp10_ = a;
	_tmp11_ = g_utf8_validate (_tmp10_, (gssize) (-1), NULL);
	g_return_val_if_fail (_tmp11_, FALSE);
	_tmp12_ = b;
	_tmp13_ = g_utf8_validate (_tmp12_, (gssize) (-1), NULL);
	g_return_val_if_fail (_tmp13_, FALSE);
	_tmp14_ = a;
	_tmp16_ = _folks_potential_match_strip_string (self, (const gchar*) _tmp14_, &_tmp15_);
	a_stripped = _tmp16_;
	a_stripped_length1 = _tmp15_;
	_a_stripped_size_ = a_stripped_length1;
	_tmp17_ = b;
	_tmp19_ = _folks_potential_match_strip_string (self, (const gchar*) _tmp17_, &_tmp18_);
	b_stripped = _tmp19_;
	b_stripped_length1 = _tmp18_;
	_b_stripped_size_ = b_stripped_length1;
	_tmp20_ = a_stripped;
	_tmp20__length1 = a_stripped_length1;
	_tmp21_ = b_stripped;
	_tmp21__length1 = b_stripped_length1;
	_tmp22_ = _folks_potential_match_jaro_dist (self, _tmp20_, _tmp20__length1, _tmp21_, _tmp21__length1);
	_tmp23_ = folks_potential_match__DIST_THRESHOLD;
	result = _tmp22_ >= _tmp23_;
	b_stripped = (g_free (b_stripped), NULL);
	a_stripped = (g_free (a_stripped), NULL);
	return result;
}


static gdouble _folks_potential_match_jaro_dist (FolksPotentialMatch* self, gunichar* s1, int s1_length1, gunichar* s2, int s2_length1) {
	gdouble result = 0.0;
	gdouble distance = 0.0;
	gint _tmp0_ = 0;
	gunichar* _tmp1_;
	gint _tmp1__length1;
	gunichar* _tmp2_;
	gint _tmp2__length1;
	gint _tmp5_;
	gint max;
	gint _tmp6_;
	gint max_dist;
	gdouble t = 0.0;
	gunichar* _tmp7_;
	gint _tmp7__length1;
	gunichar* _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	gdouble _tmp10_ = 0.0;
	gint _tmp11_ = 0;
	gdouble m;
	gunichar* _tmp12_;
	gint _tmp12__length1;
	gdouble len_s1;
	gunichar* _tmp13_;
	gint _tmp13__length1;
	gdouble len_s2;
	gdouble _tmp14_;
	gdouble _tmp15_;
	gdouble a;
	gdouble _tmp16_;
	gdouble _tmp17_;
	gdouble b;
	gdouble c;
	gdouble _tmp18_;
	gdouble _tmp22_;
	gdouble _tmp23_;
	gdouble _tmp24_;
	gdouble _tmp25_;
	gdouble _tmp26_;
	gdouble _tmp27_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp1_ = s1;
	_tmp1__length1 = s1_length1;
	_tmp2_ = s2;
	_tmp2__length1 = s2_length1;
	if (_tmp1__length1 > _tmp2__length1) {
		gunichar* _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = s1;
		_tmp3__length1 = s1_length1;
		_tmp0_ = _tmp3__length1;
	} else {
		gunichar* _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = s2;
		_tmp4__length1 = s2_length1;
		_tmp0_ = _tmp4__length1;
	}
	_tmp5_ = _tmp0_;
	max = _tmp5_;
	_tmp6_ = max;
	max_dist = (_tmp6_ / 2) - 1;
	_tmp7_ = s1;
	_tmp7__length1 = s1_length1;
	_tmp8_ = s2;
	_tmp8__length1 = s2_length1;
	_tmp9_ = max_dist;
	_tmp11_ = _folks_potential_match_matches (self, _tmp7_, _tmp7__length1, _tmp8_, _tmp8__length1, _tmp9_, &_tmp10_);
	t = _tmp10_;
	m = (gdouble) _tmp11_;
	_tmp12_ = s1;
	_tmp12__length1 = s1_length1;
	len_s1 = (gdouble) _tmp12__length1;
	_tmp13_ = s2;
	_tmp13__length1 = s2_length1;
	len_s2 = (gdouble) _tmp13__length1;
	_tmp14_ = m;
	_tmp15_ = len_s1;
	a = _tmp14_ / _tmp15_;
	_tmp16_ = m;
	_tmp17_ = len_s2;
	b = _tmp16_ / _tmp17_;
	c = (gdouble) 0;
	_tmp18_ = m;
	if (((gint) _tmp18_) > 0) {
		gdouble _tmp19_;
		gdouble _tmp20_;
		gdouble _tmp21_;
		_tmp19_ = m;
		_tmp20_ = t;
		_tmp21_ = m;
		c = (_tmp19_ - _tmp20_) / _tmp21_;
	}
	_tmp22_ = a;
	_tmp23_ = b;
	_tmp24_ = c;
	distance = (1.0 / 3.0) * ((_tmp22_ + _tmp23_) + _tmp24_);
	_tmp25_ = a;
	_tmp26_ = b;
	_tmp27_ = c;
	g_debug ("potential-match.vala:540: Jaro distance: %f (a = %f, b = %f, c = %f)", distance, _tmp25_, _tmp26_, _tmp27_);
	result = distance;
	return result;
}


/**
   * stripped_char:
   *
   * Returns a stripped version of @ch, removing any case, accentuation
   * mark, or any special mark on it.
   *
   * Copied from Empathy's libempathy-gtk/empathy-live-search.c.
   *
   * Copyright (C) 2010 Collabora Ltd.
   * Copyright (C) 2007-2010 Nokia Corporation.
   *
   * Authors: Felix Kaser <felix.kaser@collabora.co.uk>
   *          Xavier Claessens <xavier.claessens@collabora.co.uk>
   *          Claudio Saavedra <csaavedra@igalia.com>
   */
static gunichar _folks_potential_match_stripped_char (FolksPotentialMatch* self, gunichar ch) {
	gunichar result = 0U;
	gunichar _tmp0_[1] = {0};
	gunichar retval[1];
	gunichar _tmp1_;
	GUnicodeType _tmp2_ = 0;
	GUnicodeType utype;
	GUnicodeType _tmp3_;
	gunichar _tmp8_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_[0] = (gunichar) 0;
	memcpy (retval, _tmp0_, 1 * sizeof (gunichar));
	_tmp1_ = ch;
	_tmp2_ = g_unichar_type (_tmp1_);
	utype = _tmp2_;
	_tmp3_ = utype;
	switch (_tmp3_) {
		case G_UNICODE_CONTROL:
		case G_UNICODE_FORMAT:
		case G_UNICODE_UNASSIGNED:
		case G_UNICODE_NON_SPACING_MARK:
		case G_UNICODE_COMBINING_MARK:
		case G_UNICODE_ENCLOSING_MARK:
		{
			break;
		}
		case G_UNICODE_DECIMAL_NUMBER:
		case G_UNICODE_LETTER_NUMBER:
		case G_UNICODE_OTHER_NUMBER:
		case G_UNICODE_CONNECT_PUNCTUATION:
		case G_UNICODE_DASH_PUNCTUATION:
		case G_UNICODE_CLOSE_PUNCTUATION:
		case G_UNICODE_FINAL_PUNCTUATION:
		case G_UNICODE_INITIAL_PUNCTUATION:
		case G_UNICODE_OTHER_PUNCTUATION:
		case G_UNICODE_OPEN_PUNCTUATION:
		case G_UNICODE_CURRENCY_SYMBOL:
		case G_UNICODE_MODIFIER_SYMBOL:
		case G_UNICODE_MATH_SYMBOL:
		case G_UNICODE_OTHER_SYMBOL:
		case G_UNICODE_LINE_SEPARATOR:
		case G_UNICODE_PARAGRAPH_SEPARATOR:
		case G_UNICODE_SPACE_SEPARATOR:
		{
			gunichar _tmp4_;
			retval[0] = (gunichar) ' ';
			_tmp4_ = retval[0];
			break;
		}
		default:
		case G_UNICODE_PRIVATE_USE:
		case G_UNICODE_SURROGATE:
		case G_UNICODE_LOWERCASE_LETTER:
		case G_UNICODE_MODIFIER_LETTER:
		case G_UNICODE_OTHER_LETTER:
		case G_UNICODE_TITLECASE_LETTER:
		case G_UNICODE_UPPERCASE_LETTER:
		{
			gunichar _tmp5_;
			gunichar _tmp6_ = 0U;
			gunichar _tmp7_;
			_tmp5_ = ch;
			_tmp6_ = g_unichar_tolower (_tmp5_);
			ch = _tmp6_;
			_tmp7_ = ch;
			g_unichar_fully_decompose (_tmp7_, FALSE, retval, 1);
			break;
		}
	}
	_tmp8_ = retval[0];
	result = _tmp8_;
	return result;
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static gunichar* _folks_potential_match_strip_string (FolksPotentialMatch* self, const gchar* s, int* result_length1) {
	gunichar* result = NULL;
	gint next_idx;
	guint write_idx;
	gunichar ch;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gunichar* _tmp3_ = NULL;
	gunichar* output;
	gint output_length1;
	gint _output_size_;
	guint _tmp14_;
	gint _tmp15_;
	gunichar* _tmp16_;
	gint _tmp16__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (s != NULL, NULL);
	next_idx = 0;
	write_idx = (guint) 0;
	ch = (gunichar) 0;
	_tmp0_ = s;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (gunichar, _tmp2_);
	output = _tmp3_;
	output_length1 = _tmp2_;
	_output_size_ = output_length1;
	while (TRUE) {
		const gchar* _tmp4_;
		gunichar _tmp5_ = 0U;
		gboolean _tmp6_ = FALSE;
		gunichar _tmp7_;
		gunichar _tmp8_ = 0U;
		gunichar _tmp9_;
		_tmp4_ = s;
		_tmp6_ = string_get_next_char (_tmp4_, &next_idx, &_tmp5_);
		ch = _tmp5_;
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = ch;
		_tmp8_ = _folks_potential_match_stripped_char (self, _tmp7_);
		ch = _tmp8_;
		_tmp9_ = ch;
		if (_tmp9_ != ((gunichar) 0)) {
			gunichar* _tmp10_;
			gint _tmp10__length1;
			guint _tmp11_;
			gunichar _tmp12_;
			gunichar _tmp13_;
			_tmp10_ = output;
			_tmp10__length1 = output_length1;
			_tmp11_ = write_idx;
			write_idx = _tmp11_ + 1;
			_tmp12_ = ch;
			_tmp10_[_tmp11_] = _tmp12_;
			_tmp13_ = _tmp10_[_tmp11_];
		}
	}
	_tmp14_ = write_idx;
	output_length1 = (gint) _tmp14_;
	_tmp15_ = output_length1;
	_tmp16_ = output;
	_tmp16__length1 = output_length1;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	return result;
}


static gint _folks_potential_match_matches (FolksPotentialMatch* self, gunichar* s1, int s1_length1, gunichar* s2, int s2_length1, gint max_dist, gdouble* t) {
	gdouble _vala_t = 0.0;
	gint result = 0;
	gint matches;
	gunichar look_for;
	gint _tmp16_;
	gdouble _tmp17_;
	gdouble _tmp18_;
	g_return_val_if_fail (self != NULL, 0);
	matches = 0;
	_vala_t = 0.0;
	look_for = (gunichar) 0;
	{
		guint idx;
		idx = (guint) 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gunichar* _tmp3_;
				gint _tmp3__length1;
				guint _tmp4_;
				gunichar _tmp5_;
				gunichar _tmp6_;
				gunichar* _tmp7_;
				gint _tmp7__length1;
				gunichar _tmp8_;
				guint _tmp9_;
				gint _tmp10_;
				gint _tmp11_ = 0;
				gint contains;
				gint _tmp12_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = idx;
					idx = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = s1;
				_tmp3__length1 = s1_length1;
				_tmp4_ = idx;
				_tmp5_ = _tmp3_[_tmp4_];
				look_for = _tmp5_;
				_tmp6_ = look_for;
				if (!(_tmp6_ != ((gunichar) 0))) {
					break;
				}
				_tmp7_ = s2;
				_tmp7__length1 = s2_length1;
				_tmp8_ = look_for;
				_tmp9_ = idx;
				_tmp10_ = max_dist;
				_tmp11_ = _folks_potential_match_contains (self, _tmp7_, _tmp7__length1, _tmp8_, _tmp9_, (guint) _tmp10_);
				contains = _tmp11_;
				_tmp12_ = contains;
				if (_tmp12_ >= 0) {
					gint _tmp13_;
					gint _tmp14_;
					_tmp13_ = matches;
					matches = _tmp13_ + 1;
					_tmp14_ = contains;
					if (_tmp14_ > 0) {
						gdouble _tmp15_;
						_tmp15_ = _vala_t;
						_vala_t = _tmp15_ + 1.0;
					}
				}
			}
		}
	}
	_tmp16_ = matches;
	_tmp17_ = _vala_t;
	g_debug ("potential-match.vala:651: %d matches and %f / 2 transpositions", _tmp16_, _tmp17_);
	_tmp18_ = _vala_t;
	_vala_t = _tmp18_ / 2.0;
	result = matches;
	if (t) {
		*t = _vala_t;
	}
	return result;
}


static gint _folks_potential_match_contains (FolksPotentialMatch* self, gunichar* haystack, int haystack_length1, gunichar c, guint pos, guint max_dist) {
	gint result = 0;
	gunichar* _tmp0_;
	gint _tmp0__length1;
	gint haystack_len;
	gunichar* _tmp1_;
	gint _tmp1__length1;
	guint _tmp2_;
	gunichar _tmp3_;
	gunichar ch;
	gboolean _tmp4_ = FALSE;
	guint _tmp5_;
	gint _tmp6_;
	gboolean _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	gint _tmp12_;
	gint _tmp13_ = 0;
	guint idx;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = haystack;
	_tmp0__length1 = haystack_length1;
	haystack_len = _tmp0__length1;
	_tmp1_ = haystack;
	_tmp1__length1 = haystack_length1;
	_tmp2_ = pos;
	_tmp3_ = _tmp1_[_tmp2_];
	ch = _tmp3_;
	_tmp5_ = pos;
	_tmp6_ = haystack_len;
	if (_tmp5_ < ((guint) _tmp6_)) {
		gunichar _tmp7_;
		gunichar _tmp8_;
		_tmp7_ = ch;
		_tmp8_ = c;
		_tmp4_ = _tmp7_ == _tmp8_;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp9_ = _tmp4_;
	if (_tmp9_) {
		result = 0;
		return result;
	}
	_tmp10_ = pos;
	_tmp11_ = max_dist;
	_tmp12_ = haystack_len;
	_tmp13_ = CLAMP (((gint) _tmp10_) - ((gint) _tmp11_), 0, _tmp12_);
	idx = (guint) _tmp13_;
	ch = (gunichar) 0;
	while (TRUE) {
		gboolean _tmp14_ = FALSE;
		guint _tmp15_;
		guint _tmp16_;
		guint _tmp17_;
		gboolean _tmp22_;
		gunichar _tmp23_;
		gunichar _tmp24_;
		guint _tmp28_;
		_tmp15_ = idx;
		_tmp16_ = pos;
		_tmp17_ = max_dist;
		if (_tmp15_ < (_tmp16_ + _tmp17_)) {
			gunichar* _tmp18_;
			gint _tmp18__length1;
			guint _tmp19_;
			gunichar _tmp20_;
			gunichar _tmp21_;
			_tmp18_ = haystack;
			_tmp18__length1 = haystack_length1;
			_tmp19_ = idx;
			_tmp20_ = _tmp18_[_tmp19_];
			ch = _tmp20_;
			_tmp21_ = ch;
			_tmp14_ = _tmp21_ != ((gunichar) 0);
		} else {
			_tmp14_ = FALSE;
		}
		_tmp22_ = _tmp14_;
		if (!_tmp22_) {
			break;
		}
		_tmp23_ = ch;
		_tmp24_ = c;
		if (_tmp23_ == _tmp24_) {
			guint _tmp25_;
			guint _tmp26_;
			gint _tmp27_ = 0;
			_tmp25_ = pos;
			_tmp26_ = idx;
			_tmp27_ = abs (((gint) _tmp25_) - ((gint) _tmp26_));
			result = _tmp27_;
			return result;
		}
		_tmp28_ = idx;
		idx = _tmp28_ + 1;
	}
	result = -1;
	return result;
}


static void folks_potential_match_class_init (FolksPotentialMatchClass * klass) {
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GeeHashSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	folks_potential_match_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksPotentialMatchPrivate));
	G_OBJECT_CLASS (klass)->finalize = folks_potential_match_finalize;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp0_, _tmp1_);
	folks_potential_match_known_email_aliases = (GeeSet*) _tmp2_;
	_tmp3_ = folks_potential_match_known_email_aliases;
	gee_collection_add ((GeeCollection*) _tmp3_, "admin");
	_tmp4_ = folks_potential_match_known_email_aliases;
	gee_collection_add ((GeeCollection*) _tmp4_, "abuse");
	_tmp5_ = folks_potential_match_known_email_aliases;
	gee_collection_add ((GeeCollection*) _tmp5_, "webmaster");
}


static void folks_potential_match_instance_init (FolksPotentialMatch * self) {
	self->priv = FOLKS_POTENTIAL_MATCH_GET_PRIVATE (self);
}


static void folks_potential_match_finalize (GObject* obj) {
	FolksPotentialMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatch);
	_g_object_unref0 (self->priv->_individual_a);
	_g_object_unref0 (self->priv->_individual_b);
	G_OBJECT_CLASS (folks_potential_match_parent_class)->finalize (obj);
}


/**
 * Match calculator for pairs of individuals.
 *
 * This provides functionality to explore the degree of a potential match
 * between two individuals. It compares the similarity of the individuals'
 * properties to determine how likely it is that the individuals represent the
 * same physical person.
 *
 * This can be used by folks clients to, for example, present suggestions of
 * pairs of individuals which should be linked by the user.
 *
 * @since 0.5.0
 */
GType folks_potential_match_get_type (void) {
	static volatile gsize folks_potential_match_type_id__volatile = 0;
	if (g_once_init_enter (&folks_potential_match_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksPotentialMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_potential_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksPotentialMatch), 0, (GInstanceInitFunc) folks_potential_match_instance_init, NULL };
		GType folks_potential_match_type_id;
		folks_potential_match_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksPotentialMatch", &g_define_type_info, 0);
		g_once_init_leave (&folks_potential_match_type_id__volatile, folks_potential_match_type_id);
	}
	return folks_potential_match_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



