/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.plan;

import java.awt.Font;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.fop.plan.ActionInfo;
import org.apache.fop.plan.EventList;
import org.apache.fop.plan.GroupInfo;
import org.apache.fop.plan.PlanDrawer;
import org.apache.fop.svg.SVGUtilities;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimplePlanDrawer
implements PlanDrawer {
    private static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    private float fontSize;
    private HashMap hints;
    private Font font = null;
    private boolean bord = false;
    private float lSpace = 15.0f;
    private float width;
    private float height;
    private float topEdge;
    private float rightEdge;
    private String[] colours;
    private String[] darkcolours;
    private Date startDate;
    private Date endDate;

    public void setStartDate(Date sd) {
        this.startDate = sd;
    }

    public void setEndDate(Date ed) {
        this.endDate = ed;
    }

    public Document createDocument(EventList data, float w, float h, HashMap hints) {
        float strwidth;
        float pos;
        this.width = w;
        this.height = h;
        this.hints = hints;
        this.fontSize = ((Float)hints.get("font-size")).floatValue();
        this.bord = (Boolean)hints.get("border");
        String title = "";
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        Document doc = impl.createDocument(SVG_NAMESPACE, "svg", null);
        Element svgRoot = doc.getDocumentElement();
        svgRoot.setAttributeNS(null, "width", "" + this.width);
        svgRoot.setAttributeNS(null, "height", "" + this.height);
        svgRoot.setAttributeNS(null, "style", "font-size:8;font-family:" + hints.get("font-family"));
        this.font = new Font((String)hints.get("font-family"), 0, (int)this.fontSize);
        if (this.bord) {
            Element border = SVGUtilities.createRect((Document)doc, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height);
            border.setAttributeNS(null, "style", "stroke:black;fill:none");
            svgRoot.appendChild(border);
        }
        if ((pos = (float)(80.0 - (double)(strwidth = SVGUtilities.getStringWidth((String)title, (Font)this.font)) / 2.0)) < 5.0f) {
            pos = 5.0f;
        }
        Element text = SVGUtilities.createText((Document)doc, (float)pos, (float)18.0f, (String)title);
        text.setAttributeNS(null, "style", "font-size:14");
        svgRoot.appendChild(text);
        this.topEdge = SVGUtilities.getStringHeight((String)title, (Font)this.font) + 5.0f;
        this.addPlan(doc, svgRoot, data);
        return doc;
    }

    protected void addPlan(Document doc, Element svgRoot, EventList data) {
        Date currentDate = new Date();
        Date lastWeek = this.startDate;
        Date future = this.endDate;
        Calendar lw = Calendar.getInstance();
        if (lastWeek == null || future == null) {
            int dow = lw.get(7);
            lw.add(5, -dow - 6);
            lastWeek = lw.getTime();
            lw.add(5, 35);
            future = lw.getTime();
        }
        long totalDays = (future.getTime() - lastWeek.getTime() + 43200000L) / 86400000L;
        lw.setTime(lastWeek);
        int startDay = lw.get(7);
        float graphTop = this.topEdge;
        Element line = SVGUtilities.createLine((Document)doc, (float)0.0f, (float)this.topEdge, (float)this.width, (float)this.topEdge);
        line.setAttributeNS(null, "style", "fill:none;stroke:black");
        svgRoot.appendChild(line);
        Element clip1 = SVGUtilities.createClip((Document)doc, (Element)SVGUtilities.createPath((Document)doc, (String)("m0 0l126 0l0 " + this.height + "l-126 0z")), (String)"clip1");
        Element clip2 = SVGUtilities.createClip((Document)doc, (Element)SVGUtilities.createPath((Document)doc, (String)("m130 0l66 0l0 " + this.height + "l-66 0z")), (String)"clip2");
        Element clip3 = SVGUtilities.createClip((Document)doc, (Element)SVGUtilities.createPath((Document)doc, (String)("m200 0l" + (this.width - 200.0f) + " 0l0 " + this.height + "l-" + (this.width - 200.0f) + " 0z")), (String)"clip3");
        svgRoot.appendChild(clip1);
        svgRoot.appendChild(clip2);
        svgRoot.appendChild(clip3);
        DateFormat df = DateFormat.getDateInstance(3);
        Element text = SVGUtilities.createText((Document)doc, (float)201.0f, (float)(this.topEdge - 1.0f), (String)df.format(lastWeek));
        svgRoot.appendChild(text);
        text = SVGUtilities.createText((Document)doc, (float)this.width, (float)(this.topEdge - 1.0f), (String)df.format(future));
        text.setAttributeNS(null, "text-anchor", "end");
        svgRoot.appendChild(text);
        line = SVGUtilities.createLine((Document)doc, (float)128.0f, (float)this.topEdge, (float)128.0f, (float)this.height);
        line.setAttributeNS(null, "style", "fill:none;stroke:rgb(150,150,150)");
        svgRoot.appendChild(line);
        int offset = 0;
        int count = startDay;
        while ((long)count < (long)startDay + totalDays - 1L) {
            ++offset;
            if (count % 7 == 0 || count % 7 == 1) {
                Element rect = SVGUtilities.createRect((Document)doc, (float)(200.0f + (float)(offset - 1) * (this.width - 200.0f) / (float)(totalDays - 2L)), (float)((float)((double)this.topEdge + 0.5)), (float)((this.width - 200.0f) / (float)(totalDays - 3L)), (float)(this.height - 1.0f - this.topEdge));
                rect.setAttributeNS(null, "style", "stroke:none;fill:rgb(230,230,230)");
                svgRoot.appendChild(rect);
            }
            line = SVGUtilities.createLine((Document)doc, (float)(200.0f + (float)(offset - 1) * (this.width - 200.0f) / (float)(totalDays - 2L)), (float)((float)((double)this.topEdge + 0.5)), (float)(200.0f + (float)(offset - 1) * (this.width - 200.0f) / (float)(totalDays - 2L)), (float)((float)((double)this.height - 0.5)));
            line.setAttributeNS(null, "style", "fill:none;stroke:rgb(200,200,200)");
            svgRoot.appendChild(line);
            ++count;
        }
        for (count = 0; count < data.getSize(); ++count) {
            GroupInfo gi = data.getGroupInfo(count);
            Element g = SVGUtilities.createG((Document)doc);
            text = SVGUtilities.createText((Document)doc, (float)1.0f, (float)(this.topEdge + 12.0f), (String)gi.getName());
            text.setAttributeNS(null, "style", "clip-path:url(#clip1)");
            g.appendChild(text);
            if (count > 0) {
                line = SVGUtilities.createLine((Document)doc, (float)0.0f, (float)(this.topEdge + 2.0f), (float)this.width, (float)(this.topEdge + 2.0f));
                line.setAttributeNS(null, "style", "fill:none;stroke:rgb(100,100,100)");
                g.appendChild(line);
            }
            float lastTop = this.topEdge;
            this.topEdge += 14.0f;
            boolean showing = false;
            for (int count1 = 0; count1 < gi.getSize(); ++count1) {
                ActionInfo act = gi.getActionInfo(count1);
                String name = act.getOwner();
                String label = act.getLabel();
                text = SVGUtilities.createText((Document)doc, (float)8.0f, (float)(this.topEdge + 12.0f), (String)label);
                text.setAttributeNS(null, "style", "clip-path:url(#clip1)");
                g.appendChild(text);
                text = SVGUtilities.createText((Document)doc, (float)130.0f, (float)(this.topEdge + 12.0f), (String)name);
                text.setAttributeNS(null, "style", "clip-path:url(#clip2)");
                g.appendChild(text);
                int type = act.getType();
                Date start = act.getStartDate();
                Date end = act.getEndDate();
                if (end.after(lastWeek) && start.before(future)) {
                    showing = true;
                    int left = 200;
                    int right = 500;
                    int daysToStart = (int)((start.getTime() - lastWeek.getTime() + 43200000L) / 86400000L);
                    int days = (int)((end.getTime() - start.getTime() + 43200000L) / 86400000L);
                    int daysFromEnd = (int)((future.getTime() - end.getTime() + 43200000L) / 86400000L);
                    switch (type) {
                        case 1: {
                            Element taskGraphic = SVGUtilities.createRect((Document)doc, (float)((long)left + (long)(daysToStart * 300) / (totalDays - 2L)), (float)(this.topEdge + 2.0f), (float)((long)(days * 300) / (totalDays - 2L)), (float)10.0f);
                            taskGraphic.setAttributeNS(null, "style", "stroke:black;fill:blue;stroke-width:1;clip-path:url(#clip3)");
                            g.appendChild(taskGraphic);
                            break;
                        }
                        case 2: {
                            Element taskGraphic = SVGUtilities.createPath((Document)doc, (String)("m " + ((long)left + (long)(daysToStart * 300) / (totalDays - 2L) - 6L) + " " + (this.topEdge + 6.0f) + "l6 6l6-6l-6-6z"));
                            taskGraphic.setAttributeNS(null, "style", "stroke:black;fill:black;stroke-width:1;clip-path:url(#clip3)");
                            g.appendChild(taskGraphic);
                            text = SVGUtilities.createText((Document)doc, (float)((long)left + (long)(daysToStart * 300) / (totalDays - 2L) + 8L), (float)(this.topEdge + 9.0f), (String)df.format(start));
                            g.appendChild(text);
                            break;
                        }
                        case 3: {
                            Element taskGraphic = SVGUtilities.createPath((Document)doc, (String)("m " + ((long)left + (long)(daysToStart * 300) / (totalDays - 2L) - 6L) + " " + (this.topEdge + 6.0f) + "l6 -6l" + (long)(days * 300) / (totalDays - 2L) + " 0l6 6l-6 6l-4-4l" + -((long)(days * 300) / (totalDays - 2L) - 8L) + " 0l-4 4l-6-6z"));
                            taskGraphic.setAttributeNS(null, "style", "stroke:black;fill:black;stroke-width:1;clip-path:url(#clip3)");
                            g.appendChild(taskGraphic);
                            break;
                        }
                    }
                }
                this.topEdge += 14.0f;
            }
            if (showing) {
                svgRoot.appendChild(g);
                continue;
            }
            this.topEdge = lastTop;
        }
        int currentDays = (int)((currentDate.getTime() - lastWeek.getTime() + 43200000L) / 86400000L);
        text = SVGUtilities.createText((Document)doc, (float)((float)(200.0 + ((double)currentDays + 0.5) * 300.0 / 35.0)), (float)(graphTop - 1.0f), (String)df.format(currentDate));
        text.setAttributeNS(null, "text-anchor", "middle");
        text.setAttributeNS(null, "style", "stroke:rgb(100,100,100)");
        svgRoot.appendChild(text);
        line = SVGUtilities.createLine((Document)doc, (float)((float)(200.0 + ((double)currentDays + 0.5) * 300.0 / 35.0)), (float)graphTop, (float)((float)(200.0 + ((double)currentDays + 0.5) * 300.0 / 35.0)), (float)this.height);
        line.setAttributeNS(null, "style", "fill:none;stroke:rgb(200,50,50);stroke-dasharray:5,5");
        svgRoot.appendChild(line);
    }
}

