/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.plan;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.fop.plan.ActionInfo;
import org.apache.fop.plan.EventList;
import org.apache.fop.plan.GroupInfo;
import org.apache.fop.plan.SimplePlanDrawer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PlanRenderer {
    private static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    private String fontFamily = "sansserif";
    private float fontSize = 12.0f;
    private String type = "";
    private String lang = "";
    private String country = "";
    private String variant = "";
    private float width;
    private float height;
    private float topEdge;
    private float rightEdge;
    private HashMap hints = new HashMap();
    private String[] colours;
    private String[] darkcolours;

    public void setFontInfo(String fam, float si) {
        this.fontFamily = fam;
        this.fontSize = si;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    protected float toFloat(String str) {
        return Float.parseFloat(str);
    }

    public Document createSVGDocument(Document planDoc) {
        Element svgRoot = planDoc.getDocumentElement();
        this.width = this.toFloat(svgRoot.getAttribute("width"));
        this.height = this.toFloat(svgRoot.getAttribute("height"));
        this.type = svgRoot.getAttribute("type");
        this.lang = svgRoot.getAttribute("lang");
        this.country = svgRoot.getAttribute("country");
        this.variant = svgRoot.getAttribute("variant");
        String style = svgRoot.getAttribute("style");
        this.parseStyle(style);
        Locale locale = new Locale(this.lang, this.country == null ? "" : this.country, this.variant == null ? "" : this.variant);
        String start = svgRoot.getAttribute("start");
        String end = svgRoot.getAttribute("end");
        Date sd = this.getDate(start, locale);
        Date ed = this.getDate(end, locale);
        String title = "";
        EventList data = null;
        NodeList childs = svgRoot.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node obj = childs.item(i);
            String nname = obj.getNodeName();
            if (nname.equals("title")) {
                title = ((Element)obj).getFirstChild().getNodeValue();
                continue;
            }
            if (!nname.equals("events")) continue;
            data = this.getEvents((Element)obj, locale);
        }
        SimplePlanDrawer planDrawer = new SimplePlanDrawer();
        planDrawer.setStartDate(sd);
        planDrawer.setEndDate(ed);
        this.hints.put("font-family", this.fontFamily);
        this.hints.put("font-size", new Float(this.fontSize));
        this.hints.put("locale", locale);
        Document doc = planDrawer.createDocument(data, this.width, this.height, this.hints);
        return doc;
    }

    protected void parseStyle(String style) {
        this.hints.put("border", new Boolean(true));
        this.hints.put("font-family", this.fontFamily);
        this.hints.put("font-size", new Float(this.fontSize));
        this.hints.put("labelFontSize", new Float(this.fontSize));
        this.hints.put("labelFont", this.fontFamily);
        this.hints.put("labelType", "textOnly");
        StringTokenizer st = new StringTokenizer(style, ";");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken().trim();
            int index = pair.indexOf(":");
            String name = pair.substring(0, index).trim();
            String val = pair.substring(index + 1).trim();
            if (name.equals("border")) {
                this.hints.put(name, Boolean.valueOf(val));
                continue;
            }
            if (name.equals("font-size")) {
                this.hints.put(name, Float.valueOf(val));
                continue;
            }
            if (name.equals("labelFontSize")) {
                this.hints.put(name, Float.valueOf(val));
                continue;
            }
            this.hints.put(name, val);
        }
    }

    public ActionInfo getActionInfo(Element ele, Locale locale) {
        String t = ele.getAttribute("type");
        NodeList childs = ele.getChildNodes();
        ActionInfo data = new ActionInfo();
        if (t.equals("milestone")) {
            data.setType(2);
        } else if (t.equals("task")) {
            data.setType(1);
        } else if (t.equals("grouping")) {
            data.setType(3);
        }
        for (int i = 0; i < childs.getLength(); ++i) {
            Object dat;
            Node obj = childs.item(i);
            String nname = obj.getNodeName();
            if (nname.equals("label")) {
                dat = ((Element)obj).getFirstChild().getNodeValue();
                data.setLabel((String)dat);
                continue;
            }
            if (nname.equals("owner")) {
                dat = ((Element)obj).getFirstChild().getNodeValue();
                data.setOwner((String)dat);
                continue;
            }
            if (nname.equals("startdate")) {
                dat = this.getDate((Element)obj, locale);
                data.setStartDate((Date)dat);
                continue;
            }
            if (!nname.equals("enddate")) continue;
            dat = this.getDate((Element)obj, locale);
            data.setEndDate((Date)dat);
        }
        return data;
    }

    public EventList getEvents(Element ele, Locale locale) {
        EventList data = new EventList();
        NodeList childs = ele.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node obj = childs.item(i);
            if (!obj.getNodeName().equals("group")) continue;
            GroupInfo dat = this.getGroupInfo((Element)obj, locale);
            data.addGroupInfo(dat);
        }
        return data;
    }

    public GroupInfo getGroupInfo(Element ele, Locale locale) {
        NodeList childs = ele.getChildNodes();
        GroupInfo data = new GroupInfo(ele.getAttribute("name"));
        for (int i = 0; i < childs.getLength(); ++i) {
            Node obj = childs.item(i);
            if (!obj.getNodeName().equals("action")) continue;
            ActionInfo dat = this.getActionInfo((Element)obj, locale);
            data.addActionInfo(dat);
        }
        return data;
    }

    public Date getDate(Element ele, Locale locale) {
        String label = ele.getFirstChild().getNodeValue();
        return this.getDate(label, locale);
    }

    public Date getDate(String label, Locale locale) {
        Calendar cal = Calendar.getInstance(locale);
        String str = label.substring(0, 4);
        int intVal = Integer.valueOf(str);
        cal.set(1, intVal);
        str = label.substring(4, 6);
        intVal = Integer.valueOf(str);
        cal.set(2, intVal - 1);
        str = label.substring(6, 8);
        intVal = Integer.valueOf(str);
        cal.set(5, intVal);
        return cal.getTime();
    }
}

