/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.plan;

import java.util.HashMap;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.FONode;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.analyser.XMLReader;
import org.apache.fop.plan.PlanElement;
import org.apache.fop.plan.PlanObj;
import org.apache.fop.plan.PlanRenderer;
import org.w3c.dom.Document;

public class PlanElementMapping
extends ElementMapping {
    public static final String NAMESPACE = "http://xmlgraphics.apache.org/fop/plan";

    public PlanElementMapping() {
        this.namespaceURI = NAMESPACE;
    }

    protected void initialize() {
        if (this.foObjs == null) {
            this.foObjs = new HashMap();
            this.foObjs.put("plan", new PE());
            this.foObjs.put("<default>", new PlanMaker());
            XMLReader.setConverter((String)this.namespaceURI, (XMLReader.Converter)new PlanConverter());
        }
    }

    static class PlanConverter
    implements XMLReader.Converter {
        PlanConverter() {
        }

        public FopImage.ImageInfo convert(Document doc) {
            try {
                PlanRenderer pr = new PlanRenderer();
                pr.setFontInfo("Helvetica", 12.0f);
                FopImage.ImageInfo info = new FopImage.ImageInfo();
                info.data = pr.createSVGDocument(doc);
                info.width = (int)pr.getWidth();
                info.height = (int)pr.getHeight();
                info.mimeType = "image/svg+xml";
                info.str = "http://www.w3.org/2000/svg";
                return info;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }

    static class PE
    extends ElementMapping.Maker {
        PE() {
        }

        public FONode make(FONode parent) {
            return new PlanElement(parent);
        }
    }

    static class PlanMaker
    extends ElementMapping.Maker {
        PlanMaker() {
        }

        public FONode make(FONode parent) {
            return new PlanObj(parent);
        }
    }
}

