/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.plan;

import java.awt.geom.Point2D;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.plan.PlanObj;
import org.apache.fop.plan.PlanRenderer;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class PlanElement
extends PlanObj {
    private Document svgDoc = null;
    private float width;
    private float height;
    private boolean converted;

    public PlanElement(FONode parent) {
        super(parent);
    }

    public void processNode(String elementName, Locator locator, Attributes attlist, PropertyList propertyList) throws FOPException {
        super.processNode(elementName, locator, attlist, propertyList);
        this.createBasicDocument();
    }

    public void convertToSVG() {
        try {
            if (!this.converted) {
                this.converted = true;
                PlanRenderer pr = new PlanRenderer();
                pr.setFontInfo("Helvetica", 12.0f);
                this.svgDoc = pr.createSVGDocument(this.doc);
                this.width = pr.getWidth();
                this.height = pr.getHeight();
                this.doc = this.svgDoc;
            }
        }
        catch (Throwable t) {
            this.getLogger().error((Object)"Could not convert Plan to SVG", t);
            this.width = 0.0f;
            this.height = 0.0f;
        }
    }

    public Document getDOMDocument() {
        this.convertToSVG();
        return this.doc;
    }

    public String getNamespaceURI() {
        if (this.svgDoc == null) {
            return "http://xmlgraphics.apache.org/fop/plan";
        }
        return "http://www.w3.org/2000/svg";
    }

    public Point2D getDimension(Point2D view) {
        this.convertToSVG();
        return new Point2D.Float(this.width, this.height);
    }
}

