/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.plan;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;
import org.apache.fop.plan.PlanRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Main {
    public static void main(String[] args) {
        Main main = new Main();
        main.convert(args);
        System.exit(0);
    }

    public void convert(String[] params) {
        if (params.length != 2) {
            System.out.println("arguments: plan.xml output.svg");
            return;
        }
        try {
            FileInputStream is = new FileInputStream(params[0]);
            Document doc = this.createSVGDocument(is);
            SVGTranscoder svgT = new SVGTranscoder();
            TranscoderInput input = new TranscoderInput(doc);
            FileWriter ostream = new FileWriter(params[1]);
            TranscoderOutput output = new TranscoderOutput((Writer)ostream);
            svgT.transcode(input, output);
            ((Writer)ostream).flush();
            ((Writer)ostream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Document createSVGDocument(InputStream is) {
        Document doc = null;
        Element root = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            root = doc.getDocumentElement();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PlanRenderer gr = new PlanRenderer();
        gr.setFontInfo("sansserif", 12.0f);
        Document svgdoc = gr.createSVGDocument(doc);
        return svgdoc;
    }
}

