#include "db_config.h"
/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.29
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC)
#   if (__SUNPRO_CC <= 0x560)
#     define SWIGTEMPLATEDISAMBIGUATOR template
#   else
#     define SWIGTEMPLATEDISAMBIGUATOR 
#   endif
# else
#   define SWIGTEMPLATEDISAMBIGUATOR 
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__)) 
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__)) 
# else
#   define SWIGUNUSED 
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER)
# undef _CRT_SECURE_NO_DEPRECATE
# define _CRT_SECURE_NO_DEPRECATE
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTELC__)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  (*jenv)->ExceptionClear(jenv);
  excep = (*jenv)->FindClass(jenv, except_ptr->java_exception);
  if (excep)
    (*jenv)->ThrowNew(jenv, excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else


#include "db_int.h"
#include "dbinc/txn.h"

#ifdef HAVE_CRYPTO
#define	CRYPTO_ONLY(x) (x);
#else
#define	CRYPTO_ONLY(x)
#endif


/* don't use SWIG's array handling - save code space */
#define	SWIG_NOINCLUDE 1

#define	DB_ENV_INTERNAL(dbenv) ((dbenv)->api2_internal)
#define	DB_INTERNAL(db) ((db)->api_internal)

#define	DB_PKG "com/sleepycat/db/"

/* Forward declarations */
static int __dbj_throw(JNIEnv *jenv,
    int err, const char *msg, jobject obj, jobject jdbenv);

/* Global data - JVM handle, classes, fields and methods */
static JavaVM *javavm;

static jclass db_class, dbc_class, dbenv_class, dbt_class, dblsn_class;
static jclass dbpreplist_class, dbtxn_class;
static jclass keyrange_class;
static jclass bt_stat_class, compact_class, h_stat_class, lock_stat_class;
static jclass log_stat_class, mpool_stat_class, mpool_fstat_class;
static jclass mutex_stat_class, qam_stat_class, rep_stat_class;
static jclass rephost_class, seq_stat_class, txn_stat_class;
static jclass txn_active_class;
static jclass lock_class, lockreq_class, rep_processmsg_class;
static jclass dbex_class, deadex_class, lockex_class, memex_class;
static jclass repdupmasterex_class, rephandledeadex_class;
static jclass repholdelectionex_class, repjoinfailex_class, replockoutex_class;
static jclass repunavailex_class;
static jclass runrecex_class, versionex_class;
static jclass filenotfoundex_class, illegalargex_class, outofmemerr_class;
static jclass bytearray_class, string_class, outputstream_class;

static jfieldID dbc_cptr_fid;
static jfieldID dblsn_file_fid, dblsn_offset_fid;
static jfieldID dbt_data_fid, dbt_data_nio_fid, dbt_size_fid, dbt_ulen_fid;
static jfieldID dbt_dlen_fid, dbt_doff_fid, dbt_flags_fid, dbt_offset_fid;
static jfieldID kr_less_fid, kr_equal_fid, kr_greater_fid;
static jfieldID lock_cptr_fid;
static jfieldID lockreq_op_fid, lockreq_modeflag_fid, lockreq_timeout_fid;
static jfieldID lockreq_obj_fid, lockreq_lock_fid;
static jfieldID rep_processmsg_envid_fid;
static jfieldID rephost_port_fid, rephost_host_fid, rephost_eid_fid;
static jfieldID rephost_status_fid;

/* BEGIN-STAT-FIELD-DECLS */
static jfieldID bt_stat_bt_magic_fid;
static jfieldID bt_stat_bt_version_fid;
static jfieldID bt_stat_bt_metaflags_fid;
static jfieldID bt_stat_bt_nkeys_fid;
static jfieldID bt_stat_bt_ndata_fid;
static jfieldID bt_stat_bt_pagesize_fid;
static jfieldID bt_stat_bt_minkey_fid;
static jfieldID bt_stat_bt_re_len_fid;
static jfieldID bt_stat_bt_re_pad_fid;
static jfieldID bt_stat_bt_levels_fid;
static jfieldID bt_stat_bt_int_pg_fid;
static jfieldID bt_stat_bt_leaf_pg_fid;
static jfieldID bt_stat_bt_dup_pg_fid;
static jfieldID bt_stat_bt_over_pg_fid;
static jfieldID bt_stat_bt_empty_pg_fid;
static jfieldID bt_stat_bt_free_fid;
static jfieldID bt_stat_bt_int_pgfree_fid;
static jfieldID bt_stat_bt_leaf_pgfree_fid;
static jfieldID bt_stat_bt_dup_pgfree_fid;
static jfieldID bt_stat_bt_over_pgfree_fid;
static jfieldID compact_compact_fillpercent_fid;
static jfieldID compact_compact_timeout_fid;
static jfieldID compact_compact_pages_fid;
static jfieldID compact_compact_pages_free_fid;
static jfieldID compact_compact_pages_examine_fid;
static jfieldID compact_compact_levels_fid;
static jfieldID compact_compact_deadlock_fid;
static jfieldID compact_compact_pages_truncated_fid;
static jfieldID compact_compact_truncate_fid;
static jfieldID h_stat_hash_magic_fid;
static jfieldID h_stat_hash_version_fid;
static jfieldID h_stat_hash_metaflags_fid;
static jfieldID h_stat_hash_nkeys_fid;
static jfieldID h_stat_hash_ndata_fid;
static jfieldID h_stat_hash_pagesize_fid;
static jfieldID h_stat_hash_ffactor_fid;
static jfieldID h_stat_hash_buckets_fid;
static jfieldID h_stat_hash_free_fid;
static jfieldID h_stat_hash_bfree_fid;
static jfieldID h_stat_hash_bigpages_fid;
static jfieldID h_stat_hash_big_bfree_fid;
static jfieldID h_stat_hash_overflows_fid;
static jfieldID h_stat_hash_ovfl_free_fid;
static jfieldID h_stat_hash_dup_fid;
static jfieldID h_stat_hash_dup_free_fid;
static jfieldID lock_stat_st_id_fid;
static jfieldID lock_stat_st_cur_maxid_fid;
static jfieldID lock_stat_st_maxlocks_fid;
static jfieldID lock_stat_st_maxlockers_fid;
static jfieldID lock_stat_st_maxobjects_fid;
static jfieldID lock_stat_st_nmodes_fid;
static jfieldID lock_stat_st_nlocks_fid;
static jfieldID lock_stat_st_maxnlocks_fid;
static jfieldID lock_stat_st_nlockers_fid;
static jfieldID lock_stat_st_maxnlockers_fid;
static jfieldID lock_stat_st_nobjects_fid;
static jfieldID lock_stat_st_maxnobjects_fid;
static jfieldID lock_stat_st_nrequests_fid;
static jfieldID lock_stat_st_nreleases_fid;
static jfieldID lock_stat_st_nupgrade_fid;
static jfieldID lock_stat_st_ndowngrade_fid;
static jfieldID lock_stat_st_lock_wait_fid;
static jfieldID lock_stat_st_lock_nowait_fid;
static jfieldID lock_stat_st_ndeadlocks_fid;
static jfieldID lock_stat_st_locktimeout_fid;
static jfieldID lock_stat_st_nlocktimeouts_fid;
static jfieldID lock_stat_st_txntimeout_fid;
static jfieldID lock_stat_st_ntxntimeouts_fid;
static jfieldID lock_stat_st_region_wait_fid;
static jfieldID lock_stat_st_region_nowait_fid;
static jfieldID lock_stat_st_regsize_fid;
static jfieldID log_stat_st_magic_fid;
static jfieldID log_stat_st_version_fid;
static jfieldID log_stat_st_mode_fid;
static jfieldID log_stat_st_lg_bsize_fid;
static jfieldID log_stat_st_lg_size_fid;
static jfieldID log_stat_st_record_fid;
static jfieldID log_stat_st_w_bytes_fid;
static jfieldID log_stat_st_w_mbytes_fid;
static jfieldID log_stat_st_wc_bytes_fid;
static jfieldID log_stat_st_wc_mbytes_fid;
static jfieldID log_stat_st_wcount_fid;
static jfieldID log_stat_st_wcount_fill_fid;
static jfieldID log_stat_st_rcount_fid;
static jfieldID log_stat_st_scount_fid;
static jfieldID log_stat_st_region_wait_fid;
static jfieldID log_stat_st_region_nowait_fid;
static jfieldID log_stat_st_cur_file_fid;
static jfieldID log_stat_st_cur_offset_fid;
static jfieldID log_stat_st_disk_file_fid;
static jfieldID log_stat_st_disk_offset_fid;
static jfieldID log_stat_st_regsize_fid;
static jfieldID log_stat_st_maxcommitperflush_fid;
static jfieldID log_stat_st_mincommitperflush_fid;
static jfieldID mpool_fstat_file_name_fid;
static jfieldID mpool_fstat_st_pagesize_fid;
static jfieldID mpool_fstat_st_map_fid;
static jfieldID mpool_fstat_st_cache_hit_fid;
static jfieldID mpool_fstat_st_cache_miss_fid;
static jfieldID mpool_fstat_st_page_create_fid;
static jfieldID mpool_fstat_st_page_in_fid;
static jfieldID mpool_fstat_st_page_out_fid;
static jfieldID mpool_stat_st_gbytes_fid;
static jfieldID mpool_stat_st_bytes_fid;
static jfieldID mpool_stat_st_ncache_fid;
static jfieldID mpool_stat_st_regsize_fid;
static jfieldID mpool_stat_st_mmapsize_fid;
static jfieldID mpool_stat_st_maxopenfd_fid;
static jfieldID mpool_stat_st_maxwrite_fid;
static jfieldID mpool_stat_st_maxwrite_sleep_fid;
static jfieldID mpool_stat_st_map_fid;
static jfieldID mpool_stat_st_cache_hit_fid;
static jfieldID mpool_stat_st_cache_miss_fid;
static jfieldID mpool_stat_st_page_create_fid;
static jfieldID mpool_stat_st_page_in_fid;
static jfieldID mpool_stat_st_page_out_fid;
static jfieldID mpool_stat_st_ro_evict_fid;
static jfieldID mpool_stat_st_rw_evict_fid;
static jfieldID mpool_stat_st_page_trickle_fid;
static jfieldID mpool_stat_st_pages_fid;
static jfieldID mpool_stat_st_page_clean_fid;
static jfieldID mpool_stat_st_page_dirty_fid;
static jfieldID mpool_stat_st_hash_buckets_fid;
static jfieldID mpool_stat_st_hash_searches_fid;
static jfieldID mpool_stat_st_hash_longest_fid;
static jfieldID mpool_stat_st_hash_examined_fid;
static jfieldID mpool_stat_st_hash_nowait_fid;
static jfieldID mpool_stat_st_hash_wait_fid;
static jfieldID mpool_stat_st_hash_max_nowait_fid;
static jfieldID mpool_stat_st_hash_max_wait_fid;
static jfieldID mpool_stat_st_region_nowait_fid;
static jfieldID mpool_stat_st_region_wait_fid;
static jfieldID mpool_stat_st_mvcc_frozen_fid;
static jfieldID mpool_stat_st_mvcc_thawed_fid;
static jfieldID mpool_stat_st_mvcc_freed_fid;
static jfieldID mpool_stat_st_alloc_fid;
static jfieldID mpool_stat_st_alloc_buckets_fid;
static jfieldID mpool_stat_st_alloc_max_buckets_fid;
static jfieldID mpool_stat_st_alloc_pages_fid;
static jfieldID mpool_stat_st_alloc_max_pages_fid;
static jfieldID mpool_stat_st_io_wait_fid;
static jfieldID mutex_stat_st_mutex_align_fid;
static jfieldID mutex_stat_st_mutex_tas_spins_fid;
static jfieldID mutex_stat_st_mutex_cnt_fid;
static jfieldID mutex_stat_st_mutex_free_fid;
static jfieldID mutex_stat_st_mutex_inuse_fid;
static jfieldID mutex_stat_st_mutex_inuse_max_fid;
static jfieldID mutex_stat_st_region_wait_fid;
static jfieldID mutex_stat_st_region_nowait_fid;
static jfieldID mutex_stat_st_regsize_fid;
static jfieldID qam_stat_qs_magic_fid;
static jfieldID qam_stat_qs_version_fid;
static jfieldID qam_stat_qs_metaflags_fid;
static jfieldID qam_stat_qs_nkeys_fid;
static jfieldID qam_stat_qs_ndata_fid;
static jfieldID qam_stat_qs_pagesize_fid;
static jfieldID qam_stat_qs_extentsize_fid;
static jfieldID qam_stat_qs_pages_fid;
static jfieldID qam_stat_qs_re_len_fid;
static jfieldID qam_stat_qs_re_pad_fid;
static jfieldID qam_stat_qs_pgfree_fid;
static jfieldID qam_stat_qs_first_recno_fid;
static jfieldID qam_stat_qs_cur_recno_fid;
static jfieldID rep_stat_st_status_fid;
static jfieldID rep_stat_st_next_lsn_fid;
static jfieldID rep_stat_st_waiting_lsn_fid;
static jfieldID rep_stat_st_next_pg_fid;
static jfieldID rep_stat_st_waiting_pg_fid;
static jfieldID rep_stat_st_dupmasters_fid;
static jfieldID rep_stat_st_env_id_fid;
static jfieldID rep_stat_st_env_priority_fid;
static jfieldID rep_stat_st_bulk_fills_fid;
static jfieldID rep_stat_st_bulk_overflows_fid;
static jfieldID rep_stat_st_bulk_records_fid;
static jfieldID rep_stat_st_bulk_transfers_fid;
static jfieldID rep_stat_st_client_rerequests_fid;
static jfieldID rep_stat_st_client_svc_req_fid;
static jfieldID rep_stat_st_client_svc_miss_fid;
static jfieldID rep_stat_st_gen_fid;
static jfieldID rep_stat_st_egen_fid;
static jfieldID rep_stat_st_log_duplicated_fid;
static jfieldID rep_stat_st_log_queued_fid;
static jfieldID rep_stat_st_log_queued_max_fid;
static jfieldID rep_stat_st_log_queued_total_fid;
static jfieldID rep_stat_st_log_records_fid;
static jfieldID rep_stat_st_log_requested_fid;
static jfieldID rep_stat_st_master_fid;
static jfieldID rep_stat_st_master_changes_fid;
static jfieldID rep_stat_st_msgs_badgen_fid;
static jfieldID rep_stat_st_msgs_processed_fid;
static jfieldID rep_stat_st_msgs_recover_fid;
static jfieldID rep_stat_st_msgs_send_failures_fid;
static jfieldID rep_stat_st_msgs_sent_fid;
static jfieldID rep_stat_st_newsites_fid;
static jfieldID rep_stat_st_nsites_fid;
static jfieldID rep_stat_st_nthrottles_fid;
static jfieldID rep_stat_st_outdated_fid;
static jfieldID rep_stat_st_pg_duplicated_fid;
static jfieldID rep_stat_st_pg_records_fid;
static jfieldID rep_stat_st_pg_requested_fid;
static jfieldID rep_stat_st_startup_complete_fid;
static jfieldID rep_stat_st_txns_applied_fid;
static jfieldID rep_stat_st_elections_fid;
static jfieldID rep_stat_st_elections_won_fid;
static jfieldID rep_stat_st_election_cur_winner_fid;
static jfieldID rep_stat_st_election_gen_fid;
static jfieldID rep_stat_st_election_lsn_fid;
static jfieldID rep_stat_st_election_nsites_fid;
static jfieldID rep_stat_st_election_nvotes_fid;
static jfieldID rep_stat_st_election_priority_fid;
static jfieldID rep_stat_st_election_status_fid;
static jfieldID rep_stat_st_election_tiebreaker_fid;
static jfieldID rep_stat_st_election_votes_fid;
static jfieldID rep_stat_st_election_sec_fid;
static jfieldID rep_stat_st_election_usec_fid;
static jfieldID seq_stat_st_wait_fid;
static jfieldID seq_stat_st_nowait_fid;
static jfieldID seq_stat_st_current_fid;
static jfieldID seq_stat_st_value_fid;
static jfieldID seq_stat_st_last_value_fid;
static jfieldID seq_stat_st_min_fid;
static jfieldID seq_stat_st_max_fid;
static jfieldID seq_stat_st_cache_size_fid;
static jfieldID seq_stat_st_flags_fid;
static jfieldID txn_stat_st_last_ckp_fid;
static jfieldID txn_stat_st_time_ckp_fid;
static jfieldID txn_stat_st_last_txnid_fid;
static jfieldID txn_stat_st_maxtxns_fid;
static jfieldID txn_stat_st_naborts_fid;
static jfieldID txn_stat_st_nbegins_fid;
static jfieldID txn_stat_st_ncommits_fid;
static jfieldID txn_stat_st_nactive_fid;
static jfieldID txn_stat_st_nsnapshot_fid;
static jfieldID txn_stat_st_nrestores_fid;
static jfieldID txn_stat_st_maxnactive_fid;
static jfieldID txn_stat_st_maxnsnapshot_fid;
static jfieldID txn_stat_st_txnarray_fid;
static jfieldID txn_stat_st_region_wait_fid;
static jfieldID txn_stat_st_region_nowait_fid;
static jfieldID txn_stat_st_regsize_fid;
static jfieldID txn_active_txnid_fid;
static jfieldID txn_active_parentid_fid;
static jfieldID txn_active_pid_fid;
static jfieldID txn_active_lsn_fid;
static jfieldID txn_active_read_lsn_fid;
static jfieldID txn_active_mvcc_ref_fid;
static jfieldID txn_active_status_fid;
static jfieldID txn_active_xa_status_fid;
static jfieldID txn_active_xid_fid;
static jfieldID txn_active_name_fid;
/* END-STAT-FIELD-DECLS */

static jmethodID dbenv_construct, dbt_construct, dblsn_construct;
static jmethodID dbpreplist_construct, dbtxn_construct;
static jmethodID bt_stat_construct, h_stat_construct;
static jmethodID lock_stat_construct, log_stat_construct;
static jmethodID mpool_stat_construct, mpool_fstat_construct;
static jmethodID mutex_stat_construct, qam_stat_construct;
static jmethodID rep_stat_construct, seq_stat_construct;
static jmethodID txn_stat_construct, txn_active_construct;
static jmethodID dbex_construct, deadex_construct, lockex_construct;
static jmethodID memex_construct, memex_update_method;
static jmethodID repdupmasterex_construct, rephandledeadex_construct;
static jmethodID repholdelectionex_construct, repjoinfailex_construct;
static jmethodID rephost_construct;
static jmethodID replockoutex_construct, repunavailex_construct;
static jmethodID runrecex_construct, versionex_construct;
static jmethodID filenotfoundex_construct, illegalargex_construct;
static jmethodID outofmemerr_construct;
static jmethodID lock_construct;

static jmethodID app_dispatch_method, errcall_method, env_feedback_method;
static jmethodID msgcall_method, paniccall_method, rep_transport_method;
static jmethodID event_notify_method;

static jmethodID append_recno_method, bt_compare_method, bt_prefix_method;
static jmethodID db_feedback_method, dup_compare_method, h_hash_method;
static jmethodID seckey_create_method;

static jmethodID outputstream_write_method;

const struct {
	jclass *cl;
	const char *name;
} all_classes[] = {
	{ &dbenv_class, DB_PKG "internal/DbEnv" },
	{ &db_class, DB_PKG "internal/Db" },
	{ &dbc_class, DB_PKG "internal/Dbc" },
	{ &dbt_class, DB_PKG "DatabaseEntry" },
	{ &dblsn_class, DB_PKG "LogSequenceNumber" },
	{ &dbpreplist_class, DB_PKG "PreparedTransaction" },
	{ &dbtxn_class, DB_PKG "internal/DbTxn" },

	{ &bt_stat_class, DB_PKG "BtreeStats" },
	{ &compact_class, DB_PKG "CompactStats" },
	{ &h_stat_class, DB_PKG "HashStats" },
	{ &lock_stat_class, DB_PKG "LockStats" },
	{ &log_stat_class, DB_PKG "LogStats" },
	{ &mpool_fstat_class, DB_PKG "CacheFileStats" },
	{ &mpool_stat_class, DB_PKG "CacheStats" },
	{ &mutex_stat_class, DB_PKG "MutexStats" },
	{ &qam_stat_class, DB_PKG "QueueStats" },
	{ &rep_stat_class, DB_PKG "ReplicationStats" },
	{ &seq_stat_class, DB_PKG "SequenceStats" },
	{ &txn_stat_class, DB_PKG "TransactionStats" },
	{ &txn_active_class, DB_PKG "TransactionStats$Active" },

	{ &keyrange_class, DB_PKG "KeyRange" },
	{ &lock_class, DB_PKG "internal/DbLock" },
	{ &lockreq_class, DB_PKG "LockRequest" },
	{ &rep_processmsg_class, DB_PKG "internal/DbEnv$RepProcessMessage" },
	{ &rep_processmsg_class, DB_PKG "internal/DbEnv$RepProcessMessage" },

	{ &dbex_class, DB_PKG "DatabaseException" },
	{ &deadex_class, DB_PKG "DeadlockException" },
	{ &lockex_class, DB_PKG "LockNotGrantedException" },
	{ &memex_class, DB_PKG "MemoryException" },
	{ &repdupmasterex_class, DB_PKG "ReplicationDuplicateMasterException" },
	{ &rephandledeadex_class, DB_PKG "ReplicationHandleDeadException" },
	{ &repholdelectionex_class, DB_PKG "ReplicationHoldElectionException" },
	{ &rephost_class, DB_PKG "ReplicationHostAddress" },
	{ &repjoinfailex_class, DB_PKG "ReplicationJoinFailureException" },
	{ &replockoutex_class, DB_PKG "ReplicationLockoutException" },
	{ &repunavailex_class, DB_PKG "ReplicationSiteUnavailableException" },
	{ &runrecex_class, DB_PKG "RunRecoveryException" },
	{ &versionex_class, DB_PKG "VersionMismatchException" },
	{ &filenotfoundex_class, "java/io/FileNotFoundException" },
	{ &illegalargex_class, "java/lang/IllegalArgumentException" },
	{ &outofmemerr_class, "java/lang/OutOfMemoryError" },

	{ &bytearray_class, "[B" },
	{ &string_class, "java/lang/String" },
	{ &outputstream_class, "java/io/OutputStream" }
};

const struct {
	jfieldID *fid;
	jclass *cl;
	const char *name;
	const char *sig;
} all_fields[] = {
	{ &dbc_cptr_fid, &dbc_class, "swigCPtr", "J" },

	{ &dblsn_file_fid, &dblsn_class, "file", "I" },
	{ &dblsn_offset_fid, &dblsn_class, "offset", "I" },

	{ &dbt_data_fid, &dbt_class, "data", "[B" },
	{ &dbt_data_nio_fid, &dbt_class, "data_nio", "Ljava/nio/ByteBuffer;" },
	{ &dbt_size_fid, &dbt_class, "size", "I" },
	{ &dbt_ulen_fid, &dbt_class, "ulen", "I" },
	{ &dbt_dlen_fid, &dbt_class, "dlen", "I" },
	{ &dbt_doff_fid, &dbt_class, "doff", "I" },
	{ &dbt_flags_fid, &dbt_class, "flags", "I" },
	{ &dbt_offset_fid, &dbt_class, "offset", "I" },

	{ &kr_less_fid, &keyrange_class, "less", "D" },
	{ &kr_equal_fid, &keyrange_class, "equal", "D" },
	{ &kr_greater_fid, &keyrange_class, "greater", "D" },

	{ &lock_cptr_fid, &lock_class, "swigCPtr", "J" },

	{ &lockreq_op_fid, &lockreq_class, "op", "I" },
	{ &lockreq_modeflag_fid, &lockreq_class, "modeFlag", "I" },
	{ &lockreq_timeout_fid, &lockreq_class, "timeout", "I" },
	{ &lockreq_obj_fid, &lockreq_class, "obj",
	    "L" DB_PKG "DatabaseEntry;" },
	{ &lockreq_lock_fid, &lockreq_class, "lock",
	    "L" DB_PKG "internal/DbLock;" },

/* BEGIN-STAT-FIELDS */
	{ &bt_stat_bt_magic_fid, &bt_stat_class, "bt_magic", "I" },
	{ &bt_stat_bt_version_fid, &bt_stat_class, "bt_version", "I" },
	{ &bt_stat_bt_metaflags_fid, &bt_stat_class, "bt_metaflags", "I" },
	{ &bt_stat_bt_nkeys_fid, &bt_stat_class, "bt_nkeys", "I" },
	{ &bt_stat_bt_ndata_fid, &bt_stat_class, "bt_ndata", "I" },
	{ &bt_stat_bt_pagesize_fid, &bt_stat_class, "bt_pagesize", "I" },
	{ &bt_stat_bt_minkey_fid, &bt_stat_class, "bt_minkey", "I" },
	{ &bt_stat_bt_re_len_fid, &bt_stat_class, "bt_re_len", "I" },
	{ &bt_stat_bt_re_pad_fid, &bt_stat_class, "bt_re_pad", "I" },
	{ &bt_stat_bt_levels_fid, &bt_stat_class, "bt_levels", "I" },
	{ &bt_stat_bt_int_pg_fid, &bt_stat_class, "bt_int_pg", "I" },
	{ &bt_stat_bt_leaf_pg_fid, &bt_stat_class, "bt_leaf_pg", "I" },
	{ &bt_stat_bt_dup_pg_fid, &bt_stat_class, "bt_dup_pg", "I" },
	{ &bt_stat_bt_over_pg_fid, &bt_stat_class, "bt_over_pg", "I" },
	{ &bt_stat_bt_empty_pg_fid, &bt_stat_class, "bt_empty_pg", "I" },
	{ &bt_stat_bt_free_fid, &bt_stat_class, "bt_free", "I" },
	{ &bt_stat_bt_int_pgfree_fid, &bt_stat_class, "bt_int_pgfree", "I" },
	{ &bt_stat_bt_leaf_pgfree_fid, &bt_stat_class, "bt_leaf_pgfree", "I" },
	{ &bt_stat_bt_dup_pgfree_fid, &bt_stat_class, "bt_dup_pgfree", "I" },
	{ &bt_stat_bt_over_pgfree_fid, &bt_stat_class, "bt_over_pgfree", "I" },
	{ &compact_compact_fillpercent_fid, &compact_class, "compact_fillpercent", "I" },
	{ &compact_compact_timeout_fid, &compact_class, "compact_timeout", "I" },
	{ &compact_compact_pages_fid, &compact_class, "compact_pages", "I" },
	{ &compact_compact_pages_free_fid, &compact_class, "compact_pages_free", "I" },
	{ &compact_compact_pages_examine_fid, &compact_class, "compact_pages_examine", "I" },
	{ &compact_compact_levels_fid, &compact_class, "compact_levels", "I" },
	{ &compact_compact_deadlock_fid, &compact_class, "compact_deadlock", "I" },
	{ &compact_compact_pages_truncated_fid, &compact_class, "compact_pages_truncated", "I" },
	{ &compact_compact_truncate_fid, &compact_class, "compact_truncate", "I" },
	{ &h_stat_hash_magic_fid, &h_stat_class, "hash_magic", "I" },
	{ &h_stat_hash_version_fid, &h_stat_class, "hash_version", "I" },
	{ &h_stat_hash_metaflags_fid, &h_stat_class, "hash_metaflags", "I" },
	{ &h_stat_hash_nkeys_fid, &h_stat_class, "hash_nkeys", "I" },
	{ &h_stat_hash_ndata_fid, &h_stat_class, "hash_ndata", "I" },
	{ &h_stat_hash_pagesize_fid, &h_stat_class, "hash_pagesize", "I" },
	{ &h_stat_hash_ffactor_fid, &h_stat_class, "hash_ffactor", "I" },
	{ &h_stat_hash_buckets_fid, &h_stat_class, "hash_buckets", "I" },
	{ &h_stat_hash_free_fid, &h_stat_class, "hash_free", "I" },
	{ &h_stat_hash_bfree_fid, &h_stat_class, "hash_bfree", "I" },
	{ &h_stat_hash_bigpages_fid, &h_stat_class, "hash_bigpages", "I" },
	{ &h_stat_hash_big_bfree_fid, &h_stat_class, "hash_big_bfree", "I" },
	{ &h_stat_hash_overflows_fid, &h_stat_class, "hash_overflows", "I" },
	{ &h_stat_hash_ovfl_free_fid, &h_stat_class, "hash_ovfl_free", "I" },
	{ &h_stat_hash_dup_fid, &h_stat_class, "hash_dup", "I" },
	{ &h_stat_hash_dup_free_fid, &h_stat_class, "hash_dup_free", "I" },
	{ &lock_stat_st_id_fid, &lock_stat_class, "st_id", "I" },
	{ &lock_stat_st_cur_maxid_fid, &lock_stat_class, "st_cur_maxid", "I" },
	{ &lock_stat_st_maxlocks_fid, &lock_stat_class, "st_maxlocks", "I" },
	{ &lock_stat_st_maxlockers_fid, &lock_stat_class, "st_maxlockers", "I" },
	{ &lock_stat_st_maxobjects_fid, &lock_stat_class, "st_maxobjects", "I" },
	{ &lock_stat_st_nmodes_fid, &lock_stat_class, "st_nmodes", "I" },
	{ &lock_stat_st_nlocks_fid, &lock_stat_class, "st_nlocks", "I" },
	{ &lock_stat_st_maxnlocks_fid, &lock_stat_class, "st_maxnlocks", "I" },
	{ &lock_stat_st_nlockers_fid, &lock_stat_class, "st_nlockers", "I" },
	{ &lock_stat_st_maxnlockers_fid, &lock_stat_class, "st_maxnlockers", "I" },
	{ &lock_stat_st_nobjects_fid, &lock_stat_class, "st_nobjects", "I" },
	{ &lock_stat_st_maxnobjects_fid, &lock_stat_class, "st_maxnobjects", "I" },
	{ &lock_stat_st_nrequests_fid, &lock_stat_class, "st_nrequests", "I" },
	{ &lock_stat_st_nreleases_fid, &lock_stat_class, "st_nreleases", "I" },
	{ &lock_stat_st_nupgrade_fid, &lock_stat_class, "st_nupgrade", "I" },
	{ &lock_stat_st_ndowngrade_fid, &lock_stat_class, "st_ndowngrade", "I" },
	{ &lock_stat_st_lock_wait_fid, &lock_stat_class, "st_lock_wait", "I" },
	{ &lock_stat_st_lock_nowait_fid, &lock_stat_class, "st_lock_nowait", "I" },
	{ &lock_stat_st_ndeadlocks_fid, &lock_stat_class, "st_ndeadlocks", "I" },
	{ &lock_stat_st_locktimeout_fid, &lock_stat_class, "st_locktimeout", "I" },
	{ &lock_stat_st_nlocktimeouts_fid, &lock_stat_class, "st_nlocktimeouts", "I" },
	{ &lock_stat_st_txntimeout_fid, &lock_stat_class, "st_txntimeout", "I" },
	{ &lock_stat_st_ntxntimeouts_fid, &lock_stat_class, "st_ntxntimeouts", "I" },
	{ &lock_stat_st_region_wait_fid, &lock_stat_class, "st_region_wait", "I" },
	{ &lock_stat_st_region_nowait_fid, &lock_stat_class, "st_region_nowait", "I" },
	{ &lock_stat_st_regsize_fid, &lock_stat_class, "st_regsize", "I" },
	{ &log_stat_st_magic_fid, &log_stat_class, "st_magic", "I" },
	{ &log_stat_st_version_fid, &log_stat_class, "st_version", "I" },
	{ &log_stat_st_mode_fid, &log_stat_class, "st_mode", "I" },
	{ &log_stat_st_lg_bsize_fid, &log_stat_class, "st_lg_bsize", "I" },
	{ &log_stat_st_lg_size_fid, &log_stat_class, "st_lg_size", "I" },
	{ &log_stat_st_record_fid, &log_stat_class, "st_record", "I" },
	{ &log_stat_st_w_bytes_fid, &log_stat_class, "st_w_bytes", "I" },
	{ &log_stat_st_w_mbytes_fid, &log_stat_class, "st_w_mbytes", "I" },
	{ &log_stat_st_wc_bytes_fid, &log_stat_class, "st_wc_bytes", "I" },
	{ &log_stat_st_wc_mbytes_fid, &log_stat_class, "st_wc_mbytes", "I" },
	{ &log_stat_st_wcount_fid, &log_stat_class, "st_wcount", "I" },
	{ &log_stat_st_wcount_fill_fid, &log_stat_class, "st_wcount_fill", "I" },
	{ &log_stat_st_rcount_fid, &log_stat_class, "st_rcount", "I" },
	{ &log_stat_st_scount_fid, &log_stat_class, "st_scount", "I" },
	{ &log_stat_st_region_wait_fid, &log_stat_class, "st_region_wait", "I" },
	{ &log_stat_st_region_nowait_fid, &log_stat_class, "st_region_nowait", "I" },
	{ &log_stat_st_cur_file_fid, &log_stat_class, "st_cur_file", "I" },
	{ &log_stat_st_cur_offset_fid, &log_stat_class, "st_cur_offset", "I" },
	{ &log_stat_st_disk_file_fid, &log_stat_class, "st_disk_file", "I" },
	{ &log_stat_st_disk_offset_fid, &log_stat_class, "st_disk_offset", "I" },
	{ &log_stat_st_regsize_fid, &log_stat_class, "st_regsize", "I" },
	{ &log_stat_st_maxcommitperflush_fid, &log_stat_class, "st_maxcommitperflush", "I" },
	{ &log_stat_st_mincommitperflush_fid, &log_stat_class, "st_mincommitperflush", "I" },
	{ &mpool_fstat_file_name_fid, &mpool_fstat_class, "file_name", "Ljava/lang/String;" },
	{ &mpool_fstat_st_pagesize_fid, &mpool_fstat_class, "st_pagesize", "I" },
	{ &mpool_fstat_st_map_fid, &mpool_fstat_class, "st_map", "I" },
	{ &mpool_fstat_st_cache_hit_fid, &mpool_fstat_class, "st_cache_hit", "I" },
	{ &mpool_fstat_st_cache_miss_fid, &mpool_fstat_class, "st_cache_miss", "I" },
	{ &mpool_fstat_st_page_create_fid, &mpool_fstat_class, "st_page_create", "I" },
	{ &mpool_fstat_st_page_in_fid, &mpool_fstat_class, "st_page_in", "I" },
	{ &mpool_fstat_st_page_out_fid, &mpool_fstat_class, "st_page_out", "I" },
	{ &mpool_stat_st_gbytes_fid, &mpool_stat_class, "st_gbytes", "I" },
	{ &mpool_stat_st_bytes_fid, &mpool_stat_class, "st_bytes", "I" },
	{ &mpool_stat_st_ncache_fid, &mpool_stat_class, "st_ncache", "I" },
	{ &mpool_stat_st_regsize_fid, &mpool_stat_class, "st_regsize", "I" },
	{ &mpool_stat_st_mmapsize_fid, &mpool_stat_class, "st_mmapsize", "I" },
	{ &mpool_stat_st_maxopenfd_fid, &mpool_stat_class, "st_maxopenfd", "I" },
	{ &mpool_stat_st_maxwrite_fid, &mpool_stat_class, "st_maxwrite", "I" },
	{ &mpool_stat_st_maxwrite_sleep_fid, &mpool_stat_class, "st_maxwrite_sleep", "I" },
	{ &mpool_stat_st_map_fid, &mpool_stat_class, "st_map", "I" },
	{ &mpool_stat_st_cache_hit_fid, &mpool_stat_class, "st_cache_hit", "I" },
	{ &mpool_stat_st_cache_miss_fid, &mpool_stat_class, "st_cache_miss", "I" },
	{ &mpool_stat_st_page_create_fid, &mpool_stat_class, "st_page_create", "I" },
	{ &mpool_stat_st_page_in_fid, &mpool_stat_class, "st_page_in", "I" },
	{ &mpool_stat_st_page_out_fid, &mpool_stat_class, "st_page_out", "I" },
	{ &mpool_stat_st_ro_evict_fid, &mpool_stat_class, "st_ro_evict", "I" },
	{ &mpool_stat_st_rw_evict_fid, &mpool_stat_class, "st_rw_evict", "I" },
	{ &mpool_stat_st_page_trickle_fid, &mpool_stat_class, "st_page_trickle", "I" },
	{ &mpool_stat_st_pages_fid, &mpool_stat_class, "st_pages", "I" },
	{ &mpool_stat_st_page_clean_fid, &mpool_stat_class, "st_page_clean", "I" },
	{ &mpool_stat_st_page_dirty_fid, &mpool_stat_class, "st_page_dirty", "I" },
	{ &mpool_stat_st_hash_buckets_fid, &mpool_stat_class, "st_hash_buckets", "I" },
	{ &mpool_stat_st_hash_searches_fid, &mpool_stat_class, "st_hash_searches", "I" },
	{ &mpool_stat_st_hash_longest_fid, &mpool_stat_class, "st_hash_longest", "I" },
	{ &mpool_stat_st_hash_examined_fid, &mpool_stat_class, "st_hash_examined", "I" },
	{ &mpool_stat_st_hash_nowait_fid, &mpool_stat_class, "st_hash_nowait", "I" },
	{ &mpool_stat_st_hash_wait_fid, &mpool_stat_class, "st_hash_wait", "I" },
	{ &mpool_stat_st_hash_max_nowait_fid, &mpool_stat_class, "st_hash_max_nowait", "I" },
	{ &mpool_stat_st_hash_max_wait_fid, &mpool_stat_class, "st_hash_max_wait", "I" },
	{ &mpool_stat_st_region_nowait_fid, &mpool_stat_class, "st_region_nowait", "I" },
	{ &mpool_stat_st_region_wait_fid, &mpool_stat_class, "st_region_wait", "I" },
	{ &mpool_stat_st_mvcc_frozen_fid, &mpool_stat_class, "st_mvcc_frozen", "I" },
	{ &mpool_stat_st_mvcc_thawed_fid, &mpool_stat_class, "st_mvcc_thawed", "I" },
	{ &mpool_stat_st_mvcc_freed_fid, &mpool_stat_class, "st_mvcc_freed", "I" },
	{ &mpool_stat_st_alloc_fid, &mpool_stat_class, "st_alloc", "I" },
	{ &mpool_stat_st_alloc_buckets_fid, &mpool_stat_class, "st_alloc_buckets", "I" },
	{ &mpool_stat_st_alloc_max_buckets_fid, &mpool_stat_class, "st_alloc_max_buckets", "I" },
	{ &mpool_stat_st_alloc_pages_fid, &mpool_stat_class, "st_alloc_pages", "I" },
	{ &mpool_stat_st_alloc_max_pages_fid, &mpool_stat_class, "st_alloc_max_pages", "I" },
	{ &mpool_stat_st_io_wait_fid, &mpool_stat_class, "st_io_wait", "I" },
	{ &mutex_stat_st_mutex_align_fid, &mutex_stat_class, "st_mutex_align", "I" },
	{ &mutex_stat_st_mutex_tas_spins_fid, &mutex_stat_class, "st_mutex_tas_spins", "I" },
	{ &mutex_stat_st_mutex_cnt_fid, &mutex_stat_class, "st_mutex_cnt", "I" },
	{ &mutex_stat_st_mutex_free_fid, &mutex_stat_class, "st_mutex_free", "I" },
	{ &mutex_stat_st_mutex_inuse_fid, &mutex_stat_class, "st_mutex_inuse", "I" },
	{ &mutex_stat_st_mutex_inuse_max_fid, &mutex_stat_class, "st_mutex_inuse_max", "I" },
	{ &mutex_stat_st_region_wait_fid, &mutex_stat_class, "st_region_wait", "I" },
	{ &mutex_stat_st_region_nowait_fid, &mutex_stat_class, "st_region_nowait", "I" },
	{ &mutex_stat_st_regsize_fid, &mutex_stat_class, "st_regsize", "I" },
	{ &qam_stat_qs_magic_fid, &qam_stat_class, "qs_magic", "I" },
	{ &qam_stat_qs_version_fid, &qam_stat_class, "qs_version", "I" },
	{ &qam_stat_qs_metaflags_fid, &qam_stat_class, "qs_metaflags", "I" },
	{ &qam_stat_qs_nkeys_fid, &qam_stat_class, "qs_nkeys", "I" },
	{ &qam_stat_qs_ndata_fid, &qam_stat_class, "qs_ndata", "I" },
	{ &qam_stat_qs_pagesize_fid, &qam_stat_class, "qs_pagesize", "I" },
	{ &qam_stat_qs_extentsize_fid, &qam_stat_class, "qs_extentsize", "I" },
	{ &qam_stat_qs_pages_fid, &qam_stat_class, "qs_pages", "I" },
	{ &qam_stat_qs_re_len_fid, &qam_stat_class, "qs_re_len", "I" },
	{ &qam_stat_qs_re_pad_fid, &qam_stat_class, "qs_re_pad", "I" },
	{ &qam_stat_qs_pgfree_fid, &qam_stat_class, "qs_pgfree", "I" },
	{ &qam_stat_qs_first_recno_fid, &qam_stat_class, "qs_first_recno", "I" },
	{ &qam_stat_qs_cur_recno_fid, &qam_stat_class, "qs_cur_recno", "I" },
	{ &rep_stat_st_status_fid, &rep_stat_class, "st_status", "I" },
	{ &rep_stat_st_next_lsn_fid, &rep_stat_class, "st_next_lsn", "L" DB_PKG "LogSequenceNumber;" },
	{ &rep_stat_st_waiting_lsn_fid, &rep_stat_class, "st_waiting_lsn", "L" DB_PKG "LogSequenceNumber;" },
	{ &rep_stat_st_next_pg_fid, &rep_stat_class, "st_next_pg", "I" },
	{ &rep_stat_st_waiting_pg_fid, &rep_stat_class, "st_waiting_pg", "I" },
	{ &rep_stat_st_dupmasters_fid, &rep_stat_class, "st_dupmasters", "I" },
	{ &rep_stat_st_env_id_fid, &rep_stat_class, "st_env_id", "I" },
	{ &rep_stat_st_env_priority_fid, &rep_stat_class, "st_env_priority", "I" },
	{ &rep_stat_st_bulk_fills_fid, &rep_stat_class, "st_bulk_fills", "I" },
	{ &rep_stat_st_bulk_overflows_fid, &rep_stat_class, "st_bulk_overflows", "I" },
	{ &rep_stat_st_bulk_records_fid, &rep_stat_class, "st_bulk_records", "I" },
	{ &rep_stat_st_bulk_transfers_fid, &rep_stat_class, "st_bulk_transfers", "I" },
	{ &rep_stat_st_client_rerequests_fid, &rep_stat_class, "st_client_rerequests", "I" },
	{ &rep_stat_st_client_svc_req_fid, &rep_stat_class, "st_client_svc_req", "I" },
	{ &rep_stat_st_client_svc_miss_fid, &rep_stat_class, "st_client_svc_miss", "I" },
	{ &rep_stat_st_gen_fid, &rep_stat_class, "st_gen", "I" },
	{ &rep_stat_st_egen_fid, &rep_stat_class, "st_egen", "I" },
	{ &rep_stat_st_log_duplicated_fid, &rep_stat_class, "st_log_duplicated", "I" },
	{ &rep_stat_st_log_queued_fid, &rep_stat_class, "st_log_queued", "I" },
	{ &rep_stat_st_log_queued_max_fid, &rep_stat_class, "st_log_queued_max", "I" },
	{ &rep_stat_st_log_queued_total_fid, &rep_stat_class, "st_log_queued_total", "I" },
	{ &rep_stat_st_log_records_fid, &rep_stat_class, "st_log_records", "I" },
	{ &rep_stat_st_log_requested_fid, &rep_stat_class, "st_log_requested", "I" },
	{ &rep_stat_st_master_fid, &rep_stat_class, "st_master", "I" },
	{ &rep_stat_st_master_changes_fid, &rep_stat_class, "st_master_changes", "I" },
	{ &rep_stat_st_msgs_badgen_fid, &rep_stat_class, "st_msgs_badgen", "I" },
	{ &rep_stat_st_msgs_processed_fid, &rep_stat_class, "st_msgs_processed", "I" },
	{ &rep_stat_st_msgs_recover_fid, &rep_stat_class, "st_msgs_recover", "I" },
	{ &rep_stat_st_msgs_send_failures_fid, &rep_stat_class, "st_msgs_send_failures", "I" },
	{ &rep_stat_st_msgs_sent_fid, &rep_stat_class, "st_msgs_sent", "I" },
	{ &rep_stat_st_newsites_fid, &rep_stat_class, "st_newsites", "I" },
	{ &rep_stat_st_nsites_fid, &rep_stat_class, "st_nsites", "I" },
	{ &rep_stat_st_nthrottles_fid, &rep_stat_class, "st_nthrottles", "I" },
	{ &rep_stat_st_outdated_fid, &rep_stat_class, "st_outdated", "I" },
	{ &rep_stat_st_pg_duplicated_fid, &rep_stat_class, "st_pg_duplicated", "I" },
	{ &rep_stat_st_pg_records_fid, &rep_stat_class, "st_pg_records", "I" },
	{ &rep_stat_st_pg_requested_fid, &rep_stat_class, "st_pg_requested", "I" },
	{ &rep_stat_st_startup_complete_fid, &rep_stat_class, "st_startup_complete", "I" },
	{ &rep_stat_st_txns_applied_fid, &rep_stat_class, "st_txns_applied", "I" },
	{ &rep_stat_st_elections_fid, &rep_stat_class, "st_elections", "I" },
	{ &rep_stat_st_elections_won_fid, &rep_stat_class, "st_elections_won", "I" },
	{ &rep_stat_st_election_cur_winner_fid, &rep_stat_class, "st_election_cur_winner", "I" },
	{ &rep_stat_st_election_gen_fid, &rep_stat_class, "st_election_gen", "I" },
	{ &rep_stat_st_election_lsn_fid, &rep_stat_class, "st_election_lsn", "L" DB_PKG "LogSequenceNumber;" },
	{ &rep_stat_st_election_nsites_fid, &rep_stat_class, "st_election_nsites", "I" },
	{ &rep_stat_st_election_nvotes_fid, &rep_stat_class, "st_election_nvotes", "I" },
	{ &rep_stat_st_election_priority_fid, &rep_stat_class, "st_election_priority", "I" },
	{ &rep_stat_st_election_status_fid, &rep_stat_class, "st_election_status", "I" },
	{ &rep_stat_st_election_tiebreaker_fid, &rep_stat_class, "st_election_tiebreaker", "I" },
	{ &rep_stat_st_election_votes_fid, &rep_stat_class, "st_election_votes", "I" },
	{ &rep_stat_st_election_sec_fid, &rep_stat_class, "st_election_sec", "I" },
	{ &rep_stat_st_election_usec_fid, &rep_stat_class, "st_election_usec", "I" },
	{ &seq_stat_st_wait_fid, &seq_stat_class, "st_wait", "I" },
	{ &seq_stat_st_nowait_fid, &seq_stat_class, "st_nowait", "I" },
	{ &seq_stat_st_current_fid, &seq_stat_class, "st_current", "J" },
	{ &seq_stat_st_value_fid, &seq_stat_class, "st_value", "J" },
	{ &seq_stat_st_last_value_fid, &seq_stat_class, "st_last_value", "J" },
	{ &seq_stat_st_min_fid, &seq_stat_class, "st_min", "J" },
	{ &seq_stat_st_max_fid, &seq_stat_class, "st_max", "J" },
	{ &seq_stat_st_cache_size_fid, &seq_stat_class, "st_cache_size", "I" },
	{ &seq_stat_st_flags_fid, &seq_stat_class, "st_flags", "I" },
	{ &txn_stat_st_last_ckp_fid, &txn_stat_class, "st_last_ckp", "L" DB_PKG "LogSequenceNumber;" },
	{ &txn_stat_st_time_ckp_fid, &txn_stat_class, "st_time_ckp", "J" },
	{ &txn_stat_st_last_txnid_fid, &txn_stat_class, "st_last_txnid", "I" },
	{ &txn_stat_st_maxtxns_fid, &txn_stat_class, "st_maxtxns", "I" },
	{ &txn_stat_st_naborts_fid, &txn_stat_class, "st_naborts", "I" },
	{ &txn_stat_st_nbegins_fid, &txn_stat_class, "st_nbegins", "I" },
	{ &txn_stat_st_ncommits_fid, &txn_stat_class, "st_ncommits", "I" },
	{ &txn_stat_st_nactive_fid, &txn_stat_class, "st_nactive", "I" },
	{ &txn_stat_st_nsnapshot_fid, &txn_stat_class, "st_nsnapshot", "I" },
	{ &txn_stat_st_nrestores_fid, &txn_stat_class, "st_nrestores", "I" },
	{ &txn_stat_st_maxnactive_fid, &txn_stat_class, "st_maxnactive", "I" },
	{ &txn_stat_st_maxnsnapshot_fid, &txn_stat_class, "st_maxnsnapshot", "I" },
	{ &txn_stat_st_txnarray_fid, &txn_stat_class, "st_txnarray", "[L" DB_PKG "TransactionStats$Active;" },
	{ &txn_stat_st_region_wait_fid, &txn_stat_class, "st_region_wait", "I" },
	{ &txn_stat_st_region_nowait_fid, &txn_stat_class, "st_region_nowait", "I" },
	{ &txn_stat_st_regsize_fid, &txn_stat_class, "st_regsize", "I" },
	{ &txn_active_txnid_fid, &txn_active_class, "txnid", "I" },
	{ &txn_active_parentid_fid, &txn_active_class, "parentid", "I" },
	{ &txn_active_pid_fid, &txn_active_class, "pid", "I" },
	{ &txn_active_lsn_fid, &txn_active_class, "lsn", "L" DB_PKG "LogSequenceNumber;" },
	{ &txn_active_read_lsn_fid, &txn_active_class, "read_lsn", "L" DB_PKG "LogSequenceNumber;" },
	{ &txn_active_mvcc_ref_fid, &txn_active_class, "mvcc_ref", "I" },
	{ &txn_active_status_fid, &txn_active_class, "status", "I" },
	{ &txn_active_xa_status_fid, &txn_active_class, "xa_status", "I" },
	{ &txn_active_xid_fid, &txn_active_class, "xid", "[B" },
	{ &txn_active_name_fid, &txn_active_class, "name", "Ljava/lang/String;" },
/* END-STAT-FIELDS */

	{ &rephost_port_fid, &rephost_class, "port", "I" },
	{ &rephost_host_fid, &rephost_class, "host", "Ljava/lang/String;" },
	{ &rephost_eid_fid, &rephost_class, "eid", "I" },
	{ &rephost_status_fid, &rephost_class, "status", "I" },
	{ &rep_processmsg_envid_fid, &rep_processmsg_class, "envid", "I" }
};

const struct {
	jmethodID *mid;
	jclass *cl;
	const char *name;
	const char *sig;
} all_methods[] = {
	{ &dbenv_construct, &dbenv_class, "<init>", "(JZ)V" },
	{ &dbt_construct, &dbt_class, "<init>", "()V" },
	{ &dblsn_construct, &dblsn_class, "<init>", "(II)V" },
	{ &dbpreplist_construct, &dbpreplist_class, "<init>",
	    "(L" DB_PKG "internal/DbTxn;[B)V" },
	{ &dbtxn_construct, &dbtxn_class, "<init>", "(JZ)V" },

	{ &bt_stat_construct, &bt_stat_class, "<init>", "()V" },
	{ &h_stat_construct, &h_stat_class, "<init>", "()V" },
	{ &lock_stat_construct, &lock_stat_class, "<init>", "()V" },
	{ &log_stat_construct, &log_stat_class, "<init>", "()V" },
	{ &mpool_stat_construct, &mpool_stat_class, "<init>", "()V" },
	{ &mpool_fstat_construct, &mpool_fstat_class, "<init>", "()V" },
	{ &mutex_stat_construct, &mutex_stat_class, "<init>", "()V" },
	{ &qam_stat_construct, &qam_stat_class, "<init>", "()V" },
	{ &rep_stat_construct, &rep_stat_class, "<init>", "()V" },
	{ &seq_stat_construct, &seq_stat_class, "<init>", "()V" },
	{ &txn_stat_construct, &txn_stat_class, "<init>", "()V" },
	{ &txn_active_construct, &txn_active_class, "<init>", "()V" },
	{ &rephost_construct, &rephost_class, "<init>", "()V" },

	{ &dbex_construct, &dbex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &deadex_construct, &deadex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &lockex_construct, &lockex_class, "<init>",
	    "(Ljava/lang/String;IIL" DB_PKG "DatabaseEntry;L"
	    DB_PKG "internal/DbLock;IL" DB_PKG "internal/DbEnv;)V" },
	{ &memex_construct, &memex_class, "<init>",
	    "(Ljava/lang/String;L" DB_PKG "DatabaseEntry;IL"
	    DB_PKG "internal/DbEnv;)V" },
	{ &memex_update_method, &memex_class, "updateDatabaseEntry",
	    "(L" DB_PKG "DatabaseEntry;)V" },
	{ &repdupmasterex_construct, &repdupmasterex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &rephandledeadex_construct, &rephandledeadex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &repholdelectionex_construct, &repholdelectionex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &repjoinfailex_construct, &repjoinfailex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &replockoutex_construct, &replockoutex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &repunavailex_construct, &repunavailex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &runrecex_construct, &runrecex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &versionex_construct, &versionex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &filenotfoundex_construct, &filenotfoundex_class, "<init>",
	    "(Ljava/lang/String;)V" },
	{ &illegalargex_construct, &illegalargex_class, "<init>",
	    "(Ljava/lang/String;)V" },
	{ &outofmemerr_construct, &outofmemerr_class, "<init>",
	    "(Ljava/lang/String;)V" },

	{ &lock_construct, &lock_class, "<init>", "(JZ)V" },

	{ &app_dispatch_method, &dbenv_class, "handle_app_dispatch",
	    "(L" DB_PKG "DatabaseEntry;L" DB_PKG "LogSequenceNumber;I)I" },
	{ &event_notify_method, &dbenv_class, "handle_event_notify",
	    "(I)I" },
	{ &env_feedback_method, &dbenv_class, "handle_env_feedback", "(II)V" },
	{ &errcall_method, &dbenv_class, "handle_error",
	    "(Ljava/lang/String;)V" },
	{ &msgcall_method, &dbenv_class, "handle_message",
	    "(Ljava/lang/String;)V" },
	{ &paniccall_method, &dbenv_class, "handle_panic",
	    "(L" DB_PKG "DatabaseException;)V" },
	{ &rep_transport_method, &dbenv_class, "handle_rep_transport",
	    "(L" DB_PKG "DatabaseEntry;L" DB_PKG "DatabaseEntry;L"
	    DB_PKG "LogSequenceNumber;II)I" },

	{ &append_recno_method, &db_class, "handle_append_recno",
	    "(L" DB_PKG "DatabaseEntry;I)V" },
	{ &bt_compare_method, &db_class, "handle_bt_compare",
	    "([B[B)I" },
	{ &bt_prefix_method, &db_class, "handle_bt_prefix",
	    "(L" DB_PKG "DatabaseEntry;L" DB_PKG "DatabaseEntry;)I" },
	{ &db_feedback_method, &db_class, "handle_db_feedback", "(II)V" },
	{ &dup_compare_method, &db_class, "handle_dup_compare",
	    "([B[B)I" },
	{ &h_hash_method, &db_class, "handle_h_hash", "([BI)I" },
	{ &seckey_create_method, &db_class, "handle_seckey_create",
	    "(L" DB_PKG "DatabaseEntry;L" DB_PKG "DatabaseEntry;L"
	    DB_PKG "DatabaseEntry;)I" },

	{ &outputstream_write_method, &outputstream_class, "write", "([BII)V" }
};

#define	NELEM(x) (sizeof (x) / sizeof (x[0]))

JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_initialize(
    JNIEnv *jenv, jclass clazz)
{
	jclass cl;
	unsigned int i, j;

	COMPQUIET(clazz, NULL);

	if ((*jenv)->GetJavaVM(jenv, &javavm) != 0) {
		__db_errx(NULL, "Cannot get Java VM");
		return;
	}

	for (i = 0; i < NELEM(all_classes); i++) {
		cl = (*jenv)->FindClass(jenv, all_classes[i].name);
		if (cl == NULL) {
			fprintf(stderr,
			    "Failed to load class %s - check CLASSPATH\n",
			    all_classes[i].name);
			return;
		}

		/*
		 * Wrap classes in GlobalRefs so we keep the reference between
		 * calls.
		 */
		*all_classes[i].cl = (jclass)(*jenv)->NewGlobalRef(jenv, cl);

		if (*all_classes[i].cl == NULL) {
			fprintf(stderr,
			    "Failed to create a global reference for %s\n",
			    all_classes[i].name);
			return;
		}
	}

	/* Get field IDs */
	for (i = 0; i < NELEM(all_fields); i++) {
		*all_fields[i].fid = (*jenv)->GetFieldID(jenv,
		    *all_fields[i].cl, all_fields[i].name, all_fields[i].sig);

		if (*all_fields[i].fid == NULL) {
			fprintf(stderr,
			    "Failed to look up field %s with sig %s\n",
			    all_fields[i].name, all_fields[i].sig);
			return;
		}
	}

	/* Get method IDs */
	for (i = 0; i < NELEM(all_methods); i++) {
		*all_methods[i].mid = (*jenv)->GetMethodID(jenv,
		    *all_methods[i].cl, all_methods[i].name,
		    all_methods[i].sig);

		if (*all_methods[i].mid == NULL) {
			for (j = 0; j < NELEM(all_classes); j++)
				if (all_methods[i].cl == all_classes[j].cl)
					break;
			fprintf(stderr,
			    "Failed to look up method %s.%s with sig %s\n",
			    all_classes[j].name, all_methods[i].name,
			    all_methods[i].sig);
			return;
		}
	}
}

static JNIEnv *__dbj_get_jnienv(void)
{
	/*
	 * Note: Different versions of the JNI disagree on the signature for
	 * AttachCurrentThread.  The most recent documentation seems to say
	 * that (JNIEnv **) is correct, but newer JNIs seem to use (void **),
	 * oddly enough.
	 */
#ifdef JNI_VERSION_1_2
	void *jenv = 0;
#else
	JNIEnv *jenv = 0;
#endif

	/*
	 * This should always succeed, as we are called via some Java activity.
	 * I think therefore I am (a thread).
	 */
	if ((*javavm)->AttachCurrentThread(javavm, &jenv, 0) != 0)
		return (0);

	return ((JNIEnv *)jenv);
}

static jobject __dbj_wrap_DB_LSN(JNIEnv *jenv, DB_LSN *lsn)
{
	return (*jenv)->NewObject(jenv, dblsn_class, dblsn_construct,
	    lsn->file, lsn->offset);
}


/*
 * Macros to find the Java DbEnv object for methods in various classes.
 * Note that "arg1" is from the code SWIG generates for the "this"/"self".
 */
#define	JDBENV (arg1 ? (jobject)DB_ENV_INTERNAL(arg1) : NULL)
#define	DB2JDBENV ((jobject)DB_ENV_INTERNAL(arg1->dbenv))
#define	DBC2JDBENV ((jobject)DB_ENV_INTERNAL(arg1->dbp->dbenv))
#define	TXN2JDBENV ((jobject)DB_ENV_INTERNAL(arg1->mgrp->dbenv))


static jthrowable __dbj_get_except(JNIEnv *jenv,
    int err, const char *msg, jobject obj, jobject jdbenv) {
	jobject jmsg;

	if (msg == NULL)
		msg = db_strerror(err);

	jmsg = (*jenv)->NewStringUTF(jenv, msg);

	switch (err) {
	case EINVAL:
		return (jthrowable)(*jenv)->NewObject(jenv,
		    illegalargex_class, illegalargex_construct, jmsg);

	case ENOENT:
		return (jthrowable)(*jenv)->NewObject(jenv,
		    filenotfoundex_class, filenotfoundex_construct, jmsg);

	case ENOMEM:
		return (jthrowable)(*jenv)->NewObject(jenv,
		    outofmemerr_class, outofmemerr_construct, jmsg);

	case DB_BUFFER_SMALL:
		return (jthrowable)(*jenv)->NewObject(jenv, memex_class,
		    memex_construct, jmsg, obj, err, jdbenv);

	case DB_REP_DUPMASTER:
		return (jthrowable)(*jenv)->NewObject(jenv,
		    repdupmasterex_class, repdupmasterex_construct,
		    jmsg, err, jdbenv);

	case DB_REP_HANDLE_DEAD:
		return (jthrowable)(*jenv)->NewObject(jenv,
		    rephandledeadex_class, rephandledeadex_construct,
		    jmsg, err, jdbenv);

	case DB_REP_HOLDELECTION:
		return (jthrowable)(*jenv)->NewObject(jenv,
		    repholdelectionex_class, repholdelectionex_construct,
		    jmsg, err, jdbenv);

	case DB_REP_JOIN_FAILURE:
		return (jthrowable)(*jenv)->NewObject(jenv,
		    repjoinfailex_class, repjoinfailex_construct,
		    jmsg, err, jdbenv);

	case DB_REP_LOCKOUT:
		return (jthrowable)(*jenv)->NewObject(jenv,
		    replockoutex_class, replockoutex_construct,
		    jmsg, err, jdbenv);

	case DB_REP_UNAVAIL:
		return (jthrowable)(*jenv)->NewObject(jenv,
		    repunavailex_class, repunavailex_construct,
		    jmsg, err, jdbenv);

	case DB_RUNRECOVERY:
		return (jthrowable)(*jenv)->NewObject(jenv, runrecex_class,
		    runrecex_construct, jmsg, err, jdbenv);

	case DB_LOCK_DEADLOCK:
		return (jthrowable)(*jenv)->NewObject(jenv, deadex_class,
		    deadex_construct, jmsg, err, jdbenv);

	case DB_LOCK_NOTGRANTED:
		return (jthrowable)(*jenv)->NewObject(jenv, lockex_class,
		    lockex_construct, jmsg, err, 0, NULL, NULL, 0, jdbenv);

	case DB_VERSION_MISMATCH:
		return (jthrowable)(*jenv)->NewObject(jenv, versionex_class,
		    versionex_construct, jmsg, err, jdbenv);

	default:
		return (jthrowable)(*jenv)->NewObject(jenv, dbex_class,
		    dbex_construct, jmsg, err, jdbenv);
	}
}

static int __dbj_throw(JNIEnv *jenv,
    int err, const char *msg, jobject obj, jobject jdbenv)
{
	jthrowable t;

	/* If an exception is pending, ignore requests to throw a new one. */
	if ((*jenv)->ExceptionOccurred(jenv) == NULL) {
		t = __dbj_get_except(jenv, err, msg, obj, jdbenv);
		if (t == NULL) {
			/*
			 * This is a problem - something went wrong creating an
			 * exception.  We have to assume there is an exception
			 * created by the JVM that is pending as a result
			 * (e.g., OutOfMemoryError), but we don't want to lose
			 * this error, so we just call __db_errx here.
			 */
			if (msg == NULL)
				msg = db_strerror(err);

			 __db_errx(NULL, "Couldn't create exception for: '%s'",
			     msg);
		} else
			(*jenv)->Throw(jenv, t);
	}

	return (err);
}


typedef struct __dbt_locked {
	JNIEnv *jenv;
	jobject jdbt;
	DBT dbt;
	jobject jdata_nio;
	jbyteArray jarr;
	jint offset;
	int reuse;
	u_int32_t orig_size;
	jsize array_len;
} DBT_LOCKED;

static int __dbj_dbt_memcopy(DBT *dbt, u_int32_t offset, void *buf, u_int32_t size, u_int32_t flags) {
	DBT_LOCKED *ldbt = dbt->app_data;
	JNIEnv *jenv = ldbt->jenv;

	if (size == 0)
		return (0);
	else if (!F_ISSET(dbt, DB_DBT_USERCOPY)) {
		/*
		  * For simplicity, the Java API calls this function directly,
		  * so it needs to work with regular DBTs.
		  */
		switch (flags) {
		case DB_USERCOPY_GETDATA:
			memcpy(buf, (u_int8_t *)dbt->data + offset, size);
			return (0);
		case DB_USERCOPY_SETDATA:
			memcpy((u_int8_t *)dbt->data + offset, buf, size);
			return (0);
		default:
			return (EINVAL);
		}
	}

	switch (flags) {
	case DB_USERCOPY_GETDATA:
		(*jenv)->GetByteArrayRegion(jenv, ldbt->jarr, ldbt->offset +
					    offset, size, buf);
		break;
	case DB_USERCOPY_SETDATA:
		/*
		 * Check whether this is the first time through the callback by relying
		 * on the offset being zero.
		 */
		if (offset == 0 && (!ldbt->reuse ||
		    (jsize)(ldbt->offset + dbt->size) > ldbt->array_len)) {
			if (ldbt->jarr != NULL)
				(*jenv)->DeleteLocalRef(jenv, ldbt->jarr);
			ldbt->jarr = (*jenv)->NewByteArray(jenv, (jsize)dbt->size);
			if (ldbt->jarr == NULL)
				return (ENOMEM);
			(*jenv)->SetObjectField(jenv, ldbt->jdbt, dbt_data_fid, ldbt->jarr);
			/* We've allocated a new array, start from the beginning. */
			ldbt->offset = 0;
		}
		(*jenv)->SetByteArrayRegion(jenv, ldbt->jarr, ldbt->offset +
					    offset, size, buf);
		break;
	default:
		return (EINVAL);
	}
	return ((*jenv)->ExceptionOccurred(jenv) ? EINVAL : 0);
}

static void __dbj_dbt_copyout(
    JNIEnv *jenv, const DBT *dbt, jbyteArray *jarr, jobject jdbt)
{
	jbyteArray newarr = (*jenv)->NewByteArray(jenv, (jsize)dbt->size);
	if (newarr == NULL)
		return; /* An exception is pending */
	(*jenv)->SetByteArrayRegion(jenv, newarr, 0, (jsize)dbt->size,
	    (jbyte *)dbt->data);
	(*jenv)->SetObjectField(jenv, jdbt, dbt_data_fid, newarr);
	(*jenv)->SetIntField(jenv, jdbt, dbt_offset_fid, 0);
	(*jenv)->SetIntField(jenv, jdbt, dbt_size_fid, (jint)dbt->size);
	if (jarr != NULL)
		*jarr = newarr;
	else
		(*jenv)->DeleteLocalRef(jenv, newarr);
}

static int __dbj_dbt_copyin(
    JNIEnv *jenv, DBT_LOCKED *ldbt, DBT **dbtp, jobject jdbt, int allow_null)
{
	DBT *dbt;
	jlong capacity;

	memset(ldbt, 0, sizeof (*ldbt));
	ldbt->jenv = jenv;
	ldbt->jdbt = jdbt;

	if (jdbt == NULL) {
		if (allow_null) {
			*dbtp = NULL;
			return (0);
		} else {
			return (__dbj_throw(jenv, EINVAL,
			    "DatabaseEntry must not be null", NULL, NULL));
		}
	}

	dbt = &ldbt->dbt;
	if (dbtp != NULL)
		*dbtp = dbt;

	ldbt->jdata_nio = (*jenv)->GetObjectField(jenv, jdbt, dbt_data_nio_fid);
	if (ldbt->jdata_nio != NULL)
		F_SET(dbt, DB_DBT_USERMEM);
	else
		ldbt->jarr = (jbyteArray)(*jenv)->GetObjectField(jenv, jdbt, dbt_data_fid);
	ldbt->offset = (*jenv)->GetIntField(jenv, jdbt, dbt_offset_fid);
	dbt->size = (*jenv)->GetIntField(jenv, jdbt, dbt_size_fid);
	ldbt->orig_size = dbt->size;
	dbt->flags = (*jenv)->GetIntField(jenv, jdbt, dbt_flags_fid);

	if (F_ISSET(dbt, DB_DBT_USERMEM))
		dbt->ulen = (*jenv)->GetIntField(jenv, jdbt, dbt_ulen_fid);
	if (F_ISSET(dbt, DB_DBT_PARTIAL)) {
		dbt->dlen = (*jenv)->GetIntField(jenv, jdbt, dbt_dlen_fid);
		dbt->doff = (*jenv)->GetIntField(jenv, jdbt, dbt_doff_fid);

		if ((jint)dbt->doff < 0)
			return (__dbj_throw(jenv, EINVAL, "DatabaseEntry doff illegal",
			    NULL, NULL));
	}

	/*
	 * We don't support DB_DBT_REALLOC - map anything that's not USERMEM to
	 * MALLOC.
	 */
	if (!F_ISSET(dbt, DB_DBT_USERMEM)) {
		ldbt->reuse = !F_ISSET(dbt, DB_DBT_MALLOC);
		F_CLR(dbt, DB_DBT_MALLOC | DB_DBT_REALLOC);
	}

	/* Verify parameters before allocating or locking data. */
	if (ldbt->jdata_nio != NULL) {
		capacity = (*jenv)->GetDirectBufferCapacity(jenv,
				ldbt->jdata_nio);
		if (capacity > (jlong)UINT32_MAX)
			return (__dbj_throw(jenv, EINVAL,
			    "DirectBuffer may not be larger than 4GB",
			    NULL, NULL));
		ldbt->array_len = (u_int32_t)capacity;
	} else if (ldbt->jarr == NULL) {
		/*
		 * Some code makes the assumption that if a DBT's size or ulen
		 * is non-zero, there is data to copy from dbt->data.
		 *
		 * Clean up the dbt fields so we don't run into trouble.
		 * (Note that doff, dlen, and flags all may contain
		 * meaningful values.)
		 */
		dbt->data = NULL;
		ldbt->array_len = ldbt->offset = dbt->size = dbt->ulen = 0;
	} else
		ldbt->array_len = (*jenv)->GetArrayLength(jenv, ldbt->jarr);

	if (F_ISSET(dbt, DB_DBT_USERMEM)) {
		if (ldbt->offset < 0)
			return (__dbj_throw(jenv, EINVAL,
			    "offset cannot be negative",
			    NULL, NULL));
		if (dbt->size > dbt->ulen)
			return (__dbj_throw(jenv, EINVAL,
			    "size must be less than or equal to ulen",
			    NULL, NULL));
		if ((jsize)(ldbt->offset + dbt->ulen) > ldbt->array_len)
			return (__dbj_throw(jenv, EINVAL,
			    "offset + ulen greater than array length",
			    NULL, NULL));
	}

	if (ldbt->jdata_nio) {
		dbt->data = (*jenv)->GetDirectBufferAddress(jenv,
				ldbt->jdata_nio);
		dbt->data = (u_int8_t *)dbt->data + ldbt->offset;
	} else if (F_ISSET(dbt, DB_DBT_USERMEM)) {
		if (ldbt->jarr != NULL &&
		    (dbt->data = (*jenv)->GetByteArrayElements(jenv,
		    ldbt->jarr, NULL)) == NULL)
			return (EINVAL); /* an exception will be pending */
		dbt->data = (u_int8_t *)dbt->data + ldbt->offset;
	} else
		F_SET(dbt, DB_DBT_USERCOPY);
	dbt->app_data = ldbt;

	return (0);
}

static void __dbj_dbt_release(
    JNIEnv *jenv, jobject jdbt, DBT *dbt, DBT_LOCKED *ldbt) {
	jthrowable t;

	if (dbt == NULL)
		return;

	if (dbt->size != ldbt->orig_size)
		(*jenv)->SetIntField(jenv, jdbt, dbt_size_fid, (jint)dbt->size);

	if (F_ISSET(dbt, DB_DBT_USERMEM)) {
		if (ldbt->jarr != NULL)
			(*jenv)->ReleaseByteArrayElements(jenv, ldbt->jarr,
			    (jbyte *)dbt->data - ldbt->offset, 0);

		if (dbt->size > dbt->ulen &&
		    (t = (*jenv)->ExceptionOccurred(jenv)) != NULL &&
		    (*jenv)->IsInstanceOf(jenv, t, memex_class)) {
			(*jenv)->CallNonvirtualVoidMethod(jenv, t, memex_class,
			    memex_update_method, jdbt);
			/*
			 * We have to rethrow the exception because calling
			 * into Java clears it.
			 */
			(*jenv)->Throw(jenv, t);
		}
	}
}


struct __dbj_verify_data {
	JNIEnv *jenv;
	jobject streamobj;
	jbyteArray bytes;
	int nbytes;
};

static int __dbj_verify_callback(void *handle, const void *str_arg) {
	char *str;
	struct __dbj_verify_data *vd;
	int len;
	JNIEnv *jenv;

	str = (char *)str_arg;
	vd = (struct __dbj_verify_data *)handle;
	jenv = vd->jenv;
	len = strlen(str) + 1;
	if (len > vd->nbytes) {
		vd->nbytes = len;
		if (vd->bytes != NULL)
			(*jenv)->DeleteLocalRef(jenv, vd->bytes);
		if ((vd->bytes = (*jenv)->NewByteArray(jenv, (jsize)len))
		    == NULL)
			return (ENOMEM);
	}

	if (vd->bytes != NULL) {
		(*jenv)->SetByteArrayRegion(jenv, vd->bytes, 0, (jsize)len,
		    (jbyte*)str);
		(*jenv)->CallVoidMethod(jenv, vd->streamobj,
		    outputstream_write_method, vd->bytes, 0, len - 1);
	}

	if ((*jenv)->ExceptionOccurred(jenv) != NULL)
		return (EIO);

	return (0);
}


JNIEXPORT void JNICALL
Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1lock_1vec(JNIEnv *jenv,
    jclass jcls, jlong jdbenvp, jint locker, jint flags, jobjectArray list,
    jint offset, jint count) {
	DB_ENV *dbenv;
	DB_LOCKREQ *lockreq;
	DB_LOCKREQ *prereq;	/* preprocessed requests */
	DB_LOCKREQ *failedreq;
	DB_LOCK *lockp;
	DBT_LOCKED *locked_dbts;
	DBT *obj;
	int err, alloc_err, i;
	size_t bytesize, ldbtsize;
	jobject jlockreq;
	db_lockop_t op;
	jobject jobj, jlock, jdbenv;
	jlong jlockp;
	int completed;

	COMPQUIET(jcls, NULL);
	dbenv = *(DB_ENV **)(void *)&jdbenvp;
	jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);

	if (dbenv == NULL) {
		__dbj_throw(jenv, EINVAL, "null object", NULL, jdbenv);
		return;
	}

	if ((*jenv)->GetArrayLength(jenv, list) < offset + count) {
		__dbj_throw(jenv, EINVAL,
		    "DbEnv.lock_vec array not large enough", NULL, jdbenv);
		goto out0;
	}

	bytesize = sizeof(DB_LOCKREQ) * count;
	if ((err = __os_malloc(dbenv, bytesize, &lockreq)) != 0) {
		__dbj_throw(jenv, err, NULL, NULL, jdbenv);
		goto out0;
	}
	memset(lockreq, 0, bytesize);

	ldbtsize = sizeof(DBT_LOCKED) * count;
	if ((err = __os_malloc(dbenv, ldbtsize, &locked_dbts)) != 0) {
		__dbj_throw(jenv, err, NULL, NULL, jdbenv);
		goto out1;
	}
	memset(locked_dbts, 0, ldbtsize);
	prereq = &lockreq[0];

	/* fill in the lockreq array */
	for (i = 0, prereq = &lockreq[0]; i < count; i++, prereq++) {
		jlockreq = (*jenv)->GetObjectArrayElement(jenv, list,
		    offset + i);
		if (jlockreq == NULL) {
			__dbj_throw(jenv, EINVAL,
			    "DbEnv.lock_vec list entry is null", NULL, jdbenv);
			goto out2;
		}
		op = (*jenv)->GetIntField(jenv, jlockreq, lockreq_op_fid);
		prereq->op = op;

		switch (op) {
		case DB_LOCK_GET_TIMEOUT:
			/* Needed: mode, timeout, obj.  Returned: lock. */
			prereq->op = (*jenv)->GetIntField(jenv, jlockreq,
			    lockreq_timeout_fid);
			/* FALLTHROUGH */
		case DB_LOCK_GET:
			/* Needed: mode, obj.  Returned: lock. */
			prereq->mode = (*jenv)->GetIntField(jenv, jlockreq,
			    lockreq_modeflag_fid);
			jobj = (*jenv)->GetObjectField(jenv, jlockreq,
			    lockreq_obj_fid);
			if ((err = __dbj_dbt_copyin(jenv,
			    &locked_dbts[i], &obj, jobj, 0)) != 0 ||
			    (err =
			    __os_umalloc(dbenv, obj->size, &obj->data)) != 0 ||
			    (err = __dbj_dbt_memcopy(obj, 0,
				obj->data, obj->size, DB_USERCOPY_GETDATA)) != 0)
				goto out2;
			prereq->obj = obj;
			break;
		case DB_LOCK_PUT:
			/* Needed: lock.  Ignored: mode, obj. */
			jlock = (*jenv)->GetObjectField(jenv, jlockreq,
				lockreq_lock_fid);
			if (jlock == NULL ||
			    (jlockp = (*jenv)->GetLongField(jenv, jlock,
			    lock_cptr_fid)) == 0L) {
				__dbj_throw(jenv, EINVAL,
				    "LockRequest lock field is NULL", NULL,
				    jdbenv);
				goto out2;
			}
			lockp = *(DB_LOCK **)(void *)&jlockp;
			prereq->lock = *lockp;
			break;
		case DB_LOCK_PUT_ALL:
		case DB_LOCK_TIMEOUT:
			/* Needed: (none).  Ignored: lock, mode, obj. */
			break;
		case DB_LOCK_PUT_OBJ:
			/* Needed: obj.  Ignored: lock, mode. */
			jobj = (*jenv)->GetObjectField(jenv, jlockreq,
			    lockreq_obj_fid);
			if ((err = __dbj_dbt_copyin(jenv,
			    &locked_dbts[i], &obj, jobj, 0)) != 0 ||
			    (err =
			    __os_umalloc(dbenv, obj->size, &obj->data)) != 0 ||
			    (err = __dbj_dbt_memcopy(obj, 0,
				obj->data, obj->size, DB_USERCOPY_GETDATA)) != 0)
				goto out2;
			prereq->obj = obj;
			break;
		default:
			__dbj_throw(jenv, EINVAL,
			    "DbEnv.lock_vec bad op value", NULL, jdbenv);
			goto out2;
		}
	}

	err = dbenv->lock_vec(dbenv, (u_int32_t)locker, (u_int32_t)flags,
	    lockreq, count, &failedreq);
	if (err == 0)
		completed = count;
	else
		completed = failedreq - lockreq;

	/* do post processing for any and all requests that completed */
	for (i = 0; i < completed; i++) {
		op = lockreq[i].op;
		if (op == DB_LOCK_PUT) {
			/*
			 * After a successful put, the DbLock can no longer be
			 * used, so we release the storage related to it.
			 */
			jlockreq = (*jenv)->GetObjectArrayElement(jenv,
			    list, i + offset);
			jlock = (*jenv)->GetObjectField(jenv, jlockreq,
			    lockreq_lock_fid);
			jlockp = (*jenv)->GetLongField(jenv, jlock,
			    lock_cptr_fid);
			lockp = *(DB_LOCK **)(void *)&jlockp;
			__os_free(NULL, lockp);
			(*jenv)->SetLongField(jenv, jlock, lock_cptr_fid,
			    (jlong)0);
		}
		else if (op == DB_LOCK_GET) {
			/*
			 * Store the lock that was obtained.  We need to create
			 * storage for it since the lockreq array only exists
			 * during this method call.
			 */
			if ((alloc_err =
			    __os_malloc(dbenv, sizeof(DB_LOCK), &lockp)) != 0) {
				__dbj_throw(jenv, alloc_err, NULL, NULL,
				    jdbenv);
				goto out2;
			}

			*lockp = lockreq[i].lock;
			*(DB_LOCK **)(void *)&jlockp = lockp;

			jlockreq = (*jenv)->GetObjectArrayElement(jenv,
			    list, i + offset);
			jlock = (*jenv)->NewObject(jenv, lock_class,
			    lock_construct, jlockp, JNI_TRUE);
			if (jlock == NULL)
				goto out2; /* An exception is pending */
			(*jenv)->SetLongField(jenv, jlock, lock_cptr_fid,
			    jlockp);
			(*jenv)->SetObjectField(jenv, jlockreq,
			    lockreq_lock_fid, jlock);
		}
	}

	/* If one of the locks was not granted, build the exception now. */
	if (err == DB_LOCK_NOTGRANTED && i < count) {
		jlockreq = (*jenv)->GetObjectArrayElement(jenv, list,
		    i + offset);
		jobj = (*jenv)->GetObjectField(jenv, jlockreq,
		    lockreq_obj_fid);
		jlock = (*jenv)->GetObjectField(jenv, jlockreq,
		    lockreq_lock_fid);
		(*jenv)->Throw(jenv,
		    (*jenv)->NewObject(jenv, lockex_class, lockex_construct,
		    (*jenv)->NewStringUTF(jenv, "DbEnv.lock_vec incomplete"),
		    lockreq[i].op, lockreq[i].mode, jobj, jlock, i, jdbenv));
	} else if (err != 0)
		__dbj_throw(jenv, err, NULL, NULL, jdbenv);

out2:	__os_free(dbenv, locked_dbts);
out1:	for (i = 0, prereq = &lockreq[0]; i < count; i++, prereq++)
		if ((prereq->op == DB_LOCK_GET || prereq->op == DB_LOCK_PUT) &&
		    prereq->obj->data != NULL)
			__os_ufree(dbenv, prereq->obj->data);
	__os_free(dbenv, lockreq);
out0:	return;
}


/*
 * These macros are used by code generated by the s_java script.
 */
#define JAVADB_STAT_INT(jenv, jobj, fid, statp, name)			\
		(*jenv)->SetIntField(jenv, jobj, fid, (jint)statp->name)

#define JAVADB_STAT_STRING(jenv, jobj, fid, statp, name)		\
		(*jenv)->SetObjectField(jenv, jobj, fid,		\
		    (*jenv)->NewStringUTF(jenv, statp->name))

#define JAVADB_STAT_LSN(jenv, jobj, fid, statp, name)			\
		(*jenv)->SetObjectField(jenv, jobj, fid,		\
		    __dbj_wrap_DB_LSN(jenv, &statp->name))

#define JAVADB_STAT_LONG(jenv, jobj, fid, statp, name)			\
		(*jenv)->SetLongField(jenv, jobj, fid,			\
		    (jlong)statp->name)

#define JAVADB_STAT_XID(jenv, jobj, fid, statp, name) {			\
	jobject jarr =							\
	    (*jenv)->NewByteArray(jenv, (jsize)DB_XIDDATASIZE);		\
	(*jenv)->SetByteArrayRegion(jenv, jarr,				\
	    0, (jsize)DB_XIDDATASIZE, (jbyte *)statp->name);		\
	(*jenv)->SetObjectField(jenv, jobj, fid, jarr);			\
	}

/*
 * We build the active list separately.
 */
#define JAVADB_STAT_ACTIVE(jenv, cl, jobj, statp, name) \
	do {} while(0)

#include "java_stat_auto.c"


static void __dbj_error(const DB_ENV *dbenv,
    const char *prefix, const char *msg)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);

	COMPQUIET(prefix, NULL);

	if (jdbenv != NULL)
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv, dbenv_class,
		    errcall_method, (*jenv)->NewStringUTF(jenv, msg));
}

static void __dbj_env_feedback(DB_ENV *dbenv, int opcode, int percent)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);

	if (jdbenv != NULL)
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv, dbenv_class,
		    env_feedback_method, opcode, percent);
}

static void __dbj_message(const DB_ENV *dbenv, const char *msg)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);

	if (jdbenv != NULL)
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv, dbenv_class,
		    msgcall_method, (*jenv)->NewStringUTF(jenv, msg));
}

static void __dbj_panic(DB_ENV *dbenv, int err)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);

	if (jdbenv != NULL)
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv, dbenv_class,
		    paniccall_method,
		    __dbj_get_except(jenv, err, NULL, NULL, jdbenv));
}

static int __dbj_app_dispatch(DB_ENV *dbenv,
    DBT *dbt, DB_LSN *lsn, db_recops recops)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);
	jobject jdbt, jlsn;
	jbyteArray jdbtarr;
	int ret;

	if (jdbenv == NULL)
		return (EINVAL);

	jdbt = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	__dbj_dbt_copyout(jenv, dbt, &jdbtarr, jdbt);
	if (jdbt == NULL)
		return (ENOMEM); /* An exception is pending */

	jlsn = (lsn == NULL) ? NULL : __dbj_wrap_DB_LSN(jenv, lsn);

	ret = (*jenv)->CallNonvirtualIntMethod(jenv, jdbenv, dbenv_class,
	    app_dispatch_method, jdbt, jlsn, recops);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
	}

	(*jenv)->DeleteLocalRef(jenv, jdbtarr);
	(*jenv)->DeleteLocalRef(jenv, jdbt);
	if (jlsn != NULL)
		(*jenv)->DeleteLocalRef(jenv, jlsn);

	return (ret);
}

static void __dbj_event_notify(DB_ENV *dbenv, u_int32_t event_id, void * info)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);
	int ret;

	COMPQUIET(info, NULL);

	if(jdbenv == NULL)
		return ;

	ret = (*jenv)->CallNonvirtualIntMethod(jenv, jdbenv, dbenv_class,
	    event_notify_method, event_id);

	if((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
	}
	return ;
}

static int __dbj_rep_transport(DB_ENV *dbenv,
    const DBT *control, const DBT *rec, const DB_LSN *lsn, int envid,
    u_int32_t flags)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);
	jobject jcontrol, jrec, jlsn;
	jbyteArray jcontrolarr, jrecarr;
	int ret;

	if (jdbenv == NULL)
		return (EINVAL);

	jcontrol = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	jrec = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	if (jcontrol == NULL || jrec == NULL)
		return (ENOMEM); /* An exception is pending */

	__dbj_dbt_copyout(jenv, control, &jcontrolarr, jcontrol);
	__dbj_dbt_copyout(jenv, rec, &jrecarr, jrec);
	jlsn = (lsn == NULL) ? NULL : __dbj_wrap_DB_LSN(jenv, (DB_LSN *)lsn);

	if (jcontrolarr == NULL || jrecarr == NULL)
		return (ENOMEM); /* An exception is pending */

	ret = (*jenv)->CallNonvirtualIntMethod(jenv, jdbenv, dbenv_class,
	    rep_transport_method, jcontrol, jrec, jlsn, envid, flags);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
	}

	(*jenv)->DeleteLocalRef(jenv, jrecarr);
	(*jenv)->DeleteLocalRef(jenv, jcontrolarr);
	(*jenv)->DeleteLocalRef(jenv, jrec);
	(*jenv)->DeleteLocalRef(jenv, jcontrol);
	if (jlsn != NULL)
		(*jenv)->DeleteLocalRef(jenv, jlsn);

	return (ret);
}

static int __dbj_seckey_create(DB *db,
    const DBT *key, const DBT *data, DBT *result)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdb = (jobject)DB_INTERNAL(db);
	jobject jkey, jdata, jresult;
	jbyteArray jkeyarr, jdataarr;
	DBT_LOCKED lresult;
	int ret;

	if (jdb == NULL)
		return (EINVAL);

	jkey = (key->app_data != NULL) ?
	    ((DBT_LOCKED *)key->app_data)->jdbt :
	    (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	jdata = (data->app_data != NULL) ?
	    ((DBT_LOCKED *)data->app_data)->jdbt :
	    (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	jresult = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	if (jkey == NULL || jdata == NULL || jresult == NULL)
		return (ENOMEM); /* An exception is pending */

	if (key->app_data == NULL) {
		__dbj_dbt_copyout(jenv, key, &jkeyarr, jkey);
		if (jkeyarr == NULL)
			return (ENOMEM); /* An exception is pending */
	}
	if (data->app_data == NULL) {
		__dbj_dbt_copyout(jenv, data, &jdataarr, jdata);
		if (jdataarr == NULL)
			return (ENOMEM); /* An exception is pending */
	}

	ret = (int)(*jenv)->CallNonvirtualIntMethod(jenv, jdb, db_class,
	    seckey_create_method, jkey, jdata, jresult);

	if (ret != 0)
		goto err;

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
		goto err;
	}

	if ((ret = __dbj_dbt_copyin(jenv, &lresult, NULL, jresult, 0)) != 0)
		goto err;

	if (lresult.dbt.size != 0) {
		/* If there's data, we need to take a copy of it.  */
		memset(result, 0, sizeof (DBT));
		result->size = lresult.dbt.size;
		if ((ret =
		    __os_umalloc(NULL, result->size, &result->data)) != 0)
			goto err;
		if ((ret = __dbj_dbt_memcopy(&lresult.dbt, 0,
		    result->data, result->size,
		    DB_USERCOPY_GETDATA)) != 0)
			goto err;
		__dbj_dbt_release(jenv, jresult, &lresult.dbt, &lresult);
		(*jenv)->DeleteLocalRef(jenv, lresult.jarr);
		F_SET(result, DB_DBT_APPMALLOC);
	}

err:	if (key->app_data == NULL) {
		(*jenv)->DeleteLocalRef(jenv, jkeyarr);
		(*jenv)->DeleteLocalRef(jenv, jkey);
	}
	if (data->app_data == NULL) {
		(*jenv)->DeleteLocalRef(jenv, jdataarr);
		(*jenv)->DeleteLocalRef(jenv, jdata);
	}
	(*jenv)->DeleteLocalRef(jenv, jresult);

	return (ret);
}

static int __dbj_append_recno(DB *db, DBT *dbt, db_recno_t recno)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdb = (jobject)DB_INTERNAL(db);
	jobject jdbt;
	DBT_LOCKED lresult;
	jbyteArray jdbtarr;
	int ret;

	if (jdb == NULL)
		return (EINVAL);

	/*
	 * The dbt we're passed will be from the application, but we can't
	 * just reuse it, since we will have already taken a copy of the data.
	 * Make a new DatabaseEntry object here for the callback.
	 */
	jdbt = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	if (jdbt == NULL)
		return (ENOMEM); /* An exception is pending */

	__dbj_dbt_copyout(jenv, dbt, &jdbtarr, jdbt);
	if (jdbtarr == NULL)
		return (ENOMEM); /* An exception is pending */

	ret = 0;
	(*jenv)->CallNonvirtualVoidMethod(jenv, jdb, db_class,
	    append_recno_method, jdbt, recno);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		return (EINVAL);
	}

	ret = __dbj_dbt_copyin(jenv, &lresult, NULL, jdbt, 0);
	memset(dbt, 0, sizeof (DBT));

	if (ret == 0 && lresult.dbt.size != 0) {
		/* If there's data, we need to take a copy of it.  */
		dbt->size = lresult.dbt.size;
		if ((ret =
		    __os_umalloc(NULL, dbt->size, &dbt->data)) != 0)
			goto err;
		if ((ret = __dbj_dbt_memcopy(&lresult.dbt, 0,
		    dbt->data, dbt->size,
		    DB_USERCOPY_GETDATA)) != 0)
			goto err;
		__dbj_dbt_release(jenv, jdbt, &lresult.dbt, &lresult);
		(*jenv)->DeleteLocalRef(jenv, lresult.jarr);
		F_SET(dbt, DB_DBT_APPMALLOC);
	}

err:	(*jenv)->DeleteLocalRef(jenv, jdbtarr);
	(*jenv)->DeleteLocalRef(jenv, jdbt);

	return (ret);
}

static int __dbj_bt_compare(DB *db, const DBT *dbt1, const DBT *dbt2)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdb = (jobject)DB_INTERNAL(db);
	jbyteArray jdbtarr1, jdbtarr2;
	int ret;

	if (jdb == NULL)
		return (EINVAL);

	if (dbt1->app_data != NULL)
		jdbtarr1 = ((DBT_LOCKED *)dbt1->app_data)->jarr;
	else {
		jdbtarr1 = (*jenv)->NewByteArray(jenv, (jsize)dbt1->size);
		if (jdbtarr1 == NULL)
			return (ENOMEM);
		(*jenv)->SetByteArrayRegion(jenv, jdbtarr1, 0,
		    (jsize)dbt1->size, (jbyte *)dbt1->data);
	}

	if (dbt2->app_data != NULL)
		jdbtarr2 = ((DBT_LOCKED *)dbt2->app_data)->jarr;
	else {
		jdbtarr2 = (*jenv)->NewByteArray(jenv, (jsize)dbt2->size);
		if (jdbtarr2 == NULL)
			return (ENOMEM);
		(*jenv)->SetByteArrayRegion(jenv, jdbtarr2, 0,
		    (jsize)dbt2->size, (jbyte *)dbt2->data);
	}

	ret = (int)(*jenv)->CallNonvirtualIntMethod(jenv, jdb, db_class,
	    bt_compare_method, jdbtarr1, jdbtarr2);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
	}

	if (dbt1->app_data == NULL)
		(*jenv)->DeleteLocalRef(jenv, jdbtarr1);
	if (dbt2->app_data == NULL)
		(*jenv)->DeleteLocalRef(jenv, jdbtarr2);

	return (ret);
}

static size_t __dbj_bt_prefix(DB *db, const DBT *dbt1, const DBT *dbt2)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdb = (jobject)DB_INTERNAL(db);
	jobject jdbt1, jdbt2;
	jbyteArray jdbtarr1, jdbtarr2;
	int ret;

	if (jdb == NULL)
		return (EINVAL);

	if (dbt1->app_data != NULL)
		jdbt1 = ((DBT_LOCKED *)dbt1->app_data)->jdbt;
	else {
		if ((jdbt1 = (*jenv)->NewObject(jenv, dbt_class, dbt_construct)) == NULL)
			return (ENOMEM); /* An exception is pending */
		__dbj_dbt_copyout(jenv, dbt1, &jdbtarr1, jdbt1);
		if (jdbtarr1 == NULL)
			return (ENOMEM); /* An exception is pending */
	}

	if (dbt2->app_data != NULL)
		jdbt2 = ((DBT_LOCKED *)dbt2->app_data)->jdbt;
	else {
		if ((jdbt2 = (*jenv)->NewObject(jenv, dbt_class, dbt_construct)) == NULL)
			return (ENOMEM); /* An exception is pending */
		__dbj_dbt_copyout(jenv, dbt2, &jdbtarr2, jdbt2);
		if (jdbtarr2 == NULL)
			return (ENOMEM); /* An exception is pending */
	}

	ret = (int)(*jenv)->CallNonvirtualIntMethod(jenv, jdb, db_class,
	    bt_prefix_method, jdbt1, jdbt2);

	if (dbt1->app_data == NULL) {
		(*jenv)->DeleteLocalRef(jenv, jdbtarr1);
		(*jenv)->DeleteLocalRef(jenv, jdbt1);
	}
	if (dbt2->app_data == NULL) {
		(*jenv)->DeleteLocalRef(jenv, jdbtarr2);
		(*jenv)->DeleteLocalRef(jenv, jdbt2);
	}

	return (ret);
}

static int __dbj_dup_compare(DB *db, const DBT *dbt1, const DBT *dbt2)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdb = (jobject)DB_INTERNAL(db);
	jbyteArray jdbtarr1, jdbtarr2;
	int ret;

	if (jdb == NULL)
		return (EINVAL);

	jdbtarr1 = (*jenv)->NewByteArray(jenv, (jsize)dbt1->size);
	if (jdbtarr1 == NULL)
		return (ENOMEM);
	(*jenv)->SetByteArrayRegion(jenv, jdbtarr1, 0, (jsize)dbt1->size,
	    (jbyte *)dbt1->data);

	jdbtarr2 = (*jenv)->NewByteArray(jenv, (jsize)dbt2->size);
	if (jdbtarr2 == NULL)
		return (ENOMEM);
	(*jenv)->SetByteArrayRegion(jenv, jdbtarr2, 0, (jsize)dbt2->size,
	    (jbyte *)dbt2->data);

	ret = (int)(*jenv)->CallNonvirtualIntMethod(jenv, jdb, db_class,
	    dup_compare_method, jdbtarr1, jdbtarr2);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
	}

	(*jenv)->DeleteLocalRef(jenv, jdbtarr2);
	(*jenv)->DeleteLocalRef(jenv, jdbtarr1);

	return (ret);
}

static void __dbj_db_feedback(DB *db, int opcode, int percent)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdb = (jobject)DB_INTERNAL(db);

	if (jdb != NULL)
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdb, db_class,
		    db_feedback_method, opcode, percent);
}

static u_int32_t __dbj_h_hash(DB *db, const void *data, u_int32_t len)
{
	JNIEnv *jenv = __dbj_get_jnienv();
	jobject jdb = (jobject)DB_INTERNAL(db);
	jbyteArray jarr = (*jenv)->NewByteArray(jenv, (jsize)len);
	int ret;

	if (jdb == NULL)
		return (EINVAL);

	if ((jarr = (*jenv)->NewByteArray(jenv, (jsize)len)) == NULL)
		return (ENOMEM); /* An exception is pending */

	(*jenv)->SetByteArrayRegion(jenv, jarr, 0, (jsize)len, (jbyte *)data);

	ret = (int)(*jenv)->CallNonvirtualIntMethod(jenv, jdb, db_class,
	    h_hash_method, jarr, len);

	(*jenv)->DeleteLocalRef(jenv, jarr);

	return (ret);
}


JNIEXPORT jlong JNICALL
Java_com_sleepycat_db_internal_db_1javaJNI_initDbEnvRef0(
    JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
	DB_ENV *self = *(DB_ENV **)(void *)&jarg1;
	jlong ret;
	COMPQUIET(jcls, NULL);

	DB_ENV_INTERNAL(self) = (void *)(*jenv)->NewGlobalRef(jenv, jarg2);
	*(jobject *)(void *)&ret = (jobject)DB_ENV_INTERNAL(self);
	return (ret);
}

JNIEXPORT jlong JNICALL
Java_com_sleepycat_db_internal_db_1javaJNI_initDbRef0(
    JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
	DB *self = *(DB **)(void *)&jarg1;
	jlong ret;
	COMPQUIET(jcls, NULL);

	DB_INTERNAL(self) = (void *)(*jenv)->NewGlobalRef(jenv, jarg2);
	*(jobject *)(void *)&ret = (jobject)DB_INTERNAL(self);
	return (ret);
}

JNIEXPORT void JNICALL
Java_com_sleepycat_db_internal_db_1javaJNI_deleteRef0(
    JNIEnv *jenv, jclass jcls, jlong jarg1) {
	jobject jref = *(jobject *)(void *)&jarg1;
	COMPQUIET(jcls, NULL);

	if (jref != 0L)
		(*jenv)->DeleteGlobalRef(jenv, jref);
}

JNIEXPORT jlong JNICALL
Java_com_sleepycat_db_internal_db_1javaJNI_getDbEnv0(
    JNIEnv *jenv, jclass jcls, jlong jarg1) {
	DB *self = *(DB **)(void *)&jarg1;
	jlong ret;

	COMPQUIET(jenv, NULL);
	COMPQUIET(jcls, NULL);

	*(DB_ENV **)(void *)&ret = self->dbenv;
	return (ret);
}

JNIEXPORT jboolean JNICALL
Java_com_sleepycat_db_internal_DbUtil_is_1big_1endian(
    JNIEnv *jenv, jclass clazz)
{
	COMPQUIET(jenv, NULL);
	COMPQUIET(clazz, NULL);

	return (__db_isbigendian() ? JNI_TRUE : JNI_FALSE);
}


typedef int db_ret_t;
typedef int int_bool;

struct __db_lk_conflicts {
	u_int8_t *lk_conflicts;
	int lk_modes;
};

struct __db_out_stream {
	void *handle;
	int (*callback) __P((void *, const void *));
};

struct __db_repmgr_sites {
	DB_REPMGR_SITE *sites;
	u_int32_t nsites;
};

#define	Db __db
#define	Dbc __dbc
#define	Dbt __db_dbt
#define	DbEnv __db_env
#define	DbLock __db_lock_u
#define	DbLogc __db_log_cursor
#define	DbLsn __db_lsn
#define	DbMpoolFile __db_mpoolfile
#define	DbSequence __db_sequence
#define	DbTxn __db_txn

/* Suppress a compilation warning for an unused symbol */
void *unused = SWIG_JavaThrowException;

SWIGINTERN struct Db *new_Db(DB_ENV *dbenv,u_int32_t flags){
		DB *self = NULL;
		errno = db_create(&self, dbenv, flags);
		if (errno == 0 && dbenv == NULL)
			self->dbenv->dbt_usercopy = __dbj_dbt_memcopy;
		return self;
	}
SWIGINTERN db_ret_t Db_associate(struct Db *self,DB_TXN *txnid,DB *secondary,int (*callback)(DB *,DBT const *,DBT const *,DBT *),u_int32_t flags){
		return self->associate(self, txnid, secondary, callback, flags);
	}
SWIGINTERN db_ret_t Db_compact(struct Db *self,DB_TXN *txnid,DBT *start,DBT *stop,DB_COMPACT *c_data,u_int32_t flags,DBT *end){
		return self->compact(self, txnid, start, stop, c_data, flags,
		    end);
	}
SWIGINTERN int Db_close(struct Db *self,u_int32_t flags){
		errno = self->close(self, flags);
		return errno;
	}
SWIGINTERN DBC *Db_cursor(struct Db *self,DB_TXN *txnid,u_int32_t flags){
		DBC *cursorp = NULL;
		errno = self->cursor(self, txnid, &cursorp, flags);
		return cursorp;
	}
SWIGINTERN int Db_del(struct Db *self,DB_TXN *txnid,DBT *key,u_int32_t flags){
		return self->del(self, txnid, key, flags);
	}
SWIGINTERN void Db_err(struct Db *self,int error,char const *message){
		self->err(self, error, message);
	}
SWIGINTERN void Db_errx(struct Db *self,char const *message){
		self->errx(self, message);
	}
SWIGINTERN int_bool Db_get_transactional(struct Db *self){
		return self->get_transactional(self);
	}
SWIGINTERN int Db_get(struct Db *self,DB_TXN *txnid,DBT *key,DBT *data,u_int32_t flags){
		return self->get(self, txnid, key, data, flags);
	}
SWIGINTERN int_bool Db_get_byteswapped(struct Db *self){
		int ret = 0;
		errno = self->get_byteswapped(self, &ret);
		return ret;
	}
SWIGINTERN jlong Db_get_cachesize(struct Db *self){
		u_int32_t gbytes = 0, bytes = 0;
		errno = self->get_cachesize(self, &gbytes, &bytes, NULL);
		return (jlong)gbytes * GIGABYTE + bytes;
	}
SWIGINTERN u_int32_t Db_get_cachesize_ncache(struct Db *self){
		int ret = 0;
		errno = self->get_cachesize(self, NULL, NULL, &ret);
		return ret;
	}
SWIGINTERN char const *Db_get_filename(struct Db *self){
		const char *ret = NULL;
		errno = self->get_dbname(self, &ret, NULL);
		return ret;
	}
SWIGINTERN char const *Db_get_dbname(struct Db *self){
		const char *ret = NULL;
		errno = self->get_dbname(self, NULL, &ret);
		return ret;
	}
SWIGINTERN u_int32_t Db_get_encrypt_flags(struct Db *self){
		u_int32_t ret = 0;
		CRYPTO_ONLY(errno = self->get_encrypt_flags(self, &ret))
		return ret;
	}
SWIGINTERN u_int32_t Db_get_flags(struct Db *self){
		u_int32_t ret = 0;
		errno = self->get_flags(self, &ret);
		return ret;
	}
SWIGINTERN int Db_get_lorder(struct Db *self){
		int ret = 0;
		errno = self->get_lorder(self, &ret);
		return ret;
	}
SWIGINTERN DB_MPOOLFILE *Db_get_mpf(struct Db *self){
		errno = 0;
		return self->get_mpf(self);
	}
SWIGINTERN u_int32_t Db_get_open_flags(struct Db *self){
		u_int32_t ret = 0;
		errno = self->get_open_flags(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t Db_get_pagesize(struct Db *self){
		u_int32_t ret = 0;
		errno = self->get_pagesize(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t Db_get_bt_minkey(struct Db *self){
		u_int32_t ret = 0;
		errno = self->get_bt_minkey(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t Db_get_h_ffactor(struct Db *self){
		u_int32_t ret = 0;
		errno = self->get_h_ffactor(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t Db_get_h_nelem(struct Db *self){
		u_int32_t ret = 0;
		errno = self->get_h_nelem(self, &ret);
		return ret;
	}
SWIGINTERN int Db_get_re_delim(struct Db *self){
		int ret = 0;
		errno = self->get_re_delim(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t Db_get_re_len(struct Db *self){
		u_int32_t ret = 0;
		errno = self->get_re_len(self, &ret);
		return ret;
	}
SWIGINTERN int Db_get_re_pad(struct Db *self){
		int ret = 0;
		errno = self->get_re_pad(self, &ret);
		return ret;
	}
SWIGINTERN char const *Db_get_re_source(struct Db *self){
		const char *ret = NULL;
		errno = self->get_re_source(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t Db_get_q_extentsize(struct Db *self){
		u_int32_t ret = 0;
		errno = self->get_q_extentsize(self, &ret);
		return ret;
	}
SWIGINTERN DBTYPE Db_get_type(struct Db *self){
		DBTYPE type = (DBTYPE)0;
		errno = self->get_type(self, &type);
		return type;
	}
SWIGINTERN DBC *Db_join(struct Db *self,DBC **curslist,u_int32_t flags){
		DBC *dbcp = NULL;
		errno = self->join(self, curslist, &dbcp, flags);
		return dbcp;
	}
SWIGINTERN db_ret_t Db_key_range(struct Db *self,DB_TXN *txnid,DBT *key,DB_KEY_RANGE *key_range,u_int32_t flags){
		return self->key_range(self, txnid, key, key_range, flags);
	}
SWIGINTERN db_ret_t Db_open(struct Db *self,DB_TXN *txnid,char const *file,char const *database,DBTYPE type,u_int32_t flags,int mode){
		return self->open(self, txnid, file, database,
		    type, flags, mode);
	}
SWIGINTERN int Db_pget(struct Db *self,DB_TXN *txnid,DBT *key,DBT *pkey,DBT *data,u_int32_t flags){
		return self->pget(self, txnid, key, pkey, data, flags);
	}
SWIGINTERN int Db_put(struct Db *self,DB_TXN *txnid,DBT *key,DBT *data,u_int32_t flags){
		return self->put(self, txnid, key, data, flags);
	}
SWIGINTERN db_ret_t Db_remove(struct Db *self,char const *file,char const *database,u_int32_t flags){
		return self->remove(self, file, database, flags);
	}
SWIGINTERN db_ret_t Db_rename(struct Db *self,char const *file,char const *database,char const *newname,u_int32_t flags){
		return self->rename(self, file, database, newname, flags);
	}
SWIGINTERN db_ret_t Db_set_append_recno(struct Db *self,int (*db_append_recno_fcn)(DB *,DBT *,db_recno_t)){
		return self->set_append_recno(self, db_append_recno_fcn);
	}
SWIGINTERN db_ret_t Db_set_bt_compare(struct Db *self,int (*bt_compare_fcn)(DB *,DBT const *,DBT const *)){
		return self->set_bt_compare(self, bt_compare_fcn);
	}
SWIGINTERN db_ret_t Db_set_bt_minkey(struct Db *self,u_int32_t bt_minkey){
		return self->set_bt_minkey(self, bt_minkey);
	}
SWIGINTERN db_ret_t Db_set_bt_prefix(struct Db *self,size_t (*bt_prefix_fcn)(DB *,DBT const *,DBT const *)){
		return self->set_bt_prefix(self, bt_prefix_fcn);
	}
SWIGINTERN db_ret_t Db_set_cachesize(struct Db *self,jlong bytes,int ncache){
		return self->set_cachesize(self,
		    (u_int32_t)(bytes / GIGABYTE),
		    (u_int32_t)(bytes % GIGABYTE), ncache);
	}
SWIGINTERN db_ret_t Db_set_dup_compare(struct Db *self,int (*dup_compare_fcn)(DB *,DBT const *,DBT const *)){
		return self->set_dup_compare(self, dup_compare_fcn);
	}
SWIGINTERN db_ret_t Db_set_encrypt(struct Db *self,char const *passwd,u_int32_t flags){
		return self->set_encrypt(self, passwd, flags);
	}
SWIGINTERN db_ret_t Db_set_feedback(struct Db *self,void (*db_feedback_fcn)(DB *,int,int)){
		return self->set_feedback(self, db_feedback_fcn);
	}
SWIGINTERN db_ret_t Db_set_flags(struct Db *self,u_int32_t flags){
		return self->set_flags(self, flags);
	}
SWIGINTERN db_ret_t Db_set_h_ffactor(struct Db *self,u_int32_t h_ffactor){
		return self->set_h_ffactor(self, h_ffactor);
	}
SWIGINTERN db_ret_t Db_set_h_hash(struct Db *self,u_int32_t (*h_hash_fcn)(DB *,void const *,u_int32_t)){
		return self->set_h_hash(self, h_hash_fcn);
	}
SWIGINTERN db_ret_t Db_set_h_nelem(struct Db *self,u_int32_t h_nelem){
		return self->set_h_nelem(self, h_nelem);
	}
SWIGINTERN db_ret_t Db_set_lorder(struct Db *self,int lorder){
		return self->set_lorder(self, lorder);
	}
SWIGINTERN db_ret_t Db_set_pagesize(struct Db *self,u_int32_t pagesize){
		return self->set_pagesize(self, pagesize);
	}
SWIGINTERN db_ret_t Db_set_re_delim(struct Db *self,int re_delim){
		return self->set_re_delim(self, re_delim);
	}
SWIGINTERN db_ret_t Db_set_re_len(struct Db *self,u_int32_t re_len){
		return self->set_re_len(self, re_len);
	}
SWIGINTERN db_ret_t Db_set_re_pad(struct Db *self,int re_pad){
		return self->set_re_pad(self, re_pad);
	}
SWIGINTERN db_ret_t Db_set_re_source(struct Db *self,char *source){
		return self->set_re_source(self, source);
	}
SWIGINTERN db_ret_t Db_set_q_extentsize(struct Db *self,u_int32_t extentsize){
		return self->set_q_extentsize(self, extentsize);
	}
SWIGINTERN void *Db_stat(struct Db *self,DB_TXN *txnid,u_int32_t flags){
		void *statp = NULL;
		errno = self->stat(self, txnid, &statp, flags);
		return statp;
	}
SWIGINTERN db_ret_t Db_sync(struct Db *self,u_int32_t flags){
		return self->sync(self, flags);
	}
SWIGINTERN int Db_truncate(struct Db *self,DB_TXN *txnid,u_int32_t flags){
		u_int32_t count = 0;
		errno = self->truncate(self, txnid, &count, flags);
		return count;
	}
SWIGINTERN db_ret_t Db_upgrade(struct Db *self,char const *file,u_int32_t flags){
		return self->upgrade(self, file, flags);
	}
SWIGINTERN int_bool Db_verify(struct Db *self,char const *file,char const *database,struct __db_out_stream outfile,u_int32_t flags){
		/*
		 * We can't easily #include "dbinc/db_ext.h" because of name
		 * clashes, so we declare this explicitly.
		 */
		extern int __db_verify_internal __P((DB *, const char *, const
		    char *, void *, int (*)(void *, const void *), u_int32_t));
		errno = __db_verify_internal(self, file, database,
		    outfile.handle, outfile.callback, flags);
		if (errno == DB_VERIFY_BAD) {
			errno = 0;
			return 0;
		} else
			return 1;
	}
SWIGINTERN db_ret_t Dbc_close(struct Dbc *self){
		return self->c_close(self);
	}
SWIGINTERN db_recno_t Dbc_count(struct Dbc *self,u_int32_t flags){
		db_recno_t count = 0;
		errno = self->c_count(self, &count, flags);
		return count;
	}
SWIGINTERN int Dbc_del(struct Dbc *self,u_int32_t flags){
		return self->c_del(self, flags);
	}
SWIGINTERN DBC *Dbc_dup(struct Dbc *self,u_int32_t flags){
		DBC *newcurs = NULL;
		errno = self->c_dup(self, &newcurs, flags);
		return newcurs;
	}
SWIGINTERN int Dbc_get(struct Dbc *self,DBT *key,DBT *data,u_int32_t flags){
		return self->c_get(self, key, data, flags);
	}
SWIGINTERN int Dbc_pget(struct Dbc *self,DBT *key,DBT *pkey,DBT *data,u_int32_t flags){
		return self->c_pget(self, key, pkey, data, flags);
	}
SWIGINTERN int Dbc_put(struct Dbc *self,DBT *key,DBT *data,u_int32_t flags){
		return self->c_put(self, key, data, flags);
	}
SWIGINTERN struct DbEnv *new_DbEnv(u_int32_t flags){
		DB_ENV *self = NULL;
		errno = db_env_create(&self, flags);
		if (errno == 0)
			self->dbt_usercopy = __dbj_dbt_memcopy;
		return self;
	}
SWIGINTERN db_ret_t DbEnv_close(struct DbEnv *self,u_int32_t flags){
		return self->close(self, flags);
	}
SWIGINTERN db_ret_t DbEnv_dbremove(struct DbEnv *self,DB_TXN *txnid,char const *file,char const *database,u_int32_t flags){
		return self->dbremove(self, txnid, file, database, flags);
	}
SWIGINTERN db_ret_t DbEnv_dbrename(struct DbEnv *self,DB_TXN *txnid,char const *file,char const *database,char const *newname,u_int32_t flags){
		return self->dbrename(self,
		    txnid, file, database, newname, flags);
	}
SWIGINTERN void DbEnv_err(struct DbEnv *self,int error,char const *message){
		self->err(self, error, message);
	}
SWIGINTERN void DbEnv_errx(struct DbEnv *self,char const *message){
		self->errx(self, message);
	}
SWIGINTERN DB_TXN *DbEnv_cdsgroup_begin(struct DbEnv *self){
		DB_TXN *tid = NULL;
		errno = self->cdsgroup_begin(self, &tid);
		return tid;
	}
SWIGINTERN db_ret_t DbEnv_fileid_reset(struct DbEnv *self,char const *file,u_int32_t flags){
		return self->fileid_reset(self, file, flags);
	}
SWIGINTERN char const **DbEnv_get_data_dirs(struct DbEnv *self){
		const char **ret;
		errno = self->get_data_dirs(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_encrypt_flags(struct DbEnv *self){
		u_int32_t ret = 0;
		CRYPTO_ONLY(errno = self->get_encrypt_flags(self, &ret))
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_flags(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_flags(self, &ret);
		return ret;
	}
SWIGINTERN char const *DbEnv_get_home(struct DbEnv *self){
		const char *ret;
		errno = self->get_home(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_open_flags(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_open_flags(self, &ret);
		return ret;
	}
SWIGINTERN long DbEnv_get_shm_key(struct DbEnv *self){
		long ret;
		errno = self->get_shm_key(self, &ret);
		return ret;
	}
SWIGINTERN char const *DbEnv_get_tmp_dir(struct DbEnv *self){
		const char *ret;
		errno = self->get_tmp_dir(self, &ret);
		return ret;
	}
SWIGINTERN int_bool DbEnv_get_verbose(struct DbEnv *self,u_int32_t which){
		int ret;
		errno = self->get_verbose(self, which, &ret);
		return ret;
	}
SWIGINTERN int_bool DbEnv_is_bigendian(struct DbEnv *self){
		return self->is_bigendian();
	}
SWIGINTERN db_ret_t DbEnv_lsn_reset(struct DbEnv *self,char const *file,u_int32_t flags){
		return self->lsn_reset(self, file, flags);
	}
SWIGINTERN db_ret_t DbEnv_open(struct DbEnv *self,char const *db_home,u_int32_t flags,int mode){
		return self->open(self, db_home, flags, mode);
	}
SWIGINTERN db_ret_t DbEnv_remove(struct DbEnv *self,char const *db_home,u_int32_t flags){
		return self->remove(self, db_home, flags);
	}
SWIGINTERN db_ret_t DbEnv_set_cachesize(struct DbEnv *self,jlong bytes,int ncache){
		return self->set_cachesize(self,
		    (u_int32_t)(bytes / GIGABYTE),
		    (u_int32_t)(bytes % GIGABYTE), ncache);
	}
SWIGINTERN db_ret_t DbEnv_set_data_dir(struct DbEnv *self,char const *dir){
		return self->set_data_dir(self, dir);
	}
SWIGINTERN db_ret_t DbEnv_set_intermediate_dir(struct DbEnv *self,int mode,u_int32_t flags){
		return self->set_intermediate_dir(self, mode, flags);
	}
SWIGINTERN db_ret_t DbEnv_set_encrypt(struct DbEnv *self,char const *passwd,u_int32_t flags){
		return self->set_encrypt(self, passwd, flags);
	}
SWIGINTERN void DbEnv_set_errcall(struct DbEnv *self,void (*db_errcall_fcn)(DB_ENV const *,char const *,char const *)){
		self->set_errcall(self, db_errcall_fcn);
	}
SWIGINTERN db_ret_t DbEnv_set_flags(struct DbEnv *self,u_int32_t flags,int_bool onoff){
		return self->set_flags(self, flags, onoff);
	}
SWIGINTERN db_ret_t DbEnv_set_feedback(struct DbEnv *self,void (*env_feedback_fcn)(DB_ENV *,int,int)){
		return self->set_feedback(self, env_feedback_fcn);
	}
SWIGINTERN db_ret_t DbEnv_set_mp_max_openfd(struct DbEnv *self,int maxopenfd){
		return self->set_mp_max_openfd(self, maxopenfd);
	}
SWIGINTERN db_ret_t DbEnv_set_mp_max_write(struct DbEnv *self,int maxwrite,int maxwrite_sleep){
		return self->set_mp_max_write(self, maxwrite, maxwrite_sleep);
	}
SWIGINTERN db_ret_t DbEnv_set_mp_mmapsize(struct DbEnv *self,size_t mp_mmapsize){
		return self->set_mp_mmapsize(self, mp_mmapsize);
	}
SWIGINTERN void DbEnv_set_msgcall(struct DbEnv *self,void (*db_msgcall_fcn)(DB_ENV const *,char const *)){
		self->set_msgcall(self, db_msgcall_fcn);
	}
SWIGINTERN db_ret_t DbEnv_set_paniccall(struct DbEnv *self,void (*db_panic_fcn)(DB_ENV *,int)){
		return self->set_paniccall(self, db_panic_fcn);
	}
SWIGINTERN db_ret_t DbEnv_set_rpc_server(struct DbEnv *self,char *host,long cl_timeout,long sv_timeout,u_int32_t flags){
		return self->set_rpc_server(self, NULL, host,
		    cl_timeout, sv_timeout, flags);
	}
SWIGINTERN db_ret_t DbEnv_set_shm_key(struct DbEnv *self,long shm_key){
		return self->set_shm_key(self, shm_key);
	}
SWIGINTERN db_ret_t DbEnv_set_timeout(struct DbEnv *self,db_timeout_t timeout,u_int32_t flags){
		return self->set_timeout(self, timeout, flags);
	}
SWIGINTERN db_ret_t DbEnv_set_tmp_dir(struct DbEnv *self,char const *dir){
		return self->set_tmp_dir(self, dir);
	}
SWIGINTERN db_ret_t DbEnv_set_tx_max(struct DbEnv *self,u_int32_t max){
		return self->set_tx_max(self, max);
	}
SWIGINTERN db_ret_t DbEnv_set_app_dispatch(struct DbEnv *self,int (*tx_recover)(DB_ENV *,DBT *,DB_LSN *,db_recops)){
		return self->set_app_dispatch(self, tx_recover);
	}
SWIGINTERN db_ret_t DbEnv_set_event_notify(struct DbEnv *self,void (*event_notify)(DB_ENV *,u_int32_t,void *)){
		return self->set_event_notify(self, event_notify);
	}
SWIGINTERN db_ret_t DbEnv_set_tx_timestamp(struct DbEnv *self,time_t *timestamp){
		return self->set_tx_timestamp(self, timestamp);
	}
SWIGINTERN db_ret_t DbEnv_set_verbose(struct DbEnv *self,u_int32_t which,int_bool onoff){
		return self->set_verbose(self, which, onoff);
	}
SWIGINTERN struct __db_lk_conflicts DbEnv_get_lk_conflicts(struct DbEnv *self){
		struct __db_lk_conflicts ret;
		errno = self->get_lk_conflicts(self,
		    (const u_int8_t **)&ret.lk_conflicts, &ret.lk_modes);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_lk_detect(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_lk_detect(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_lk_max_locks(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_lk_max_locks(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_lk_max_lockers(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_lk_max_lockers(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_lk_max_objects(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_lk_max_objects(self, &ret);
		return ret;
	}
SWIGINTERN int DbEnv_lock_detect(struct DbEnv *self,u_int32_t flags,u_int32_t atype){
		int aborted;
		errno = self->lock_detect(self, flags, atype, &aborted);
		return aborted;
	}
SWIGINTERN DB_LOCK *DbEnv_lock_get(struct DbEnv *self,u_int32_t locker,u_int32_t flags,DBT const *object,db_lockmode_t lock_mode){
		DB_LOCK *lock = NULL;
		if ((errno = __os_malloc(self, sizeof (DB_LOCK), &lock)) == 0)
			errno = self->lock_get(self, locker, flags, object,
			    lock_mode, lock);
		return lock;
	}
SWIGINTERN u_int32_t DbEnv_lock_id(struct DbEnv *self){
		u_int32_t id;
		errno = self->lock_id(self, &id);
		return id;
	}
SWIGINTERN db_ret_t DbEnv_lock_id_free(struct DbEnv *self,u_int32_t id){
		return self->lock_id_free(self, id);
	}
SWIGINTERN db_ret_t DbEnv_lock_put(struct DbEnv *self,DB_LOCK *lock){
		return self->lock_put(self, lock);
	}
SWIGINTERN DB_LOCK_STAT *DbEnv_lock_stat(struct DbEnv *self,u_int32_t flags){
		DB_LOCK_STAT *statp = NULL;
		errno = self->lock_stat(self, &statp, flags);
		return statp;
	}
SWIGINTERN db_ret_t DbEnv_set_lk_conflicts(struct DbEnv *self,struct __db_lk_conflicts conflicts){
		return self->set_lk_conflicts(self,
		    conflicts.lk_conflicts, conflicts.lk_modes);
	}
SWIGINTERN db_ret_t DbEnv_set_lk_detect(struct DbEnv *self,u_int32_t detect){
		return self->set_lk_detect(self, detect);
	}
SWIGINTERN db_ret_t DbEnv_set_lk_max_lockers(struct DbEnv *self,u_int32_t max){
		return self->set_lk_max_lockers(self, max);
	}
SWIGINTERN db_ret_t DbEnv_set_lk_max_locks(struct DbEnv *self,u_int32_t max){
		return self->set_lk_max_locks(self, max);
	}
SWIGINTERN db_ret_t DbEnv_set_lk_max_objects(struct DbEnv *self,u_int32_t max){
		return self->set_lk_max_objects(self, max);
	}
SWIGINTERN u_int32_t DbEnv_get_lg_bsize(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_lg_bsize(self, &ret);
		return ret;
	}
SWIGINTERN char const *DbEnv_get_lg_dir(struct DbEnv *self){
		const char *ret;
		errno = self->get_lg_dir(self, &ret);
		return ret;
	}
SWIGINTERN int DbEnv_get_lg_filemode(struct DbEnv *self){
		int ret;
		errno = self->get_lg_filemode(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_lg_max(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_lg_max(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_lg_regionmax(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_lg_regionmax(self, &ret);
		return ret;
	}
SWIGINTERN char **DbEnv_log_archive(struct DbEnv *self,u_int32_t flags){
		char **list = NULL;
		errno = self->log_archive(self, &list, flags);
		return list;
	}
SWIGINTERN int DbEnv_log_compare(DB_LSN const *lsn0,DB_LSN const *lsn1){
		return log_compare(lsn0, lsn1);
	}
SWIGINTERN DB_LOGC *DbEnv_log_cursor(struct DbEnv *self,u_int32_t flags){
		DB_LOGC *cursor = NULL;
		errno = self->log_cursor(self, &cursor, flags);
		return cursor;
	}
SWIGINTERN char *DbEnv_log_file(struct DbEnv *self,DB_LSN *lsn){
		char namebuf[DB_MAXPATHLEN];
		errno = self->log_file(self, lsn, namebuf, sizeof namebuf);
		return (errno == 0) ? strdup(namebuf) : NULL;
	}
SWIGINTERN db_ret_t DbEnv_log_flush(struct DbEnv *self,DB_LSN const *lsn_or_null){
		return self->log_flush(self, lsn_or_null);
	}
SWIGINTERN db_ret_t DbEnv_log_put(struct DbEnv *self,DB_LSN *lsn,DBT const *data,u_int32_t flags){
		return self->log_put(self, lsn, data, flags);
	}
SWIGINTERN db_ret_t DbEnv_log_print(struct DbEnv *self,DB_TXN *txn,char const *msg){
		return self->log_printf(self, txn, "%s", msg);
	}
SWIGINTERN DB_LOG_STAT *DbEnv_log_stat(struct DbEnv *self,u_int32_t flags){
		DB_LOG_STAT *sp = NULL;
		errno = self->log_stat(self, &sp, flags);
		return sp;
	}
SWIGINTERN db_ret_t DbEnv_set_lg_bsize(struct DbEnv *self,u_int32_t lg_bsize){
		return self->set_lg_bsize(self, lg_bsize);
	}
SWIGINTERN db_ret_t DbEnv_set_lg_dir(struct DbEnv *self,char const *dir){
		return self->set_lg_dir(self, dir);
	}
SWIGINTERN db_ret_t DbEnv_set_lg_filemode(struct DbEnv *self,int mode){
		return self->set_lg_filemode(self, mode);
	}
SWIGINTERN db_ret_t DbEnv_set_lg_max(struct DbEnv *self,u_int32_t lg_max){
		return self->set_lg_max(self, lg_max);
	}
SWIGINTERN db_ret_t DbEnv_set_lg_regionmax(struct DbEnv *self,u_int32_t lg_regionmax){
		return self->set_lg_regionmax(self, lg_regionmax);
	}
SWIGINTERN jlong DbEnv_get_cachesize(struct DbEnv *self){
		u_int32_t gbytes, bytes;
		errno = self->get_cachesize(self, &gbytes, &bytes, NULL);
		return (jlong)gbytes * GIGABYTE + bytes;
	}
SWIGINTERN int DbEnv_get_cachesize_ncache(struct DbEnv *self){
		int ret;
		errno = self->get_cachesize(self, NULL, NULL, &ret);
		return ret;
	}
SWIGINTERN int DbEnv_get_mp_max_openfd(struct DbEnv *self){
		int ret;
		errno = self->get_mp_max_openfd(self, &ret);
		return ret;
	}
SWIGINTERN int DbEnv_get_mp_max_write(struct DbEnv *self){
		int ret, junk;
		errno = self->get_mp_max_write(self, &ret, &junk);
		return ret;
	}
SWIGINTERN int DbEnv_get_mp_max_write_sleep(struct DbEnv *self){
		int ret, junk;
		errno = self->get_mp_max_write(self, &junk, &ret);
		return ret;
	}
SWIGINTERN size_t DbEnv_get_mp_mmapsize(struct DbEnv *self){
		size_t ret;
		errno = self->get_mp_mmapsize(self, &ret);
		return ret;
	}
SWIGINTERN DB_MPOOL_STAT *DbEnv_memp_stat(struct DbEnv *self,u_int32_t flags){
		DB_MPOOL_STAT *mp_stat = NULL;
		errno = self->memp_stat(self, &mp_stat, NULL, flags);
		return mp_stat;
	}
SWIGINTERN DB_MPOOL_FSTAT **DbEnv_memp_fstat(struct DbEnv *self,u_int32_t flags){
		DB_MPOOL_FSTAT **mp_fstat = NULL;
		errno = self->memp_stat(self, NULL, &mp_fstat, flags);
		return mp_fstat;
	}
SWIGINTERN int DbEnv_memp_trickle(struct DbEnv *self,int percent){
		int ret;
		errno = self->memp_trickle(self, percent, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_mutex_get_align(struct DbEnv *self){
		u_int32_t ret;
		errno = self->mutex_get_align(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_mutex_get_increment(struct DbEnv *self){
		u_int32_t ret;
		errno = self->mutex_get_increment(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_mutex_get_max(struct DbEnv *self){
		u_int32_t ret;
		errno = self->mutex_get_max(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_mutex_get_tas_spins(struct DbEnv *self){
		u_int32_t ret;
		errno = self->mutex_get_tas_spins(self, &ret);
		return ret;
	}
SWIGINTERN db_ret_t DbEnv_mutex_set_align(struct DbEnv *self,u_int32_t align){
		return self->mutex_set_align(self, align);
	}
SWIGINTERN db_ret_t DbEnv_mutex_set_increment(struct DbEnv *self,u_int32_t increment){
		return self->mutex_set_increment(self, increment);
	}
SWIGINTERN db_ret_t DbEnv_mutex_set_max(struct DbEnv *self,u_int32_t mutex_max){
		return self->mutex_set_increment(self, mutex_max);
	}
SWIGINTERN db_ret_t DbEnv_mutex_set_tas_spins(struct DbEnv *self,u_int32_t tas_spins){
		return self->mutex_set_tas_spins(self, tas_spins);
	}
SWIGINTERN DB_MUTEX_STAT *DbEnv_mutex_stat(struct DbEnv *self,u_int32_t flags){
		DB_MUTEX_STAT *statp = NULL;
		errno = self->mutex_stat(self, &statp, flags);
		return statp;
	}
SWIGINTERN u_int32_t DbEnv_get_tx_max(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_tx_max(self, &ret);
		return ret;
	}
SWIGINTERN time_t DbEnv_get_tx_timestamp(struct DbEnv *self){
		time_t ret;
		errno = self->get_tx_timestamp(self, &ret);
		return ret;
	}
SWIGINTERN db_timeout_t DbEnv_get_timeout(struct DbEnv *self,u_int32_t flag){
		db_timeout_t ret;
		errno = self->get_timeout(self, &ret, flag);
		return ret;
	}
SWIGINTERN DB_TXN *DbEnv_txn_begin(struct DbEnv *self,DB_TXN *parent,u_int32_t flags){
		DB_TXN *tid = NULL;
		errno = self->txn_begin(self, parent, &tid, flags);
		return tid;
	}
SWIGINTERN db_ret_t DbEnv_txn_checkpoint(struct DbEnv *self,u_int32_t kbyte,u_int32_t min,u_int32_t flags){
		return self->txn_checkpoint(self, kbyte, min, flags);
	}
SWIGINTERN DB_PREPLIST *DbEnv_txn_recover(struct DbEnv *self,int count,u_int32_t flags){
		DB_PREPLIST *preplist;
		long retcount;

		/* Add a NULL element to terminate the array. */
		if ((errno = __os_malloc(self,
		    (count + 1) * sizeof(DB_PREPLIST), &preplist)) != 0)
			return NULL;

		if ((errno = self->txn_recover(self, preplist, count,
		    &retcount, flags)) != 0) {
			__os_free(self, preplist);
			return NULL;
		}

		preplist[retcount].txn = NULL;
		return preplist;
	}
SWIGINTERN DB_TXN_STAT *DbEnv_txn_stat(struct DbEnv *self,u_int32_t flags){
		DB_TXN_STAT *statp = NULL;
		errno = self->txn_stat(self, &statp, flags);
		return statp;
	}
SWIGINTERN jlong DbEnv_rep_get_limit(struct DbEnv *self){
		u_int32_t gbytes, bytes;
		errno = self->rep_get_limit(self, &gbytes, &bytes);
		return (jlong)gbytes * GIGABYTE + bytes;
	}
SWIGINTERN int DbEnv_rep_elect(struct DbEnv *self,int nsites,int nvotes,u_int32_t flags){
		int id;
		errno = self->rep_elect(self, nsites, nvotes, &id, flags);
		return id;
	}
SWIGINTERN int DbEnv_rep_process_message(struct DbEnv *self,DBT *control,DBT *rec,int *envid,DB_LSN *ret_lsn){
		return self->rep_process_message(self, control, rec, envid,
		    ret_lsn);
	}
SWIGINTERN db_ret_t DbEnv_rep_flush(struct DbEnv *self){
		return self->rep_flush(self);
	}
SWIGINTERN db_ret_t DbEnv_rep_set_config(struct DbEnv *self,u_int32_t which,int_bool onoff){
		return self->rep_set_config(self, which, onoff);
	}
SWIGINTERN db_ret_t DbEnv_rep_start(struct DbEnv *self,DBT *cdata,u_int32_t flags){
		return self->rep_start(self, cdata, flags);
	}
SWIGINTERN db_ret_t DbEnv_rep_sync(struct DbEnv *self,u_int32_t flags){
		return self->rep_sync(self, flags);
	}
SWIGINTERN int_bool DbEnv_rep_get_config(struct DbEnv *self,u_int32_t which){
		int ret;
		errno = self->rep_get_config(self, which, &ret);
		return ret;
	}
SWIGINTERN DB_REP_STAT *DbEnv_rep_stat(struct DbEnv *self,u_int32_t flags){
		DB_REP_STAT *statp = NULL;
		errno = self->rep_stat(self, &statp, flags);
		return statp;
	}
SWIGINTERN db_ret_t DbEnv_rep_set_limit(struct DbEnv *self,jlong bytes){
		return self->rep_set_limit(self,
		    (u_int32_t)(bytes / GIGABYTE),
		    (u_int32_t)(bytes % GIGABYTE));
	}
SWIGINTERN db_ret_t DbEnv_set_rep_request(struct DbEnv *self,u_int32_t min,u_int32_t max){
		return self->set_rep_request(self, min, max);
	}
SWIGINTERN db_ret_t DbEnv_rep_set_transport(struct DbEnv *self,int envid,int (*send)(DB_ENV *,DBT const *,DBT const *,DB_LSN const *,int,u_int32_t)){
		return self->rep_set_transport(self, envid, send);
	}
SWIGINTERN int DbEnv_rep_get_nsites(struct DbEnv *self){
		int ret;
		errno = self->rep_get_nsites(self, &ret);
		return ret;
	}
SWIGINTERN int DbEnv_rep_get_priority(struct DbEnv *self){
		int ret;
		errno = self->rep_get_priority(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_rep_get_timeout(struct DbEnv *self,int which){
		u_int32_t ret;
		errno = self->rep_get_timeout(self, which, &ret);
		return ret;
	}
SWIGINTERN db_ret_t DbEnv_rep_set_nsites(struct DbEnv *self,int number){
		return self->rep_set_nsites(self, number);
	}
SWIGINTERN db_ret_t DbEnv_rep_set_priority(struct DbEnv *self,int priority){
		return self->rep_set_priority(self, priority);
	}
SWIGINTERN db_ret_t DbEnv_rep_set_timeout(struct DbEnv *self,int which,db_timeout_t timeout){
		return self->rep_set_timeout(self, which, timeout);
	}
SWIGINTERN int DbEnv_repmgr_add_remote_site(struct DbEnv *self,char const *host,u_int32_t port,u_int32_t flags){
		int eid;
		errno = self->repmgr_add_remote_site(self, host, port, &eid, flags);
		return eid;
	}
SWIGINTERN db_ret_t DbEnv_repmgr_get_ack_policy(struct DbEnv *self){
		int ret;
		errno = self->repmgr_get_ack_policy(self, &ret);
		return ret;
	}
SWIGINTERN db_ret_t DbEnv_repmgr_set_ack_policy(struct DbEnv *self,int policy){
		return self->repmgr_set_ack_policy(self, policy);
	}
SWIGINTERN db_ret_t DbEnv_repmgr_set_local_site(struct DbEnv *self,char const *host,u_int32_t port,u_int32_t flags){
		return self->repmgr_set_local_site(self, host, port, flags);
	}
SWIGINTERN struct __db_repmgr_sites DbEnv_repmgr_site_list(struct DbEnv *self){
		struct __db_repmgr_sites sites;
		errno = self->repmgr_site_list(self,
		    &sites.nsites, &sites.sites);
		return sites;
	}
SWIGINTERN db_ret_t DbEnv_repmgr_start(struct DbEnv *self,int nthreads,u_int32_t flags){
		return self->repmgr_start(self, nthreads, flags);
	}
SWIGINTERN char const *DbEnv_strerror(int error){
		return db_strerror(error);
	}
SWIGINTERN int DbEnv_get_version_major(){
		return DB_VERSION_MAJOR;
	}
SWIGINTERN int DbEnv_get_version_minor(){
		return DB_VERSION_MINOR;
	}
SWIGINTERN int DbEnv_get_version_patch(){
		return DB_VERSION_PATCH;
	}
SWIGINTERN char const *DbEnv_get_version_string(){
		return DB_VERSION_STRING;
	}
SWIGINTERN void delete_DbLock(struct DbLock *self){
		__os_free(NULL, self);
	}
SWIGINTERN db_ret_t DbLogc_close(struct DbLogc *self,u_int32_t flags){
		return self->close(self, flags);
	}
SWIGINTERN int DbLogc_get(struct DbLogc *self,DB_LSN *lsn,DBT *data,u_int32_t flags){
		return self->get(self, lsn, data, flags);
	}
SWIGINTERN DB_CACHE_PRIORITY DbMpoolFile_get_priority(struct DbMpoolFile *self){
		DB_CACHE_PRIORITY ret;
		errno = self->get_priority(self, &ret);
		return ret;
	}
SWIGINTERN db_ret_t DbMpoolFile_set_priority(struct DbMpoolFile *self,DB_CACHE_PRIORITY priority){
		return self->set_priority(self, priority);
	}
SWIGINTERN u_int32_t DbMpoolFile_get_flags(struct DbMpoolFile *self){
		u_int32_t ret;
		errno = self->get_flags(self, &ret);
		return ret;
	}
SWIGINTERN db_ret_t DbMpoolFile_set_flags(struct DbMpoolFile *self,u_int32_t flags,int_bool onoff){
		return self->set_flags(self, flags, onoff);
	}
SWIGINTERN jlong DbMpoolFile_get_maxsize(struct DbMpoolFile *self){
		u_int32_t gbytes, bytes;
		errno = self->get_maxsize(self, &gbytes, &bytes);
		return (jlong)gbytes * GIGABYTE + bytes;
	}
SWIGINTERN db_ret_t DbMpoolFile_set_maxsize(struct DbMpoolFile *self,jlong bytes){
		return self->set_maxsize(self,
		    (u_int32_t)(bytes / GIGABYTE),
		    (u_int32_t)(bytes % GIGABYTE));
	}
SWIGINTERN struct DbSequence *new_DbSequence(DB *db,u_int32_t flags){
		DB_SEQUENCE *self = NULL;
		errno = db_sequence_create(&self, db, flags);
		return self;
	}
SWIGINTERN db_ret_t DbSequence_close(struct DbSequence *self,u_int32_t flags){
		return self->close(self, flags);
	}
SWIGINTERN db_seq_t DbSequence_get(struct DbSequence *self,DB_TXN *txnid,int32_t delta,u_int32_t flags){
		db_seq_t ret = 0;
		errno = self->get(self, txnid, delta, &ret, flags);
		return ret;
	}
SWIGINTERN int32_t DbSequence_get_cachesize(struct DbSequence *self){
		int32_t ret = 0;
		errno = self->get_cachesize(self, &ret);
		return ret;
	}
SWIGINTERN DB *DbSequence_get_db(struct DbSequence *self){
		DB *ret = NULL;
		errno = self->get_db(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbSequence_get_flags(struct DbSequence *self){
		u_int32_t ret = 0;
		errno = self->get_flags(self, &ret);
		return ret;
	}
SWIGINTERN db_ret_t DbSequence_get_key(struct DbSequence *self,DBT *key){
		return self->get_key(self, key);
	}
SWIGINTERN db_seq_t DbSequence_get_range_min(struct DbSequence *self){
		db_seq_t ret = 0;
		errno = self->get_range(self, &ret, NULL);
		return ret;
	}
SWIGINTERN db_seq_t DbSequence_get_range_max(struct DbSequence *self){
		db_seq_t ret = 0;
		errno = self->get_range(self, NULL, &ret);
		return ret;
	}
SWIGINTERN db_ret_t DbSequence_initial_value(struct DbSequence *self,db_seq_t val){
		return self->initial_value(self, val);
	}
SWIGINTERN db_ret_t DbSequence_open(struct DbSequence *self,DB_TXN *txnid,DBT *key,u_int32_t flags){
		return self->open(self, txnid, key, flags);
	}
SWIGINTERN db_ret_t DbSequence_remove(struct DbSequence *self,DB_TXN *txnid,u_int32_t flags){
		return self->remove(self, txnid, flags);
	}
SWIGINTERN db_ret_t DbSequence_set_cachesize(struct DbSequence *self,int32_t size){
		return self->set_cachesize(self, size);
	}
SWIGINTERN db_ret_t DbSequence_set_flags(struct DbSequence *self,u_int32_t flags){
		return self->set_flags(self, flags);
	}
SWIGINTERN db_ret_t DbSequence_set_range(struct DbSequence *self,db_seq_t min,db_seq_t max){
		return self->set_range(self, min, max);
	}
SWIGINTERN DB_SEQUENCE_STAT *DbSequence_stat(struct DbSequence *self,u_int32_t flags){
		DB_SEQUENCE_STAT *ret = NULL;
		errno = self->stat(self, &ret, flags);
		return ret;
	}
SWIGINTERN db_ret_t DbTxn_abort(struct DbTxn *self){
		return self->abort(self);
	}
SWIGINTERN db_ret_t DbTxn_commit(struct DbTxn *self,u_int32_t flags){
		return self->commit(self, flags);
	}
SWIGINTERN db_ret_t DbTxn_discard(struct DbTxn *self,u_int32_t flags){
		return self->discard(self, flags);
	}
SWIGINTERN char const *DbTxn_get_name(struct DbTxn *self){
		const char *name = NULL;
		errno = self->get_name(self, &name);
		return name;
	}
SWIGINTERN u_int32_t DbTxn_id(struct DbTxn *self){
		return self->id(self);
	}
SWIGINTERN db_ret_t DbTxn_prepare(struct DbTxn *self,u_int8_t *gid){
		return self->prepare(self, gid);
	}
SWIGINTERN db_ret_t DbTxn_set_timeout(struct DbTxn *self,db_timeout_t timeout,u_int32_t flags){
		return self->set_timeout(self, timeout, flags);
	}
SWIGINTERN db_ret_t DbTxn_set_name(struct DbTxn *self,char const *name){
		return self->set_name(self, name);
	}

#ifdef __cplusplus
extern "C" {
#endif

JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_new_1Db(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  DB_ENV *arg1 = (DB_ENV *) 0 ;
  u_int32_t arg2 ;
  struct Db *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DB_ENV **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  errno = 0;
  result = (struct Db *)new_Db(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  *(struct Db **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1associate(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jobject jarg4, jint jarg5) {
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  DB *arg3 = (DB *) 0 ;
  int (*arg4)(DB *,DBT const *,DBT const *,DBT *) = (int (*)(DB *,DBT const *,DBT const *,DBT *)) 0 ;
  u_int32_t arg5 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  arg3 = *(DB **)&jarg3; 
  
  arg4 = (jarg4 == NULL) ? NULL : __dbj_seckey_create;
  
  arg5 = (u_int32_t)jarg5; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_associate(arg1,arg2,arg3,arg4,arg5);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1compact(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg3, jobject jarg4, jobject jarg5, jint jarg6, jobject jarg7) {
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  DBT *arg4 = (DBT *) 0 ;
  DB_COMPACT *arg5 = (DB_COMPACT *) 0 ;
  u_int32_t arg6 ;
  DBT *arg7 = (DBT *) 0 ;
  db_ret_t result;
  DBT_LOCKED ldbt3 ;
  DBT_LOCKED ldbt4 ;
  DB_COMPACT compact5 ;
  DBT_LOCKED ldbt7 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 1) != 0) {
    return ; /* An exception will be pending. */
  }
  
  if (__dbj_dbt_copyin(jenv, &ldbt4, &arg4, jarg4, 1) != 0) {
    return ; /* An exception will be pending. */
  }
  
  memset(&compact5, 0, sizeof (DB_COMPACT));
  arg5 = &compact5;
  arg5->compact_fillpercent = (*jenv)->GetIntField(jenv, jarg5,
    compact_compact_fillpercent_fid);
  arg5->compact_timeout = (*jenv)->GetIntField(jenv, jarg5,
    compact_compact_timeout_fid);
  arg5->compact_pages = (*jenv)->GetIntField(jenv, jarg5,
    compact_compact_pages_fid);
  
  arg6 = (u_int32_t)jarg6; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt7, &arg7, jarg7, 1) != 0) {
    return ; /* An exception will be pending. */
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_compact(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
  __dbj_dbt_release(jenv, jarg4, arg4, &ldbt4); 
  __dbj_fill_compact(jenv, jarg5, arg5); 
  __dbj_dbt_release(jenv, jarg7, arg7, &ldbt7); 
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1close0(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)Db_close(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1cursor(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jlong jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  u_int32_t arg3 ;
  DBC *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DBC *)Db_cursor(arg1,arg2,arg3);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  *(DBC **)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1del(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg3, jint jarg4) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  u_int32_t arg4 ;
  int result;
  DBT_LOCKED ldbt3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  result = (int)Db_del(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_DBDEL(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1err(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3) {
  struct Db *arg1 = (struct Db *) 0 ;
  int arg2 ;
  char *arg3 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  Db_err(arg1,arg2,(char const *)arg3); 
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1errx(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  Db_errx(arg1,(char const *)arg2); 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1transactional(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  int_bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  result = (int_bool)Db_get_transactional(arg1); 
  jresult = (result) ? JNI_TRUE : JNI_FALSE; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg3, jobject jarg4, jint jarg5) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  DBT *arg4 = (DBT *) 0 ;
  u_int32_t arg5 ;
  int result;
  DBT_LOCKED ldbt3 ;
  DBT_LOCKED ldbt4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  
  if (__dbj_dbt_copyin(jenv, &ldbt4, &arg4, jarg4, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg5 = (u_int32_t)jarg5; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  result = (int)Db_get(arg1,arg2,arg3,arg4,arg5);
  if (!DB_RETOK_DBGET(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
  __dbj_dbt_release(jenv, jarg4, arg4, &ldbt4); 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1byteswapped(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  int_bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int_bool)Db_get_byteswapped(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (result) ? JNI_TRUE : JNI_FALSE; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1cachesize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  jlong result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = Db_get_cachesize(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1cachesize_1ncache(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_cachesize_ncache(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1filename(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char *)Db_get_filename(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1dbname(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char *)Db_get_dbname(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1encrypt_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_encrypt_flags(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_flags(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1lorder(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)Db_get_lorder(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1mpf(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DB_MPOOLFILE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_MPOOLFILE *)Db_get_mpf(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  *(DB_MPOOLFILE **)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1open_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_open_flags(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1pagesize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_pagesize(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1bt_1minkey(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_bt_minkey(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1h_1ffactor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_h_ffactor(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1h_1nelem(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_h_nelem(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1re_1delim(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)Db_get_re_delim(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1re_1len(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_re_len(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1re_1pad(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)Db_get_re_pad(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1re_1source(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char *)Db_get_re_source(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1q_1extentsize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_q_extentsize(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1type(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DBTYPE result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DBTYPE)Db_get_type(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1join(JNIEnv *jenv, jclass jcls, jlong jarg1, jobjectArray jarg2, jint jarg3) {
  jlong jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DBC **arg2 = (DBC **) 0 ;
  u_int32_t arg3 ;
  DBC *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  {
    int i, count, err;
    
    count = (*jenv)->GetArrayLength(jenv, jarg2);
    if ((err = __os_malloc(NULL, (count + 1) * sizeof(DBC *), &arg2)) != 0) {
      __dbj_throw(jenv, err, NULL, NULL, DB2JDBENV);
      return 0;
    }
    for (i = 0; i < count; i++) {
      jobject jobj = (*jenv)->GetObjectArrayElement(jenv, jarg2, i);
      /*
      		 * A null in the array is treated as an endpoint.
      		 */
      if (jobj == NULL) {
        arg2[i] = NULL;
        break;
      } else {
        jlong jptr = (*jenv)->GetLongField(jenv, jobj,
          dbc_cptr_fid);
        arg2[i] = *(DBC **)(void *)&jptr;
      }
    }
    arg2[count] = NULL;
  }
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DBC *)Db_join(arg1,arg2,arg3);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  *(DBC **)&jresult = result; 
  
  __os_free(NULL, arg2);
  
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1key_1range(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg3, jobject jarg4, jint jarg5) {
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  DB_KEY_RANGE *arg4 = (DB_KEY_RANGE *) 0 ;
  u_int32_t arg5 ;
  db_ret_t result;
  DBT_LOCKED ldbt3 ;
  DB_KEY_RANGE range4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return ; /* An exception will be pending. */
  }
  {
    arg4 = &range4;
  }
  arg5 = (u_int32_t)jarg5; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_key_range(arg1,arg2,arg3,arg4,arg5);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  {
    (*jenv)->SetDoubleField(jenv, jarg4, kr_less_fid, arg4->less);
    (*jenv)->SetDoubleField(jenv, jarg4, kr_equal_fid, arg4->equal);
    (*jenv)->SetDoubleField(jenv, jarg4, kr_greater_fid, arg4->greater);
  }
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1open(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jint jarg5, jint jarg6, jint jarg7) {
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  DBTYPE arg5 ;
  u_int32_t arg6 ;
  int arg7 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return ;
  }
  arg5 = (DBTYPE)jarg5; 
  arg6 = (u_int32_t)jarg6; 
  arg7 = (int)jarg7; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_open(arg1,arg2,(char const *)arg3,(char const *)arg4,arg5,arg6,arg7);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4);
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1pget(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg3, jobject jarg4, jobject jarg5, jint jarg6) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  DBT *arg4 = (DBT *) 0 ;
  DBT *arg5 = (DBT *) 0 ;
  u_int32_t arg6 ;
  int result;
  DBT_LOCKED ldbt3 ;
  DBT_LOCKED ldbt4 ;
  DBT_LOCKED ldbt5 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  
  if (__dbj_dbt_copyin(jenv, &ldbt4, &arg4, jarg4, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  
  if (__dbj_dbt_copyin(jenv, &ldbt5, &arg5, jarg5, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg6 = (u_int32_t)jarg6; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  result = (int)Db_pget(arg1,arg2,arg3,arg4,arg5,arg6);
  if (!DB_RETOK_DBGET(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
  __dbj_dbt_release(jenv, jarg4, arg4, &ldbt4); 
  __dbj_dbt_release(jenv, jarg5, arg5, &ldbt5); 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1put(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg3, jobject jarg4, jint jarg5) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  DBT *arg4 = (DBT *) 0 ;
  u_int32_t arg5 ;
  int result;
  DBT_LOCKED ldbt3 ;
  DBT_LOCKED ldbt4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  
  if (__dbj_dbt_copyin(jenv, &ldbt4, &arg4, jarg4, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg5 = (u_int32_t)jarg5; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  result = (int)Db_put(arg1,arg2,arg3,arg4,arg5);
  if (!DB_RETOK_DBPUT(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
  __dbj_dbt_release(jenv, jarg4, arg4, &ldbt4); 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1remove0(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jint jarg4) {
  struct Db *arg1 = (struct Db *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  u_int32_t arg4 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_remove(arg1,(char const *)arg2,(char const *)arg3,arg4);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1rename0(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jstring jarg4, jint jarg5) {
  struct Db *arg1 = (struct Db *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  u_int32_t arg5 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return ;
  }
  arg5 = (u_int32_t)jarg5; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_rename(arg1,(char const *)arg2,(char const *)arg3,(char const *)arg4,arg5);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4);
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1append_1recno(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  int (*arg2)(DB *,DBT *,db_recno_t) = (int (*)(DB *,DBT *,db_recno_t)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  arg2 = (jarg2 == NULL) ? NULL : __dbj_append_recno;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_append_recno(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1bt_1compare(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  int (*arg2)(DB *,DBT const *,DBT const *) = (int (*)(DB *,DBT const *,DBT const *)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  arg2 = (jarg2 == NULL) ? NULL : __dbj_bt_compare;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_bt_compare(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1bt_1minkey(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_bt_minkey(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1bt_1prefix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  size_t (*arg2)(DB *,DBT const *,DBT const *) = (size_t (*)(DB *,DBT const *,DBT const *)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  arg2 = (jarg2 == NULL) ? NULL : __dbj_bt_prefix;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_bt_prefix(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1cachesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  struct Db *arg1 = (struct Db *) 0 ;
  jlong arg2 ;
  int arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = jarg2; 
  arg3 = (int)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_cachesize(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1dup_1compare(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  int (*arg2)(DB *,DBT const *,DBT const *) = (int (*)(DB *,DBT const *,DBT const *)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  arg2 = (jarg2 == NULL) ? NULL : __dbj_dup_compare;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_dup_compare(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1encrypt(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
  struct Db *arg1 = (struct Db *) 0 ;
  char *arg2 = (char *) 0 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_encrypt(arg1,(char const *)arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1feedback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  void (*arg2)(DB *,int,int) = (void (*)(DB *,int,int)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  arg2 = (jarg2 == NULL) ? NULL : __dbj_db_feedback;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_feedback(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_flags(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1h_1ffactor(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_h_ffactor(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1h_1hash(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t (*arg2)(DB *,void const *,u_int32_t) = (u_int32_t (*)(DB *,void const *,u_int32_t)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  
  arg2 = (jarg2 == NULL) ? NULL : __dbj_h_hash;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_h_hash(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1h_1nelem(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_h_nelem(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1lorder(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  int arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_lorder(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1pagesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_pagesize(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1re_1delim(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  int arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_re_delim(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1re_1len(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_re_len(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1re_1pad(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  int arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_re_pad(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1re_1source(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  char *arg2 = (char *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_re_source(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1q_1extentsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_q_extentsize(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


JNIEXPORT jobject JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jobject jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  u_int32_t arg3 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (void *)Db_stat(arg1,arg2,arg3);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  
  if (result == NULL)
  jresult = NULL;
  else {
    DB *db = (DB *)arg1;
    DBTYPE dbtype;
    int err;
    
    if ((err = db->get_type(db, &dbtype)) != 0) {
      __dbj_throw(jenv, err, NULL, NULL, DB2JDBENV);
      return 0;
    }
    
    switch (dbtype) {
      /* Btree and recno share the same stat structure */
    case DB_BTREE:
    case DB_RECNO:
      jresult = (*jenv)->NewObject(jenv, bt_stat_class,
        bt_stat_construct);
      if (jresult != NULL)
      __dbj_fill_bt_stat(jenv, jresult,
        (DB_BTREE_STAT *)result);
      break;
      
      /* Hash stat structure */
    case DB_HASH:
      jresult = (*jenv)->NewObject(jenv, h_stat_class,
        h_stat_construct);
      if (jresult != NULL)
      __dbj_fill_h_stat(jenv, jresult,
        (DB_HASH_STAT *)result);
      break;
      
    case DB_QUEUE:
      jresult = (*jenv)->NewObject(jenv, qam_stat_class,
        qam_stat_construct);
      if (jresult != NULL)
      __dbj_fill_qam_stat(jenv, jresult,
        (DB_QUEUE_STAT *)result);
      break;
      
      /* That's all the database types we're aware of! */
    default:
      __dbj_throw(jenv, EINVAL, "Db.stat only implemented for"
        " BTREE, HASH, QUEUE and RECNO", NULL, DB2JDBENV);
      break;
    }
    
    __os_ufree(db->dbenv, result);
  }
  
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1sync(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_sync(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1truncate(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  u_int32_t arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)Db_truncate(arg1,arg2,arg3);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1upgrade(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
  struct Db *arg1 = (struct Db *) 0 ;
  char *arg2 = (char *) 0 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_upgrade(arg1,(char const *)arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1verify0(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3, jobject jarg4, jint jarg5) {
  jboolean jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  struct __db_out_stream arg4 ;
  u_int32_t arg5 ;
  int_bool result;
  struct __dbj_verify_data data4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  {
    data4.jenv = jenv;
    data4.streamobj = jarg4;
    data4.bytes = NULL;
    data4.nbytes = 0;
    (&arg4)->handle = &data4;
    (&arg4)->callback = __dbj_verify_callback;
  }
  arg5 = (u_int32_t)jarg5; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int_bool)Db_verify(arg1,(char const *)arg2,(char const *)arg3,arg4,arg5);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (result) ? JNI_TRUE : JNI_FALSE; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Dbc_1close0(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  struct Dbc *arg1 = (struct Dbc *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Dbc **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Dbc_close(arg1);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Dbc_1count(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  struct Dbc *arg1 = (struct Dbc *) 0 ;
  u_int32_t arg2 ;
  db_recno_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Dbc **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (db_recno_t)Dbc_count(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DBC2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Dbc_1del(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  struct Dbc *arg1 = (struct Dbc *) 0 ;
  u_int32_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Dbc **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  result = (int)Dbc_del(arg1,arg2);
  if (!DB_RETOK_DBCDEL(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DBC2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Dbc_1dup(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  struct Dbc *arg1 = (struct Dbc *) 0 ;
  u_int32_t arg2 ;
  DBC *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Dbc **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DBC *)Dbc_dup(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DBC2JDBENV);
  }
  
  *(DBC **)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Dbc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jobject jarg3, jint jarg4) {
  jint jresult = 0 ;
  struct Dbc *arg1 = (struct Dbc *) 0 ;
  DBT *arg2 = (DBT *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  u_int32_t arg4 ;
  int result;
  DBT_LOCKED ldbt2 ;
  DBT_LOCKED ldbt3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Dbc **)&jarg1; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt2, &arg2, jarg2, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  result = (int)Dbc_get(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_DBCGET(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DBC2JDBENV);
  }
  
  jresult = (jint)result; 
  __dbj_dbt_release(jenv, jarg2, arg2, &ldbt2); 
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Dbc_1pget(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jobject jarg3, jobject jarg4, jint jarg5) {
  jint jresult = 0 ;
  struct Dbc *arg1 = (struct Dbc *) 0 ;
  DBT *arg2 = (DBT *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  DBT *arg4 = (DBT *) 0 ;
  u_int32_t arg5 ;
  int result;
  DBT_LOCKED ldbt2 ;
  DBT_LOCKED ldbt3 ;
  DBT_LOCKED ldbt4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Dbc **)&jarg1; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt2, &arg2, jarg2, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  
  if (__dbj_dbt_copyin(jenv, &ldbt4, &arg4, jarg4, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg5 = (u_int32_t)jarg5; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  result = (int)Dbc_pget(arg1,arg2,arg3,arg4,arg5);
  if (!DB_RETOK_DBCGET(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DBC2JDBENV);
  }
  
  jresult = (jint)result; 
  __dbj_dbt_release(jenv, jarg2, arg2, &ldbt2); 
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
  __dbj_dbt_release(jenv, jarg4, arg4, &ldbt4); 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Dbc_1put(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jobject jarg3, jint jarg4) {
  jint jresult = 0 ;
  struct Dbc *arg1 = (struct Dbc *) 0 ;
  DBT *arg2 = (DBT *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  u_int32_t arg4 ;
  int result;
  DBT_LOCKED ldbt2 ;
  DBT_LOCKED ldbt3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct Dbc **)&jarg1; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt2, &arg2, jarg2, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  result = (int)Dbc_put(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_DBCPUT(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DBC2JDBENV);
  }
  
  jresult = (jint)result; 
  __dbj_dbt_release(jenv, jarg2, arg2, &ldbt2); 
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_new_1DbEnv(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  u_int32_t arg1 ;
  struct DbEnv *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (u_int32_t)jarg1; 
  
  errno = 0;
  result = (struct DbEnv *)new_DbEnv(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  *(struct DbEnv **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1close0(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_close(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1dbremove(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jint jarg5) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  u_int32_t arg5 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return ;
  }
  arg5 = (u_int32_t)jarg5; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_dbremove(arg1,arg2,(char const *)arg3,(char const *)arg4,arg5);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4);
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1dbrename(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jint jarg6) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  char *arg5 = (char *) 0 ;
  u_int32_t arg6 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return ;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg5, 0);
    if (!arg5) return ;
  }
  arg6 = (u_int32_t)jarg6; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_dbrename(arg1,arg2,(char const *)arg3,(char const *)arg4,(char const *)arg5,arg6);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, arg4);
  if (arg5) (*jenv)->ReleaseStringUTFChars(jenv, jarg5, arg5);
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1err(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  char *arg3 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  DbEnv_err(arg1,arg2,(char const *)arg3); 
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1errx(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  DbEnv_errx(arg1,(char const *)arg2); 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1cdsgroup_1begin(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DB_TXN *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  result = (DB_TXN *)DbEnv_cdsgroup_begin(arg1); 
  *(DB_TXN **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1fileid_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  result = (db_ret_t)DbEnv_fileid_reset(arg1,(char const *)arg2,arg3); 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jobjectArray JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1data_1dirs(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jobjectArray jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char **)DbEnv_get_data_dirs(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  {
    if (result != NULL) {
      /*@SWIG:STRING_ARRAY_OUT@*/	int i, len;
      
      len = 0;
      while (result[len] != NULL)
      len++;
      if ((jresult = (*jenv)->NewObjectArray(jenv, (jsize)len, string_class,
            NULL)) == NULL)
      return 0; /* an exception is pending */
      for (i = 0; i < len; i++) {
        jstring str = (*jenv)->NewStringUTF(jenv, result[i]);
        (*jenv)->SetObjectArrayElement(jenv, jresult, (jsize)i, str);
      }
      /*@SWIG@*/
    }
  }
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1encrypt_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_encrypt_flags(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_flags(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1home(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char *)DbEnv_get_home(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1open_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_open_flags(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1shm_1key(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  long result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (long)DbEnv_get_shm_key(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jlong)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1tmp_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char *)DbEnv_get_tmp_dir(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1verbose(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  int_bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int_bool)DbEnv_get_verbose(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (result) ? JNI_TRUE : JNI_FALSE; 
  return jresult;
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1is_1bigendian(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int_bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  result = (int_bool)DbEnv_is_bigendian(arg1); 
  jresult = (result) ? JNI_TRUE : JNI_FALSE; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1lsn_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_lsn_reset(arg1,(char const *)arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1open(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3, jint jarg4) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  u_int32_t arg3 ;
  int arg4 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (u_int32_t)jarg3; 
  arg4 = (int)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_open(arg1,(char const *)arg2,arg3,arg4);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1remove0(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_remove(arg1,(char const *)arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1cachesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  jlong arg2 ;
  int arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = jarg2; 
  arg3 = (int)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_cachesize(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1data_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_data_dir(arg1,(char const *)arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1intermediate_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_intermediate_dir(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1encrypt(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_encrypt(arg1,(char const *)arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1errcall(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  void (*arg2)(DB_ENV const *,char const *,char const *) = (void (*)(DB_ENV const *,char const *,char const *)) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  arg2 = (jarg2 == NULL) ? NULL : __dbj_error;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  DbEnv_set_errcall(arg1,arg2); 
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jboolean jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  int_bool arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (jarg3 == JNI_TRUE); 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_flags(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1feedback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  void (*arg2)(DB_ENV *,int,int) = (void (*)(DB_ENV *,int,int)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  arg2 = (jarg2 == NULL) ? NULL : __dbj_env_feedback;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_feedback(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1mp_1max_1openfd(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_mp_max_openfd(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1mp_1max_1write(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  int arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_mp_max_write(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1mp_1mmapsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  size_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (size_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_mp_mmapsize(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1msgcall(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  void (*arg2)(DB_ENV const *,char const *) = (void (*)(DB_ENV const *,char const *)) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  arg2 = (jarg2 == NULL) ? NULL : __dbj_message;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  DbEnv_set_msgcall(arg1,arg2); 
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1paniccall(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  void (*arg2)(DB_ENV *,int) = (void (*)(DB_ENV *,int)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  arg2 = (jarg2 == NULL) ? NULL : __dbj_panic;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_paniccall(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1rpc_1server(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jlong jarg4, jint jarg5) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  long arg3 ;
  long arg4 ;
  u_int32_t arg5 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (long)jarg3; 
  arg4 = (long)jarg4; 
  arg5 = (u_int32_t)jarg5; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_rpc_server(arg1,arg2,arg3,arg4,arg5);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1shm_1key(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  long arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (long)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_shm_key(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1timeout(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  db_timeout_t arg2 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (db_timeout_t)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_timeout(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1tmp_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_tmp_dir(arg1,(char const *)arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1tx_1max(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_tx_max(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1app_1dispatch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int (*arg2)(DB_ENV *,DBT *,DB_LSN *,db_recops) = (int (*)(DB_ENV *,DBT *,DB_LSN *,db_recops)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  arg2 = (jarg2 == NULL) ? NULL : __dbj_app_dispatch;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_app_dispatch(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1event_1notify(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  void (*arg2)(DB_ENV *,u_int32_t,void *) = (void (*)(DB_ENV *,u_int32_t,void *)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  arg2 = (jarg2 == NULL) ? NULL : __dbj_event_notify;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_event_notify(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1tx_1timestamp0(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  time_t *arg2 = (time_t *) 0 ;
  db_ret_t result;
  time_t time2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  time2 = (time_t)jarg2;
  arg2 = &time2;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_tx_timestamp(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1verbose(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jboolean jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  int_bool arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (jarg3 == JNI_TRUE); 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_verbose(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT jobjectArray JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lk_1conflicts(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jobjectArray jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  struct __db_lk_conflicts result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = DbEnv_get_lk_conflicts(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  {
    int i;
    jbyteArray bytes;
    
    jresult = (*jenv)->NewObjectArray(jenv,
      (jsize)(&result)->lk_modes, bytearray_class, NULL);
    if (jresult == NULL)
    return 0; /* an exception is pending */
    for (i = 0; i < (&result)->lk_modes; i++) {
      bytes = (*jenv)->NewByteArray(jenv, (jsize)(&result)->lk_modes);
      if (bytes == NULL)
      return 0; /* an exception is pending */
      (*jenv)->SetByteArrayRegion(jenv, bytes, 0, (jsize)(&result)->lk_modes,
        (jbyte *)((&result)->lk_conflicts + i * (&result)->lk_modes));
      (*jenv)->SetObjectArrayElement(jenv, jresult, (jsize)i, bytes);
    }
  }
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lk_1detect(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_lk_detect(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lk_1max_1locks(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_lk_max_locks(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lk_1max_1lockers(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_lk_max_lockers(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lk_1max_1objects(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_lk_max_objects(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1lock_1detect(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  u_int32_t arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_lock_detect(arg1,arg2,arg3);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1lock_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jobject jarg4, jint jarg5) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  u_int32_t arg3 ;
  DBT *arg4 = (DBT *) 0 ;
  db_lockmode_t arg5 ;
  DB_LOCK *result = 0 ;
  DBT_LOCKED ldbt4 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt4, &arg4, jarg4, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg5 = (db_lockmode_t)jarg5; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_LOCK *)DbEnv_lock_get(arg1,arg2,arg3,(struct Dbt const *)arg4,arg5);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  *(DB_LOCK **)&jresult = result; 
  __dbj_dbt_release(jenv, jarg4, arg4, &ldbt4); 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1lock_1id(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_lock_id(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1lock_1id_1free(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_lock_id_free(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1lock_1put(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DB_LOCK *arg2 = (DB_LOCK *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = *(DB_LOCK **)&jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_lock_put(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT jobject JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1lock_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jobject jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  DB_LOCK_STAT *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_LOCK_STAT *)DbEnv_lock_stat(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  
  jresult = (*jenv)->NewObject(jenv, lock_stat_class, lock_stat_construct);
  if (jresult != NULL)
  __dbj_fill_lock_stat(jenv, jresult, result);
  __os_ufree(NULL, result);
  
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lk_1conflicts(JNIEnv *jenv, jclass jcls, jlong jarg1, jobjectArray jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  struct __db_lk_conflicts arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  {
    int i, len, err;
    size_t bytesize;
    
    len = (&arg2)->lk_modes = (*jenv)->GetArrayLength(jenv, jarg2);
    bytesize = sizeof(u_char) * len * len;
    
    if ((err = __os_malloc(NULL, bytesize, &(&arg2)->lk_conflicts)) != 0) {
      __dbj_throw(jenv, err, NULL, NULL, JDBENV);
      return ;
    }
    
    for (i = 0; i < len; i++) {
      jobject sub_array = (*jenv)->GetObjectArrayElement(jenv,
        jarg2, i);
      (*jenv)->GetByteArrayRegion(jenv,(jbyteArray)sub_array, 0, len,
        (jbyte *)&(&arg2)->lk_conflicts[i * len]);
    }
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lk_conflicts(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  
  __os_free(NULL, (&arg2)->lk_conflicts);
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lk_1detect(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lk_detect(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lk_1max_1lockers(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lk_max_lockers(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lk_1max_1locks(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lk_max_locks(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lk_1max_1objects(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lk_max_objects(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lg_1bsize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_lg_bsize(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lg_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char *)DbEnv_get_lg_dir(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lg_1filemode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_get_lg_filemode(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lg_1max(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_lg_max(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lg_1regionmax(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_lg_regionmax(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jobjectArray JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1log_1archive(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jobjectArray jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char **)DbEnv_log_archive(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  {
    if (result != NULL) {
      /*@SWIG:STRING_ARRAY_OUT@*/	int i, len;
      
      len = 0;
      while (result[len] != NULL)
      len++;
      if ((jresult = (*jenv)->NewObjectArray(jenv, (jsize)len, string_class,
            NULL)) == NULL)
      return 0; /* an exception is pending */
      for (i = 0; i < len; i++) {
        jstring str = (*jenv)->NewStringUTF(jenv, result[i]);
        (*jenv)->SetObjectArrayElement(jenv, jresult, (jsize)i, str);
      }
      /*@SWIG@*/
      __os_ufree(NULL, result);
    }
  }
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1log_1compare(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jint jresult = 0 ;
  DB_LSN *arg1 = (DB_LSN *) 0 ;
  DB_LSN *arg2 = (DB_LSN *) 0 ;
  int result;
  DB_LSN lsn1 ;
  DB_LSN lsn2 ;
  
  (void)jenv;
  (void)jcls;
  
  if (jarg1 == NULL) {
    arg1 = NULL;
  } else {
    arg1 = &lsn1;
    arg1->file = (*jenv)->GetIntField(jenv, jarg1, dblsn_file_fid);
    arg1->offset = (*jenv)->GetIntField(jenv, jarg1,
      dblsn_offset_fid);
  }
  
  
  if (jarg2 == NULL) {
    arg2 = NULL;
  } else {
    arg2 = &lsn2;
    arg2->file = (*jenv)->GetIntField(jenv, jarg2, dblsn_file_fid);
    arg2->offset = (*jenv)->GetIntField(jenv, jarg2,
      dblsn_offset_fid);
  }
  
  
  if (arg1 == NULL) {
    __dbj_throw(jenv, EINVAL, "null LogSequenceNumber", NULL, NULL);
    return 0;
  }
  
  
  if (arg2 == NULL) {
    __dbj_throw(jenv, EINVAL, "null LogSequenceNumber", NULL, NULL);
    return 0;
  }
  
  result = (int)DbEnv_log_compare((struct DbLsn const *)arg1,(struct DbLsn const *)arg2); 
  jresult = (jint)result; 
  
  if (jarg1 != NULL) {
    (*jenv)->SetIntField(jenv, jarg1, dblsn_file_fid, arg1->file);
    (*jenv)->SetIntField(jenv, jarg1,
      dblsn_offset_fid, arg1->offset);
  }
  
  
  if (jarg2 != NULL) {
    (*jenv)->SetIntField(jenv, jarg2, dblsn_file_fid, arg2->file);
    (*jenv)->SetIntField(jenv, jarg2,
      dblsn_offset_fid, arg2->offset);
  }
  
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1log_1cursor(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  DB_LOGC *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_LOGC *)DbEnv_log_cursor(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  *(DB_LOGC **)&jresult = result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1log_1file(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
  jstring jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DB_LSN *arg2 = (DB_LSN *) 0 ;
  char *result = 0 ;
  DB_LSN lsn2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg2 == NULL) {
    arg2 = NULL;
  } else {
    arg2 = &lsn2;
    arg2->file = (*jenv)->GetIntField(jenv, jarg2, dblsn_file_fid);
    arg2->offset = (*jenv)->GetIntField(jenv, jarg2,
      dblsn_offset_fid);
  }
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  if (arg2 == NULL) {
    __dbj_throw(jenv, EINVAL, "null LogSequenceNumber", NULL, NULL);
    return 0;
  }
  
  
  errno = 0;
  result = (char *)DbEnv_log_file(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  
  if (jarg2 != NULL) {
    (*jenv)->SetIntField(jenv, jarg2, dblsn_file_fid, arg2->file);
    (*jenv)->SetIntField(jenv, jarg2,
      dblsn_offset_fid, arg2->offset);
  }
  
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1log_1flush(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DB_LSN *arg2 = (DB_LSN *) 0 ;
  db_ret_t result;
  DB_LSN lsn2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg2 == NULL) {
    arg2 = NULL;
  } else {
    arg2 = &lsn2;
    arg2->file = (*jenv)->GetIntField(jenv, jarg2, dblsn_file_fid);
    arg2->offset = (*jenv)->GetIntField(jenv, jarg2,
      dblsn_offset_fid);
  }
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  
  result = (db_ret_t)DbEnv_log_flush(arg1,(struct DbLsn const *)arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  
  if (jarg2 != NULL) {
    (*jenv)->SetIntField(jenv, jarg2, dblsn_file_fid, arg2->file);
    (*jenv)->SetIntField(jenv, jarg2,
      dblsn_offset_fid, arg2->offset);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1log_1put(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jobject jarg3, jint jarg4) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DB_LSN *arg2 = (DB_LSN *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  u_int32_t arg4 ;
  db_ret_t result;
  DB_LSN lsn2 ;
  DBT_LOCKED ldbt3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg2 == NULL) {
    arg2 = NULL;
  } else {
    arg2 = &lsn2;
    arg2->file = (*jenv)->GetIntField(jenv, jarg2, dblsn_file_fid);
    arg2->offset = (*jenv)->GetIntField(jenv, jarg2,
      dblsn_offset_fid);
  }
  
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return ; /* An exception will be pending. */
  }
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  if (arg2 == NULL) {
    __dbj_throw(jenv, EINVAL, "null LogSequenceNumber", NULL, NULL);
    return ;
  }
  
  
  result = (db_ret_t)DbEnv_log_put(arg1,arg2,(struct Dbt const *)arg3,arg4);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  
  if (jarg2 != NULL) {
    (*jenv)->SetIntField(jenv, jarg2, dblsn_file_fid, arg2->file);
    (*jenv)->SetIntField(jenv, jarg2,
      dblsn_offset_fid, arg2->offset);
  }
  
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1log_1print(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  char *arg3 = (char *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_log_print(arg1,arg2,(char const *)arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, arg3);
}


JNIEXPORT jobject JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1log_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jobject jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  DB_LOG_STAT *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_LOG_STAT *)DbEnv_log_stat(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  
  jresult = (*jenv)->NewObject(jenv, log_stat_class, log_stat_construct);
  if (jresult != NULL)
  __dbj_fill_log_stat(jenv, jresult, result);
  __os_ufree(NULL, result);
  
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lg_1bsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lg_bsize(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lg_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lg_dir(arg1,(char const *)arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lg_1filemode(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lg_filemode(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lg_1max(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lg_max(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lg_1regionmax(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lg_regionmax(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1cachesize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  jlong result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = DbEnv_get_cachesize(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1cachesize_1ncache(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_get_cachesize_ncache(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1mp_1max_1openfd(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_get_mp_max_openfd(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1mp_1max_1write(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_get_mp_max_write(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1mp_1max_1write_1sleep(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_get_mp_max_write_sleep(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1mp_1mmapsize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = DbEnv_get_mp_mmapsize(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jlong)result; 
  return jresult;
}


JNIEXPORT jobject JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1memp_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jobject jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  DB_MPOOL_STAT *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_MPOOL_STAT *)DbEnv_memp_stat(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  
  jresult = (*jenv)->NewObject(jenv, mpool_stat_class, mpool_stat_construct);
  if (jresult != NULL)
  __dbj_fill_mpool_stat(jenv, jresult, result);
  __os_ufree(NULL, result);
  
  return jresult;
}


JNIEXPORT jobjectArray JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1memp_1fstat(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jobjectArray jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  DB_MPOOL_FSTAT **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_MPOOL_FSTAT **)DbEnv_memp_fstat(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  {
    int i, len;
    
    len = 0;
    while (result[len] != NULL)
    len++;
    jresult = (*jenv)->NewObjectArray(jenv, (jsize)len,
      mpool_fstat_class, 0);
    if (jresult == NULL) {
      __os_ufree(NULL, result);
      return 0;
    }
    for (i = 0; i < len; i++) {
      jobject obj = (*jenv)->NewObject(jenv, mpool_fstat_class,
        mpool_fstat_construct);
      if (obj == NULL) {
        __os_ufree(NULL, result);
        return 0; /* an exception is pending */
      }
      (*jenv)->SetObjectArrayElement(jenv, jresult, i, obj);
      __dbj_fill_mpool_fstat(jenv, obj, result[i]);
    }
    __os_ufree(NULL, result);
  }
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1memp_1trickle(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_memp_trickle(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1mutex_1get_1align(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_mutex_get_align(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1mutex_1get_1increment(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_mutex_get_increment(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1mutex_1get_1max(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_mutex_get_max(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1mutex_1get_1tas_1spins(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_mutex_get_tas_spins(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1mutex_1set_1align(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_mutex_set_align(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1mutex_1set_1increment(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_mutex_set_increment(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1mutex_1set_1max(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_mutex_set_max(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1mutex_1set_1tas_1spins(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_mutex_set_tas_spins(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT jobject JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1mutex_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jobject jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  DB_MUTEX_STAT *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_MUTEX_STAT *)DbEnv_mutex_stat(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  
  jresult = (*jenv)->NewObject(jenv, mutex_stat_class, mutex_stat_construct);
  if (jresult != NULL)
  __dbj_fill_mutex_stat(jenv, jresult, result);
  __os_ufree(NULL, result);
  
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1tx_1max(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_tx_max(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1tx_1timestamp(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  time_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = DbEnv_get_tx_timestamp(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jlong)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1timeout(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_timeout_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (db_timeout_t)DbEnv_get_timeout(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jlong)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1txn_1begin(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  u_int32_t arg3 ;
  DB_TXN *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_TXN *)DbEnv_txn_begin(arg1,arg2,arg3);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  *(DB_TXN **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1txn_1checkpoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  u_int32_t arg3 ;
  u_int32_t arg4 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_txn_checkpoint(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT jobjectArray JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1txn_1recover(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  jobjectArray jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  u_int32_t arg3 ;
  DB_PREPLIST *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_PREPLIST *)DbEnv_txn_recover(arg1,arg2,arg3);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  {
    int i, len;
    
    len = 0;
    while (result[len].txn != NULL)
    len++;
    jresult = (*jenv)->NewObjectArray(jenv, (jsize)len, dbpreplist_class,
      NULL);
    if (jresult == NULL)
    return 0; /* an exception is pending */
    for (i = 0; i < len; i++) {
      jobject jtxn = (*jenv)->NewObject(jenv, dbtxn_class,
        dbtxn_construct, result[i].txn, JNI_FALSE);
      jobject bytearr = (*jenv)->NewByteArray(jenv,
        (jsize)sizeof(result[i].gid));
      jobject obj = (*jenv)->NewObject(jenv, dbpreplist_class,
        dbpreplist_construct, jtxn, bytearr);
      
      if (jtxn == NULL || bytearr == NULL || obj == NULL)
      return 0; /* An exception is pending */
      
      (*jenv)->SetByteArrayRegion(jenv, bytearr, 0,
        (jsize)sizeof(result[i].gid), (jbyte *)result[i].gid);
      (*jenv)->SetObjectArrayElement(jenv, jresult, i, obj);
    }
    __os_ufree(NULL, result);
  }
  return jresult;
}


JNIEXPORT jobject JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1txn_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jobject jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  DB_TXN_STAT *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_TXN_STAT *)DbEnv_txn_stat(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  {
    unsigned int i;
    jobjectArray actives;
    jresult = (*jenv)->NewObject(jenv, txn_stat_class, txn_stat_construct);
    if (jresult != NULL)
    __dbj_fill_txn_stat(jenv, jresult, result);
    
    actives = (*jenv)->NewObjectArray(jenv, (jsize)result->st_nactive,
      txn_active_class, 0);
    if (actives == NULL) {
      __os_ufree(NULL, result);
      return 0;
    }
    (*jenv)->SetObjectField(jenv, jresult,
      txn_stat_st_txnarray_fid, actives);
    for (i = 0; i < result->st_nactive; i++) {
      jobject obj = (*jenv)->NewObject(jenv, txn_active_class,
        txn_active_construct);
      if (obj == NULL) {
        __os_ufree(NULL, result);
        return 0; /* an exception is pending */
      }
      (*jenv)->SetObjectArrayElement(jenv, actives, (jsize)i, obj);
      __dbj_fill_txn_active(jenv, obj, &result->st_txnarray[i]);
    }
    __os_ufree(NULL, result);
  }
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1get_1limit(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  jlong result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = DbEnv_rep_get_limit(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1elect(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  int arg3 ;
  u_int32_t arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_rep_elect(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1process_1message(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jobject jarg3, jobject jarg4, jobject jarg5) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DBT *arg2 = (DBT *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  int *arg4 = (int *) 0 ;
  DB_LSN *arg5 = (DB_LSN *) 0 ;
  int result;
  DBT_LOCKED ldbt2 ;
  DBT_LOCKED ldbt3 ;
  int id4 ;
  DB_LSN lsn5 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt2, &arg2, jarg2, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  
  id4 = (*jenv)->GetIntField(jenv, jarg4, rep_processmsg_envid_fid);
  arg4 = &id4;
  
  
  if (jarg5 == NULL) {
    arg5 = NULL;
  } else {
    arg5 = &lsn5;
    arg5->file = (*jenv)->GetIntField(jenv, jarg5, dblsn_file_fid);
    arg5->offset = (*jenv)->GetIntField(jenv, jarg5,
      dblsn_offset_fid);
  }
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  if (arg5 == NULL) {
    __dbj_throw(jenv, EINVAL, "null LogSequenceNumber", NULL, NULL);
    return 0;
  }
  
  
  result = (int)DbEnv_rep_process_message(arg1,arg2,arg3,arg4,arg5);
  if (!DB_RETOK_REPPMSG(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  
  (*jenv)->SetIntField(jenv, jarg4, rep_processmsg_envid_fid, *arg4);
  
  __dbj_dbt_release(jenv, jarg2, arg2, &ldbt2); 
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
  
  if (jarg5 != NULL) {
    (*jenv)->SetIntField(jenv, jarg5, dblsn_file_fid, arg5->file);
    (*jenv)->SetIntField(jenv, jarg5,
      dblsn_offset_fid, arg5->offset);
  }
  
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1flush(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_rep_flush(arg1);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1set_1config(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jboolean jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  int_bool arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (jarg3 == JNI_TRUE); 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_rep_set_config(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1start(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DBT *arg2 = (DBT *) 0 ;
  u_int32_t arg3 ;
  db_ret_t result;
  DBT_LOCKED ldbt2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt2, &arg2, jarg2, 1) != 0) {
    return ; /* An exception will be pending. */
  }
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_rep_start(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  __dbj_dbt_release(jenv, jarg2, arg2, &ldbt2); 
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1sync(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_rep_sync(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT jboolean JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1get_1config(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jboolean jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  int_bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int_bool)DbEnv_rep_get_config(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (result) ? JNI_TRUE : JNI_FALSE; 
  return jresult;
}


JNIEXPORT jobject JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jobject jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  DB_REP_STAT *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_REP_STAT *)DbEnv_rep_stat(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  
  jresult = (*jenv)->NewObject(jenv, rep_stat_class, rep_stat_construct);
  if (jresult != NULL)
  __dbj_fill_rep_stat(jenv, jresult, result);
  __os_ufree(NULL, result);
  
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1set_1limit(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  jlong arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_rep_set_limit(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1rep_1request(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_rep_request(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1set_1transport(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jobject jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  int (*arg3)(DB_ENV *,DBT const *,DBT const *,DB_LSN const *,int,u_int32_t) = (int (*)(DB_ENV *,DBT const *,DBT const *,DB_LSN const *,int,u_int32_t)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  
  arg3 = (jarg3 == NULL) ? NULL : __dbj_rep_transport;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_rep_set_transport(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1get_1nsites(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_rep_get_nsites(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1get_1priority(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_rep_get_priority(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1get_1timeout(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_rep_get_timeout(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1set_1nsites(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_rep_set_nsites(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1set_1priority(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_rep_set_priority(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1set_1timeout(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  db_timeout_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (db_timeout_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_rep_set_timeout(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1repmgr_1add_1remote_1site(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3, jint jarg4) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  u_int32_t arg3 ;
  u_int32_t arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (u_int32_t)jarg3; 
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_repmgr_add_remote_site(arg1,(char const *)arg2,arg3,arg4);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1repmgr_1get_1ack_1policy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_repmgr_get_ack_policy(arg1);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1repmgr_1set_1ack_1policy(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_repmgr_set_ack_policy(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1repmgr_1set_1local_1site(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3, jint jarg4) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  u_int32_t arg3 ;
  u_int32_t arg4 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (u_int32_t)jarg3; 
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_repmgr_set_local_site(arg1,(char const *)arg2,arg3,arg4);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


JNIEXPORT jobjectArray JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1repmgr_1site_1list(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jobjectArray jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  struct __db_repmgr_sites result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = DbEnv_repmgr_site_list(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  {
    int i, len;
    
    len = (&result)->nsites;
    jresult = (*jenv)->NewObjectArray(jenv, (jsize)len, rephost_class,
      NULL);
    if (jresult == NULL)
    return 0; /* an exception is pending */
    for (i = 0; i < len; i++) {
      jobject jrep_addr = (*jenv)->NewObject(jenv,
        rephost_class, rephost_construct);
      
      (*jenv)->SetObjectField(jenv, jrep_addr, rephost_host_fid,
        (*jenv)->NewStringUTF(jenv, (&result)->sites[i].host));
      (*jenv)->SetIntField(jenv, jrep_addr, rephost_port_fid,
        (&result)->sites[i].port);
      (*jenv)->SetIntField(jenv, jrep_addr, rephost_eid_fid,
        (&result)->sites[i].eid);
      (*jenv)->SetIntField(jenv, jrep_addr, rephost_status_fid,
        (&result)->sites[i].status);
      
      if (jrep_addr == NULL)
      return 0; /* An exception is pending */
      
      (*jenv)->SetObjectArrayElement(jenv, jresult, i, jrep_addr);
    }
    __os_ufree(NULL, (&result)->sites);
  }
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1repmgr_1start(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_repmgr_start(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1strerror(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  int arg1 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (char *)DbEnv_strerror(arg1); 
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1version_1major(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)DbEnv_get_version_major(); 
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1version_1minor(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)DbEnv_get_version_minor(); 
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1version_1patch(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)DbEnv_get_version_patch(); 
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1version_1string(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)DbEnv_get_version_string(); 
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_delete_1DbLock(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  struct DbLock *arg1 = (struct DbLock *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbLock **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  delete_DbLock(arg1);
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbLogc_1close0(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbLogc *arg1 = (struct DbLogc *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbLogc **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbLogc_close(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbLogc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2, jobject jarg3, jint jarg4) {
  jint jresult = 0 ;
  struct DbLogc *arg1 = (struct DbLogc *) 0 ;
  DB_LSN *arg2 = (DB_LSN *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  u_int32_t arg4 ;
  int result;
  DB_LSN lsn2 ;
  DBT_LOCKED ldbt3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbLogc **)&jarg1; 
  
  if (jarg2 == NULL) {
    arg2 = NULL;
  } else {
    arg2 = &lsn2;
    arg2->file = (*jenv)->GetIntField(jenv, jarg2, dblsn_file_fid);
    arg2->offset = (*jenv)->GetIntField(jenv, jarg2,
      dblsn_offset_fid);
  }
  
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  if (arg2 == NULL) {
    __dbj_throw(jenv, EINVAL, "null LogSequenceNumber", NULL, NULL);
    return 0;
  }
  
  
  result = (int)DbLogc_get(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_LGGET(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
  jresult = (jint)result; 
  
  if (jarg2 != NULL) {
    (*jenv)->SetIntField(jenv, jarg2, dblsn_file_fid, arg2->file);
    (*jenv)->SetIntField(jenv, jarg2,
      dblsn_offset_fid, arg2->offset);
  }
  
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbMpoolFile_1get_1priority(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbMpoolFile *arg1 = (struct DbMpoolFile *) 0 ;
  DB_CACHE_PRIORITY result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbMpoolFile **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_CACHE_PRIORITY)DbMpoolFile_get_priority(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbMpoolFile_1set_1priority(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbMpoolFile *arg1 = (struct DbMpoolFile *) 0 ;
  DB_CACHE_PRIORITY arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbMpoolFile **)&jarg1; 
  arg2 = (DB_CACHE_PRIORITY)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbMpoolFile_set_priority(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbMpoolFile_1get_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbMpoolFile *arg1 = (struct DbMpoolFile *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbMpoolFile **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbMpoolFile_get_flags(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbMpoolFile_1set_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jboolean jarg3) {
  struct DbMpoolFile *arg1 = (struct DbMpoolFile *) 0 ;
  u_int32_t arg2 ;
  int_bool arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbMpoolFile **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (jarg3 == JNI_TRUE); 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbMpoolFile_set_flags(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbMpoolFile_1get_1maxsize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  struct DbMpoolFile *arg1 = (struct DbMpoolFile *) 0 ;
  jlong result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbMpoolFile **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = DbMpoolFile_get_maxsize(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbMpoolFile_1set_1maxsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  struct DbMpoolFile *arg1 = (struct DbMpoolFile *) 0 ;
  jlong arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbMpoolFile **)&jarg1; 
  arg2 = jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbMpoolFile_set_maxsize(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_new_1DbSequence(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  DB *arg1 = (DB *) 0 ;
  u_int32_t arg2 ;
  struct DbSequence *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DB **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  errno = 0;
  result = (struct DbSequence *)new_DbSequence(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  *(struct DbSequence **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1close0(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbSequence **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbSequence_close(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  int32_t arg3 ;
  u_int32_t arg4 ;
  db_seq_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbSequence **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  arg3 = (int32_t)jarg3; 
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (db_seq_t)DbSequence_get(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (jlong)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1get_1cachesize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbSequence **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int32_t)DbSequence_get_cachesize(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1get_1db(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  DB *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbSequence **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB *)DbSequence_get_db(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  *(DB **)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1get_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbSequence **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbSequence_get_flags(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1get_1key(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  DBT *arg2 = (DBT *) 0 ;
  db_ret_t result;
  DBT_LOCKED ldbt2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbSequence **)&jarg1; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt2, &arg2, jarg2, 0) != 0) {
    return ; /* An exception will be pending. */
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbSequence_get_key(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
  __dbj_dbt_release(jenv, jarg2, arg2, &ldbt2); 
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1get_1range_1min(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  db_seq_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbSequence **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (db_seq_t)DbSequence_get_range_min(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (jlong)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1get_1range_1max(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  db_seq_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbSequence **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (db_seq_t)DbSequence_get_range_max(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (jlong)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1initial_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  db_seq_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbSequence **)&jarg1; 
  arg2 = (db_seq_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbSequence_initial_value(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1open(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg3, jint jarg4) {
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  u_int32_t arg4 ;
  db_ret_t result;
  DBT_LOCKED ldbt3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbSequence **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return ; /* An exception will be pending. */
  }
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbSequence_open(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1remove0(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbSequence **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbSequence_remove(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1set_1cachesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbSequence **)&jarg1; 
  arg2 = (int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbSequence_set_cachesize(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1set_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbSequence **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbSequence_set_flags(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1set_1range(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  db_seq_t arg2 ;
  db_seq_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbSequence **)&jarg1; 
  arg2 = (db_seq_t)jarg2; 
  arg3 = (db_seq_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbSequence_set_range(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


JNIEXPORT jobject JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jobject jresult = 0 ;
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  u_int32_t arg2 ;
  DB_SEQUENCE_STAT *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbSequence **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_SEQUENCE_STAT *)DbSequence_stat(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  
  jresult = (*jenv)->NewObject(jenv, seq_stat_class, seq_stat_construct);
  if (jresult != NULL)
  __dbj_fill_seq_stat(jenv, jresult, result);
  __os_ufree(NULL, result);
  
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbTxn_1abort0(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  struct DbTxn *arg1 = (struct DbTxn *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbTxn **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbTxn_abort(arg1);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbTxn_1commit0(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbTxn *arg1 = (struct DbTxn *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbTxn **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbTxn_commit(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbTxn_1discard0(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  struct DbTxn *arg1 = (struct DbTxn *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbTxn **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbTxn_discard(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


JNIEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbTxn_1get_1name(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jstring jresult = 0 ;
  struct DbTxn *arg1 = (struct DbTxn *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbTxn **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char *)DbTxn_get_name(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, TXN2JDBENV);
  }
  
  if(result) jresult = (*jenv)->NewStringUTF(jenv, result);
  return jresult;
}


JNIEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbTxn_1id(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  struct DbTxn *arg1 = (struct DbTxn *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbTxn **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  result = (u_int32_t)DbTxn_id(arg1); 
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbTxn_1prepare(JNIEnv *jenv, jclass jcls, jlong jarg1, jbyteArray jarg2) {
  struct DbTxn *arg1 = (struct DbTxn *) 0 ;
  u_int8_t *arg2 = (u_int8_t *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbTxn **)&jarg1; 
  
  arg2 = (u_int8_t *)(*jenv)->GetByteArrayElements(jenv, jarg2, NULL);
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  if ((*jenv)->GetArrayLength(jenv, jarg2) < DB_XIDDATASIZE) {
    __dbj_throw(jenv, EINVAL,
      "DbTxn.prepare gid array must be >= 128 bytes", NULL,
      TXN2JDBENV);
    return ;
  }
  
  
  result = (db_ret_t)DbTxn_prepare(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, TXN2JDBENV);
  }
  
  
  (*jenv)->ReleaseByteArrayElements(jenv, jarg2, (jbyte *)arg2, 0);
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbTxn_1set_1timeout(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  struct DbTxn *arg1 = (struct DbTxn *) 0 ;
  db_timeout_t arg2 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbTxn **)&jarg1; 
  arg2 = (db_timeout_t)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbTxn_set_timeout(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, TXN2JDBENV);
  }
  
}


JNIEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbTxn_1set_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  struct DbTxn *arg1 = (struct DbTxn *) 0 ;
  char *arg2 = (char *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbTxn **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbTxn_set_name(arg1,(char const *)arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, TXN2JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, arg2);
}


#ifdef __cplusplus
}
#endif

