.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
glhanoi - OpenGL Towers of Hanoi
.SH SYNOPSIS
.B glhanoi
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-delay \fInumber\fP]
[\-count \fInumber\fP]
[\-speed \fInumber\fP]
[\-rotspeed \fInumber\fP]
[\-wireframe]
[\-light]
[\-texture]
[\-fog]
[\-fps]
.SH DESCRIPTION
Implementation of Towers of Hanoi in OpenGL
.SH OPTIONS
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-delay \fInumber\fP
Per-frame delay, in microseconds.  Default: 15000 (0.015 seconds.).
.TP 8
.B \-count \fInumber\fP
Number of disks.  Default: 7.
.TP 8
.B \-wireframe | \-no-wireframe
Render in wireframe instead of solid.
.TP 8
.B \-fog | \-no-fog
Render in fog.
.TP 8
.B \-fps | \-no-fps
Whether to show a frames-per-second display at the bottom of the screen.
.TP 8
.B \-light | -no-light
Whether the scene is lit.
.TP 8
.B \-texture | \-no-texture
Render with textures instead of solid.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2004 by Dave Atkinson.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Dave Atkinson.
