/*
 * Copyright (c) 2000 by Conectiva S.A. (http://www.conectiva.com)
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *  
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * CONECTIVA LINUX BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
 * OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * 
 * Except as contained in this notice, the name of Conectiva Linux shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in this Software without prior written authorization from
 * Conectiva Linux.
 *
 * Author: Paulo Csar Pereira de Andrade <pcpa@conectiva.com.br>
 *
 * $XFree86: xc/programs/Xserver/hw/xfree86/xf86cfg/screen.h,v 1.3 2000/12/01 18:31:07 paulo Exp $
 */

#include "xf86config.h"
#include "config.h"

#ifndef _xf86cfg_screen_h
#define _xf86cfg_screen_h

/*
 * Prototypes
 */
void AddScreen(xf86cfgDevice*, xf86cfgDevice*);
void RemoveScreen(xf86cfgDevice*, xf86cfgDevice*);

void DrawScreen(Display*, Drawable, int, int, int, int, Bool, int);
void DrawScreenMask(Display*, Drawable, GC, int, int, int, int, int);
void CreateScreenWidget(xf86cfgScreen*);
void SetScreenRotate(xf86cfgScreen*);

void AdjustScreenUI(void);
void UpdateScreenUI(void);

#endif /* _xf86cfg_screen_h */
