.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86: xc/doc/man/X11/XPutRes.man,v 1.6 2005/02/11 03:02:55 dawes Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XrmPutResource 3X11 __vendorversion__ "XLIB FUNCTIONS"
.SH NAME
XrmPutResource, XrmQPutResource, XrmPutStringResource, XrmQPutStringResource, XrmPutLineResource \- store database resources
.SH SYNTAX
.HP
void XrmPutResource\^(\^XrmDatabase *\fIdatabase\fP\^, char
*\fIspecifier\fP\^, char *\fItype\fP\^, XrmValue *\fIvalue\fP\^); 
.HP
void XrmQPutResource\^(\^XrmDatabase *\fIdatabase\fP\^, XrmBindingList
\fIbindings\fP\^, XrmQuarkList \fIquarks\fP\^, XrmRepresentation \fItype\fP\^,
XrmValue *\fIvalue\fP\^); 
.HP
void XrmPutStringResource\^(\^XrmDatabase *\fIdatabase\fP\^, char
*\fIspecifier\fP\^, char *\fIvalue\fP\^); 
.HP
void XrmQPutStringResource\^(\^XrmDatabase *\fIdatabase\fP\^, XrmBindingList
\fIbindings\fP\^, XrmQuarkList \fIquarks\fP\^, char *\fIvalue\fP\^); 
.HP
void XrmPutLineResource\^(\^XrmDatabase *\fIdatabase\fP\^, char
*\fIline\fP\^); 
.SH ARGUMENTS
.IP \fIbindings\fP 1i
Specifies a list of bindings.
.IP \fIdatabase\fP 1i
Specifies the resource database.
.IP \fIline\fP 1i
Specifies the resource name and value pair as a single string.
.IP \fIquarks\fP 1i
Specifies the complete or partial name or the class list of the resource.
.IP \fIspecifier\fP 1i
Specifies a complete or partial specification of the resource.
.IP \fItype\fP 1i
Specifies the type of the resource.
.IP \fIvalue\fP 1i
Specifies the value of the resource, which is specified as a string.
.SH DESCRIPTION
If database contains NULL,
.ZN XrmPutResource
creates a new database and returns a pointer to it.
.ZN XrmPutResource
is a convenience function that calls
.ZN XrmStringToBindingQuarkList
followed by:
.LP
.Ds
XrmQPutResource(database, bindings, quarks, XrmStringToQuark(type), value)
.De
.LP
If the specifier and type are not in the Host Portable Character Encoding,
the result is implementation-dependent.
The value is stored in the database without modification.
.LP
If database contains NULL,
.ZN XrmQPutResource
creates a new database and returns a pointer to it.
If a resource entry with the identical bindings and quarks already
exists in the database, the previous type and value are replaced by the new
specified type and value.
The value is stored in the database without modification.
.LP
If database contains NULL,
.ZN XrmPutStringResource
creates a new database and returns a pointer to it.
.ZN XrmPutStringResource
adds a resource with the specified value to the specified database.
.ZN XrmPutStringResource
is a convenience function that first calls
.ZN XrmStringToBindingQuarkList
on the specifier and then calls
.ZN XrmQPutResource ,
using a ``String'' representation type.
If the specifier is not in the Host Portable Character Encoding,
the result is implementation-dependent.
The value is stored in the database without modification.
.LP
If database contains NULL,
.ZN XrmQPutStringResource
creates a new database and returns a pointer to it.
.ZN XrmQPutStringResource
is a convenience routine that constructs an
.ZN XrmValue
for the value string (by calling
.ZN strlen
to compute the size) and
then calls
.ZN XrmQPutResource ,
using a ``String'' representation type.
The value is stored in the database without modification.
.LP
If database contains NULL,
.ZN XrmPutLineResource
creates a new database and returns a pointer to it.
.ZN XrmPutLineResource
adds a single resource entry to the specified database.
The line should be in valid ResourceLine format (see section 15.1)
terminated by a newline or null character;
the database that results from using a string
with incorrect syntax is implementation-dependent.
The string is parsed in the locale of the database.
If the
.ZN ResourceName
is not in the Host Portable Character Encoding,
the result is implementation-dependent.
Note that comment lines are not stored.
.SH "SEE ALSO"
XrmGetResource(3X11),
XrmInitialize(3X11),
XrmMergeDatabases(3X11),
XrmUniqueQuark(3X11)
.br
\fI\*(xL\fP
