      SUBROUTINE CHR_MTOA( STR1, STR2 )
*+
*  Name:
*     CHR_MTOA

*  Purpose:
*     Translate a string from the machine's characters set to ASCII.

*  Language:
*     Starlink Fortran 77

*  Invocation:
*     CALL CHR_MTOA( STR1, STR2 )

*  Description:
*     The string STR1, encoded in the host machine's character set, is
*     returned in STR2 translated into a form which can be written and 
*     subsequently read correctly by a machine which uses the ASCII 
*     character set.

*  Arguments:
*     STR1 = CHARACTER * ( * ) (Given)
*        A string represented by the host machine's character set.
*     STR2 = CHARACTER * ( * ) (Returned)
*        A string represented by the ASCII character set.    
*        If STR2 is shorter than STR1, the translated string will be 
*        truncated; if STR2 is longer than STR1, STR2 will be padded 
*        with blanks beyond the translated string.

*  Authors:
*     PCTR: P.C.T. Rees (STARLINK)
*     ACC:  A.C. Charles (STARLINK)
*     {enter_new_authors_here}

*  History:
*     25-FEB-1991 (PCTR):
*        Original version.
*     10-MAR-1994 (ACC for PCTR):
*        Modifications to prologue.
*     {enter_changes_here}

*  Bugs:
*     {note_any_bugs_here}

*-
      
*  Type Definitions:
      IMPLICIT NONE              ! No implicit typing

*  Arguments Given:
      CHARACTER STR1 * ( * )

*  Arguments Returned:
      CHARACTER STR2 * ( * )

*.

*  Version for machines which use the ASCII character set.
      STR2 = STR1

*  Template for a portable version.
*  External References:
*     CHARACTER * 1 MCH_MTOA     ! Machine-specific character conversion

*  Local Variables:
*     INTEGER ICHR               ! Character loop index
*     INTEGER LENGTH             ! Maximum loop index.
*     INTEGER LEN1               ! Declared length of STR1
*     INTEGER LEN2               ! Declared length of STR2

*.

*  Get the declared length of the two given strings.
*     LEN1 = LEN( STR1 )
*     LEN2 = LEN( STR2 )

*  Get the maximum loop index.
*     LENGTH = MIN( LEN1, LEN2 )

*  Trap a zero length strings.
*     IF ( LENGTH .GT. 0 ) THEN

*     Loop to apply character conversion.
*        DO 10 ICHR = 1, LENGTH
*           STR2( ICHR : ICHR ) = MCH_MTOA( STR1( ICHR : ICHR ) )
*10      CONTINUE
*     END IF

      END
