/***************************************************************************
 *
 * gnome-mount-properties-view.h : Nautilus properties page
 *
 * Copyright (C) 2006 David Zeuthen, <david@fubar.dk>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 **************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <libhal.h>
#include <libhal-storage.h>

#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include <glade/glade.h>
#include <time.h>
#include <sys/time.h>
#include <string.h>

#include "gnome-mount-properties-view.h"

struct _GnomeMountPropertiesView {
	GtkVBox base_instance;

	GladeXML *xml;
};

struct _GnomeMountPropertiesViewClass {
	GtkVBoxClass base_class;
};

G_DEFINE_TYPE (GnomeMountPropertiesView, gm_properties_view, GTK_TYPE_VBOX)

static void
gm_properties_view_dispose (GObject *object)
{
	GnomeMountPropertiesView *properties = GM_PROPERTIES_VIEW (object);

	if (properties->xml) {
		g_object_unref (properties->xml);
		properties->xml = NULL;
	}
}

static void
gm_properties_view_class_init (GnomeMountPropertiesViewClass *properties_class)
{
	GObjectClass *g_object_class = G_OBJECT_CLASS (properties_class);

	g_object_class->dispose = gm_properties_view_dispose;
}

void
gm_properties_view_set_info (GnomeMountPropertiesView *properties, GnomeVFSVolume *volume, LibHalContext *hal_ctx)
{
	GtkWidget *widget;
	LibHalVolume *vol;
	char *udi;
	GladeXML *xml;
	char *fssize = NULL;
	char *fstype = NULL;
	char *fsuuid = NULL;
	char *fslabel = NULL;

	xml = properties->xml;
	udi = gnome_vfs_volume_get_hal_udi (volume);
	vol = libhal_volume_from_udi (hal_ctx, udi);
	if (vol == NULL)
		goto out;

	fssize = gnome_vfs_format_file_size_for_display (libhal_volume_get_size (vol));
	if (libhal_volume_get_fstype (vol) != NULL && libhal_volume_get_fsversion (vol) != NULL) {
		fstype = g_strdup_printf ("%s (%s)", 
					  libhal_volume_get_fstype (vol),
					  libhal_volume_get_fsversion (vol));
	} else if (libhal_volume_get_fstype (vol) != NULL) {
		fstype = g_strdup (libhal_volume_get_fstype (vol));
	}
	fsuuid = g_strdup (libhal_volume_get_uuid (vol));
	fslabel = g_strdup (libhal_volume_get_label (vol));

	gtk_label_set_text (GTK_LABEL (glade_xml_get_widget (xml, "fs_label")),
			    fslabel);
	gtk_label_set_text (GTK_LABEL (glade_xml_get_widget (xml, "fs_uuid")),
			    fsuuid);
	gtk_label_set_text (GTK_LABEL (glade_xml_get_widget (xml, "fs_size")),
			    fssize);
	gtk_label_set_text (GTK_LABEL (glade_xml_get_widget (xml, "fs_type")),
			    fstype);

	g_free (fssize);
	g_free (fstype);
	g_free (fsuuid);
	g_free (fslabel);

out:
	if (vol != NULL)
		libhal_volume_free (vol);

	g_free (udi);
}

static void
gm_properties_view_init (GnomeMountPropertiesView *properties)
{
	GladeXML *xml;

	/* Create a new GladeXML object from XML file */
	xml = glade_xml_new (GLADEDIR "/gnome-mount-properties.glade", "gm_page_root", GETTEXT_PACKAGE);
	properties->xml = xml;
	g_assert (xml != NULL);

	gtk_box_pack_start (GTK_BOX (properties),
			    glade_xml_get_widget (xml, "gm_page_root"),
			    TRUE, TRUE, 0);
}

void
gm_properties_view_register_type (GTypeModule *module)
{
	gm_properties_view_get_type ();
}

GtkWidget *
gm_properties_view_new (void)
{
	GnomeMountPropertiesView *properties;

	properties = g_object_new (GM_TYPE_PROPERTIES, NULL);

	return GTK_WIDGET (properties);
}
