/* ***** BEGIN LICENSE BLOCK *****
 * Version: NPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1999
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "nsMailtoUrl.h"

#include <nsIURI.h>
#include <nsNetCID.h>
#include <nsCRT.h>
#define MOZILLA_INTERNAL_API
#include <nsString.h>
#include <nsIComponentManager.h>
#include <nsReadableUtils.h>
#include <nsEscape.h>
#undef MOZILLA_INTERNAL_API

static NS_DEFINE_CID(kSimpleURICID, NS_SIMPLEURI_CID);

struct nsMailtoUrlPrivate
{
   // data retrieved from parsing the url: (Note the url could be a
   // post from file or it could be in the url)
   nsCString m_toPart;
   nsCString m_ccPart;
   nsCString m_subjectPart;
   nsCString m_newsgroupPart;
   nsCString m_newsHostPart;
   nsCString m_referencePart;
   nsCString m_bodyPart;
   nsCString m_bccPart;
   nsCString m_followUpToPart;
   nsCString m_fromPart;
   nsCString m_htmlPart;
   nsCString m_organizationPart;
   nsCString m_replyToPart;
   nsCString m_priorityPart;

   PRBool    m_forcePlainText;
};


/////////////////////////////////////////////////////////////////////////////////////
// mailto url definition
/////////////////////////////////////////////////////////////////////////////////////
nsMailtoUrl::nsMailtoUrl()
{
  NS_INIT_ISUPPORTS();
  m_baseURL = do_CreateInstance(kSimpleURICID);
  priv = new nsMailtoUrlPrivate;
  priv->m_forcePlainText = PR_FALSE;
}

nsMailtoUrl::~nsMailtoUrl()
{
  delete priv;
}

NS_IMPL_ISUPPORTS2(nsMailtoUrl, nsIMailtoUrl, nsIURI)

nsresult nsMailtoUrl::ParseMailtoUrl(char * searchPart)
{
	char *rest = searchPart;
	// okay, first, free up all of our old search part state.....
	CleanupMailtoState();

	if (rest && *rest == '?')
	{
 		/* start past the '?' */
		rest++;
	}

	if (rest)
	{
    char *token = nsCRT::strtok(rest, "&", &rest);
		while (token && *token)
		{
			char *value = 0;
      char *eq = PL_strchr(token, '=');
			if (eq)
			{
				value = eq+1;
				*eq = 0;
			}
			
			switch (nsCRT::ToUpper(*token))
			{
/* DO NOT support attachment= in mailto urls. This poses a security fire hole!!! 
				case 'A':
          if (!nsCRT::strcasecmp (token, "attachment"))
					  m_attachmentPart = value;
				  break;
*/
				case 'B':
				  if (!nsCRT::strcasecmp (token, "bcc"))
				  {
					  if (!priv->m_bccPart.IsEmpty())
            {
               priv->m_bccPart += ", ";
               priv->m_bccPart += value;
            }
            else
					    priv->m_bccPart = value; 
          }
					else if (!nsCRT::strcasecmp (token, "body"))
					{
            if (!priv->m_bodyPart.IsEmpty())
            {
              priv->m_bodyPart +="\n";
              priv->m_bodyPart += value;
            }
            else
              priv->m_bodyPart = value;
          }
          break;
        case 'C': 
					if (!nsCRT::strcasecmp  (token, "cc"))
					{
						if (!priv->m_ccPart.IsEmpty())
						{
              priv->m_ccPart += ", ";
              priv->m_ccPart += value;
						}
						else
							priv->m_ccPart = value;
					}
          break;
        case 'F': 
					if (!nsCRT::strcasecmp (token, "followup-to"))
						priv->m_followUpToPart = value;
					else if (!nsCRT::strcasecmp (token, "from"))
						priv->m_fromPart = value;
					else if (!nsCRT::strcasecmp (token, "force-plain-text"))
						priv->m_forcePlainText = PR_TRUE;
					break;
        case 'H':
				  if (!nsCRT::strcasecmp(token, "html-part"))
						  priv->m_htmlPart = value;
          break;
				case 'N':
					if (!nsCRT::strcasecmp (token, "newsgroups"))
						priv->m_newsgroupPart = value;
					else if (!nsCRT::strcasecmp (token, "newshost"))
						priv->m_newsHostPart = value;
				  break;
				case 'O':
					if (!nsCRT::strcasecmp (token, "organization"))
						priv->m_organizationPart = value;
					break;
        case 'R':
					if (!nsCRT::strcasecmp (token, "references"))
						priv->m_referencePart = value;
					else if (!nsCRT::strcasecmp (token, "reply-to"))
						priv->m_replyToPart = value;
					break;
				case 'S':
					if(!nsCRT::strcasecmp (token, "subject"))
						priv->m_subjectPart = value;
					break;
				case 'P':
					if (!nsCRT::strcasecmp (token, "priority"))
						priv->m_priorityPart = PL_strdup(value);
					break;
				case 'T':
					if (!nsCRT::strcasecmp (token, "to"))
				  {
						if (!priv->m_toPart.IsEmpty())
						{
              priv->m_toPart += ", ";
              priv->m_toPart += value;
						}
						else
							priv->m_toPart = value;
					}
					break;
        default:
          break;
      } // end of switch statement...
			
			if (eq)
				  *eq = '='; /* put it back */
				token = nsCRT::strtok(rest, "&", &rest);
		} // while we still have part of the url to parse...
	} // if rest && *rest

	return NS_OK;
}


NS_IMETHODIMP nsMailtoUrl::SetSpec(const nsACString &aSpec)
{
  m_baseURL->SetSpec(aSpec);
	return ParseUrl();
}

nsresult nsMailtoUrl::CleanupMailtoState()
{
    priv->m_ccPart = "";
    priv->m_subjectPart = "";
    priv->m_newsgroupPart = "";
    priv->m_newsHostPart = ""; 
    priv->m_referencePart = "";
    priv->m_bodyPart = "";
    priv->m_bccPart = "";
    priv->m_followUpToPart = "";
    priv->m_fromPart = "";
    priv->m_htmlPart = "";
    priv->m_organizationPart = "";
    priv->m_replyToPart = "";
    priv->m_priorityPart = "";
	return NS_OK;
}

nsresult nsMailtoUrl::ParseUrl()
{
	nsresult rv = NS_OK;

  // we can get the path from the simple url.....
  nsCAutoString path;
  m_baseURL->GetPath(path);
  priv->m_toPart.Assign(path);

  PRInt32 startOfSearchPart = priv->m_toPart.FindChar('?');
  if (startOfSearchPart >= 0)
  {
    // now parse out the search field...
    nsCAutoString searchPart;
    PRUint32 numExtraChars = priv->m_toPart.Right(searchPart,
                                            priv->m_toPart.Length() -
                                            startOfSearchPart);
    if (!searchPart.IsEmpty())
    {
      ParseMailtoUrl(searchPart.BeginWriting());
      // now we need to strip off the search part from the
      // to part....
      priv->m_toPart.Cut(startOfSearchPart, numExtraChars);
    }
	}
  else if (!priv->m_toPart.IsEmpty())
  {
    nsUnescape(priv->m_toPart.BeginWriting());
  }

  return rv;
}

NS_IMETHODIMP nsMailtoUrl::GetMessageContents(char ** aToPart, char ** aCcPart, char ** aBccPart, 
		char ** aFromPart, char ** aFollowUpToPart, char ** aOrganizationPart, 
		char ** aReplyToPart, char ** aSubjectPart, char ** aBodyPart, char ** aHtmlPart, 
		char ** aReferencePart, char ** aAttachmentPart, char ** aPriorityPart, 
		char ** aNewsgroupPart, char ** aNewsHostPart, PRBool * aForcePlainText)
{
	if (aToPart)
		*aToPart = ToNewCString(priv->m_toPart);
	if (aCcPart)
		*aCcPart = ToNewCString(priv->m_ccPart);
	if (aBccPart)
		*aBccPart = ToNewCString(priv->m_bccPart);
	if (aFromPart)
		*aFromPart = ToNewCString(priv->m_fromPart);
	if (aFollowUpToPart)
		*aFollowUpToPart = ToNewCString(priv->m_followUpToPart);
	if (aOrganizationPart)
		*aOrganizationPart = ToNewCString(priv->m_organizationPart);
	if (aReplyToPart)
		*aReplyToPart = ToNewCString(priv->m_replyToPart);
	if (aSubjectPart)
		*aSubjectPart = ToNewCString(priv->m_subjectPart);
	if (aBodyPart)
		*aBodyPart = ToNewCString(priv->m_bodyPart);
	if (aHtmlPart)
		*aHtmlPart = ToNewCString(priv->m_htmlPart);
	if (aReferencePart)
		*aReferencePart = ToNewCString(priv->m_referencePart);
	if (aAttachmentPart)
		*aAttachmentPart = nsnull; // never pass out an attachment part as part of a mailto url
	if (aPriorityPart)
		*aPriorityPart = ToNewCString(priv->m_priorityPart);
	if (aNewsgroupPart)
		*aNewsgroupPart = ToNewCString(priv->m_newsgroupPart);
	if (aNewsHostPart)
		*aNewsHostPart = ToNewCString(priv->m_newsHostPart);
	if (aForcePlainText)
		*aForcePlainText = priv->m_forcePlainText;
	return NS_OK;
}

////////////////////////////////////////////////////////////////////////////////////
// Begin nsIURI support
////////////////////////////////////////////////////////////////////////////////////


NS_IMETHODIMP nsMailtoUrl::GetSpec(nsACString &aSpec)
{
	return m_baseURL->GetSpec(aSpec);
}

NS_IMETHODIMP nsMailtoUrl::GetPrePath(nsACString &aPrePath)
{
	return m_baseURL->GetPrePath(aPrePath);
}

NS_IMETHODIMP nsMailtoUrl::GetScheme(nsACString &aScheme)
{
	return m_baseURL->GetScheme(aScheme);
}

NS_IMETHODIMP nsMailtoUrl::SetScheme(const nsACString &aScheme)
{
	return m_baseURL->SetScheme(aScheme);
}

NS_IMETHODIMP nsMailtoUrl::GetUserPass(nsACString &aUserPass)
{
	return m_baseURL->GetUserPass(aUserPass);
}

NS_IMETHODIMP nsMailtoUrl::SetUserPass(const nsACString &aUserPass)
{
	return m_baseURL->SetUserPass(aUserPass);
}

NS_IMETHODIMP nsMailtoUrl::GetUsername(nsACString &aUsername)
{
	return m_baseURL->GetUsername(aUsername);
}

NS_IMETHODIMP nsMailtoUrl::SetUsername(const nsACString &aUsername)
{
	return m_baseURL->SetUsername(aUsername);
}

NS_IMETHODIMP nsMailtoUrl::GetPassword(nsACString &aPassword)
{
	return m_baseURL->GetPassword(aPassword);
}

NS_IMETHODIMP nsMailtoUrl::SetPassword(const nsACString &aPassword)
{
	return m_baseURL->SetPassword(aPassword);
}

NS_IMETHODIMP nsMailtoUrl::GetHostPort(nsACString &aHostPort)
{
	return m_baseURL->GetHost(aHostPort);
}

NS_IMETHODIMP nsMailtoUrl::SetHostPort(const nsACString &aHostPort)
{
	return m_baseURL->SetHost(aHostPort);
}

NS_IMETHODIMP nsMailtoUrl::GetHost(nsACString &aHost)
{
	return m_baseURL->GetHost(aHost);
}

NS_IMETHODIMP nsMailtoUrl::SetHost(const nsACString &aHost)
{
	return m_baseURL->SetHost(aHost);
}

NS_IMETHODIMP nsMailtoUrl::GetPort(PRInt32 *aPort)
{
	return m_baseURL->GetPort(aPort);
}

NS_IMETHODIMP nsMailtoUrl::SetPort(PRInt32 aPort)
{
	return m_baseURL->SetPort(aPort);
}

NS_IMETHODIMP nsMailtoUrl::GetPath(nsACString &aPath)
{
	return m_baseURL->GetPath(aPath);
}

NS_IMETHODIMP nsMailtoUrl::SetPath(const nsACString &aPath)
{
	return m_baseURL->SetPath(aPath);
}

NS_IMETHODIMP nsMailtoUrl::GetAsciiHost(nsACString &aHostA)
{
	return m_baseURL->GetAsciiHost(aHostA);
}

NS_IMETHODIMP nsMailtoUrl::GetAsciiSpec(nsACString &aSpecA)
{
	return m_baseURL->GetAsciiSpec(aSpecA);
}

NS_IMETHODIMP nsMailtoUrl::GetOriginCharset(nsACString &aOriginCharset)
{
    return m_baseURL->GetOriginCharset(aOriginCharset);
}

NS_IMETHODIMP nsMailtoUrl::SchemeIs(const char *aScheme, PRBool *_retval)
{
	return m_baseURL->SchemeIs(aScheme, _retval);
}

NS_IMETHODIMP nsMailtoUrl::Equals(nsIURI *other, PRBool *_retval)
{
	return m_baseURL->Equals(other, _retval);
}

NS_IMETHODIMP nsMailtoUrl::Clone(nsIURI **_retval)
{
	return m_baseURL->Clone(_retval);
}	

NS_IMETHODIMP nsMailtoUrl::Resolve(const nsACString &relativePath, nsACString &result) 
{
	return m_baseURL->Resolve(relativePath, result);
}
