/*
 *  Copyright (C) 2001,2002,2003 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CookiePromptService.h"
#include "ContentHandler.h"
#include "FilePicker.h"
#include "GlobalHistory.h"
#include "JSConsoleService.h"
#include "MyportalProtocolHandler.h"
#include "PrintingPromptService.h"
#include "ProgressListener.h"
#include "SideBarProxy.h"
#ifdef HAVE_MOZILLA_PSM
#include "GtkNSSDialogs.h"
#include "GtkNSSKeyPairDialogs.h"
#include "GtkNSSClientAuthDialogs.h"
#include "GtkNSSSecurityWarningDialogs.h"
#endif

#include "ExternalProtocolService.h"
#include "gUrlCID.h"
#include "nsAboutRedirector.h"
#include "nsMailtoUrl.h"

#include <nsIGenericFactory.h>
#include <nsIComponentRegistrar.h>
#include <nsICategoryManager.h>
#include <nsCOMPtr.h>
#define MOZILLA_INTERNAL_API
#include <nsIServiceManager.h>
#undef MOZILLA_INTERNAL_API
#include <nsDocShellCID.h>

#include <glib.h>

NS_GENERIC_FACTORY_CONSTRUCTOR(GProgressListener)
NS_GENERIC_FACTORY_CONSTRUCTOR(GFilePicker)
NS_GENERIC_FACTORY_CONSTRUCTOR(JSConsoleService)
NS_GENERIC_FACTORY_CONSTRUCTOR(GContentHandler)
NS_GENERIC_FACTORY_CONSTRUCTOR(MozGlobalHistory)
NS_GENERIC_FACTORY_CONSTRUCTOR(GPrintingPromptService)
NS_GENERIC_FACTORY_CONSTRUCTOR(GSidebarProxy)
NS_DECL_CLASSINFO(GSidebarProxy)
NS_GENERIC_FACTORY_CONSTRUCTOR(GCookiePromptService)
NS_GENERIC_FACTORY_CONSTRUCTOR(nsAboutRedirector)
#ifdef HAVE_MOZILLA_PSM
NS_GENERIC_FACTORY_CONSTRUCTOR(GtkNSSDialogs)
NS_GENERIC_FACTORY_CONSTRUCTOR(GtkNSSKeyPairDialogs)
NS_GENERIC_FACTORY_CONSTRUCTOR(GtkNSSClientAuthDialogs)
NS_GENERIC_FACTORY_CONSTRUCTOR(GtkNSSSecurityWarningDialogs)
#endif
NS_GENERIC_FACTORY_CONSTRUCTOR(GMyportalProtocolHandler)
NS_GENERIC_FACTORY_CONSTRUCTOR(GExternalProtocolService)

NS_GENERIC_FACTORY_CONSTRUCTOR(nsMailtoUrl);
static NS_DEFINE_CID(kMailtoUrlCID, NS_MAILTOURL_CID);

// NS_DOWNLOAD_CONTRACTID was renamed in mozilla 1.8b
#ifndef NS_TRANSFER_CONTRACTID
#define NS_TRANSFER_CONTRACTID NS_DOWNLOAD_CONTRACTID
#endif

static NS_METHOD
RegisterSidebar(nsIComponentManager *aCompMgr, nsIFile *aPath,
                const char *registryLocation, const char *componentType,
                const nsModuleComponentInfo *info)
{
	nsCOMPtr<nsICategoryManager> cm =
		do_GetService(NS_CATEGORYMANAGER_CONTRACTID);
	NS_ENSURE_TRUE (cm, NS_ERROR_FAILURE);

	return cm->AddCategoryEntry("JavaScript global property",
				    "sidebar", NS_SIDEBAR_CONTRACTID,
				    PR_FALSE, PR_TRUE, nsnull);
}

static const nsModuleComponentInfo sAppComps[] = {
	{
		G_PROGRESSDIALOG_CLASSNAME,
		G_PROGRESSDIALOG_CID,
		G_PROGRESSDIALOG_CONTRACTID,
		GProgressListenerConstructor
	},
	{
		G_PROGRESSDIALOG_CLASSNAME,
		G_PROGRESSDIALOG_CID,
		NS_TRANSFER_CONTRACTID,
		GProgressListenerConstructor
	},
	{	
		G_JS_CONSOLESERVICE_CLASSNAME,
		G_JSCONSOLESERVICE_CID,
		NS_JSCONSOLESERVICE_CONTRACTID,
		JSConsoleServiceConstructor
	},
	{
		G_FILEPICKER_CLASSNAME,
		G_FILEPICKER_CID,
		G_FILEPICKER_CONTRACTID,
		GFilePickerConstructor
	},
	{
		NS_IHELPERAPPLAUNCHERDLG_CLASSNAME,
		G_CONTENTHANDLER_CID,
		NS_IHELPERAPPLAUNCHERDLG_CONTRACTID,
		GContentHandlerConstructor
	},
	{
		G_EXTERNALPROTOCOLSERVICE_CLASSNAME,
		G_EXTERNALPROTOCOLSERVICE_CID,
		NS_EXTERNALPROTOCOLSERVICE_CONTRACTID,
		GExternalProtocolServiceConstructor
	},
	{
		GALEON_GLOBALHISTORY_CLASSNAME,
		GALEON_GLOBALHISTORY_CID,
		NS_GLOBALHISTORY2_CONTRACTID,
		MozGlobalHistoryConstructor
	},
	{
		G_PRINTINGPROMPTSERVICE_CLASSNAME,
		G_PRINTINGPROMPTSERVICE_CID,
		G_PRINTINGPROMPTSERVICE_CONTRACTID,
		GPrintingPromptServiceConstructor
	},
	{
		G_SIDEBAR_CLASSNAME,
		G_SIDEBAR_CID,
		NS_SIDEBAR_CONTRACTID,
		GSidebarProxyConstructor,
		RegisterSidebar,
		nsnull, // No unregister func
		nsnull, // No factory destructor
		NS_CI_INTERFACE_GETTER_NAME(GSidebarProxy),
		nsnull, // No language helper
		&NS_CLASSINFO_NAME(GSidebarProxy),
		nsIClassInfo::DOM_OBJECT
	},
	{
		G_COOKIEPROMPTSERVICE_CLASSNAME,
		G_COOKIEPROMPTSERVICE_CID,
		G_COOKIEPROMPTSERVICE_CONTRACTID,
		GCookiePromptServiceConstructor
	},
#ifdef HAVE_MOZILLA_PSM
	{
		GTK_NSSDIALOGS_CLASSNAME,
		GTK_NSSDIALOGS_CID,
		NS_BADCERTLISTENER_CONTRACTID,
		GtkNSSDialogsConstructor
	},
	{
		GTK_NSSDIALOGS_CLASSNAME,
		GTK_NSSDIALOGS_CID,
		NS_CERTIFICATEDIALOGS_CONTRACTID,
		GtkNSSDialogsConstructor
	},
	{
		GTK_NSSCLIENTAUTHDIALOGS_CLASSNAME,
		GTK_NSSCLIENTAUTHDIALOGS_CID,
		NS_CLIENTAUTHDIALOGS_CONTRACTID,
		GtkNSSClientAuthDialogsConstructor
	},
	{
		GTK_NSSKEYPAIRDIALOGS_CLASSNAME,
		GTK_NSSKEYPAIRDIALOGS_CID,
		NS_GENERATINGKEYPAIRINFODIALOGS_CONTRACTID,
		GtkNSSKeyPairDialogsConstructor
	},
        {
                GTK_NSSSECURITYWARNINGDIALOGS_CLASSNAME,
                GTK_NSSSECURITYWARNINGDIALOGS_CID,
                NS_SECURITYWARNINGDIALOGS_CONTRACTID,
                GtkNSSSecurityWarningDialogsConstructor
        },
#endif
	{
		G_ABOUT_MYPORTAL_CLASSNAME,
		G_MYPORTAL_PROTOCOL_CID,
		G_ABOUT_MYPORTAL_CONTRACTID,
		GMyportalProtocolHandlerConstructor
	},
	{
		G_MYPORTAL_HANDLER_CLASSNAME,
		G_MYPORTAL_PROTOCOL_CID,
		G_MYPORTAL_HANDLER_CONTRACTID,
		GMyportalProtocolHandlerConstructor
	},
	{
		G_ABOUT_TOPHER_MODULE_CLASSNAME,
		G_ABOUT_REDIRECTOR_MODULE_CID,
		G_ABOUT_TOPHER_MODULE_CONTRACTID,
		nsAboutRedirectorConstructor
	},
	{       /* This MUST be last */
		NS_MAILTOURL_CLASSNAME,
		NS_MAILTOURL_CID,
		NS_MAILTOURL_CONTRACTID,
		nsMailtoUrlConstructor
	}
};

#define NS_MSGCONTENTPOLICY_CONTRACTID "@mozilla.org/messenger/content-policy;1"

static nsresult
remove_thunderbird_contentpolicy()
{
	nsCOMPtr<nsICategoryManager> cm;
	cm = do_GetService(NS_CATEGORYMANAGER_CONTRACTID);
	NS_ENSURE_TRUE (cm, NS_ERROR_FAILURE);

	cm->DeleteCategoryEntry("content-policy",
				NS_MSGCONTENTPOLICY_CONTRACTID, PR_TRUE);

	return NS_OK;
}

#if defined(HAVE_MOZILLA_PSM) && ! defined(HAVE_NSIDOCSHELL_GETSECUREUI)
/* feb0fe98-f5ee-4d26-ad76-70856de63720 */
#define NEW_CID { 0xfeb0fe98, 0xf5ee, 0x4d26, { 0xad, 0x76, 0x70, 0x85, 0x6d, 0xe6, 0x37, 0x20 } }

static nsresult
reregister_secure_browser_ui (nsIComponentManager *cm, nsIComponentRegistrar *cr)
{
	nsresult rv;
	
	/* Workaround as a result of:
	 *  https://bugzilla.mozilla.org/show_bug.cgi?id=94974
	 * see
	 *  http://bugzilla.gnome.org/show_bug.cgi?id=164670
	 */
	nsCOMPtr<nsIFactory> factory;
	rv = cm->GetClassObjectByContractID ("@mozilla.org/secure_browser_ui;1", 
					     NS_GET_IID(nsIFactory), getter_AddRefs (factory));
	NS_ENSURE_SUCCESS (rv, rv);

	nsCID *cidPtr = nsnull;
	rv = cr->ContractIDToCID("@mozilla.org/secure_browser_ui;1", &cidPtr);
	NS_ENSURE_SUCCESS (rv, rv);

	rv = cr->UnregisterFactory (*cidPtr, factory);
	NS_ENSURE_SUCCESS (rv, rv);

	const nsCID new_cid = NEW_CID;
	rv = cr->RegisterFactory (new_cid, "Galeon Secure Browser Class",
				  "@galeon.sf.net/hacks/secure-browser-ui;1", factory);
	NS_ENSURE_SUCCESS (rv, rv);

	return NS_OK;
}
#endif

gboolean
mozilla_register_components (void)
{
	gboolean ret = TRUE;
	nsresult rv;

	nsCOMPtr<nsIComponentRegistrar> cr;
	rv = NS_GetComponentRegistrar(getter_AddRefs(cr));
	NS_ENSURE_SUCCESS(rv, rv);

	nsCOMPtr<nsIComponentManager> cm;
	NS_GetComponentManager (getter_AddRefs (cm));
	NS_ENSURE_TRUE (cm, FALSE);

	guint numAppComps = G_N_ELEMENTS (sAppComps);

	/* See if we should register the nsMailtoUrl handler */
	PRBool isMailtoUrlReg;
	rv = cr->IsContractIDRegistered(NS_MAILTOURL_CONTRACTID,
					&isMailtoUrlReg);
	if (NS_SUCCEEDED(rv) && isMailtoUrlReg)
	{
		numAppComps--; /* No */
	}

	for (guint i = 0; i < G_N_ELEMENTS (sAppComps); i++)
	{
		nsCOMPtr<nsIGenericFactory> componentFactory;
		rv = NS_NewGenericFactory(getter_AddRefs(componentFactory),
					  &(sAppComps[i]));
		if (NS_FAILED(rv) || !componentFactory)
		{
			g_warning ("Failed to make a factory for %s\n", sAppComps[i].mDescription);

			ret = FALSE;
			continue;  // don't abort registering other components
		}

		rv = cr->RegisterFactory(sAppComps[i].mCID,
					 sAppComps[i].mDescription,
					 sAppComps[i].mContractID,
					 componentFactory);
		if (NS_FAILED(rv))
		{
			g_warning ("Failed to register %s\n", sAppComps[i].mDescription);

			ret = FALSE;
		}

		if (sAppComps[i].mRegisterSelfProc)
		{
			rv = sAppComps[i].mRegisterSelfProc (cm, nsnull, nsnull, nsnull, &sAppComps[i]);

			if (NS_FAILED (rv))
			{
				g_warning ("Failed to register-self for %s\n", sAppComps[i].mDescription);
				ret = FALSE;
			}
		}
	}

	// Thunderbird includes a fascist content policy - we don't need it
	remove_thunderbird_contentpolicy ();

#if defined(HAVE_MOZILLA_PSM) && ! defined(HAVE_NSIDOCSHELL_GETSECUREUI)
	// Workaround for http://bugzilla.gnome.org/show_bug.cgi?id=164670
	reregister_secure_browser_ui (cm, cr);
#endif

	return ret;
}
