# 2021-12-07 Triage Log

A week of mostly rather small changes with many regressions being hard to diagnose. The largest regression comes from the introduction of a new future (desugaring `.await` into a call to `IntoFuture::into_future`). This was deemed acceptable as it only seems to have a negative impact in stress test situations where async/await is used more than one would normally expect. Unfortunately this does mean regressions beat out improvements this week.

Triage done by **@rylev**.
Revision range: [1c0287830e0fb3c4007afea2819ba03766da6e9c..ecb65b0e170fc5275870c9d0fba7267a57cf35e5](https://perf.rust-lang.org/?start=1c0287830e0fb3c4007afea2819ba03766da6e9c&end=ecb65b0e170fc5275870c9d0fba7267a57cf35e5&absolute=false&stat=instructions%3Au)

3 Regressions, 5 Improvements, 5 Mixed; 3 of them in rollups
31 comparisons made in total

#### Regressions

Implement version of normalize_erasing_regions that allows for normalization failure [#91255](https://github.com/rust-lang/rust/issues/91255)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=26b45573be204da2cc0db12828b7a03c41c73793&end=f04a2f4b8e89eac1119061ea2055d33c97e618b4&stat=instructions:u) (up to 0.9% on `incr-full` builds of `ctfe-stress-4`)
- Nothing immediately jumps out as an issue, so a run of cachegrind might be necessary.
- Left a [comment](https://github.com/rust-lang/rust/pull/91255#issuecomment-988266695) as such.


Rollup of 10 pull requests [#91486](https://github.com/rust-lang/rust/issues/91486)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=190367ba2ef1d279004b8372cf022b5fc96145dd&end=3e21768a0a3fc84befd1cbe825ae6849e9941b73&stat=instructions:u) (up to 1.1% on `full` builds of `match-stress-enum`)
- Seems to be impacting compilation of match expressions, but none of the sub PRs seem to be a likely culprit.
- Left a [comment](https://github.com/rust-lang/rust/pull/91486#issuecomment-988271162) as such.


Reintroduce `into_future` in `.await` desugaring [#90737](https://github.com/rust-lang/rust/issues/90737)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=ff2439b7b9bafcfdff86b7847128014699df8442&end=532d2b14c05f9bc20b2d27cbb5f4550d28343a36&stat=instructions:u) (up to 9.3% on `incr-full` builds of `deeply-nested-async`)
- The regression was very much expected but only really appears in extremely `await`-heavy code. We'll have to wait to see how this impacts real world users, and see if we can work on performance of trait obligation resolution to improve the performance lost.
- A more detailed justification for taking the performance hit can be found [here](https://github.com/rust-lang/rust/pull/90737#issuecomment-985924986).


#### Improvements

Lint elided lifetimes in path during lifetime resolution. [#90446](https://github.com/rust-lang/rust/issues/90446)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=48a5999fceeea84a8971634355287faa349909d4&end=76938d64a42304e4413842656c044e9b40a6041b&stat=instructions:u) (up to -1.4% on `incr-unchanged` builds of `stm32f4`)


fix sparc64 ABI for aggregates with floating point members [#91003](https://github.com/rust-lang/rust/issues/91003)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=76938d64a42304e4413842656c044e9b40a6041b&end=a2b7b7891e4623e716185f3ab62bd206fb4c5182&stat=instructions:u) (up to -0.7% on `incr-unchanged` builds of `deeply-nested-async`)


Optimize `rustc_lexer` [#91393](https://github.com/rust-lang/rust/issues/91393)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=d47a6cc3f2dab0ef046c2bb7b76a9ee8d1a0be92&end=2a9e0831d6603d87220cedd1b1293e2eb82ef55c&stat=instructions:u) (up to -1.0% on `incr-unchanged` builds of `coercions`)


Revert "Auto merge of #91354 - fee1-dead:const_env, r=spastorino" [#91491](https://github.com/rust-lang/rust/issues/91491)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=2a9e0831d6603d87220cedd1b1293e2eb82ef55c&end=ff2439b7b9bafcfdff86b7847128014699df8442&stat=instructions:u) (up to -1.1% on `incr-patched: b9b3e592dd cherry picked` builds of `style-servo`)
- Reverted some performance regressions.


Add a MIR pass manager (Taylor's Version) [#91475](https://github.com/rust-lang/rust/issues/91475)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=5e93f6e318e687c05c8c44517de4586ed75ce3f4&end=bdaa9010493d26611079a9de1c8722532e140a24&stat=instructions:u) (up to -0.8% on `full` builds of `stm32f4`)


#### Mixed

Introduce `RawVec::reserve_for_push`. [#91352](https://github.com/rust-lang/rust/issues/91352)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=1c0287830e0fb3c4007afea2819ba03766da6e9c&end=207c80f105282245d93024c95ac408c622f70114&stat=instructions:u) (up to -3.0% on `incr-patched: println` builds of `webrender-wrench`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=1c0287830e0fb3c4007afea2819ba03766da6e9c&end=207c80f105282245d93024c95ac408c622f70114&stat=instructions:u) (up to 0.4% on `incr-patched: println` builds of `style-servo`)
- The improvements outweigh the regressions and are mostly found in real-world crates.
- Justification for the regressions can be found [here](https://github.com/rust-lang/rust/pull/91352#issuecomment-982986307).


Rollup of 4 pull requests [#91406](https://github.com/rust-lang/rust/issues/91406)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=207c80f105282245d93024c95ac408c622f70114&end=d384ff79308c4eb0a3679817cd0def0147ad8612&stat=instructions:u) (up to -2.7% on `incr-unchanged` builds of `deeply-nested-async`)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=207c80f105282245d93024c95ac408c622f70114&end=d384ff79308c4eb0a3679817cd0def0147ad8612&stat=instructions:u) (up to 7.1% on `incr-unchanged` builds of `clap-rs`)
- A case where it's hard to tell where the regression is coming from, but it is a quite a large regression in a real-world crate (albeit one that is a tiny bit noisy). 
- Both [](https://github.com/rust-lang/rust/pull/91366) and [](https://github.com/rust-lang/rust/pull/91397) only really touch rustdoc so that's unlikely the culprit. 
- Left a comment for [follow up](https://github.com/rust-lang/rust/pull/91406#issuecomment-988258182)


Cleanup: Eliminate ConstnessAnd [#91354](https://github.com/rust-lang/rust/issues/91354)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=d9baa361902b172be716f96619b909f340802dea&end=18bb8c61a975fff6424cda831ace5b0404277145&stat=instructions:u) (up to -0.6% on `full` builds of `deeply-nested`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=d9baa361902b172be716f96619b909f340802dea&end=18bb8c61a975fff6424cda831ace5b0404277145&stat=instructions:u) (up to 1.1% on `incr-patched: b9b3e592dd cherry picked` builds of `style-servo`)
- Reverted by [#91491](https://github.com/rust-lang/rust/issues/91491) which recovered the regression.


Rollup of 4 iffy pull requests [#91455](https://github.com/rust-lang/rust/issues/91455)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=18bb8c61a975fff6424cda831ace5b0404277145&end=e5038e20999eef35260b070189883edc2a8a34b2&stat=instructions:u) (up to -6.7% on `incr-unchanged` builds of `clap-rs`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=18bb8c61a975fff6424cda831ace5b0404277145&end=e5038e20999eef35260b070189883edc2a8a34b2&stat=instructions:u) (up to 3.4% on `incr-unchanged` builds of `clap-rs`)
- The improvements outweigh the regressions with the largest regression in a non-noisy benchmark being only 0.8%.
- Given the difficult nature of figuring out what caused regressions in a rollup of 4 iffy pull requests, we'll let this one slide.


Reduce boilerplate around infallible folders [#91318](https://github.com/rust-lang/rust/issues/91318)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=e5038e20999eef35260b070189883edc2a8a34b2&end=acbe4443cc4c9695c0b74a7b64b60333c990a400&stat=instructions:u) (up to -0.8% on `incr-unchanged` builds of `externs`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=e5038e20999eef35260b070189883edc2a8a34b2&end=acbe4443cc4c9695c0b74a7b64b60333c990a400&stat=instructions:u) (up to 0.6% on `full` builds of `deeply-nested`)
- [cachegrind](https://github.com/rust-lang/rust/pull/91318#issuecomment-985506557) was already run, but there are no clear explanations for the regressions.

#### Untriaged Pull Requests

- [#91406 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/91406)
- [#91354 Cleanup: Eliminate ConstnessAnd](https://github.com/rust-lang/rust/pull/91354)
- [#91318 Reduce boilerplate around infallible folders](https://github.com/rust-lang/rust/pull/91318)
- [#91288 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/91288)
- [#91269 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/91269)
- [#91255 Implement version of normalize_erasing_regions that allows for normalization failure](https://github.com/rust-lang/rust/pull/91255)
- [#91246 Faster `Layout::array`](https://github.com/rust-lang/rust/pull/91246)
- [#91230 Make `TypeFolder::fold_*` return `Result`](https://github.com/rust-lang/rust/pull/91230)
- [#91205 Visit `param_env` field in Obligation's `TypeFoldable` impl](https://github.com/rust-lang/rust/pull/91205)
- [#91073 rustdoc: Make two small cleanups](https://github.com/rust-lang/rust/pull/91073)
- [#90883 Rollup of 3 pull requests](https://github.com/rust-lang/rust/pull/90883)
- [#90839 Generate documentation in rustc `rustc_index::newtype_index` macro](https://github.com/rust-lang/rust/pull/90839)
- [#90821 MIRI says `reverse` is UB, so replace it with something LLVM can vectorize](https://github.com/rust-lang/rust/pull/90821)
- [#90788 Mark places as initialized when mutably borrowed](https://github.com/rust-lang/rust/pull/90788)
- [#90769 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/90769)
- [#90750 rustdoc: Replace where-bounded Clean impl with simple function](https://github.com/rust-lang/rust/pull/90750)
- [#90746 Optimize pattern matching](https://github.com/rust-lang/rust/pull/90746)
- [#90695 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/90695)
- [#90684 Change paths for `dist` command to match the components they generate](https://github.com/rust-lang/rust/pull/90684)
- [#90681 Update libc to 0.2.108](https://github.com/rust-lang/rust/pull/90681)
- [#90645 Implement diagnostic for String conversion](https://github.com/rust-lang/rust/pull/90645)
- [#90579 Remove eval_always for inherent_impls.](https://github.com/rust-lang/rust/pull/90579)
- [#90559 Optimize bidi character detection.](https://github.com/rust-lang/rust/pull/90559)
- [#90542 Make RawVec private to alloc](https://github.com/rust-lang/rust/pull/90542)
- [#90535 Implement `clone_from` for `State`](https://github.com/rust-lang/rust/pull/90535)
- [#90489 rustdoc: Go back to loading all external crates unconditionally](https://github.com/rust-lang/rust/pull/90489)
- [#90485 Don't destructure args tuple in format_args!](https://github.com/rust-lang/rust/pull/90485)
- [#90462 [master] Fix CVE-2021-42574](https://github.com/rust-lang/rust/pull/90462)
- [#90443 Merge `DocContext.{ty,lt,ct}_substs` into one map](https://github.com/rust-lang/rust/pull/90443)
