      SUBROUTINE TEST_HTOI(STATUS)
*+
*  Name:
*     TEST_HTOI

*  Purpose:
*     Test CHR_HTOI.

*  Language:
*     Starlink Fortran 77

*  Invocation:
*     CALL TEST_HTOI(STATUS)

*  Description:
*     Test CHR_HTOI.
*     If any failure occurs, return STATUS = SAI__ERROR.
*     Otherwise, STATUS is unchanged.

*  Arguments:
*     STATUS = INTEGER (Returned)
*        The status of the tests. 

*  Authors:
*     RLVAD::AJC: A J Chipperfield (STARLINK)
*     RLVAD::ACC: A C Charles (STARLINK)
*     {enter_new_authors_here}

*  History:
*     17-AUG-1989 (RLVAD::AJC):
*        Original version.
*     14-SEP-1993 (ACC)
*        Modularised version: broken into one routine for each of 5 main 
*        categories of tests.
*     01-MAR-1994 (ACC)
*        Second modularised version: broken further into one routine for 
*        each of subroutine tested.  This subroutine created.
*     {enter_further_changes_here}

*  Bugs:
*     {note_any_bugs_here}

*  Subprograms called:   
*     CHR_HTOI

*-

*  Type Definitions:
      IMPLICIT NONE              ! No implicit typing

*  Arguments Given:
*     None

*  Arguments Returned:
      INTEGER STATUS

*  Global Constants:
      INCLUDE 'SAE_PAR'          ! Standard SAE constants
      INCLUDE 'CHR_ERR'

*  Local Variables:
      INTEGER ISTAT              ! Local status
      INTEGER I                  ! INTEGER value

*.

*    Test CHR_HTOI

*    Given illegal string
      ISTAT = SAI__OK
      CALL CHR_HTOI ('X', I, ISTAT)
      IF (ISTAT .EQ. SAI__ERROR) THEN
         PRINT *, 'CHR_HTOI detecting error OK'
      ELSE
         PRINT *, 'CHR_HTOI detecting error FAILS'
         STATUS = SAI__ERROR
      ENDIF

*    Given valid string
      ISTAT = SAI__OK
      CALL CHR_HTOI ('00F9', I, ISTAT)
      IF ((ISTAT .EQ. SAI__OK) .AND. (I .EQ. 249))THEN
         PRINT *, 'CHR_HTOI OK'
      ELSE
         PRINT *, 'CHR_HTOI FAILS - 00F9 converted to', I
         STATUS = SAI__ERROR
      ENDIF

      END
