/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimptextlayer_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"


/**
 * SECTION: gimptextlayer
 * @title: gimptextlayer
 * @short_description: Functions for querying and manipulating text layers.
 *
 * Functions for querying and manipulating text layers.
 **/


/**
 * _gimp_text_layer_new:
 * @image: The image.
 * @text: The text to generate (in UTF-8 encoding).
 * @font: The font to write the text with.
 * @size: The size of text in either pixels or points.
 * @unit: The units of specified size.
 *
 * Creates a new text layer.
 *
 * This procedure creates a new text layer. The arguments are kept as
 * simple as necessary for the normal case. All text attributes,
 * however, can be modified with the appropriate
 * gimp_text_layer_set_*() procedures. The new layer still needs to be
 * added to the image, as this is not automatic. Add the new layer
 * using gimp_image_insert_layer().
 *
 * Returns: (transfer none): The new text layer.
 *
 * Since: 2.6
 **/
GimpTextLayer *
_gimp_text_layer_new (GimpImage   *image,
                      const gchar *text,
                      GimpFont    *font,
                      gdouble      size,
                      GimpUnit     unit)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpTextLayer *layer = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_STRING, text,
                                          GIMP_TYPE_FONT, font,
                                          G_TYPE_DOUBLE, size,
                                          GIMP_TYPE_UNIT, unit,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-new",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    layer = GIMP_VALUES_GET_TEXT_LAYER (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return layer;
}

/**
 * gimp_text_layer_get_text:
 * @layer: The text layer.
 *
 * Get the text from a text layer as string.
 *
 * This procedure returns the text from a text layer as a string.
 *
 * Returns: (transfer full): The text from the specified text layer.
 *          The returned value must be freed with g_free().
 *
 * Since: 2.6
 **/
gchar *
gimp_text_layer_get_text (GimpTextLayer *layer)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *text = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-get-text",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    text = GIMP_VALUES_DUP_STRING (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return text;
}

/**
 * gimp_text_layer_set_text:
 * @layer: The text layer.
 * @text: The new text to set.
 *
 * Set the text of a text layer.
 *
 * This procedure changes the text of a text layer.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.6
 **/
gboolean
gimp_text_layer_set_text (GimpTextLayer *layer,
                          const gchar   *text)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_STRING, text,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-set-text",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_text_layer_get_markup:
 * @layer: The text layer.
 *
 * Get the markup from a text layer as string.
 *
 * This procedure returns the markup of the styles from a text layer.
 * The markup will be in the form of Pango's markup - See
 * https://www.pango.org/ for more information about Pango and its
 * markup.
 *
 * Returns: (transfer full):
 *          The markup which represents the style of the specified text layer.
 *          The returned value must be freed with g_free().
 *
 * Since: 2.8
 **/
gchar *
gimp_text_layer_get_markup (GimpTextLayer *layer)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *markup = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-get-markup",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    markup = GIMP_VALUES_DUP_STRING (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return markup;
}

/**
 * gimp_text_layer_set_markup:
 * @layer: The text layer.
 * @markup: The new markup to set.
 *
 * Set the markup for a text layer from a string.
 *
 * This procedure sets the markup of the styles for a text layer. The
 * markup should be in the form of Pango's markup - See
 * https://docs.gtk.org/Pango/pango_markup.html for a reference.
 * Note that GIMP's text tool does not support all of Pango markup. Any
 * unsupported markup will still be applied to your text layer, yet
 * would be dropped as soon as you edit text with the tool.
 *
 * Returns: TRUE on success.
 *
 * Since: 3.0
 **/
gboolean
gimp_text_layer_set_markup (GimpTextLayer *layer,
                            const gchar   *markup)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_STRING, markup,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-set-markup",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_text_layer_get_font:
 * @layer: The text layer.
 *
 * Get the font from a text layer as string.
 *
 * This procedure returns the font from a text layer.
 *
 * Returns: (transfer none):
 *          The font which is used in the specified text layer.
 *
 * Since: 2.6
 **/
GimpFont *
gimp_text_layer_get_font (GimpTextLayer *layer)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpFont *font = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-get-font",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    font = GIMP_VALUES_GET_FONT (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return font;
}

/**
 * gimp_text_layer_set_font:
 * @layer: The text layer.
 * @font: The new font to use.
 *
 * Set the font of a text layer.
 *
 * This procedure modifies the font used in the specified text layer.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.6
 **/
gboolean
gimp_text_layer_set_font (GimpTextLayer *layer,
                          GimpFont      *font)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          GIMP_TYPE_FONT, font,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-set-font",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_text_layer_get_font_size:
 * @layer: The text layer.
 * @unit: (out) (transfer none): The unit used for the font size.
 *
 * Get the font size from a text layer.
 *
 * This procedure returns the size of the font which is used in a text
 * layer. You will receive the size as a float 'font-size' in 'unit'
 * units.
 *
 * Returns: The font size.
 *
 * Since: 2.6
 **/
gdouble
gimp_text_layer_get_font_size (GimpTextLayer *layer,
                               GimpUnit      *unit)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble font_size = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-get-font-size",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    {
      font_size = GIMP_VALUES_GET_DOUBLE (return_vals, 1);
      *unit = GIMP_VALUES_GET_INT (return_vals, 2);
    }

  gimp_value_array_unref (return_vals);

  return font_size;
}

/**
 * gimp_text_layer_set_font_size:
 * @layer: The text layer.
 * @font_size: The font size.
 * @unit: The unit to use for the font size.
 *
 * Set the font size.
 *
 * This procedure changes the font size of a text layer. The size of
 * your font will be a double 'font-size' of 'unit' units.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.6
 **/
gboolean
gimp_text_layer_set_font_size (GimpTextLayer *layer,
                               gdouble        font_size,
                               GimpUnit       unit)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_DOUBLE, font_size,
                                          GIMP_TYPE_UNIT, unit,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-set-font-size",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_text_layer_get_antialias:
 * @layer: The text layer.
 *
 * Check if antialiasing is used in the text layer.
 *
 * This procedure checks if antialiasing is enabled in the specified
 * text layer.
 *
 * Returns: A flag which is true if antialiasing is used for rendering the font in the text layer.
 *
 * Since: 2.6
 **/
gboolean
gimp_text_layer_get_antialias (GimpTextLayer *layer)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean antialias = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-get-antialias",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    antialias = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return antialias;
}

/**
 * gimp_text_layer_set_antialias:
 * @layer: The text layer.
 * @antialias: Enable/disable antialiasing of the text.
 *
 * Enable/disable anti-aliasing in a text layer.
 *
 * This procedure enables or disables anti-aliasing of the text in a
 * text layer.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.6
 **/
gboolean
gimp_text_layer_set_antialias (GimpTextLayer *layer,
                               gboolean       antialias)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_BOOLEAN, antialias,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-set-antialias",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_text_layer_get_hint_style:
 * @layer: The text layer.
 *
 * Get information about hinting in the specified text layer.
 *
 * This procedure provides information about the hinting that is being
 * used in a text layer. Hinting can be optimized for fidelity or
 * contrast or it can be turned entirely off.
 *
 * Returns: The hint style used for font outlines.
 *
 * Since: 2.8
 **/
GimpTextHintStyle
gimp_text_layer_get_hint_style (GimpTextLayer *layer)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpTextHintStyle style = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-get-hint-style",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    style = GIMP_VALUES_GET_ENUM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return style;
}

/**
 * gimp_text_layer_set_hint_style:
 * @layer: The text layer.
 * @style: The new hint style.
 *
 * Control how font outlines are hinted in a text layer.
 *
 * This procedure sets the hint style for font outlines in a text
 * layer. This controls whether to fit font outlines to the pixel grid,
 * and if so, whether to optimize for fidelity or contrast.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_text_layer_set_hint_style (GimpTextLayer     *layer,
                                GimpTextHintStyle  style)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          GIMP_TYPE_TEXT_HINT_STYLE, style,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-set-hint-style",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_text_layer_get_kerning:
 * @layer: The text layer.
 *
 * Check if kerning is used in the text layer.
 *
 * This procedure checks if kerning is enabled in the specified text
 * layer.
 *
 * Returns: A flag which is true if kerning is used in the text layer.
 *
 * Since: 2.6
 **/
gboolean
gimp_text_layer_get_kerning (GimpTextLayer *layer)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean kerning = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-get-kerning",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    kerning = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return kerning;
}

/**
 * gimp_text_layer_set_kerning:
 * @layer: The text layer.
 * @kerning: Enable/disable kerning in the text.
 *
 * Enable/disable kerning in a text layer.
 *
 * This procedure enables or disables kerning in a text layer.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.6
 **/
gboolean
gimp_text_layer_set_kerning (GimpTextLayer *layer,
                             gboolean       kerning)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_BOOLEAN, kerning,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-set-kerning",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_text_layer_get_language:
 * @layer: The text layer.
 *
 * Get the language used in the text layer.
 *
 * This procedure returns the language string which is set for the text
 * in the text layer.
 *
 * Returns: (transfer full): The language used in the text layer.
 *          The returned value must be freed with g_free().
 *
 * Since: 2.6
 **/
gchar *
gimp_text_layer_get_language (GimpTextLayer *layer)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *language = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-get-language",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    language = GIMP_VALUES_DUP_STRING (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return language;
}

/**
 * gimp_text_layer_set_language:
 * @layer: The text layer.
 * @language: The new language to use for the text layer.
 *
 * Set the language of the text layer.
 *
 * This procedure sets the language of the text in text layer. For some
 * scripts the language has an influence of how the text is rendered.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.6
 **/
gboolean
gimp_text_layer_set_language (GimpTextLayer *layer,
                              const gchar   *language)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_STRING, language,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-set-language",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_text_layer_get_base_direction:
 * @layer: The text layer.
 *
 * Get the base direction used for rendering the text layer.
 *
 * This procedure returns the base direction used for rendering the
 * text in the text layer
 *
 * Returns: The based direction used for the text layer.
 *
 * Since: 2.6
 **/
GimpTextDirection
gimp_text_layer_get_base_direction (GimpTextLayer *layer)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpTextDirection direction = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-get-base-direction",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    direction = GIMP_VALUES_GET_ENUM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return direction;
}

/**
 * gimp_text_layer_set_base_direction:
 * @layer: The text layer.
 * @direction: The base direction of the text.
 *
 * Set the base direction in the text layer.
 *
 * This procedure sets the base direction used in applying the Unicode
 * bidirectional algorithm when rendering the text.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.6
 **/
gboolean
gimp_text_layer_set_base_direction (GimpTextLayer     *layer,
                                    GimpTextDirection  direction)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          GIMP_TYPE_TEXT_DIRECTION, direction,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-set-base-direction",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_text_layer_get_justification:
 * @layer: The text layer.
 *
 * Get the text justification information of the text layer.
 *
 * This procedure returns the alignment of the lines in the text layer
 * relative to each other.
 *
 * Returns: The justification used in the text layer.
 *
 * Since: 2.6
 **/
GimpTextJustification
gimp_text_layer_get_justification (GimpTextLayer *layer)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpTextJustification justify = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-get-justification",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    justify = GIMP_VALUES_GET_ENUM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return justify;
}

/**
 * gimp_text_layer_set_justification:
 * @layer: The text layer.
 * @justify: The justification for your text.
 *
 * Set the justification of the text in a text layer.
 *
 * This procedure sets the alignment of the lines in the text layer
 * relative to each other.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.6
 **/
gboolean
gimp_text_layer_set_justification (GimpTextLayer         *layer,
                                   GimpTextJustification  justify)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          GIMP_TYPE_TEXT_JUSTIFICATION, justify,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-set-justification",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_text_layer_get_color:
 * @layer: The text layer.
 *
 * Get the color of the text in a text layer.
 *
 * This procedure returns the color of the text in a text layer.
 *
 * Returns: (transfer full): The color of the text.
 *
 * Since: 2.6
 **/
GeglColor *
gimp_text_layer_get_color (GimpTextLayer *layer)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GeglColor *color = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-get-color",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    color = g_value_dup_object (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return color;
}

/**
 * gimp_text_layer_set_color:
 * @layer: The text layer.
 * @color: The color to use for the text.
 *
 * Set the color of the text in the text layer.
 *
 * This procedure sets the text color in the text layer 'layer'.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.6
 **/
gboolean
gimp_text_layer_set_color (GimpTextLayer *layer,
                           GeglColor     *color)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          GEGL_TYPE_COLOR, color,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-set-color",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_text_layer_get_indent:
 * @layer: The text layer.
 *
 * Get the line indentation of text layer.
 *
 * This procedure returns the indentation of the first line in a text
 * layer.
 *
 * Returns: The indentation value of the first line.
 *
 * Since: 2.6
 **/
gdouble
gimp_text_layer_get_indent (GimpTextLayer *layer)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble indent = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-get-indent",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    indent = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return indent;
}

/**
 * gimp_text_layer_set_indent:
 * @layer: The text layer.
 * @indent: The indentation for the first line.
 *
 * Set the indentation of the first line in a text layer.
 *
 * This procedure sets the indentation of the first line in the text
 * layer.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.6
 **/
gboolean
gimp_text_layer_set_indent (GimpTextLayer *layer,
                            gdouble        indent)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_DOUBLE, indent,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-set-indent",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_text_layer_get_line_spacing:
 * @layer: The text layer.
 *
 * Get the spacing between lines of text.
 *
 * This procedure returns the line-spacing between lines of text in a
 * text layer.
 *
 * Returns: The line-spacing value.
 *
 * Since: 2.6
 **/
gdouble
gimp_text_layer_get_line_spacing (GimpTextLayer *layer)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble line_spacing = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-get-line-spacing",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    line_spacing = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return line_spacing;
}

/**
 * gimp_text_layer_set_line_spacing:
 * @layer: The text layer.
 * @line_spacing: The additional line spacing to use.
 *
 * Adjust the line spacing in a text layer.
 *
 * This procedure sets the additional spacing used between lines a text
 * layer.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.6
 **/
gboolean
gimp_text_layer_set_line_spacing (GimpTextLayer *layer,
                                  gdouble        line_spacing)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_DOUBLE, line_spacing,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-set-line-spacing",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_text_layer_get_letter_spacing:
 * @layer: The text layer.
 *
 * Get the letter spacing used in a text layer.
 *
 * This procedure returns the additional spacing between the single
 * glyphs in a text layer.
 *
 * Returns: The letter-spacing value.
 *
 * Since: 2.6
 **/
gdouble
gimp_text_layer_get_letter_spacing (GimpTextLayer *layer)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble letter_spacing = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-get-letter-spacing",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    letter_spacing = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return letter_spacing;
}

/**
 * gimp_text_layer_set_letter_spacing:
 * @layer: The text layer.
 * @letter_spacing: The additional letter spacing to use.
 *
 * Adjust the letter spacing in a text layer.
 *
 * This procedure sets the additional spacing between the single glyphs
 * in a text layer.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.6
 **/
gboolean
gimp_text_layer_set_letter_spacing (GimpTextLayer *layer,
                                    gdouble        letter_spacing)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_DOUBLE, letter_spacing,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-set-letter-spacing",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_text_layer_resize:
 * @layer: The text layer.
 * @width: The new box width in pixels.
 * @height: The new box height in pixels.
 *
 * Resize the box of a text layer.
 *
 * This procedure changes the width and height of a text layer while
 * keeping it as a text layer and not converting it to a bitmap like
 * gimp_layer_resize() would do.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.8
 **/
gboolean
gimp_text_layer_resize (GimpTextLayer *layer,
                        gdouble        width,
                        gdouble        height)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_TEXT_LAYER, layer,
                                          G_TYPE_DOUBLE, width,
                                          G_TYPE_DOUBLE, height,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-text-layer-resize",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
