      SUBROUTINE PAR_PUTNI ( PARAM, NDIM, MAXD, VALUES, ACTD,
     :                         STATUS )
*+
*  Name:
*     PAR_PUTNx
 
*  Purpose:
*     Puts an array of values into a parameter.
 
*  Language:
*     Starlink Fortran 77
 
*  Invocation:
*     CALL PAR_PUTNx ( PARAM, NDIM, MAXD, VALUES, ACTD, STATUS )
 
*  Description:
*     This routine puts an n-dimensional array of values into a
*     parameter.  If necessary, the specified array is converted to
*     the type of the parameter.
 
*  Arguments:
*     PARAM = CHARACTER * ( * ) (Given)
*        The parameter name.
*     NDIM = INTEGER (Given)
*        The number of dimensions of the values array.  This must match
*        the number of dimensions of the object.
*     MAXD( NDIM ) = INTEGER (Given)
*        The array specifying the dimensions of the array to be put.
*        These may not be greater than the actual dimensions of the
*        parameter (ACTD) nor those of the VALUES array.
*     VALUES( * ) = ? (Given)
*        The array of values to be put into the parameter.  These must
*        be in Fortran order.
*     ACTD( NDIM ) = INTEGER (Given)
*        The dimensions of the parameter storage to be created. These are
*        unlikely to be different from MAXD.
*     STATUS = INTEGER (Given and Returned)
*        The global status.
 
*  Notes:
*     -  There is a routine for each of the data types character,
*     double precision, integer, logical, and real: replace "x" in the
*     routine name by C, D, I, L, or R respectively as appropriate.  The
*     VALUES argument must have the corresponding data type.
*     - In order to obtain a storage object for the parameter, the
*     current implementation of the underlying ADAM parameter system
*     will proceed in the same way as it does for input parameters.
*     This can result in users being prompted for 'a value'. This
*     behaviour, and how to avoid it, is discussed further in the
*     Interface Module Reference Manual (SUN/115).
*     -  Limit checks for IN, RANGE, MIN/MAX are not applied.
 
*  Algorithm:
*     Call the underlying parameter-system primitives.
 
*  Authors:
*     BDK: B D Kelly (REVAD::BDK)
*     AJC: A J Chipperfield (STARLINK)
*     {enter_new_authors_here}
 
*  History:
*     18-NOV-1984 (BDK):
*        Original version.
*     1-JUN-1988 (AJC):
*        Revised prologue.
*     12-NOV-1990 (AJC):
*        Revised prologue again
*     1992 November 13 (MJC):
*        Commented the code, and renamed the NAMECODE identifier.
*        Fixed bug so the pointer rather than the parameter name is
*        passed to the SUBPAR_PUTNx routine.  Re-tidied the prologue.
*      9-NOV-1998 (AJC):
*        Correct description of ACTD
*     {enter_further_changes_here}
 
*  Bugs:
*     {note_any_bugs_here}
 
*-
 
*  Type Definitions:
      IMPLICIT NONE              ! No implicit typing
 
*  Global Constants:
      INCLUDE 'SAE_PAR'          ! Standard SAE constants
 
*  Arguments Given:
      CHARACTER * ( * ) PARAM
      INTEGER NDIM
      INTEGER MAXD( * )
      INTEGER VALUES( * )
 
*  Arguments Returned:
      INTEGER ACTD( * )
 
*  Status:
      INTEGER STATUS              ! Global status
 
*  Local Variables:
      INTEGER NAMCOD              ! Pointer to the parameter
 
*.
 
*  Check the inherited global status.
      IF ( STATUS .NE. SAI__OK ) RETURN
 
*  Find the parameter-system pointer to the internal parameter space
*  associated with the parameter.
      CALL SUBPAR_FINDPAR( PARAM, NAMCOD, STATUS )
 
*  Use the pointer to put the array of values into the parameter.
      CALL SUBPAR_PUTNI( NAMCOD, NDIM, MAXD, VALUES, ACTD, STATUS )
 
      END
