      SUBROUTINE NDF_ACRE( INDF, STATUS )
*+
*  Name:
*     NDF_ACRE

*  Purpose:
*     Ensure that an axis coordinate system exists for an NDF.

*  Language:
*     Starlink Fortran 77

*  Invocation:
*     CALL NDF_ACRE( INDF, STATUS )

*  Description:
*     The routine ensures that an axis coordinate system exists for an
*     NDF. An axis component with default coordinate values is created
*     if necessary.

*  Arguments:
*     INDF = INTEGER (Given)
*        NDF identifier.
*     STATUS = INTEGER (Given and Returned)
*        The global status.

*  Algorithm:
*     -  Import the NDF identifier.
*     -  Check that write access to the NDF is available.
*     -  Obtain an index to the data object entry in the DCB.
*     -  Create the axis coordinate system if necessary.
*     -  If an error occurred, then report context information.

*  Authors:
*     RFWS: R.F. Warren-Smith (STARLINK)
*     {enter_new_authors_here}

*  History:
*     29-JUN-1990 (RFWS):
*        Original version.
*     15-OCT-1990 (RFWS):
*        Changed to pass a DCB index to NDF1_ACRE rather than an ACB
*        index.
*     {enter_further_changes_here}

*  Bugs:
*     {note_any_bugs_here}

*-
      
*  Type Definitions:
      IMPLICIT NONE              ! No implicit typing

*  Global Constants:
      INCLUDE 'SAE_PAR'          ! Standard SAE constants
      INCLUDE 'DAT_PAR'          ! DAT_ public constants
      INCLUDE 'NDF_PAR'          ! NDF_ public constants
      INCLUDE 'NDF_CONST'        ! NDF_ private constants

*  Global Variables:
      INCLUDE 'NDF_ACB'          ! NDF_ Access Control Block
*        ACB_IDCB( NDF__MXACB ) = INTEGER (Read)
*           Index to data object entry in the DCB.

*  Arguments Given:
      INTEGER INDF

*  Status:
      INTEGER STATUS             ! Global status

*  Local Variables:
      INTEGER IACB               ! Index to the NDF entry in the ACB
      INTEGER IDCB               ! Index to data object entry in the DCB

*.

*  Check inherited global status.
      IF ( STATUS .NE. SAI__OK ) RETURN

*  Import the NDF identifier.
      CALL NDF1_IMPID( INDF, IACB, STATUS )

*  Check that write access to the NDF is available.
      CALL NDF1_CHACC( IACB, 'WRITE', STATUS )
      IF ( STATUS .EQ. SAI__OK ) THEN

*  Obtain an index to the data object entry in the DCB.
         IDCB = ACB_IDCB( IACB )

*  Create the axis coordinate system if necessary.
         CALL NDF1_ACRE( IDCB, STATUS )
      END IF
       
*  If an error occurred, then report context information and call the
*  error tracing routine.
      IF ( STATUS .NE. SAI__OK ) THEN
         CALL ERR_REP( 'NDF_ACRE_ERR',
     :   'NDF_ACRE: Error ensuring that an axis coordinate system ' //
     :   'exists for an NDF.', STATUS )
         CALL NDF1_TRACE( 'NDF_ACRE', STATUS )
      END IF

      END
