/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api;

import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.Appendable;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.ChildElement;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.DefaultDocumentWriter;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.Element;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.Factory;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.NamespaceRegistry;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.schema.QualifiedName;

public interface DocumentWriter<T extends Element<T>>
extends Closeable,
Appendable<T> {
    public static <T extends Element<T>> DocumentWriter<T> noop() {
        return new DocumentWriter<T>(){

            @Override
            public <C extends ChildElement<T, ? super C>> Appendable<T> append(Factory<C> creator, Consumer<? super C> configurer) {
                return this;
            }

            @Override
            public void close() {
            }
        };
    }

    public static <R extends Element<R>> DocumentWriter<R> create(QualifiedName rootElementName, NamespaceRegistry namespaceRegistry, Path xmlFile) throws Exception {
        return new DefaultDocumentWriter(rootElementName, namespaceRegistry, Files.newBufferedWriter(xmlFile, new OpenOption[0]));
    }
}

