/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.NamespaceRegistry;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.schema.Namespace;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.schema.QualifiedName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Context {
    private final ConcurrentMap<QualifiedName, String> prefixedNames = new ConcurrentHashMap<QualifiedName, String>();
    private final Document document;
    private final NamespaceRegistry namespaceRegistry;

    static Context create(QualifiedName rootElement, NamespaceRegistry namespaceRegistry) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Context context = new Context(document, namespaceRegistry);
            document.appendChild(Context.createRoot(rootElement, namespaceRegistry, context));
            return context;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Element createRoot(QualifiedName rootElement, NamespaceRegistry namespaceRegistry, Context context) {
        Element root = context.createElement(rootElement);
        namespaceRegistry.getAdditionalNamespaces().forEach(namespace -> {
            String prefix = namespaceRegistry.getPrefix((Namespace)namespace).orElseThrow(IllegalStateException::new);
            root.setAttribute("xmlns:" + prefix, namespace.getUri());
        });
        return root;
    }

    private Context(Document document, NamespaceRegistry namespaceRegistry) {
        this.document = document;
        this.namespaceRegistry = namespaceRegistry;
    }

    Document getDocument() {
        return this.document;
    }

    Element createElement(QualifiedName qualifiedName) {
        return this.namespaceRegistry.getPrefix(qualifiedName.getNamespace()).isPresent() ? this.document.createElementNS(qualifiedName.getNamespace().getUri(), this.prefixed(qualifiedName)) : this.document.createElement(qualifiedName.getSimpleName());
    }

    String prefixed(QualifiedName qualifiedName) {
        Optional<String> prefix = this.namespaceRegistry.getPrefix(qualifiedName.getNamespace());
        return this.prefixedNames.computeIfAbsent(qualifiedName, __ -> prefix.map(it -> it + ":" + qualifiedName.getSimpleName()).orElse(qualifiedName.getSimpleName()));
    }
}

