/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import org.openjdk.asmtools.jasm.Tables;
import org.openjdk.asmtools.jdis.CodeData;
import org.openjdk.asmtools.jdis.TraceUtils;

class StackMapData {
    static int prevFramePC = 0;
    boolean isStackMapTable = false;
    Tables.StackMapFrameType stackFrameType = null;
    int start_pc;
    int[] lockMap;
    int[] stackMap;

    public StackMapData(CodeData code, DataInputStream in) throws IOException {
        this.start_pc = in.readUnsignedShort();
        this.lockMap = this.readMap(code, in);
        this.stackMap = this.readMap(code, in);
        TraceUtils.traceln(2, String.format("stack_map_entry:pc=%d numloc=%s  numstack=%s", this.start_pc, TraceUtils.mapToHexString(this.lockMap), TraceUtils.mapToHexString(this.stackMap)));
    }

    public StackMapData(CodeData code, DataInputStream in, boolean isStackMapTable) throws IOException {
        this.isStackMapTable = isStackMapTable;
        int ft_val = in.readUnsignedByte();
        Tables.StackMapFrameType frame_type = Tables.stackMapFrameType(ft_val);
        int offset = 0;
        switch (frame_type) {
            case SAME_FRAME: {
                offset = ft_val;
                TraceUtils.traceln(2, String.format("same_frame=%d", ft_val));
                break;
            }
            case SAME_FRAME_EX: {
                offset = in.readUnsignedShort();
                TraceUtils.traceln(2, String.format("same_frame_extended=%d, offset=%d", ft_val, offset));
                break;
            }
            case SAME_LOCALS_1_STACK_ITEM_FRAME: {
                offset = ft_val - 64;
                this.stackMap = this.readMapElements(code, in, 1);
                TraceUtils.traceln(2, String.format("same_locals_1_stack_item_frame=%d, offset=%d, numstack=%s", ft_val, offset, TraceUtils.mapToHexString(this.stackMap)));
                break;
            }
            case SAME_LOCALS_1_STACK_ITEM_EXTENDED_FRAME: {
                offset = in.readUnsignedShort();
                this.stackMap = this.readMapElements(code, in, 1);
                TraceUtils.traceln(2, String.format("same_locals_1_stack_item_frame_extended=%d, offset=%d, numstack=%s", ft_val, offset, TraceUtils.mapToHexString(this.stackMap)));
                break;
            }
            case CHOP_1_FRAME: 
            case CHOP_2_FRAME: 
            case CHOP_3_FRAME: {
                offset = in.readUnsignedShort();
                TraceUtils.traceln(2, String.format("chop_frame=%d offset=%d", ft_val, offset));
                break;
            }
            case APPEND_FRAME: {
                offset = in.readUnsignedShort();
                this.lockMap = this.readMapElements(code, in, ft_val - 251);
                TraceUtils.traceln(2, String.format("append_frame=%d offset=%d numlock=%s", ft_val, offset, TraceUtils.mapToHexString(this.lockMap)));
                break;
            }
            case FULL_FRAME: {
                offset = in.readUnsignedShort();
                this.lockMap = this.readMap(code, in);
                this.stackMap = this.readMap(code, in);
                TraceUtils.traceln(2, String.format("full_frame=%d offset=%d numloc=%s  numstack=%s", ft_val, offset, TraceUtils.mapToHexString(this.lockMap), TraceUtils.mapToHexString(this.stackMap)));
                break;
            }
            default: {
                TraceUtils.traceln("incorrect frame_type argument");
            }
        }
        this.stackFrameType = frame_type;
        prevFramePC = this.start_pc = prevFramePC == 0 ? offset : prevFramePC + offset + 1;
    }

    private int[] readMap(CodeData code, DataInputStream in) throws IOException {
        int num = in.readUnsignedShort();
        return this.readMapElements(code, in, num);
    }

    private int[] readMapElements(CodeData code, DataInputStream in, int num) throws IOException {
        int[] map = new int[num];
        for (int k = 0; k < num; ++k) {
            int mt_val = 0;
            mt_val = in.readUnsignedByte();
            Tables.StackMapType maptype = Tables.stackMapType(mt_val, null);
            switch (maptype) {
                case ITEM_Object: {
                    mt_val |= in.readUnsignedShort() << 8;
                    break;
                }
                case ITEM_NewObject: {
                    int pc = in.readUnsignedShort();
                    code.get_iAtt((int)pc).referred = true;
                    mt_val |= pc << 8;
                    break;
                }
            }
            map[k] = mt_val;
        }
        return map;
    }
}

