/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.Indenter;
import org.openjdk.asmtools.jdis.Options;

public class BootstrapMethodData
extends Indenter {
    int bsm_index;
    ArrayList<Integer> bsm_args_indexes;
    private Options options = Options.OptionObject();
    private ClassData cls;
    private PrintWriter out;

    public BootstrapMethodData(ClassData cls) {
        this.cls = cls;
        this.out = cls.out;
    }

    public void read(DataInputStream in) throws IOException {
        this.bsm_index = in.readUnsignedShort();
        int arg_num = in.readUnsignedShort();
        this.bsm_args_indexes = new ArrayList(arg_num);
        for (int i = 0; i < arg_num; ++i) {
            this.bsm_args_indexes.add(in.readUnsignedShort());
        }
    }

    public void print() throws IOException {
        this.out.print(this.getIndentString() + JasmTokens.Token.BOOTSTRAPMETHOD.parseKey() + " #" + this.bsm_index);
        for (int i = 0; i < this.bsm_args_indexes.size(); ++i) {
            this.out.print(" #" + this.bsm_args_indexes.get(i));
        }
        this.out.println(";");
    }
}

