/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.openjdk.asmtools.jasm.Tables;
import org.openjdk.asmtools.jdis.AnnotationData;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.ConstantPool;
import org.openjdk.asmtools.jdis.TraceUtils;

public class AnnotationElement {
    public int name_cpx;
    public AnnotValue value = null;
    protected ClassData cls;

    public static AnnotValue readValue(DataInputStream in, ClassData cls, boolean invisible) throws IOException {
        AnnotValue val = null;
        char tg = (char)in.readByte();
        Tables.AnnotElemType tag = Tables.annotElemType(tg);
        switch (tag) {
            case AE_STRING: 
            case AE_BYTE: 
            case AE_CHAR: 
            case AE_INT: 
            case AE_SHORT: 
            case AE_BOOLEAN: 
            case AE_FLOAT: 
            case AE_DOUBLE: 
            case AE_LONG: 
            case AE_CLASS: {
                short CPX3 = in.readShort();
                val = new CPX_AnnotValue(tag, cls, CPX3);
                break;
            }
            case AE_ENUM: {
                short CPX1 = in.readShort();
                short CPX22 = in.readShort();
                val = new CPX2_AnnotValue(tag, cls, CPX1, CPX22);
                break;
            }
            case AE_ANNOTATION: {
                AnnotationData ad = new AnnotationData(invisible, cls);
                ad.read(in);
                val = new Annot_AnnotValue(tag, cls, ad);
                break;
            }
            case AE_ARRAY: {
                Array_AnnotValue aelem;
                val = aelem = new Array_AnnotValue(tag, cls);
                int cnt = in.readShort();
                for (int i = 0; i < cnt; ++i) {
                    aelem.add(AnnotationElement.readValue(in, cls, invisible));
                }
                break;
            }
            default: {
                throw new IOException("Unknown tag in annotation '" + tg + "' [" + Integer.toHexString(tg) + "]");
            }
        }
        return val;
    }

    public AnnotationElement(ClassData cls) {
        this.cls = cls;
    }

    public void read(DataInputStream in, boolean invisible) throws IOException {
        this.name_cpx = in.readShort();
        this.value = AnnotationElement.readValue(in, this.cls, invisible);
        TraceUtils.traceln(String.format("                   AnnotElem: name[%d]=%s value=%s", this.name_cpx, this.cls.pool.getString(this.name_cpx), this.value.toString()));
    }

    public String stringVal() {
        return this.cls.pool.getName(this.name_cpx);
    }

    public void print(PrintWriter out, String tab) {
        out.print(this.stringVal() + " = ");
        this.value.print(out, "");
    }

    public String toString() {
        return "<AnnotElem " + this.stringVal() + " = " + this.value.toString() + ">";
    }

    public static class CPX_AnnotValue
    extends AnnotValue {
        public int cpx;

        public CPX_AnnotValue(Tables.AnnotElemType tag, ClassData cls, int cpx) {
            super(tag, cls);
            this.cpx = cpx;
        }

        @Override
        public String stringVal() {
            StringBuilder sb = new StringBuilder();
            switch (this.tag) {
                case AE_STRING: {
                    sb.append('\"' + this.cls.pool.getString(this.cpx) + '\"');
                    break;
                }
                case AE_BYTE: {
                    sb.append("byte " + this.cls.pool.getConst(this.cpx).stringVal());
                    break;
                }
                case AE_CHAR: {
                    sb.append("char " + this.cls.pool.getConst(this.cpx).stringVal());
                    break;
                }
                case AE_INT: {
                    sb.append(this.cls.pool.getConst(this.cpx).stringVal());
                    break;
                }
                case AE_SHORT: {
                    sb.append("short " + this.cls.pool.getConst(this.cpx).stringVal());
                    break;
                }
                case AE_BOOLEAN: {
                    ConstantPool.CP_Int cns = (ConstantPool.CP_Int)this.cls.pool.getConst(this.cpx);
                    sb.append("boolean " + (cns.value == 0 ? "false" : "true"));
                    break;
                }
                case AE_FLOAT: {
                    sb.append(this.cls.pool.getConst(this.cpx).stringVal());
                    break;
                }
                case AE_DOUBLE: {
                    sb.append(this.cls.pool.getConst(this.cpx).stringVal());
                    break;
                }
                case AE_LONG: {
                    sb.append(this.cls.pool.getConst(this.cpx).stringVal());
                    break;
                }
                case AE_CLASS: {
                    sb.append("class " + this.cls.pool.decodeClassDescriptor(this.cpx));
                    break;
                }
            }
            return sb.toString();
        }

        @Override
        public void print(PrintWriter out, String tab) {
            out.print(tab + this.stringVal());
        }

        @Override
        public String toString() {
            return "<CPX_AnnotValue tag: '" + (Object)((Object)this.tag) + "' stringVal=" + this.stringVal() + ">";
        }
    }

    public static class CPX2_AnnotValue
    extends AnnotValue {
        public int cpx1;
        public int cpx2;

        public CPX2_AnnotValue(Tables.AnnotElemType tag, ClassData cls, int cpx1, int cpx2) {
            super(tag, cls);
            this.cpx1 = cpx1;
            this.cpx2 = cpx2;
        }

        @Override
        public String stringVal() {
            StringBuilder sb = new StringBuilder();
            switch (this.tag) {
                case AE_ENUM: {
                    sb.append("enum " + this.cls.pool.decodeClassDescriptor(this.cpx1) + " " + this.cls.pool.getName(this.cpx2));
                    break;
                }
            }
            return sb.toString();
        }

        @Override
        public void print(PrintWriter out, String tab) {
            out.print(tab + this.stringVal());
        }

        @Override
        public String toString() {
            return "<CPX2_AnnotValue tag: '" + (Object)((Object)this.tag) + "' stringVal=" + this.stringVal() + ">";
        }
    }

    public static class Annot_AnnotValue
    extends AnnotValue {
        AnnotationData annot;

        public Annot_AnnotValue(Tables.AnnotElemType tagval, ClassData cls, AnnotationData annot) {
            super(tagval, cls);
            this.annot = annot;
        }

        @Override
        public String stringVal() {
            return this.annot.toString();
        }

        @Override
        public void print(PrintWriter out, String tab) {
            this.annot.print(out, tab);
        }

        @Override
        public String toString() {
            return "<Annot_AnnotValue " + (Object)((Object)this.tag) + " " + this.stringVal() + ">";
        }
    }

    public static class Array_AnnotValue
    extends AnnotValue {
        public ArrayList<AnnotValue> array = new ArrayList();

        public Array_AnnotValue(Tables.AnnotElemType tagval, ClassData cls) {
            super(tagval, cls);
        }

        @Override
        public String stringVal() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.stringVal() + " = ");
            sb.append("{");
            int i = 0;
            int cnt = this.array.size();
            for (AnnotValue arrayelem : this.array) {
                sb.append(arrayelem.toString());
                if (i >= cnt - 1) continue;
                sb.append(",");
            }
            sb.append("}");
            return sb.toString();
        }

        public void add(AnnotValue elem) {
            this.array.add(elem);
        }

        @Override
        public void print(PrintWriter out, String tab) {
            out.println("{");
            int i = 0;
            int cnt = this.array.size();
            for (AnnotValue arrayelem : this.array) {
                arrayelem.print(out, tab + "  ");
                if (i < cnt - 1) {
                    out.println(",");
                }
                ++i;
            }
            out.println("}");
        }

        @Override
        public String toString() {
            return "<Array_AnnotValue " + (Object)((Object)this.tag) + " " + this.stringVal() + ">";
        }
    }

    public static class AnnotValue {
        public Tables.AnnotElemType tag;
        protected ClassData cls;

        public AnnotValue(Tables.AnnotElemType tagval, ClassData cls) {
            this.tag = tagval;
            this.cls = cls;
        }

        public String stringVal() {
            return "";
        }

        public void print(PrintWriter out, String tab) {
            out.print(this.tag.val() + "  ");
        }

        public String toString() {
            return "<AnnotValue " + this.tag.printval() + " " + this.stringVal() + ">";
        }
    }
}

