/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jcoder;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Stack;
import org.openjdk.asmtools.jcoder.ByteBuffer;
import org.openjdk.asmtools.jcoder.JcodTokens;
import org.openjdk.asmtools.jcoder.Scanner;
import org.openjdk.asmtools.jcoder.SourceFile;
import org.openjdk.asmtools.jcoder.SyntaxError;

class Jcoder {
    private ArrayList<ByteBuffer> Classes = new ArrayList();
    private ByteBuffer buf;
    private DataOutputStream bufstream;
    private int depth = 0;
    private String tabStr = "";
    private Context context = null;
    protected SourceFile env;
    protected Scanner scanner;
    private static char fileSeparator;

    Jcoder(SourceFile sf, HashMap<String, String> macros) throws IOException {
        this.scanner = new Scanner(sf, macros);
        this.env = sf;
        this.context = new Context();
    }

    private void expect(JcodTokens.Token t) throws SyntaxError, IOException {
        if (this.scanner.token != t) {
            this.env.traceln("expect:" + (Object)((Object)t) + " instead of " + (Object)((Object)this.scanner.token));
            switch (t) {
                case IDENT: {
                    this.env.error(this.scanner.pos, "identifier.expected");
                    break;
                }
                default: {
                    this.env.error(this.scanner.pos, "token.expected", t.toString());
                }
            }
            throw new SyntaxError();
        }
        this.scanner.scan();
    }

    private void recoverField() throws SyntaxError, IOException {
        block6: while (true) {
            switch (this.scanner.token) {
                case LBRACE: {
                    this.scanner.match(JcodTokens.Token.LBRACE, JcodTokens.Token.RBRACE);
                    this.scanner.scan();
                    continue block6;
                }
                case LPAREN: {
                    this.scanner.match(JcodTokens.Token.LPAREN, JcodTokens.Token.RPAREN);
                    this.scanner.scan();
                    continue block6;
                }
                case LSQBRACKET: {
                    this.scanner.match(JcodTokens.Token.LSQBRACKET, JcodTokens.Token.RSQBRACKET);
                    this.scanner.scan();
                    continue block6;
                }
                case RBRACE: 
                case EOF: 
                case INTERFACE: 
                case CLASS: {
                    throw new SyntaxError();
                }
            }
            this.scanner.scan();
        }
    }

    private void parseArray() throws IOException {
        int numSize;
        int num_expected;
        this.scanner.scan();
        int length0 = this.buf.length;
        int pos0 = this.scanner.pos;
        if (this.scanner.token == JcodTokens.Token.INTVAL) {
            num_expected = this.scanner.intValue;
            this.scanner.scan();
        } else {
            num_expected = -1;
        }
        this.expect(JcodTokens.Token.RSQBRACKET);
        switch (this.scanner.token) {
            case BYTEINDEX: {
                this.scanner.scan();
                numSize = 1;
                break;
            }
            case SHORTINDEX: {
                this.scanner.scan();
                numSize = 2;
                break;
            }
            case ZEROINDEX: {
                this.scanner.scan();
                numSize = 0;
                break;
            }
            default: {
                numSize = 2;
            }
        }
        if (numSize > 0) {
            this.buf.append(num_expected, numSize);
        }
        int num_present = this.parseStruct();
        if (num_expected == -1) {
            this.env.trace(" buf.writeAt(" + length0 + ", " + num_present + ", " + numSize + ");  ");
            if (numSize > 0) {
                this.buf.writeAt(length0, num_present, numSize);
            }
        } else if (num_expected != num_present) {
            if (this.context.isConstantPool() && num_expected == num_present + 1) {
                return;
            }
            this.env.error(pos0, "warn.array.wronglength", num_expected, num_present);
        }
    }

    private void parseByteArray() throws IOException {
        int lenSize;
        int len_expected;
        this.scanner.scan();
        this.expect(JcodTokens.Token.LSQBRACKET);
        int length0 = this.buf.length;
        int pos0 = this.scanner.pos;
        if (this.scanner.token == JcodTokens.Token.INTVAL) {
            len_expected = this.scanner.intValue;
            this.scanner.scan();
        } else {
            len_expected = -1;
        }
        this.expect(JcodTokens.Token.RSQBRACKET);
        switch (this.scanner.token) {
            case BYTEINDEX: {
                this.scanner.scan();
                lenSize = 1;
                break;
            }
            case SHORTINDEX: {
                this.scanner.scan();
                lenSize = 2;
                break;
            }
            case ZEROINDEX: {
                this.scanner.scan();
                lenSize = 0;
                break;
            }
            default: {
                lenSize = 4;
            }
        }
        if (lenSize > 0) {
            this.buf.append(len_expected, lenSize);
        }
        int length1 = this.buf.length;
        this.parseStruct();
        int len_present = this.buf.length - length1;
        if (len_expected == -1) {
            this.env.trace(" buf.writeAt(" + length0 + ", " + len_present + ", " + lenSize + ");  ");
            if (lenSize > 0) {
                this.buf.writeAt(length0, len_present, lenSize);
            }
        } else if (len_expected != len_present) {
            this.env.error(pos0, "warn.array.wronglength", len_expected, len_present);
        }
    }

    private void parseAttr() throws IOException {
        int len_expected;
        this.scanner.scan();
        this.expect(JcodTokens.Token.LPAREN);
        if (this.scanner.token != JcodTokens.Token.INTVAL) {
            this.env.error(this.scanner.pos, "attrname.expected");
            throw new SyntaxError();
        }
        int cpx = this.scanner.intValue;
        this.scanner.scan();
        this.buf.append(cpx, 2);
        int pos0 = this.scanner.pos;
        int length0 = this.buf.length;
        if (this.scanner.token == JcodTokens.Token.COMMA) {
            this.scanner.scan();
            len_expected = this.scanner.intValue;
            this.expect(JcodTokens.Token.INTVAL);
        } else {
            len_expected = -1;
        }
        this.buf.append(len_expected, 4);
        this.expect(JcodTokens.Token.RPAREN);
        this.parseStruct();
        int len_present = this.buf.length - (length0 + 4);
        if (len_expected == -1) {
            this.buf.writeAt(length0, len_present, 4);
        } else if (len_expected != len_present) {
            this.env.error(pos0, "warn.attr.wronglength", len_expected, len_present);
        }
    }

    private void parseComp() throws IOException {
        int len_expected;
        this.scanner.scan();
        this.expect(JcodTokens.Token.LPAREN);
        int tag = this.scanner.intValue;
        this.expect(JcodTokens.Token.INTVAL);
        this.buf.append(tag, 1);
        int pos0 = this.scanner.pos;
        int length0 = this.buf.length;
        if (this.scanner.token == JcodTokens.Token.COMMA) {
            this.scanner.scan();
            len_expected = this.scanner.intValue;
            this.expect(JcodTokens.Token.INTVAL);
        } else {
            len_expected = -1;
        }
        this.buf.append(len_expected, 2);
        this.expect(JcodTokens.Token.RPAREN);
        this.parseStruct();
        int len_present = this.buf.length - (length0 + 2);
        if (len_expected == -1) {
            this.buf.writeAt(length0, len_present, 2);
        } else if (len_expected != len_present) {
            this.env.error(pos0, "warn.attr.wronglength", len_expected, len_present);
        }
    }

    private void adjustDepth(boolean up) {
        if (up) {
            ++this.depth;
            this.context.update();
            this.scanner.setDebugCP(this.context.isConstantPool());
        } else {
            --this.depth;
            this.context.exit();
        }
        StringBuilder bldr = new StringBuilder();
        int tabAmt = 4;
        int len = this.depth * tabAmt;
        for (int i = 0; i < len; ++i) {
            bldr.append(" ");
        }
        this.tabStr = bldr.toString();
    }

    private int parseStruct() throws IOException {
        this.adjustDepth(true);
        this.env.traceln(" ");
        this.env.traceln(this.tabStr + "MapStruct { <" + this.context + "> ");
        this.expect(JcodTokens.Token.LBRACE);
        int num = 0;
        int addElem = 0;
        block16: while (true) {
            try {
                switch (this.scanner.token) {
                    case COMMA: {
                        this.scanner.scan();
                        continue block16;
                    }
                    case SEMICOLON: {
                        ++num;
                        addElem = 0;
                        this.scanner.scan();
                        continue block16;
                    }
                    case CLASS: {
                        this.scanner.addConstDebug(JcodTokens.ConstType.CONSTANT_CLASS);
                        this.env.trace("class ");
                        this.scanner.longValue = JcodTokens.ConstType.CONSTANT_CLASS.value();
                        this.scanner.intSize = 1;
                    }
                    case INTVAL: {
                        this.env.trace("int [" + this.scanner.longValue + "] ");
                        this.buf.append(this.scanner.longValue, this.scanner.intSize);
                        this.scanner.scan();
                        addElem = 1;
                        continue block16;
                    }
                    case STRINGVAL: {
                        this.scanner.scan();
                        this.scanner.addConstDebug(JcodTokens.ConstType.CONSTANT_UTF8);
                        this.env.trace("UTF8 [\"" + this.scanner.stringValue + "\"] ");
                        this.bufstream.writeUTF(this.scanner.stringValue);
                        addElem = 1;
                        continue block16;
                    }
                    case LONGSTRINGVAL: {
                        this.scanner.scan();
                        this.env.traceln("LongString [\"" + Arrays.toString(this.scanner.longStringValue.data) + "\"] ");
                        this.buf.write(this.scanner.longStringValue.data, 0, this.scanner.longStringValue.length);
                        addElem = 1;
                        continue block16;
                    }
                    case LBRACE: {
                        this.parseStruct();
                        addElem = 1;
                        continue block16;
                    }
                    case LSQBRACKET: {
                        this.parseArray();
                        addElem = 1;
                        continue block16;
                    }
                    case BYTES: {
                        this.env.trace("bytes ");
                        this.parseByteArray();
                        addElem = 1;
                        continue block16;
                    }
                    case ATTR: {
                        this.env.trace("attr ");
                        this.parseAttr();
                        addElem = 1;
                        continue block16;
                    }
                    case COMP: {
                        this.env.trace("comp ");
                        this.parseComp();
                        addElem = 1;
                        continue block16;
                    }
                    case RBRACE: {
                        this.scanner.scan();
                        this.env.traceln(" ");
                        this.env.traceln(this.tabStr + "} // MapStruct  <" + this.context + "> [");
                        this.adjustDepth(false);
                        return num + addElem;
                    }
                }
                this.env.traceln("unexp token=" + (Object)((Object)this.scanner.token));
                this.env.traceln("   scanner.stringval = \"" + this.scanner.stringValue + "\"");
                this.env.error(this.scanner.pos, "element.expected");
                throw new SyntaxError();
            }
            catch (SyntaxError e) {
                this.recoverField();
                continue;
            }
            break;
        }
    }

    private void recoverFile() throws IOException {
        block7: while (true) {
            switch (this.scanner.token) {
                case INTERFACE: 
                case CLASS: {
                    return;
                }
                case LBRACE: {
                    this.scanner.match(JcodTokens.Token.LBRACE, JcodTokens.Token.RBRACE);
                    this.scanner.scan();
                    continue block7;
                }
                case LPAREN: {
                    this.scanner.match(JcodTokens.Token.LPAREN, JcodTokens.Token.RPAREN);
                    this.scanner.scan();
                    continue block7;
                }
                case LSQBRACKET: {
                    this.scanner.match(JcodTokens.Token.LSQBRACKET, JcodTokens.Token.RSQBRACKET);
                    this.scanner.scan();
                    continue block7;
                }
                case EOF: {
                    return;
                }
            }
            this.scanner.scan();
        }
    }

    private void parseModule() throws IOException {
        this.scanner.skipTill(123);
        this.buf = new ByteBuffer();
        this.bufstream = new DataOutputStream(this.buf);
        this.buf.myname = "module-info.class";
        this.scanner.scan();
        this.env.traceln("starting " + this.buf.myname);
        this.parseClause();
        this.env.traceln("ending " + this.buf.myname);
    }

    private void parseClass(JcodTokens.Token prev) throws IOException {
        this.scanner.scan();
        this.buf = new ByteBuffer();
        this.bufstream = new DataOutputStream(this.buf);
        switch (this.scanner.token) {
            case STRINGVAL: {
                this.buf.myname = this.scanner.stringValue;
                break;
            }
            case IDENT: 
            case BYTEINDEX: 
            case SHORTINDEX: 
            case BYTES: 
            case ATTR: 
            case COMP: 
            case MACRO: 
            case FILE: {
                if (prev == JcodTokens.Token.FILE) {
                    this.buf.myname = this.scanner.stringValue;
                    break;
                }
                this.buf.myname = this.scanner.stringValue + ".class";
                break;
            }
            default: {
                this.env.error(this.scanner.prevPos, "name.expected");
                throw new SyntaxError();
            }
        }
        this.scanner.scan();
        this.env.traceln("starting class " + this.buf.myname);
        this.parseClause();
        this.env.traceln("ending class " + this.buf.myname);
    }

    private void parseClause() throws IOException {
        switch (this.scanner.token) {
            case LBRACE: {
                this.parseStruct();
                break;
            }
            case LSQBRACKET: {
                this.parseArray();
                break;
            }
            case BYTES: {
                this.parseByteArray();
                break;
            }
            case ATTR: {
                this.parseAttr();
                break;
            }
            case COMP: {
                this.parseComp();
                break;
            }
            default: {
                this.env.error(this.scanner.pos, "struct.expected");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void parseFile() {
        this.env.traceln("PARSER");
        this.context.init();
        try {
            block9: while (this.scanner.token != JcodTokens.Token.EOF) {
                try {
                    switch (this.scanner.token) {
                        case INTERFACE: 
                        case CLASS: 
                        case FILE: 
                        case MODULE: {
                            JcodTokens.Token t = this.scanner.token;
                            if (t == JcodTokens.Token.MODULE) {
                                this.parseModule();
                            } else {
                                this.parseClass(t);
                            }
                            this.env.flushErrors();
                            this.Classes.add(this.buf);
                            continue block9;
                        }
                        case SEMICOLON: {
                            this.scanner.scan();
                            continue block9;
                        }
                        case EOF: {
                            return;
                        }
                    }
                    this.env.traceln("unexpected token=" + this.scanner.token.toString());
                    this.env.error(this.scanner.pos, "toplevel.expected");
                    throw new SyntaxError();
                }
                catch (SyntaxError e) {
                    String msg = e.getMessage();
                    this.env.traceln("SyntaxError " + (msg == null ? "" : msg));
                    if (this.env.debugInfoFlag) {
                        e.printStackTrace();
                    }
                    this.recoverFile();
                }
            }
            return;
        }
        catch (IOException e) {
            this.env.error(this.scanner.pos, "io.exception", this.env.getInputFileName());
        }
    }

    public void write(ByteBuffer cls, File destdir) throws IOException {
        File outfile;
        String myname = cls.myname;
        if (myname == null) {
            this.env.error("cannot.write", null);
            return;
        }
        this.env.traceln("writing " + myname);
        if (destdir == null) {
            int startofname = myname.lastIndexOf(47);
            if (startofname != -1) {
                myname = myname.substring(startofname + 1);
            }
            outfile = new File(myname);
        } else {
            File outdir;
            this.env.traceln("writing -d " + destdir.getPath());
            if (fileSeparator == '\u0000') {
                fileSeparator = System.getProperty("file.separator").charAt(0);
            }
            if (fileSeparator != '/') {
                myname = myname.replace('/', fileSeparator);
            }
            if (!(outdir = new File((outfile = new File(destdir, myname)).getParent())).exists() && !outdir.mkdirs()) {
                this.env.error("cannot.write", (Object)outdir.getPath());
                return;
            }
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outfile));
        out.write(cls.data, 0, cls.length);
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(File destdir) throws IOException {
        for (ByteBuffer cls : this.Classes) {
            this.write(cls, destdir);
        }
    }

    public class Context {
        Stack<ContextVal> stack = new Stack();
        private boolean hasCP;
        private boolean hasMethods;
        private boolean hasInterfaces;
        private boolean hasFields;

        Context() {
            this.init();
        }

        boolean isConstantPool() {
            return !this.stack.empty() && this.stack.peek().tag == ContextTag.CONSTANTPOOL;
        }

        public void init() {
            this.stack.removeAllElements();
            this.hasCP = false;
            this.hasMethods = false;
            this.hasInterfaces = false;
            this.hasFields = false;
        }

        void update() {
            if (this.stack.empty()) {
                this.stack.push(new ContextVal(ContextTag.CLASS));
                return;
            }
            ContextVal currentCtx = this.stack.peek();
            switch (currentCtx.tag.ordinal()) {
                case 1: {
                    if (!this.hasCP) {
                        this.stack.push(new ContextVal(ContextTag.CONSTANTPOOL));
                        this.hasCP = true;
                        break;
                    }
                    if (!this.hasInterfaces) {
                        this.stack.push(new ContextVal(ContextTag.INTERFACES));
                        this.hasInterfaces = true;
                        break;
                    }
                    if (!this.hasFields) {
                        this.stack.push(new ContextVal(ContextTag.FIELDS));
                        this.hasFields = true;
                        break;
                    }
                    if (!this.hasMethods) {
                        this.stack.push(new ContextVal(ContextTag.METHODS));
                        this.hasMethods = true;
                        break;
                    }
                    ++currentCtx.compCount;
                    this.stack.push(new ContextVal(ContextTag.ATTRIBUTE, currentCtx));
                    break;
                }
                case 3: {
                    ++currentCtx.compCount;
                    this.stack.push(new ContextVal(ContextTag.INTERFACE, currentCtx));
                    break;
                }
                case 7: {
                    ++currentCtx.compCount;
                    this.stack.push(new ContextVal(ContextTag.FIELD, currentCtx));
                    break;
                }
                case 5: {
                    ++currentCtx.compCount;
                    this.stack.push(new ContextVal(ContextTag.METHOD, currentCtx));
                    break;
                }
                case 6: 
                case 8: 
                case 9: {
                    ++currentCtx.compCount;
                    this.stack.push(new ContextVal(ContextTag.ATTRIBUTE, currentCtx));
                    break;
                }
            }
        }

        void exit() {
            if (!this.stack.isEmpty()) {
                this.stack.pop();
            }
        }

        public String toString() {
            if (this.stack.isEmpty()) {
                return "";
            }
            ContextVal currentCtx = this.stack.peek();
            String retval = currentCtx.tag.printval();
            switch (currentCtx.tag.ordinal()) {
                case 4: 
                case 6: 
                case 8: 
                case 9: {
                    if (currentCtx.owner == null) break;
                    retval = retval + "[" + currentCtx.owner.compCount + "]";
                }
            }
            return retval;
        }
    }

    private class ContextVal {
        public ContextTag tag;
        int compCount;
        ContextVal owner;

        ContextVal(ContextTag tg) {
            this.tag = tg;
            this.compCount = 0;
            this.owner = null;
        }

        ContextVal(ContextTag tg, ContextVal ownr) {
            this.tag = tg;
            this.compCount = 0;
            this.owner = ownr;
        }
    }

    private static enum ContextTag {
        NULL(""),
        CLASS("Class"),
        CONSTANTPOOL("Constant-Pool"),
        INTERFACES("Interfaces"),
        INTERFACE("Interface"),
        METHODS("Methods"),
        METHOD("Method"),
        FIELDS("Fields"),
        FIELD("Field"),
        ATTRIBUTE("Attribute");

        private final String printValue;

        private ContextTag(String value) {
            this.printValue = value;
        }

        public String printval() {
            return this.printValue;
        }
    }
}

