/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import org.openjdk.asmtools.jasm.Argument;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.Environment;

class SwitchTable {
    Argument deflabel = null;
    ArrayList<Argument> labels = new ArrayList();
    ArrayList<Integer> keys = new ArrayList();
    Argument[] resLabels;
    int high;
    int low;
    int pc;
    int pad;
    Environment env;

    SwitchTable(Environment env) {
        this.env = env;
    }

    void addEntry(int key, Argument label) {
        this.keys.add(key);
        this.labels.add(label);
    }

    int calcLookupSwitch(int pc) {
        this.pc = pc;
        this.pad = 3 - pc & 3;
        int len = 1 + this.pad + (this.keys.size() + 1) * 8;
        if (this.deflabel == null) {
            this.deflabel = new Argument(pc + len);
        }
        return len;
    }

    void writeLookupSwitch(CheckedDataOutputStream out) throws IOException {
        int k;
        this.env.traceln("  writeLookupSwitch: pc=" + this.pc + " pad=" + this.pad + " deflabel=" + this.deflabel.arg);
        for (k = 0; k < this.pad; ++k) {
            out.writeByte(0);
        }
        out.writeInt(this.deflabel.arg - this.pc);
        out.writeInt(this.keys.size());
        for (k = 0; k < this.keys.size(); ++k) {
            out.writeInt(this.keys.get(k));
            out.writeInt(this.labels.get((int)k).arg - this.pc);
        }
    }

    int recalcTableSwitch(int pc) {
        int k;
        int numpairs = this.keys.size();
        int high1 = Integer.MIN_VALUE;
        int low1 = Integer.MAX_VALUE;
        int numslots = 0;
        if (numpairs > 0) {
            for (k = 0; k < numpairs; ++k) {
                int key = this.keys.get(k);
                if (key > high1) {
                    high1 = key;
                }
                if (key >= low1) continue;
                low1 = key;
            }
            numslots = high1 - low1 + 1;
        }
        this.env.traceln("  recalcTableSwitch: low=" + low1 + " high=" + high1);
        this.pc = pc;
        this.pad = 3 - pc & 3;
        int len = 1 + this.pad + (numslots + 3) * 4;
        if (this.deflabel == null) {
            this.deflabel = new Argument(pc + len);
        }
        Argument[] resLabels1 = new Argument[numslots];
        for (k = 0; k < numslots; ++k) {
            resLabels1[k] = this.deflabel;
        }
        for (k = 0; k < numpairs; ++k) {
            this.env.traceln("   keys.data[" + k + "]=" + this.keys.get(k));
            resLabels1[this.keys.get((int)k).intValue() - low1] = this.labels.get(k);
        }
        this.resLabels = resLabels1;
        this.labels = null;
        this.keys = null;
        this.high = high1;
        this.low = low1;
        return len;
    }

    void writeTableSwitch(CheckedDataOutputStream out) throws IOException {
        int k;
        for (k = 0; k < this.pad; ++k) {
            out.writeByte(0);
        }
        out.writeInt(this.deflabel.arg - this.pc);
        out.writeInt(this.low);
        out.writeInt(this.high);
        for (k = 0; k < this.resLabels.length; ++k) {
            out.writeInt(this.resLabels[k].arg - this.pc);
        }
    }
}

