/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.openjdk.asmtools.common.Tool;
import org.openjdk.asmtools.jasm.CFVersion;
import org.openjdk.asmtools.jasm.ClassData;
import org.openjdk.asmtools.jasm.Environment;
import org.openjdk.asmtools.jasm.Parser;
import org.openjdk.asmtools.util.I18NResourceBundle;
import org.openjdk.asmtools.util.ProductInfo;

public class Main
extends Tool {
    public static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);
    private File destDir = null;
    private boolean traceFlag = false;
    private long tm = System.currentTimeMillis();
    private ArrayList<String> v = new ArrayList();
    private boolean nowrite = false;
    private boolean nowarn = false;
    private boolean strict = false;
    private String props = null;
    private int nwarnings = 0;
    private CFVersion cfv = new CFVersion();
    private int bytelimit = 0;
    private boolean debugScanner = false;
    private boolean debugMembers = false;
    private boolean debugCP = false;
    private boolean debugAnnot = false;
    private boolean debugInstr = false;

    public Main(PrintWriter out, String programName) {
        super(out, programName);
        this.printCannotReadMsg = fname -> this.error(i18n.getString("jasm.error.cannot_read", fname));
    }

    public Main(PrintStream out, String program) {
        this(new PrintWriter(out), program);
    }

    @Override
    public void usage() {
        this.println(i18n.getString("jasm.usage"));
        this.println(i18n.getString("jasm.opt.d"));
        this.println(i18n.getString("jasm.opt.g"));
        this.println(i18n.getString("jasm.opt.v"));
        this.println(i18n.getString("jasm.opt.nowrite"));
        this.println(i18n.getString("jasm.opt.nowarn"));
        this.println(i18n.getString("jasm.opt.strict"));
        this.println(i18n.getString("jasm.opt.cv", (short)45, (short)3));
        this.println(i18n.getString("jasm.opt.version"));
    }

    private synchronized boolean parseArgs(String[] argv) {
        boolean frozenCFV = false;
        block40: for (int i = 0; i < argv.length; ++i) {
            String arg;
            switch (arg = argv[i]) {
                case "-v": {
                    this.traceFlag = true;
                    continue block40;
                }
                case "-g": {
                    this.DebugFlag = () -> true;
                    continue block40;
                }
                case "-nowrite": {
                    this.nowrite = true;
                    continue block40;
                }
                case "-strict": {
                    this.strict = true;
                    continue block40;
                }
                case "-nowarn": {
                    this.nowarn = true;
                    continue block40;
                }
                case "-version": {
                    this.println(ProductInfo.FULL_VERSION);
                    continue block40;
                }
                case "-d": {
                    if (i + 1 >= argv.length) {
                        this.error(i18n.getString("jasm.error.d_requires_argument"));
                        this.usage();
                        return false;
                    }
                    this.destDir = new File(argv[++i]);
                    if (this.destDir.exists()) continue block40;
                    this.error(i18n.getString("jasm.error.does_not_exist", (Object)this.destDir.getPath()));
                    return false;
                }
                case "-XdScanner": {
                    this.debugScanner = true;
                    continue block40;
                }
                case "-XdMember": {
                    this.debugMembers = true;
                    continue block40;
                }
                case "-XdCP": {
                    this.debugCP = true;
                    continue block40;
                }
                case "-XdInstr": {
                    this.debugInstr = true;
                    continue block40;
                }
                case "-XdAnnot": {
                    this.debugAnnot = true;
                    continue block40;
                }
                case "-XdAll": {
                    this.debugScanner = true;
                    this.debugMembers = true;
                    this.debugCP = true;
                    this.debugInstr = true;
                    this.debugAnnot = true;
                    continue block40;
                }
                case "-Xdlimit": {
                    if (i + 1 > argv.length) {
                        this.println(" Error: Unspecified byte-limit");
                        return false;
                    }
                    String bytelimstr = argv[++i];
                    this.bytelimit = 0;
                    try {
                        this.bytelimit = Integer.parseInt(bytelimstr);
                        continue block40;
                    }
                    catch (NumberFormatException e) {
                        this.println(" Error: Unspecified byte-limit");
                        return false;
                    }
                }
                case "-fixcv": {
                    frozenCFV = true;
                }
                case "-cv": {
                    int index;
                    if (i + 1 >= argv.length) {
                        this.error(i18n.getString("jasm.error.cv_requires_arg"));
                        this.usage();
                        return false;
                    }
                    String[] versions = new String[]{"", ""};
                    if ((index = argv[++i].indexOf(".")) != -1) {
                        versions[0] = argv[i].substring(0, index);
                        versions[1] = argv[i].substring(index + 1);
                    }
                    if (versions.length != 2) {
                        this.error(i18n.getString("jasm.error.invalid_major_minor_param"));
                        this.usage();
                        return false;
                    }
                    try {
                        this.cfv = new CFVersion(frozenCFV, Short.parseShort(versions[0]), Short.parseShort(versions[1]));
                        continue block40;
                    }
                    catch (NumberFormatException e) {
                        this.error(i18n.getString("jasm.error.invalid_major_minor_param"));
                        this.usage();
                        return false;
                    }
                }
                default: {
                    if (arg.startsWith("-")) {
                        this.error(i18n.getString("jasm.error.invalid_option", (Object)arg));
                        this.usage();
                        return false;
                    }
                    this.v.add(argv[i]);
                }
            }
        }
        if (this.v.size() == 0) {
            this.usage();
            return false;
        }
        if (this.strict) {
            this.nowarn = false;
        }
        return true;
    }

    private void reset() {
        this.destDir = null;
        this.traceFlag = false;
        this.DebugFlag = () -> false;
        System.currentTimeMillis();
        this.v = new ArrayList();
        this.nowrite = false;
        this.nowarn = false;
        this.strict = false;
        this.props = null;
        this.nwarnings = 0;
        this.bytelimit = 0;
    }

    public synchronized boolean compile(String[] argv) {
        boolean errsOrWarns;
        String er;
        this.reset();
        boolean validArgs = this.parseArgs(argv);
        if (!validArgs) {
            return false;
        }
        Environment sf = null;
        try {
            for (String inpname : this.v) {
                DataInputStream dataInputStream = this.getDataInputStream(inpname);
                if (dataInputStream == null) {
                    ++this.nerrors;
                    continue;
                }
                sf = new Environment(dataInputStream, inpname, this.out, this.nowarn);
                Environment.traceFlag = this.traceFlag;
                sf.debugInfoFlag = this.DebugFlag.getAsBoolean();
                Parser p = new Parser(sf, this.cfv.clone());
                p.setDebugFlags(this.debugScanner, this.debugMembers, this.debugCP, this.debugAnnot, this.debugInstr);
                p.parseFile();
                this.nerrors += sf.nerrors;
                this.nwarnings += sf.nwarnings;
                if (this.nowrite || this.nerrors > 0) {
                    sf.flushErrors();
                    continue;
                }
                try {
                    ClassData[] clsData = p.getClassesData();
                    for (int i = 0; i < clsData.length; ++i) {
                        ClassData cd = clsData[i];
                        if (this.bytelimit > 0) {
                            cd.setByteLimit(this.bytelimit);
                        }
                        cd.write(this.destDir);
                    }
                }
                catch (IOException ex) {
                    if (this.bytelimit > 0) {
                        ex.printStackTrace();
                        this.error("UserSpecified byte-limit at byte[" + this.bytelimit + "]: " + ex.getMessage() + "\n" + inpname + ": [" + sf.lineNumber() + ", " + sf.lineOffset() + "]");
                    }
                    String er2 = i18n.getString("jasm.error.cannot_write", (Object)ex.getMessage());
                    this.error(er2 + "\n" + inpname + ": [" + sf.lineNumber() + ", " + sf.lineOffset() + "]");
                }
                sf.flushErrors();
            }
        }
        catch (Error ee) {
            if (this.DebugFlag.getAsBoolean()) {
                ee.printStackTrace();
            }
            er = ee.getMessage() + "\n" + i18n.getString("jasm.error.fatal_error");
            this.error(er + "\n" + sf.getInputFileName() + ": [" + sf.lineNumber() + ", " + sf.lineOffset() + "]");
        }
        catch (Exception ee) {
            if (this.DebugFlag.getAsBoolean()) {
                ee.printStackTrace();
            }
            er = ee.getMessage() + "\n" + ee.getMessage() + "\n" + i18n.getString("jasm.error.fatal_exception");
            this.error(er + "\n" + sf.getInputFileName() + ": [" + sf.lineNumber() + ", " + sf.lineOffset() + "]");
        }
        boolean errs = this.nerrors > 0;
        boolean warns = this.nwarnings > 0 && !this.nowarn;
        boolean bl = errsOrWarns = errs || warns;
        if (!errsOrWarns) {
            return true;
        }
        if (errs) {
            this.out.print(this.nerrors > 1 ? this.nerrors + " errors" : "1 error");
        }
        if (errs && warns) {
            this.out.print(", ");
        }
        if (warns) {
            this.out.print(this.nwarnings > 1 ? this.nwarnings + " warnings" : "1 warning");
        }
        this.println();
        if (this.strict) {
            return !errsOrWarns;
        }
        return !errs;
    }

    public static void main(String[] argv) {
        Main compiler = new Main(new PrintWriter(System.out), "jasm");
        System.exit(compiler.compile(argv) ? 0 : 1);
    }
}

