/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import org.openjdk.asmtools.jasm.Argument;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.Data;

class BootstrapMethodData
extends Argument
implements Data {
    ConstantPool.ConstCell bootstrapMethodHandle;
    ArrayList<ConstantPool.ConstCell> arguments;
    public int placeholder_index = -1;

    public BootstrapMethodData(ConstantPool.ConstCell bsmHandle, ArrayList<ConstantPool.ConstCell> arguments) {
        this.bootstrapMethodHandle = bsmHandle;
        this.arguments = arguments;
    }

    public BootstrapMethodData(int placeholder) {
        this.bootstrapMethodHandle = null;
        this.arguments = null;
        this.placeholder_index = placeholder;
    }

    @Override
    public int getLength() {
        return 4 + this.arguments.size() * 2;
    }

    public boolean isPlaceholder() {
        return this.placeholder_index > -1;
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        out.writeShort(this.bootstrapMethodHandle.arg);
        out.writeShort(this.arguments.size());
        for (ConstantPool.ConstCell argument : this.arguments) {
            out.writeShort(argument.arg);
        }
    }
}

