/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import org.openjdk.asmtools.jasm.Argument;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.Data;

class AnnotationData
implements Data {
    boolean invisible;
    Argument typeCPX;
    ArrayList<ElemValuePair> elemValuePairs;
    int annotationLength = 0;

    public AnnotationData(Argument typeCPX, boolean invisible) {
        this.typeCPX = typeCPX;
        this.elemValuePairs = new ArrayList();
        this.invisible = invisible;
    }

    public void add(ElemValuePair elemValuePair) {
        this.elemValuePairs.add(elemValuePair);
        this.annotationLength += elemValuePair.getLength();
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        out.writeShort(this.typeCPX.arg);
        out.writeShort(this.elemValuePairs.size());
        for (Data data : this.elemValuePairs) {
            data.write(out);
        }
    }

    @Override
    public int getLength() {
        return 4 + this.annotationLength;
    }

    public static class ElemValuePair
    implements Data {
        ConstantPool.ConstCell name;
        Data value;

        public ElemValuePair(ConstantPool.ConstCell name, Data value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            this.name.write(out);
            this.value.write(out);
        }

        @Override
        public int getLength() {
            return 2 + this.value.getLength();
        }
    }
}

