/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools;

import org.openjdk.asmtools.util.I18NResourceBundle;
import org.openjdk.asmtools.util.ProductInfo;

public class Main {
    public static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);

    public static void main(String[] args) {
        String cmd;
        if (args.length == 0) {
            Main.usage(i18n.getString("main.error.no_arguments"), 1);
        }
        if ((cmd = args[0]).equals("-?") || cmd.equals("-h") || cmd.equals("-help")) {
            Main.usage(null, 0);
        } else if (cmd.equals("-version")) {
            Main.printVersion();
        } else {
            String[] newArgs = new String[args.length - 1];
            System.arraycopy(args, 1, newArgs, 0, args.length - 1);
            if (cmd.equals("jasm")) {
                Main.jasm(newArgs);
            } else if (cmd.equals("jdis")) {
                Main.jdis(newArgs);
            } else if (cmd.equals("jcoder")) {
                Main.jcoder(newArgs);
            } else if (cmd.equals("jdec")) {
                Main.jdec(newArgs);
            } else if (cmd.equals("jcdec")) {
                Main.jcdec(newArgs);
            } else {
                Main.usage(i18n.getString("main.error.unknown_tool", (Object)cmd), 1);
            }
        }
    }

    public static void usage(String msg, int exitCode) {
        System.err.println(i18n.getString("main.usage", (Object)"asmtools.jar"));
        if (msg != null) {
            System.err.println(msg);
        }
        System.exit(exitCode);
    }

    public static void printVersion() {
        System.out.println(ProductInfo.FULL_VERSION);
    }

    public static void jasm(String[] args) {
        org.openjdk.asmtools.jasm.Main.main(args);
    }

    public static void jcdec(String[] args) {
        org.openjdk.asmtools.jcdec.Main.main(args);
    }

    public static void jcoder(String[] args) {
        org.openjdk.asmtools.jcoder.Main.main(args);
    }

    public static void jdec(String[] args) {
        org.openjdk.asmtools.jdec.Main.main(args);
    }

    public static void jdis(String[] args) {
        org.openjdk.asmtools.jdis.Main.main(args);
    }
}

