/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.tool.ConfigManager;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import java.util.ListIterator;

public class DesktopManager
extends CommandManager {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ConfigManager.class);
    private boolean firstTimeFlag;
    private boolean resumeFlag;

    @Override
    public HelpTree.Node getHelp() {
        String[] cmds = new String[]{"cleanDesktop", "newDesktop", "resume", "laf"};
        return new HelpTree.Node(i18n, "dt.opts", cmds);
    }

    Desktop createDesktop() {
        Desktop d = new Desktop();
        if (this.firstTimeFlag) {
            d.setFirstTime(this.firstTimeFlag);
        }
        if (this.resumeFlag) {
            d.setRestoreOnStart(true);
        }
        return d;
    }

    Desktop createDesktop(CommandContext ctx) {
        Desktop d = new Desktop(ctx);
        if (this.firstTimeFlag) {
            d.setFirstTime(this.firstTimeFlag);
        }
        if (this.resumeFlag) {
            d.setRestoreOnStart(true);
        }
        return d;
    }

    @Override
    public boolean parseCommand(String cmd, ListIterator<String> argIter, CommandContext ctx) throws Command.Fault {
        if (cmd.equalsIgnoreCase("newDesktop") || cmd.equalsIgnoreCase("cleanDesktop")) {
            this.firstTimeFlag = true;
            ctx.addCommand(new NewDesktopCommand());
            return true;
        }
        if (cmd.equalsIgnoreCase("resume")) {
            this.resumeFlag = true;
            ctx.addCommand(new ResumeCommand());
            return true;
        }
        if (cmd.equalsIgnoreCase("laf")) {
            ctx.addCommand(new SetLafCommand(argIter, ctx));
            return true;
        }
        return false;
    }

    private static class NewDesktopCommand
    extends Command {
        NewDesktopCommand() {
            super("newDesktop");
        }

        @Override
        public void run(CommandContext ctx) {
        }
    }

    private static class ResumeCommand
    extends Command {
        public ResumeCommand() {
            super("resume");
        }

        @Override
        public void run(CommandContext ctx) {
        }
    }

    private static class SetLafCommand
    extends Command {
        private SetLafCommand(ListIterator<String> argIter, CommandContext ctx) throws Command.Fault {
            super("laf");
            int laf;
            if (!argIter.hasNext()) {
                throw new Command.Fault(i18n, "dt.opts.laf.missingArg");
            }
            String lafName = argIter.next();
            if ("nimbus".equalsIgnoreCase(lafName)) {
                laf = 1;
            } else if ("metal".equalsIgnoreCase(lafName)) {
                laf = 2;
            } else if ("system".equalsIgnoreCase(lafName) || "sys".equalsIgnoreCase(lafName)) {
                laf = 0;
            } else if ("default".equalsIgnoreCase(lafName)) {
                laf = 1;
            } else {
                throw (Command)this.new Command.Fault(i18n, "dt.opts.laf.badArg", new Object[]{lafName});
            }
            this.addArg(lafName);
            ctx.setPreferredLookAndFeel(laf);
        }

        @Override
        public void run(CommandContext ctx) {
        }
    }
}

