/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.interview.CompositeQuestion;
import com.sun.interview.Interview;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.javatest.FileParameters;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.util.DirectoryClassLoader;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.PropertyUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;

public class ConfigManager
extends CommandManager {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ConfigManager.class);

    static Command getOpenCommand(File file) throws Command.Fault {
        return new OpenCommand(file);
    }

    @Override
    public HelpTree.Node getHelp() {
        Object[] childData = new Object[]{ConcurrencyCommand.getName(), ConfigCommand.getName(), EnvCommand.getName(), EnvFilesCommand.getNames(), ExcludeListCommand.getName(), KeywordsCommand.getName(), KflCommand.getName(), OpenCommand.getName(), ParamsCommand.getHelp(), PriorStatusCommand.getName(), SetCommand.getName(), TestsCommand.getName(), TestSuiteCommand.getNames(), TimeoutFactorCommand.getName(), WorkDirectoryCommand.getNames(), WriteConfigCommand.getName()};
        return this.getHelp(i18n, "cnfg", childData);
    }

    HelpTree.Node getHelp(I18NResourceBundle i18n, String prefix, Object ... childData) {
        Vector<HelpTree.Node> v = new Vector<HelpTree.Node>();
        for (Object data : childData) {
            if (data instanceof HelpTree.Node) {
                v.add((HelpTree.Node)data);
                continue;
            }
            if (data instanceof String) {
                v.add(new HelpTree.Node(i18n, prefix + "." + data));
                continue;
            }
            if (data instanceof String[]) {
                String[] names;
                for (String name : names = (String[])data) {
                    v.add(new HelpTree.Node(i18n, prefix + "." + name));
                }
                continue;
            }
            throw new IllegalArgumentException();
        }
        return new HelpTree.Node(i18n, prefix, v.toArray(new HelpTree.Node[v.size()]));
    }

    @Override
    public boolean parseCommand(String cmd, ListIterator<String> argIter, CommandContext ctx) throws Command.Fault {
        if (ConfigManager.isMatch(cmd, ConcurrencyCommand.getName())) {
            ctx.addCommand(new ConcurrencyCommand(argIter));
            return true;
        }
        if (ConfigManager.isMatch(cmd, ConfigCommand.getName())) {
            ctx.addCommand(new ConfigCommand(argIter));
            return true;
        }
        if (ConfigManager.isMatch(cmd, EnvCommand.getName())) {
            ctx.addCommand(new EnvCommand(argIter));
            return true;
        }
        if (ConfigManager.isMatch(cmd, EnvFilesCommand.getNames())) {
            ctx.addCommand(new EnvFilesCommand(argIter));
            return true;
        }
        if (ConfigManager.isMatch(cmd, ExcludeListCommand.getName())) {
            ctx.addCommand(new ExcludeListCommand(argIter));
            return true;
        }
        if (ConfigManager.isMatch(cmd, OpenCommand.getName())) {
            ctx.addCommand(new OpenCommand(argIter));
            return true;
        }
        if (ConfigManager.isMatch(cmd, KeywordsCommand.getName())) {
            ctx.addCommand(new KeywordsCommand(argIter));
            return true;
        }
        if (ConfigManager.isMatch(cmd, KflCommand.getName())) {
            ctx.addCommand(new KflCommand(argIter));
            return true;
        }
        if (ConfigManager.isMatch(cmd, ParamsCommand.getName())) {
            ctx.addCommand(new ParamsCommand(argIter));
            return true;
        }
        if (ConfigManager.isMatch(cmd, PriorStatusCommand.getName())) {
            ctx.addCommand(new PriorStatusCommand(argIter));
            return true;
        }
        if (ConfigManager.isMatch(cmd, SetCommand.getName())) {
            ctx.addCommand(new SetCommand(argIter));
            return true;
        }
        if (ConfigManager.isMatch(cmd, SetXCommand.getName())) {
            ctx.addCommand(new SetXCommand(argIter));
            return true;
        }
        if (ConfigManager.isMatch(cmd, TestsCommand.getName())) {
            ctx.addCommand(new TestsCommand(argIter));
            return true;
        }
        if (ConfigManager.isMatch(cmd, TestSuiteCommand.getNames())) {
            ctx.addCommand(new TestSuiteCommand(argIter));
            return true;
        }
        if (ConfigManager.isMatch(cmd, TimeoutFactorCommand.getName())) {
            ctx.addCommand(new TimeoutFactorCommand(argIter));
            return true;
        }
        if (ConfigManager.isMatch(cmd, WorkDirectoryCommand.getNames())) {
            ctx.addCommand(new WorkDirectoryCommand(argIter));
            return true;
        }
        if (ConfigManager.isMatch(cmd, WriteConfigCommand.getName())) {
            ctx.addCommand(new WriteConfigCommand(argIter));
            return true;
        }
        return false;
    }

    private static class OpenCommand
    extends Command {
        private Command cmdForFile;

        OpenCommand(File file) throws Command.Fault {
            super(file.getPath());
            this.cmdForFile = this.getCommandForFile(file);
        }

        OpenCommand(Iterator<String> argIter) throws Command.Fault {
            super(OpenCommand.getName());
            if (!argIter.hasNext()) {
                throw new Command.Fault(i18n, "cnfg.open.missingArg");
            }
            String arg = this.nextArg(argIter);
            this.cmdForFile = this.getCommandForFile(new File(arg));
        }

        static String getName() {
            return "open";
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            this.cmdForFile.run(ctx);
        }

        Command getCommandForFile(File file) throws Command.Fault {
            if (!file.exists()) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.open.cantFindFile", (Object)file);
            }
            if (TestSuite.isTestSuite(file)) {
                return new TestSuiteCommand(file);
            }
            if (WorkDirectory.isWorkDirectory(file)) {
                return new WorkDirectoryCommand(file);
            }
            if (FileParameters.isParameterFile(file)) {
                return new ParamFileCommand(file);
            }
            if (InterviewParameters.isInterviewFile(file)) {
                return new ConfigCommand(file);
            }
            if (file.getPath().endsWith(".jte")) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.open.cantOpenJTE", (Object)file);
            }
            if (file.getPath().endsWith(".jtt")) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.open.cantOpenJTT", (Object)file);
            }
            if (file.getPath().endsWith(".jtx")) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.open.cantOpenJTX", (Object)file);
            }
            throw (Command)this.new Command.Fault(i18n, "cnfg.open.unknownFileType", (Object)file);
        }
    }

    private static class ConcurrencyCommand
    extends Command {
        private int value;

        ConcurrencyCommand(Iterator<String> argIter) throws Command.Fault {
            super(ConcurrencyCommand.getName());
            ParsePosition pos;
            if (!argIter.hasNext()) {
                throw new Command.Fault(i18n, "cnfg.conc.missingArg");
            }
            String arg = this.nextArg(argIter);
            NumberFormat fmt = NumberFormat.getIntegerInstance();
            Number num = fmt.parse(arg, pos = new ParsePosition(0));
            if (num != null && pos.getIndex() == arg.length()) {
                this.value = num.intValue();
                if (this.value < 1 || this.value > 256) {
                    throw (Command)this.new Command.Fault(i18n, "cnfg.conc.badRange", arg, 1, 256);
                }
            } else {
                throw (Command)this.new Command.Fault(i18n, "cnfg.conc.badValue", (Object)arg);
            }
        }

        static String getName() {
            return "concurrency";
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            InterviewParameters p = this.getConfig(ctx);
            if (!(p.getConcurrencyParameters() instanceof Parameters.MutableConcurrencyParameters)) {
                throw new Command.Fault(i18n, "cnfg.conc.notEditable");
            }
            Parameters.MutableConcurrencyParameters cParams = (Parameters.MutableConcurrencyParameters)p.getConcurrencyParameters();
            cParams.setConcurrency(this.value);
        }
    }

    private static class ConfigCommand
    extends Command {
        private File path;

        ConfigCommand(Iterator<String> argIter) throws Command.Fault {
            super(ConfigCommand.getName());
            if (!argIter.hasNext()) {
                throw new Command.Fault(i18n, "cnfg.conf.missingArg");
            }
            this.path = new File(this.nextArg(argIter));
        }

        ConfigCommand(File path) {
            super(path.getPath());
            this.path = path;
        }

        static String getName() {
            return "config";
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            try {
                ctx.setConfig(this.path);
                ctx.setAutoRunReportDir(null);
            }
            catch (CommandContext.Fault e) {
                throw new Command.Fault(e);
            }
        }
    }

    private static class EnvCommand
    extends Command {
        private String name;

        EnvCommand(Iterator<String> argIter) throws Command.Fault {
            super(EnvCommand.getName());
            if (!argIter.hasNext()) {
                throw new Command.Fault(i18n, "cnfg.env.missingArg");
            }
            this.name = this.nextArg(argIter);
        }

        static String getName() {
            return "env";
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            InterviewParameters p = this.getConfig(ctx);
            if (!(p.getEnvParameters() instanceof Parameters.LegacyEnvParameters)) {
                throw new Command.Fault(i18n, "cnfg.env.notEditable");
            }
            Parameters.LegacyEnvParameters eParams = (Parameters.LegacyEnvParameters)p.getEnvParameters();
            eParams.setEnvName(this.name);
        }
    }

    private static class EnvFilesCommand
    extends Command {
        private File[] files;

        EnvFilesCommand(ListIterator<String> argIter) throws Command.Fault {
            super(EnvFilesCommand.getNames()[0]);
            Vector<File> v = new Vector<File>();
            while (argIter.hasNext()) {
                String arg = this.nextArg(argIter);
                if (arg.startsWith("-")) {
                    this.putbackArg(argIter);
                    break;
                }
                v.add(new File(arg));
            }
            if (v.isEmpty()) {
                throw new Command.Fault(i18n, "cnfg.envFiles.noFiles");
            }
            this.files = new File[v.size()];
            v.toArray(this.files);
        }

        static String[] getNames() {
            return new String[]{"envfile", "envfiles"};
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            InterviewParameters p = this.getConfig(ctx);
            if (!(p.getEnvParameters() instanceof Parameters.LegacyEnvParameters)) {
                throw new Command.Fault(i18n, "cnfg.envFiles.notEditable");
            }
            Parameters.LegacyEnvParameters eParams = (Parameters.LegacyEnvParameters)p.getEnvParameters();
            eParams.setEnvFiles(this.files);
        }
    }

    private static class ExcludeListCommand
    extends Command {
        private File[] files;

        ExcludeListCommand(ListIterator<String> argIter) throws Command.Fault {
            super(ExcludeListCommand.getName());
            Vector<File> v = new Vector<File>();
            while (argIter.hasNext()) {
                String arg = this.nextArg(argIter);
                if (arg.startsWith("-")) {
                    this.putbackArg(argIter);
                    break;
                }
                v.add(new File(arg));
            }
            if (v.isEmpty()) {
                throw new Command.Fault(i18n, "cnfg.excl.noFiles");
            }
            this.files = new File[v.size()];
            v.toArray(this.files);
        }

        static String getName() {
            return "excludeList";
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            InterviewParameters p = this.getConfig(ctx);
            if (!(p.getExcludeListParameters() instanceof Parameters.MutableExcludeListParameters)) {
                throw new Command.Fault(i18n, "cnfg.excl.notEditable");
            }
            Parameters.MutableExcludeListParameters eParams = (Parameters.MutableExcludeListParameters)p.getExcludeListParameters();
            eParams.setExcludeMode(4);
            eParams.setCustomExcludeFiles(this.files);
        }
    }

    private static class KeywordsCommand
    extends Command {
        private String expr;

        KeywordsCommand(Iterator<String> argIter) throws Command.Fault {
            super(KeywordsCommand.getName());
            if (!argIter.hasNext()) {
                throw new Command.Fault(i18n, "cnfg.keywords.missingArg");
            }
            this.expr = this.nextArg(argIter);
        }

        static String getName() {
            return "keywords";
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            InterviewParameters p = this.getConfig(ctx);
            if (p.getKeywordsParameters() instanceof Parameters.MutableKeywordsParameters) {
                Parameters.MutableKeywordsParameters kParams = (Parameters.MutableKeywordsParameters)p.getKeywordsParameters();
                if (this.expr == null) {
                    kParams.setKeywordsMode(1);
                } else {
                    kParams.setKeywordsMode(2);
                    kParams.setMatchKeywords(3, this.expr);
                }
            } else {
                throw new Command.Fault(i18n, "cnfg.keywords.notEditable");
            }
        }
    }

    private static class KflCommand
    extends Command {
        private File[] files;

        KflCommand(ListIterator<String> argIter) throws Command.Fault {
            super(KflCommand.getName());
            Vector<File> v = new Vector<File>();
            while (argIter.hasNext()) {
                String arg = this.nextArg(argIter);
                if (arg.startsWith("-")) {
                    this.putbackArg(argIter);
                    break;
                }
                v.add(new File(arg));
            }
            if (v.isEmpty()) {
                throw new Command.Fault(i18n, "cnfg.kfl.noFiles");
            }
            this.files = new File[v.size()];
            v.toArray(this.files);
        }

        static String getName() {
            return "kfl";
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            InterviewParameters p = this.getConfig(ctx);
            p.setKnownFailureFiles(this.files);
        }
    }

    private static class ParamsCommand
    extends ParamsBaseCommand {
        private FileParameters params;

        ParamsCommand(Iterator<String> argIter) throws Command.Fault {
            super(ParamsCommand.getName());
            Vector<String> v = new Vector<String>();
            while (argIter.hasNext()) {
                v.add(this.nextArg(argIter));
            }
            try {
                this.params = new FileParameters(v.toArray(new String[v.size()]));
            }
            catch (IllegalArgumentException e) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.params.badValue", (Object)e.getMessage());
            }
            if (!this.params.isValid()) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.params.badValue", (Object)this.params.getErrorMessage());
            }
        }

        static String getName() {
            return "params";
        }

        static HelpTree.Node getHelp() {
            String[] opts = new String[]{"testSuite", "t", "keywords", "status", "exclude", "envfile", "env", "conc", "timeout", "report", "r", "workdir", "w"};
            return new HelpTree.Node(i18n, "cnfg.params", opts);
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            this.setParameters(ctx, this.params);
        }
    }

    private static class PriorStatusCommand
    extends Command {
        private boolean[] values;

        PriorStatusCommand(Iterator<String> argIter) throws Command.Fault {
            super(PriorStatusCommand.getName());
            if (!argIter.hasNext()) {
                throw new Command.Fault(i18n, "cnfg.status.missingArg");
            }
            String arg = this.nextArg(argIter);
            String[] words = PriorStatusCommand.split(arg.toLowerCase());
            boolean any = false;
            this.values = new boolean[4];
            if (words != null) {
                for (String w : words) {
                    if (w.startsWith("pass")) {
                        any = true;
                        this.values[0] = true;
                        continue;
                    }
                    if (w.startsWith("fail")) {
                        any = true;
                        this.values[1] = true;
                        continue;
                    }
                    if (w.startsWith("error")) {
                        any = true;
                        this.values[2] = true;
                        continue;
                    }
                    if (w.startsWith("notrun")) {
                        any = true;
                        this.values[3] = true;
                        continue;
                    }
                    throw (Command)this.new Command.Fault(i18n, "cnfg.status.badArg", (Object)w);
                }
            }
            if (!any) {
                throw new Command.Fault(i18n, "cnfg.status.noValues");
            }
        }

        static String getName() {
            return "priorStatus";
        }

        private static String[] split(String s) {
            if (s == null) {
                return null;
            }
            Vector<String> v = new Vector<String>();
            int start = -1;
            for (int i = 0; i < s.length(); ++i) {
                if (Character.isLetterOrDigit(s.charAt(i))) {
                    if (start != -1) continue;
                    start = i;
                    continue;
                }
                if (start != -1) {
                    v.add(s.substring(start, i));
                }
                start = -1;
            }
            if (start != -1) {
                v.add(s.substring(start));
            }
            if (v.isEmpty()) {
                return null;
            }
            return v.toArray(new String[v.size()]);
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            InterviewParameters p = this.getConfig(ctx);
            if (!(p.getPriorStatusParameters() instanceof Parameters.MutablePriorStatusParameters)) {
                throw new Command.Fault(i18n, "cnfg.status.notEditable");
            }
            Parameters.MutablePriorStatusParameters sParams = (Parameters.MutablePriorStatusParameters)p.getPriorStatusParameters();
            sParams.setPriorStatusMode(2);
            sParams.setMatchPriorStatusValues(this.values);
        }
    }

    private static class SetCommand
    extends Command {
        private File file;
        private String tag;
        private String value;

        SetCommand(Iterator<String> argIter) throws Command.Fault {
            super(SetCommand.getName());
            if (!argIter.hasNext()) {
                throw new Command.Fault(i18n, "cnfg.set.insufficientArgs");
            }
            String arg = this.nextArg(argIter);
            if (arg.equals("-f") || arg.equals("-file")) {
                if (!argIter.hasNext()) {
                    throw new Command.Fault(i18n, "cnfg.set.insufficientArgs");
                }
                this.file = new File(this.nextArg(argIter));
            } else {
                this.tag = arg;
                if (!argIter.hasNext()) {
                    throw new Command.Fault(i18n, "cnfg.set.insufficientArgs");
                }
                this.value = this.nextArg(argIter);
            }
        }

        static String getName() {
            return "set";
        }

        private static String getPathTrace(Question ... path) {
            String lineSep = System.getProperty("line.separator");
            StringBuilder sb = new StringBuilder();
            for (Question q : path) {
                sb.append(q.getTag());
                if (!(q instanceof NullQuestion)) {
                    String s = q.getStringValue();
                    sb.append(" (");
                    if (s == null) {
                        sb.append("null");
                    } else if (s.length() < 32) {
                        sb.append(s);
                    } else {
                        sb.append(s.substring(0, 32));
                        sb.append("...");
                    }
                    sb.append(")");
                }
                sb.append(lineSep);
            }
            return sb.toString();
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            InterviewParameters p = this.getConfig(ctx);
            Question[] path = p.getPath();
            if (this.file != null) {
                Map<String, String> values = this.loadFile(this.file);
                for (int i = 0; i < path.length; ++i) {
                    Question q = path[i];
                    String v = values.get(q.getTag());
                    if (v == null) continue;
                    this.setValue(q, v);
                    path = p.getPath();
                }
            } else {
                for (Question q : path) {
                    if (!q.getTag().equals(this.tag)) continue;
                    this.setValue(q, this.value);
                    return;
                }
                throw (Command)this.new Command.Fault(i18n, "cnfg.set.tagNotFound", this.tag, SetCommand.getPathTrace(path));
            }
        }

        private void setValue(Question q, String value) throws Command.Fault {
            try {
                if (q instanceof CompositeQuestion) {
                    CompositeQuestion cq = (CompositeQuestion)q;
                    int sepIndex = value.indexOf(58);
                    if (sepIndex > 0) {
                        String key = value.substring(0, sepIndex);
                        String val = sepIndex == value.length() + 1 ? "" : value.substring(sepIndex + 1);
                        cq.setValue(key, val);
                    } else {
                        q.setValue(value);
                    }
                } else {
                    q.setValue(value);
                }
            }
            catch (Interview.Fault e) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.set.cantSetValue", q.getTag(), value, e.getMessage());
            }
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private Map<String, String> loadFile(File file) throws Command.Fault {
            try (FileInputStream fis = new FileInputStream(file);){
                Map<String, String> map;
                try (BufferedInputStream in = new BufferedInputStream(fis);){
                    map = PropertyUtils.load(in);
                }
                return map;
            }
            catch (FileNotFoundException e) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.set.cantFindFile", (Object)file);
            }
            catch (IOException e) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.set.cantReadFile", file, e.getMessage());
            }
        }
    }

    private static class TestsCommand
    extends Command {
        private String[] tests;

        TestsCommand(ListIterator<String> argIter) throws Command.Fault {
            super(TestsCommand.getName());
            Vector<String> v = new Vector<String>();
            while (argIter.hasNext()) {
                String arg = this.nextArg(argIter);
                if (arg.startsWith("-")) {
                    this.putbackArg(argIter);
                    break;
                }
                v.add(arg);
            }
            if (v.isEmpty()) {
                throw new Command.Fault(i18n, "cnfg.tests.noTests");
            }
            this.tests = new String[v.size()];
            v.toArray(this.tests);
        }

        static String getName() {
            return "tests";
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            InterviewParameters p = this.getConfig(ctx);
            if (!(p.getTestsParameters() instanceof Parameters.MutableTestsParameters)) {
                throw new Command.Fault(i18n, "cnfg.tests.notEditable");
            }
            Parameters.MutableTestsParameters iParams = (Parameters.MutableTestsParameters)p.getTestsParameters();
            iParams.setTestsMode(2);
            iParams.setSpecifiedTests(this.tests);
        }
    }

    private static class TestSuiteCommand
    extends Command {
        private File path;
        private boolean preferFlag;

        TestSuiteCommand(Iterator<String> argIter) throws Command.Fault {
            super(TestSuiteCommand.getNames()[0]);
            while (argIter.hasNext()) {
                String arg = this.nextArg(argIter);
                if (arg.equalsIgnoreCase("-preferred")) {
                    this.preferFlag = true;
                    continue;
                }
                if (arg.startsWith("-")) {
                    throw (Command)this.new Command.Fault(i18n, "cnfg.ts.badArg", (Object)arg);
                }
                this.path = new File(arg);
                return;
            }
            throw new Command.Fault(i18n, "cnfg.ts.missingArg");
        }

        TestSuiteCommand(File path) {
            super(path.getPath());
            this.path = path;
        }

        static String[] getNames() {
            return new String[]{"testsuite", "ts"};
        }

        @Override
        public URL getCustomSplash() {
            String basePath = this.path.getAbsolutePath() + File.separator + "lib";
            DirectoryClassLoader loader = new DirectoryClassLoader(basePath);
            try {
                ResourceBundle b = ResourceBundle.getBundle("splash", Locale.getDefault(), loader);
                String icon = b.getString("splash.icon");
                File f = new File(icon);
                if (!f.isAbsolute()) {
                    f = new File(basePath, icon);
                }
                if (f.canRead()) {
                    try {
                        return f.toURL();
                    }
                    catch (MalformedURLException e) {
                        return null;
                    }
                }
                return null;
            }
            catch (ClassCastException | NullPointerException | MissingResourceException m) {
                return null;
            }
        }

        @Override
        ClassLoader getCustomHelpLoader() {
            try {
                String basePath = this.path.getCanonicalPath() + File.separator + "lib";
                DirectoryClassLoader loader = new DirectoryClassLoader(basePath);
                ResourceBundle b = ResourceBundle.getBundle("help", Locale.getDefault(), loader);
                String cp = b.getString("classpath");
                File f = new File(cp);
                if (!f.isAbsolute()) {
                    f = new File(this.path.getPath(), cp);
                }
                return new URLClassLoader(new URL[]{f.toURL()}, this.getClass().getClassLoader());
            }
            catch (IOException | ClassCastException | NullPointerException | MissingResourceException m) {
                return null;
            }
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            block11: {
                if (!this.path.exists()) {
                    throw (Command)this.new Command.Fault(i18n, "cnfg.ts.cantFindTestSuite", (Object)this.path);
                }
                if (!TestSuite.isTestSuite(this.path)) {
                    throw (Command)this.new Command.Fault(i18n, "cnfg.ts.notATestSuite", (Object)this.path);
                }
                try {
                    Map<String, String> p;
                    String s;
                    ctx.setTestSuite(this.path);
                    if (!this.preferFlag || (s = (p = Desktop.getPreviousDesktop(null)).get("tool.count")) == null) break block11;
                    int count = Integer.parseInt(s);
                    for (int i = 0; i < count; ++i) {
                        s = p.get("tool." + i + ".class");
                        if (!"com.sun.javatest.exec.ExecTool".equals(s) || (s = p.get("tool." + i + ".testSuite")) == null) continue;
                        String s1 = this.path.getPath();
                        String s2 = s;
                        try {
                            s1 = this.path.getCanonicalPath();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            File file = new File(s2);
                            s2 = file.getCanonicalPath();
                        }
                        catch (IOException file) {
                            // empty catch block
                        }
                        if (!s1.equals(s2)) continue;
                        s = p.get("tool." + i + ".workDir");
                        if (s != null && WorkDirectory.isUsableWorkDirectory(new File(s))) {
                            ctx.setDefaultWorkDir(s);
                            s = p.get("tool." + i + ".filter");
                            Map<String, String> data = this.collectSpecificData("tool." + i + ".", p);
                            if (s != null) {
                                ctx.setDesktopData(data);
                            }
                            break;
                        }
                        if (s == null) continue;
                        System.out.println(i18n.getString("cnfg.badWorkdir", (Object)s));
                    }
                }
                catch (CommandContext.Fault e) {
                    throw new Command.Fault(e);
                }
            }
        }

        private Map<String, String> collectSpecificData(String prefix, Map<String, String> p) {
            Set<Map.Entry<String, String>> s = p.entrySet();
            Iterator<Map.Entry<String, String>> it = s.iterator();
            HashMap<String, String> res = new HashMap<String, String>();
            while (it.hasNext()) {
                Map.Entry<String, String> en = it.next();
                if (!en.getKey().toString().startsWith(prefix)) continue;
                String key = en.getKey();
                if ("-workDir-config-class-mgr-".contains(key = key.substring(prefix.length()))) continue;
                res.put(key, en.getValue());
            }
            return res;
        }
    }

    private static class TimeoutFactorCommand
    extends Command {
        private float value;

        TimeoutFactorCommand(Iterator<String> argIter) throws Command.Fault {
            super(TimeoutFactorCommand.getName());
            ParsePosition pos;
            if (!argIter.hasNext()) {
                throw new Command.Fault(i18n, "cnfg.tf.missingArg");
            }
            String arg = this.nextArg(argIter);
            NumberFormat fmt = NumberFormat.getNumberInstance();
            Number num = fmt.parse(arg, pos = new ParsePosition(0));
            if (num != null && pos.getIndex() == arg.length()) {
                this.value = num.floatValue();
                if (this.value < 0.1f || this.value > 100.0f) {
                    throw (Command)this.new Command.Fault(i18n, "cnfg.tf.badRange", arg, Float.valueOf(0.1f), Float.valueOf(100.0f));
                }
            } else {
                throw (Command)this.new Command.Fault(i18n, "cnfg.tf.badValue", (Object)arg);
            }
        }

        static String getName() {
            return "timeoutfactor";
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            InterviewParameters p = this.getConfig(ctx);
            if (!(p.getTimeoutFactorParameters() instanceof Parameters.MutableTimeoutFactorParameters)) {
                throw new Command.Fault(i18n, "cnfg.tf.notEditable");
            }
            Parameters.MutableTimeoutFactorParameters cParams = (Parameters.MutableTimeoutFactorParameters)p.getTimeoutFactorParameters();
            cParams.setTimeoutFactor(this.value);
        }
    }

    private static class WorkDirectoryCommand
    extends Command {
        private File path;
        private boolean createFlag;
        private boolean overwriteFlag;

        WorkDirectoryCommand(Iterator<String> argIter) throws Command.Fault {
            super(WorkDirectoryCommand.getNames()[0]);
            while (argIter.hasNext()) {
                String arg = this.nextArg(argIter);
                if (arg.equalsIgnoreCase("-create")) {
                    this.createFlag = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-overwrite")) {
                    this.createFlag = true;
                    this.overwriteFlag = true;
                    continue;
                }
                if (arg.startsWith("-")) {
                    throw (Command)this.new Command.Fault(i18n, "cnfg.wd.badArg", (Object)arg);
                }
                this.path = new File(arg);
                return;
            }
            throw new Command.Fault(i18n, "cnfg.wd.missingArg");
        }

        WorkDirectoryCommand(File path) {
            super(path.getPath());
            this.path = path;
        }

        static String[] getNames() {
            return new String[]{"workdirectory", "workdir", "wd"};
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            if (!this.createFlag) {
                if (!this.path.exists()) {
                    throw (Command)this.new Command.Fault(i18n, "cnfg.wd.cantFindWorkDir", (Object)this.path);
                }
                if (!WorkDirectory.isWorkDirectory(this.path) && !WorkDirectory.isEmptyDirectory(this.path)) {
                    throw (Command)this.new Command.Fault(i18n, "cnfg.wd.notAWorkDirectory", (Object)this.path);
                }
            }
            if (this.overwriteFlag) {
                this.remove(this.path);
                if (this.path.exists()) {
                    throw (Command)this.new Command.Fault(i18n, "cnfg.wd.cantRemoveWorkDir", (Object)this.path);
                }
            }
            try {
                ctx.setWorkDirectory(this.path, this.createFlag);
            }
            catch (CommandContext.Fault e) {
                throw new Command.Fault(e);
            }
        }

        private void remove(File path) {
            if (path.exists()) {
                if (path.isDirectory()) {
                    File[] files;
                    for (File file : files = path.listFiles()) {
                        this.remove(file);
                    }
                    String[] undeletables = path.list();
                    if (undeletables != null && undeletables.length > 0) {
                        for (String name : undeletables) {
                            if (!name.startsWith(".nfs")) continue;
                            File fOld = new File(path, name);
                            File fNew = new File(path.getParentFile(), name);
                            boolean bl = fOld.renameTo(fNew);
                        }
                    }
                }
                path.delete();
            }
        }
    }

    private static class WriteConfigCommand
    extends Command {
        private File path;

        WriteConfigCommand(Iterator<String> argIter) throws Command.Fault {
            super(WriteConfigCommand.getName());
            if (!argIter.hasNext()) {
                throw new Command.Fault(i18n, "cnfg.conf.missingArg");
            }
            this.path = new File(this.nextArg(argIter));
        }

        WriteConfigCommand(File path) {
            super(path.getPath());
            this.path = path;
        }

        static String getName() {
            return "writeConfig";
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            try {
                InterviewParameters p = this.getConfig(ctx);
                p.saveAs(this.path, true, true);
            }
            catch (IOException e) {
                if (!this.path.canWrite()) {
                    throw (Command)this.new Command.Fault(i18n, "cnfg.writeConfig.cantWrite", (Object)this.path.getPath());
                }
                throw (Command)this.new Command.Fault(i18n, "cnfg.writeConfig.writeErr", this.path, e);
            }
            catch (Interview.Fault e) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.writeConfig.badConfig", this.path, e.getMessage());
            }
        }
    }

    private static class SetXCommand
    extends Command {
        private File file;
        private String name;
        private String value;

        SetXCommand(Iterator<String> argIter) throws Command.Fault {
            super(SetXCommand.getName());
            if (!argIter.hasNext()) {
                throw new Command.Fault(i18n, "cnfg.set.insufficientArgs");
            }
            String arg = this.nextArg(argIter);
            if (arg.equals("-f") || arg.equals("-file")) {
                if (!argIter.hasNext()) {
                    throw new Command.Fault(i18n, "cnfg.set.insufficientArgs");
                }
                this.file = new File(this.nextArg(argIter));
            } else {
                this.name = arg;
                if (!argIter.hasNext()) {
                    throw new Command.Fault(i18n, "cnfg.set.insufficientArgs");
                }
                this.value = this.nextArg(argIter);
            }
        }

        static String getName() {
            return "setX";
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            InterviewParameters p = this.getConfig(ctx);
            if (this.file != null) {
                Map<String, String> values = this.loadFile(this.file);
                Set<String> keys = values.keySet();
                Iterator<String> it = keys.iterator();
                String name = null;
                int i = 0;
                while (it.hasNext()) {
                    name = it.next();
                    p.storeProperty(name, values.get(name));
                    ++i;
                }
            } else {
                p.storeProperty(this.name, this.value);
            }
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private Map<String, String> loadFile(File file) throws Command.Fault {
            try (FileInputStream fis = new FileInputStream(file);){
                Map<String, String> map;
                try (BufferedInputStream in = new BufferedInputStream(fis);){
                    map = PropertyUtils.load(in);
                }
                return map;
            }
            catch (FileNotFoundException e) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.set.cantFindFile", (Object)file);
            }
            catch (IOException e) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.set.cantReadFile", file, e.getMessage());
            }
        }
    }

    private static class ParamFileCommand
    extends ParamsBaseCommand {
        private File path;

        ParamFileCommand(File path) {
            super(path.getPath());
            this.path = path;
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            try {
                FileParameters params = new FileParameters(this.path);
                if (!params.isValid()) {
                    throw (Command)this.new Command.Fault(i18n, "cnfg.params.badParameterFile", this.path, params.getErrorMessage());
                }
                this.setParameters(ctx, params);
            }
            catch (FileNotFoundException e) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.params.cantFindFile", (Object)this.path);
            }
            catch (IOException e) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.params.cantReadFile", this.path, e);
            }
        }
    }

    private static abstract class ParamsBaseCommand
    extends Command {
        ParamsBaseCommand(String name) {
            super(name);
        }

        protected void setParameters(CommandContext ctx, FileParameters fp) throws Command.Fault {
            try {
                ctx.setTestSuite(fp.getTestSuite());
                if (fp.getWorkDirectory() != null) {
                    ctx.setWorkDirectory(fp.getWorkDirectory());
                }
                this.getConfig(ctx).load(fp);
                File autoRunReportDir = fp.getReportDir();
                if (autoRunReportDir == null) {
                    File rd = new File("reports", "report");
                    autoRunReportDir = ctx.getWorkDirectory().getFile(rd.getPath());
                }
                ctx.setAutoRunReportDir(autoRunReportDir);
            }
            catch (TestSuite.Fault e) {
                throw (Command)this.new Command.Fault(i18n, "cnfg.cantSetParameters", (Object)e.getMessage());
            }
            catch (CommandContext.Fault e) {
                throw new Command.Fault(e);
            }
        }
    }
}

