/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.HelpSetFactory;
import com.sun.interview.Interview;
import com.sun.javatest.tool.jthelp.HelpID;
import com.sun.javatest.tool.jthelp.HelpSet;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;

public class JavaHelpFactory
implements HelpSetFactory {
    private static final ResourceBundle i18n = ResourceBundle.getBundle("com.sun.interview.i18n");

    @Override
    public Object createHelpSetObject(String name, Class<?> c) throws Interview.Fault {
        String hsn;
        ClassLoader cl = c.getClassLoader();
        String pref = "";
        if (name.startsWith("/")) {
            hsn = name.substring(1);
            pref = hsn.substring(0, hsn.lastIndexOf(47) + 1);
        } else {
            String cn = c.getName();
            String pn = cn.substring(0, cn.lastIndexOf(46));
            hsn = pn.replace('.', '/') + "/" + name;
            pref = hsn.substring(0, hsn.indexOf(name));
        }
        URL u = HelpSet.findHelpSet(cl, hsn);
        if (u == null) {
            throw new HelpNotFoundFault(i18n, "interview.cantFindHelp", hsn);
        }
        return new HelpSet(cl, u, pref);
    }

    @Override
    public Object createHelpSetObject(String name, File file) throws Interview.Fault {
        try {
            URL[] urls = new URL[]{new URL("file:" + file.getAbsolutePath() + "/")};
            URLClassLoader cl = new URLClassLoader(urls);
            URL url = HelpSet.findHelpSet(cl, name);
            if (url == null) {
                throw new HelpNotFoundFault(i18n, "interview.cantFindHelp", file.getPath());
            }
            return new HelpSet(cl, url);
        }
        catch (MalformedURLException e) {
            throw new HelpNotFoundFault(i18n, "interview.cantFindHelp", file.getPath());
        }
    }

    @Override
    public Object createHelpID(Object hsObject, String target) {
        HelpSet hs;
        HashMap<String, URL> m;
        if (hsObject != null && (m = (hs = (HelpSet)hsObject).getCombinedMap()) != null && !m.isEmpty()) {
            return HelpID.create(target, hs);
        }
        return null;
    }

    @Override
    public Object updateHelpSetObject(Interview interview, Object object) {
        HelpSet newHelpSet = (HelpSet)object;
        HelpSet oldHelpSet = (HelpSet)interview.getHelpSet();
        if (interview.getParent() == null) {
            if (oldHelpSet == null) {
                for (Interview i : interview.getInterviews()) {
                    HelpSet ihs = (HelpSet)i.getHelpSet();
                    if (ihs == null) continue;
                    newHelpSet.add(ihs);
                }
            } else {
                ArrayList<HelpSet> helpSetsToRemove = new ArrayList<HelpSet>();
                for (HelpSet entry : oldHelpSet.getHelpSets()) {
                    helpSetsToRemove.add(entry);
                    newHelpSet.add(entry);
                }
                for (HelpSet helpToRemove : helpSetsToRemove) {
                    oldHelpSet.remove(helpToRemove);
                }
            }
        } else {
            Interview i = interview;
            while (i.getParent() != null) {
                i = i.getParent();
            }
            HelpSet rootHelpSet = (HelpSet)i.getHelpSet();
            if (rootHelpSet != null) {
                if (oldHelpSet != null) {
                    rootHelpSet.remove(oldHelpSet);
                }
                rootHelpSet.add(newHelpSet);
            }
        }
        return newHelpSet;
    }

    public static class HelpNotFoundFault
    extends Interview.Fault {
        public final String name;

        HelpNotFoundFault(ResourceBundle i18n, String s, String name) {
            super(i18n, s, (Object)name);
            this.name = name;
        }
    }

    public static class BadHelpFault
    extends Interview.Fault {
        BadHelpFault(ResourceBundle i18n, String s, Exception e) {
            super(i18n, s, (Object)e.getMessage());
        }
    }
}

