/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.tool;

import com.sun.interview.Interview;
import com.sun.javatest.AllTestsFilter;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.JavaTestSecurityManager;
import com.sun.javatest.Keywords;
import com.sun.javatest.ParameterFilter;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.StatusFilter;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.ExecToolManager;
import com.sun.javatest.httpd.HttpdServer;
import com.sun.javatest.httpd.PageGenerator;
import com.sun.javatest.regtest.BadArgs;
import com.sun.javatest.regtest.Main;
import com.sun.javatest.regtest.agent.JDK_Version;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.ExecMode;
import com.sun.javatest.regtest.config.GroupManager;
import com.sun.javatest.regtest.config.IgnoreKind;
import com.sun.javatest.regtest.config.JDK;
import com.sun.javatest.regtest.config.OS;
import com.sun.javatest.regtest.config.RegressionParameters;
import com.sun.javatest.regtest.config.RegressionTestSuite;
import com.sun.javatest.regtest.config.TestManager;
import com.sun.javatest.regtest.exec.Agent;
import com.sun.javatest.regtest.exec.Lock;
import com.sun.javatest.regtest.report.BasicObserver;
import com.sun.javatest.regtest.report.ElapsedTimeHandler;
import com.sun.javatest.regtest.report.RegressionReporter;
import com.sun.javatest.regtest.report.TestStats;
import com.sun.javatest.regtest.report.Verbose;
import com.sun.javatest.regtest.report.VerboseHandler;
import com.sun.javatest.regtest.report.XMLWriter;
import com.sun.javatest.regtest.tool.Help;
import com.sun.javatest.regtest.tool.JarManager;
import com.sun.javatest.regtest.tool.Option;
import com.sun.javatest.regtest.tool.OptionDecoder;
import com.sun.javatest.regtest.tool.Startup;
import com.sun.javatest.regtest.tool.Version;
import com.sun.javatest.regtest.util.NaturalComparator;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.awt.EventQueue;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax.swing.Timer;

public class Tool {
    public static final String MAIN = "main";
    public static final String SELECT = "select";
    public static final String JDK = "jdk";
    public static final String MODE = "mode";
    public static final String VERBOSE = "verbose";
    public static final String DOC = "doc";
    public static final String TIMEOUT = "timeout";
    public static final String AGENT_POOL = "pool";
    public List<Option> options = List.of(new Option(Option.ArgType.OPT, "verbose", "verbose", new String[]{"-v", "-verbose"}){

        @Override
        public String[] getChoices() {
            String[] values = new String[Verbose.values().length];
            int i = 0;
            for (String s : Verbose.values()) {
                values[i++] = s;
            }
            return values;
        }

        @Override
        public void process(String opt, String arg) throws BadArgs {
            if (arg == null) {
                verbose = Verbose.DEFAULT;
            } else {
                verbose = Verbose.decode(arg);
                if (verbose == null) {
                    throw new BadArgs(i18n, "main.unknownVerbose", arg);
                }
            }
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"-v1"}){

        @Override
        public void process(String opt, String arg) {
            verbose = Verbose.SUMMARY;
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"-va"}){

        @Override
        public void process(String opt, String arg) {
            verbose = Verbose.ALL;
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"-vp"}){

        @Override
        public void process(String opt, String arg) {
            verbose = Verbose.PASS;
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"-vf"}){

        @Override
        public void process(String opt, String arg) {
            verbose = Verbose.FAIL;
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"-ve"}){

        @Override
        public void process(String opt, String arg) {
            verbose = Verbose.ERROR;
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"-vt"}){

        @Override
        public void process(String opt, String arg) {
            verbose = Verbose.TIME;
        }
    }, new Option(Option.ArgType.NONE, "doc", "", new String[]{"-t", "-tagspec"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.help.setTagSpec(true);
        }
    }, new Option(Option.ArgType.NONE, "doc", "", new String[]{"-n", "-relnote"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.help.setReleaseNotes(true);
        }
    }, new Option(Option.ArgType.OLD, "main", "", new String[]{"-w", "-workDir"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.workDirArg = Path.of(arg, new String[0]);
        }
    }, new Option(Option.ArgType.OPT, "main", "", new String[]{"-retain"}){

        @Override
        public String[] getChoices() {
            return new String[]{"none", "lastRun", "pass", "fail", "error", "all", "file-pattern"};
        }

        @Override
        public void process(String opt, String arg) throws BadArgs {
            if (arg != null) {
                arg = arg.trim();
            }
            Tool.this.retainArgs = arg == null || arg.length() == 0 ? Collections.singletonList("all") : List.of(arg.split(","));
            if (Tool.this.retainArgs.contains("none") && Tool.this.retainArgs.size() > 1) {
                throw new BadArgs(i18n, "main.badRetainNone", arg);
            }
            if (Tool.this.retainArgs.contains("lastRun") && Tool.this.retainArgs.size() > 1) {
                throw new BadArgs(i18n, "main.badRetainLastRun", arg);
            }
        }
    }, new Option(Option.ArgType.OLD, "main", "", new String[]{"-r", "-reportDir"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.reportDirArg = Path.of(arg, new String[0]);
        }
    }, new Option(Option.ArgType.NONE, "main", "ro-nr", new String[]{"-ro", "-reportOnly"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.reportOnlyFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "main", "ro-nr", new String[]{"-nr", "-noreport"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.reportMode = ReportMode.NONE;
        }
    }, new Option(Option.ArgType.STD, "main", "ro-nr", new String[]{"-show"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.reportMode = ReportMode.NONE;
            Tool.this.showStream = arg;
        }
    }, new Option(Option.ArgType.STD, "main", "ro-nr", new String[]{"-report"}){

        @Override
        public String[] getChoices() {
            String[] values = new String[ReportMode.values().length];
            int i = 0;
            for (ReportMode m : ReportMode.values()) {
                values[i++] = m.toString().toLowerCase(Locale.US).replace("_", "-");
            }
            return values;
        }

        @Override
        public void process(String opt, String arg) throws BadArgs {
            switch (arg) {
                case "none": {
                    Tool.this.reportMode = ReportMode.NONE;
                    break;
                }
                case "executed": {
                    Tool.this.reportMode = ReportMode.EXECUTED;
                    break;
                }
                case "all-executed": {
                    Tool.this.reportMode = ReportMode.ALL_EXECUTED;
                    break;
                }
                case "files": {
                    Tool.this.reportMode = ReportMode.FILES;
                    break;
                }
                case "all": {
                    Tool.this.reportMode = ReportMode.ALL;
                    break;
                }
                default: {
                    throw new BadArgs(i18n, "main.badReportOption", arg);
                }
            }
        }
    }, new Option(Option.ArgType.STD, "timeout", "", new String[]{"-timeout", "-timeoutFactor"}){

        @Override
        public void process(String opt, String arg) throws BadArgs {
            try {
                Tool.this.timeoutFactorArg = Float.valueOf(Float.parseFloat(arg));
            }
            catch (NumberFormatException e) {
                throw new BadArgs(i18n, "main.badTimeoutFactor", new Object[0]);
            }
        }
    }, new Option(Option.ArgType.STD, "timeout", "", new String[]{"-tl", "-timelimit"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.timeLimitArg = arg;
        }
    }, new Option(Option.ArgType.GNU, "pool", null, new String[]{"--max-pool-size"}){

        @Override
        public void process(String opt, String arg) throws BadArgs {
            try {
                Tool.this.maxPoolSize = Integer.parseInt(arg);
            }
            catch (NumberFormatException e) {
                throw new BadArgs(i18n, "main.badMaxPoolSize", arg);
            }
        }
    }, new Option(Option.ArgType.GNU, "pool", null, new String[]{"--pool-idle-timeout"}){

        @Override
        public void process(String opt, String arg) throws BadArgs {
            try {
                Tool.this.poolIdleTimeout = Duration.ofMillis((long)(1000.0f * Float.parseFloat(arg)));
            }
            catch (NumberFormatException e) {
                throw new BadArgs(i18n, "main.badPoolIdleTimeout", arg);
            }
        }
    }, new Option(Option.ArgType.STD, "main", "", new String[]{"-conc", "-concurrency"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.concurrencyArg = arg;
        }
    }, new Option(Option.ArgType.OPT, "main", "", new String[]{"-xml"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.xmlFlag = true;
            Tool.this.xmlVerifyFlag = "verify".equals(arg);
        }
    }, new Option(Option.ArgType.STD, "main", "", new String[]{"-dir"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.baseDirArg = Path.of(arg, new String[0]);
        }
    }, new Option(Option.ArgType.OPT, "main", "", new String[]{"-allowSetSecurityManager"}){

        @Override
        public String[] getChoices() {
            return new String[]{"yes", "no", "on", "off", "true", "false"};
        }

        @Override
        public void process(String opt, String arg) {
            boolean b;
            Tool.this.allowSetSecurityManagerFlag = b = arg == null || List.of("yes", "on", "true").contains(arg);
        }
    }, new Option(Option.ArgType.STD, "select", "", new String[]{"-status"}){

        @Override
        public String[] getChoices() {
            return new String[]{"pass", "fail", "notRun", "error"};
        }

        @Override
        public void process(String opt, String arg) {
            Tool.this.priorStatusValuesArg = arg.toLowerCase();
        }
    }, new Option(Option.ArgType.STD, "select", null, new String[]{"-exclude", "-Xexclude"}){

        @Override
        public void process(String opt, String arg) {
            File f = Tool.getNormalizedFile(new File(arg));
            Tool.this.excludeListArgs.add(f.toPath());
        }
    }, new Option(Option.ArgType.STD, "select", null, new String[]{"-match"}){

        @Override
        public void process(String opt, String arg) {
            File f = Tool.getNormalizedFile(new File(arg));
            Tool.this.matchListArgs.add(f.toPath());
        }
    }, new Option(Option.ArgType.NONE, "main", null, new String[]{"-startHttpd"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.httpdFlag = true;
        }
    }, new Option(Option.ArgType.OLD, "main", "", new String[]{"-o", "-observer"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.observerClassName = arg;
        }
    }, new Option(Option.ArgType.OLD, "main", "", new String[]{"-ttf", "-testThreadFactory"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.testThreadFactory = arg;
        }
    }, new Option(Option.ArgType.STD, "main", "", new String[]{"-ttfp", "-testThreadFactoryPath"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.testThreadFactoryPathArg = arg;
        }
    }, new Option(Option.ArgType.OLD, "main", "", new String[]{"-od", "-observerDir", "-op", "-observerPath"}){

        @Override
        public void process(String opt, String arg) {
            if ((arg = arg.trim()).length() == 0) {
                return;
            }
            Tool.this.observerPathArg = new ArrayList<Path>();
            for (String f : arg.split(File.pathSeparator)) {
                if (f.length() == 0) continue;
                Tool.this.observerPathArg.add(Path.of(f, new String[0]));
            }
        }
    }, new Option(Option.ArgType.STD, "timeout", "", new String[]{"-th", "-timeoutHandler"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.timeoutHandlerClassName = arg;
        }
    }, new Option(Option.ArgType.STD, "timeout", "", new String[]{"-thd", "-timeoutHandlerDir"}){

        @Override
        public void process(String opt, String arg) {
            if ((arg = arg.trim()).length() == 0) {
                return;
            }
            Tool.this.timeoutHandlerPathArg = new ArrayList<Path>();
            for (String f : arg.split(File.pathSeparator)) {
                if (f.length() == 0) continue;
                Tool.this.timeoutHandlerPathArg.add(Path.of(f, new String[0]));
            }
        }
    }, new Option(Option.ArgType.STD, "timeout", "", new String[]{"-thtimeout", "-timeoutHandlerTimeout"}){

        @Override
        public void process(String opt, String arg) throws BadArgs {
            try {
                Tool.this.timeoutHandlerTimeoutArg = Long.parseLong(arg);
            }
            catch (NumberFormatException e) {
                throw new BadArgs(i18n, "main.badTimeoutHandlerTimeout", new Object[0]);
            }
        }
    }, new Option(Option.ArgType.NONE, "main", null, new String[]{"-g", "-gui"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.guiFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "main", null, new String[]{"-c", "-check"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.checkFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "main", null, new String[]{"-l", "-listtests"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.listTestsFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "main", null, new String[]{"-showGroups"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.showGroupsFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "main", "ignore", new String[]{"-noignore"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.ignoreKind = IgnoreKind.RUN;
        }
    }, new Option(Option.ArgType.STD, "main", "ignore", new String[]{"-ignore"}){

        @Override
        public String[] getChoices() {
            String[] values = new String[IgnoreKind.values().length];
            int i = 0;
            for (IgnoreKind k : IgnoreKind.values()) {
                values[i++] = k.toString().toLowerCase();
            }
            return values;
        }

        @Override
        public void process(String opt, String arg) throws BadArgs {
            for (IgnoreKind k : IgnoreKind.values()) {
                if (!arg.equalsIgnoreCase(k.toString())) continue;
                if (k == IgnoreKind.QUIET) {
                    Tool.this.extraKeywordExpr = Tool.combineKeywords(Tool.this.extraKeywordExpr, "!ignore");
                }
                Tool.this.ignoreKind = k;
                return;
            }
            throw new BadArgs(i18n, "main.unknownIgnore", arg);
        }
    }, new Option(Option.ArgType.OLD, "main", null, new String[]{"-e"}){

        @Override
        public void process(String opt, String arg) {
            if ((arg = arg.trim()).length() == 0) {
                return;
            }
            Tool.this.envVarArgs.addAll(List.of(arg.split(",")));
        }
    }, new Option(Option.ArgType.STD, "main", "", new String[]{"-lock"}){

        @Override
        public void process(String opt, String arg) throws BadArgs {
            File f = Tool.getNormalizedFile(new File(arg));
            try {
                if (!(!f.exists() ? f.createNewFile() : f.isFile() && f.canRead())) {
                    throw new BadArgs(i18n, "main.badLockFile", arg);
                }
            }
            catch (IOException e) {
                throw new BadArgs(i18n, "main.cantCreateLockFile", arg);
            }
            Tool.this.exclusiveLockArg = f.toPath();
        }
    }, new Option(Option.ArgType.STD, "main", "", new String[]{"-nativepath"}){

        @Override
        public void process(String opt, String arg) throws BadArgs {
            if (arg.contains(File.pathSeparator)) {
                throw new BadArgs(i18n, "main.nativePathMultiplePath", arg);
            }
            File f = new File(arg);
            if (!f.exists()) {
                throw new BadArgs(i18n, "main.nativePathNotExist", arg);
            }
            if (!f.isDirectory()) {
                throw new BadArgs(i18n, "main.nativePathNotDir", arg);
            }
            Tool.this.nativeDirArg = f.toPath();
        }
    }, new Option(Option.ArgType.NONE, "main", "wsl-cygwin", new String[]{"-wsl"}){

        @Override
        public void process(String opt, String arg) throws BadArgs {
            if (!Tool.this.isWindows()) {
                throw new BadArgs(i18n, "main.windowsOnly", opt);
            }
            if (Tool.this.isCygwinDetected()) {
                Tool.this.out.println(i18n.getString("main.warn.wsl.specified.found.cygwin"));
            }
            Tool.this.useWindowsSubsystemForLinux = true;
        }
    }, new Option(Option.ArgType.NONE, "main", "wsl-cygwin", new String[]{"-cygwin"}){

        @Override
        public void process(String opt, String arg) throws BadArgs {
            if (!Tool.this.isWindows()) {
                throw new BadArgs(i18n, "main.windowsOnly", opt);
            }
            if (Tool.this.isWindowsSubsystemForLinuxDetected()) {
                Tool.this.out.println(i18n.getString("main.warn.cygwin.specified.found.wsl"));
            }
            Tool.this.useWindowsSubsystemForLinux = false;
        }
    }, new Option(Option.ArgType.NONE, "select", "a-m", new String[]{"-a", "-automatic", "-automagic"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.extraKeywordExpr = Tool.combineKeywords(Tool.this.extraKeywordExpr, Tool.AUTOMATIC);
        }
    }, new Option(Option.ArgType.NONE, "select", "a-m", new String[]{"-m", "-manual"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.extraKeywordExpr = Tool.combineKeywords(Tool.this.extraKeywordExpr, Tool.MANUAL);
        }
    }, new Option(Option.ArgType.NONE, "select", "shell-noshell", new String[]{"-shell"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.extraKeywordExpr = Tool.combineKeywords(Tool.this.extraKeywordExpr, "shell");
        }
    }, new Option(Option.ArgType.NONE, "select", "shell-noshell", new String[]{"-noshell"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.extraKeywordExpr = Tool.combineKeywords(Tool.this.extraKeywordExpr, "!shell");
        }
    }, new Option(Option.ArgType.STD, "select", null, new String[]{"-bug"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.extraKeywordExpr = Tool.combineKeywords(Tool.this.extraKeywordExpr, "bug" + arg);
        }
    }, new Option(Option.ArgType.STD, "select", null, new String[]{"-k", "-keywords"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.userKeywordExpr = Tool.combineKeywords(Tool.this.userKeywordExpr, "(" + arg + ")");
        }
    }, new Option(Option.ArgType.NONE, "mode", "avm-ovm", new String[]{"-ovm", "-othervm"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.execMode = ExecMode.OTHERVM;
        }
    }, new Option(Option.ArgType.NONE, "mode", "avm-ovm", new String[]{"-avm", "-agentvm", "-s", "-svm", "-samevm"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.execMode = ExecMode.AGENTVM;
        }
    }, new Option(Option.ArgType.OLD, "jdk", "", new String[]{"-jdk", "-testjdk"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.testJDK = com.sun.javatest.regtest.config.JDK.of(arg);
        }
    }, new Option(Option.ArgType.OLD, "jdk", "", new String[]{"-compilejdk"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.compileJDK = com.sun.javatest.regtest.config.JDK.of(arg);
        }
    }, new Option(Option.ArgType.STD, "jdk", "", new String[]{"-cpa", "-classpathappend"}){

        @Override
        public void process(String opt, String arg) {
            if ((arg = arg.trim()).length() == 0) {
                return;
            }
            for (String f : arg.split(File.pathSeparator)) {
                if (f.length() == 0) continue;
                Tool.this.classPathAppendArg.add(Path.of(f, new String[0]));
            }
        }
    }, new Option(Option.ArgType.NONE, "jdk", "jit-nojit", new String[]{"-jit"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.jitFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "jdk", "jit-nojit", new String[]{"-nojit"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.jitFlag = false;
        }
    }, new Option(Option.ArgType.NONE, "jdk", null, new String[]{"-classic", "-green", "-native", "-hotspot", "-client", "-server", "-d32", "-d64"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.testVMOpts.add(opt);
        }
    }, new Option(Option.ArgType.OPT, "jdk", null, new String[]{"-enableassertions", "-ea", "-disableassertions", "-da"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.testVMOpts.add(opt);
        }
    }, new Option(Option.ArgType.NONE, "jdk", null, new String[]{"-enablesystemassertions", "-esa", "-disablesystemassertions", "-dsa"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.testVMOpts.add(opt);
        }
    }, new Option(Option.ArgType.GNU, "jdk", null, new String[]{"--add-modules"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.testVMOpts.add(opt);
            Tool.this.testVMOpts.add(arg);
        }
    }, new Option(Option.ArgType.GNU, "jdk", null, new String[]{"--limit-modules"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.testVMOpts.add(opt);
            Tool.this.testVMOpts.add(arg);
        }
    }, new Option(Option.ArgType.WILDCARD, "jdk", null, new String[]{"-XX", "-Xms", "-Xmx"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.testVMOpts.add(opt);
        }
    }, new Option(Option.ArgType.WILDCARD, "jdk", null, new String[]{"-Xint", "-Xmixed", "-Xcomp"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.testVMOpts.add(opt);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-Xbootclasspath"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.testVMOpts.add("-Xbootclasspath:" + String.valueOf(Tool.filesToAbsolutePath(Tool.pathToFiles(arg))));
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-Xbootclasspath/a"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.testVMOpts.add("-Xbootclasspath/a:" + String.valueOf(Tool.filesToAbsolutePath(Tool.pathToFiles(arg))));
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-Xbootclasspath/p"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.testVMOpts.add("-Xbootclasspath/p:" + String.valueOf(Tool.filesToAbsolutePath(Tool.pathToFiles(arg))));
        }
    }, new Option(Option.ArgType.GNU, "jdk", null, new String[]{"--patch-module"}){

        @Override
        public void process(String opt, String arg) {
            int eq = arg.indexOf("=");
            Tool.this.testVMOpts.add("--patch-module");
            Tool.this.testVMOpts.add(arg.substring(0, eq + 1) + String.valueOf(Tool.filesToAbsolutePath(Tool.pathToFiles(arg.substring(eq + 1)))));
        }
    }, new Option(Option.ArgType.WILDCARD, "jdk", null, new String[]{"-X"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.testVMOpts.add(opt);
        }
    }, new Option(Option.ArgType.WILDCARD, "jdk", null, new String[]{"-D"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.testVMOpts.add(opt);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-vmoption"}){

        @Override
        public void process(String opt, String arg) {
            if (arg.length() > 0) {
                Tool.this.testVMOpts.add(arg);
            }
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-vmoptions"}){

        @Override
        public void process(String opt, String arg) {
            if ((arg = arg.trim()).length() == 0) {
                return;
            }
            Tool.this.testVMOpts.addAll(List.of(arg.split("\\s+")));
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-agentlib"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.testVMOpts.add(opt);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-agentpath"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.testVMOpts.add(opt);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-javaagent"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.testVMOpts.add(opt);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-javacoption"}){

        @Override
        public void process(String opt, String arg) {
            if ((arg = arg.trim()).length() == 0) {
                return;
            }
            Tool.this.testCompilerOpts.add(arg);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-javacoptions"}){

        @Override
        public void process(String opt, String arg) {
            if ((arg = arg.trim()).length() == 0) {
                return;
            }
            Tool.this.testCompilerOpts.addAll(List.of(arg.split("\\s+")));
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-javaoption"}){

        @Override
        public void process(String opt, String arg) {
            if ((arg = arg.trim()).length() == 0) {
                return;
            }
            Tool.this.testJavaOpts.add(arg);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-javaoptions"}){

        @Override
        public void process(String opt, String arg) {
            if ((arg = arg.trim()).length() == 0) {
                return;
            }
            Tool.this.testJavaOpts.addAll(List.of(arg.split("\\s+")));
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"-debug"}){

        @Override
        public void process(String opt, String arg) {
            if ((arg = arg.trim()).length() == 0) {
                return;
            }
            Tool.this.testDebugOpts.addAll(List.of(arg.split("\\s+")));
        }
    }, new Option(Option.ArgType.REST, "doc", "help", new String[]{"--help", "-h", "-help", "-usage"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.help.setCommandLineHelpQuery(arg);
        }
    }, new Option(Option.ArgType.NONE, "doc", "help", new String[]{"-version"}){

        @Override
        public void process(String opt, String arg) {
            Tool.this.help.setVersionFlag(true);
        }
    }, new Option(Option.ArgType.FILE, "main", null, new String[0]){

        @Override
        public void process(String opt, String arg) throws BadArgs {
            if (TestManager.GroupSpec.isGroupSpec(arg)) {
                Tool.this.testGroupSpecArgs.add(TestManager.GroupSpec.of(arg));
            } else if (TestManager.TestSpec.isTestSpec(arg)) {
                Tool.this.testSpecArgs.add(TestManager.TestSpec.of(arg));
            } else {
                throw new BadArgs(i18n, "main.badTestOrGroup", arg);
            }
        }
    });
    int errors;
    private final PrintWriter out;
    private final PrintWriter err;
    private List<String> expandedArgs;
    private Path workDirArg;
    private List<String> retainArgs;
    private List<Path> excludeListArgs = new ArrayList<Path>();
    private String userKeywordExpr;
    private String extraKeywordExpr;
    private String concurrencyArg;
    private Float timeoutFactorArg;
    private String priorStatusValuesArg;
    private Path reportDirArg;
    public List<TestManager.GroupSpec> testGroupSpecArgs = new ArrayList<TestManager.GroupSpec>();
    public List<TestManager.TestSpec> testSpecArgs = new ArrayList<TestManager.TestSpec>();
    private Path baseDirArg;
    private ExecMode execMode;
    private JDK compileJDK;
    private JDK testJDK;
    private boolean guiFlag;
    private boolean reportOnlyFlag;
    private String showStream;
    private ReportMode reportMode;
    private boolean allowSetSecurityManagerFlag = true;
    private static Verbose verbose;
    private boolean httpdFlag;
    private String timeLimitArg;
    private String observerClassName;
    private List<Path> observerPathArg;
    private String timeoutHandlerClassName;
    private List<Path> timeoutHandlerPathArg;
    private long timeoutHandlerTimeoutArg = -1L;
    private String testThreadFactory;
    private String testThreadFactoryPathArg;
    private int maxPoolSize = -1;
    private Duration poolIdleTimeout = Duration.ofSeconds(30L);
    private List<String> testCompilerOpts = new ArrayList<String>();
    private List<String> testJavaOpts = new ArrayList<String>();
    private List<String> testVMOpts = new ArrayList<String>();
    private List<String> testDebugOpts = new ArrayList<String>();
    private boolean checkFlag;
    private boolean listTestsFlag;
    private boolean showGroupsFlag;
    private List<String> envVarArgs = new ArrayList<String>();
    private IgnoreKind ignoreKind;
    private List<Path> classPathAppendArg = new ArrayList<Path>();
    private Path nativeDirArg;
    private Boolean useWindowsSubsystemForLinux;
    private boolean jitFlag = true;
    private Help help;
    private boolean xmlFlag;
    private boolean xmlVerifyFlag;
    private Path exclusiveLockArg;
    private List<Path> matchListArgs = new ArrayList<Path>();
    private final Path javatest_jar;
    private final Path jtreg_jar;
    private SearchPath junitPath;
    private SearchPath testngPath;
    private SearchPath asmtoolsPath;
    private Path policyFile;
    private TestStats testStats;
    private static final String AUTOMATIC = "!manual";
    private static final String MANUAL = "manual";
    private static final String[] DEFAULT_UNIX_ENV_VARS;
    private static final String[] DEFAULT_WINDOWS_ENV_VARS;
    private static final I18NResourceBundle i18n;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Tool.checkJavaOSVersion();
        PrintWriter out = new PrintWriter(System.out, true);
        PrintWriter err = new PrintWriter(System.err, true);
        Tool m = new Tool(out, err);
        try {
            int rc;
            try {
                rc = m.run(args);
            }
            finally {
                out.flush();
                err.flush();
            }
            if (!m.guiFlag || rc != 0) {
                Tool.exit(rc);
            }
        }
        catch (TestManager.NoTests e) {
            err.println(i18n.getString("main.error", (Object)e.getMessage()));
            Tool.exit(1);
        }
        catch (Harness.Fault | Main.Fault e) {
            err.println(i18n.getString("main.error", (Object)e.getMessage()));
            Tool.exit(5);
        }
        catch (BadArgs e) {
            err.println(i18n.getString("main.badArgs", (Object)e.getMessage()));
            new Help(m.options).showCommandLineHelp(out);
            Tool.exit(4);
        }
        catch (InterruptedException e) {
            err.println(i18n.getString("main.interrupted"));
            Tool.exit(6);
        }
        catch (SecurityException e) {
            err.println(i18n.getString("main.securityException", (Object)e.getMessage()));
            e.printStackTrace(System.err);
            Tool.exit(6);
        }
        catch (Error | RuntimeException e) {
            err.println(i18n.getString("main.unexpectedException", (Object)e.toString()));
            e.printStackTrace(System.err);
            Tool.exit(6);
        }
    }

    private static void checkJavaOSVersion() {
        String osName = System.getProperty("os.name");
        if (osName != null && osName.equals("Mac OS X")) {
            List<String> command = List.of("sw_vers", "-productVersion");
            try {
                String expectVersion;
                Process p = new ProcessBuilder(command).redirectErrorStream(true).start();
                try (InputStream in = p.getInputStream();
                     BufferedReader r = new BufferedReader(new InputStreamReader(in));){
                    expectVersion = r.lines().collect(Collectors.joining());
                }
                p.waitFor();
                int rc = p.exitValue();
                if (rc != 0) {
                    System.err.println("Error getting OS version: " + String.join((CharSequence)" ", command) + ": rc=" + rc);
                    System.exit(99);
                }
                Tool.checkJavaOSVersion(expectVersion);
            }
            catch (IOException | InterruptedException e) {
                System.err.println("Error getting OS version: " + String.join((CharSequence)" ", command) + ": " + String.valueOf(e));
                System.exit(99);
            }
        }
    }

    private static void checkJavaOSVersion(String expectVersion) {
        String osVersion = System.getProperty("os.version");
        if (!osVersion.startsWith(expectVersion)) {
            System.err.println("The version of JDK you are using to run jtreg does not report the OS version correctly.");
            System.err.println("    java.home:    " + System.getProperty("java.home"));
            System.err.println("    java.version: " + System.getProperty("java.version"));
            System.err.println("    os.version:   " + osVersion + "  (expected: " + expectVersion + ")");
            System.err.println("Use a more recent update of this version of JDK, or a newer version of JDK.");
            System.exit(1);
        }
    }

    private static void exit(int exitCode) {
        SecurityManager sc = System.getSecurityManager();
        if (sc instanceof JavaTestSecurityManager) {
            JavaTestSecurityManager.setAllowExit(true);
        }
        System.exit(exitCode);
    }

    public Tool() {
        this(new PrintWriter(System.out, true), new PrintWriter(System.err, true));
    }

    public Tool(PrintWriter out, PrintWriter err) {
        this.out = out;
        this.err = err;
        this.javatest_jar = JarManager.forClass(Harness.class);
        this.jtreg_jar = JarManager.forClass(this.getClass());
        this.help = new Help(this.options);
        if (this.javatest_jar != null) {
            this.help.addVersionHelper(o -> {
                block13: {
                    try (JarFile jf = new JarFile(this.javatest_jar.toFile());){
                        JarEntry e = jf.getJarEntry("META-INF/buildInfo.txt");
                        if (e == null) break block13;
                        try (InputStream in = jf.getInputStream(e);){
                            Properties p = new Properties();
                            p.load(in);
                            String v = p.getProperty("version");
                            String s = "JT Harness, version " + v + " " + p.getProperty("milestone") + " " + p.getProperty("build") + " (" + p.getProperty("date") + ")";
                            o.println(s);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public final int run(String[] args) throws BadArgs, Main.Fault, Harness.Fault, InterruptedException {
        if (args.length > 0) {
            this.expandedArgs = Tool.expandAtFiles(args);
            new OptionDecoder(this.options).decodeArgs(this.expandedArgs);
        } else {
            this.help = new Help(this.options);
            this.help.setCommandLineHelpQuery(null);
        }
        return this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public int run() throws BadArgs, Main.Fault, Harness.Fault, InterruptedException {
        boolean bl;
        JDK_Version jDK_Version;
        Path baseDir;
        this.findSystemJarFiles();
        if (this.help.isEnabled()) {
            this.guiFlag = this.help.show(this.out);
            return 0;
        }
        if (this.userKeywordExpr != null) {
            this.userKeywordExpr = this.userKeywordExpr.replace("-", "_");
            try {
                Keywords.create("expr", this.userKeywordExpr);
            }
            catch (Keywords.Fault e) {
                throw new Main.Fault(i18n, "main.badKeywords", e.getMessage());
            }
        }
        if (this.baseDirArg == null) {
            baseDir = Path.of(System.getProperty("user.dir"), new String[0]);
        } else {
            if (!Files.exists(this.baseDirArg, new LinkOption[0])) {
                throw new Main.Fault(i18n, "main.cantFindFile", this.baseDirArg);
            }
            baseDir = this.baseDirArg.toAbsolutePath();
        }
        TestManager testManager = new TestManager(this.out, baseDir, this::error);
        testManager.addTestSpecs(this.testSpecArgs);
        testManager.addGroupSpecs(this.testGroupSpecArgs);
        if (testManager.isEmpty()) {
            throw new TestManager.NoTests();
        }
        boolean multiRun = testManager.isMultiRun();
        for (RegressionTestSuite regressionTestSuite : testManager.getTestSuites()) {
            Version currentVersion;
            Version requiredVersion = regressionTestSuite.getRequiredVersion();
            if (requiredVersion.compareTo(currentVersion = Version.getCurrent()) <= 0) continue;
            throw new Main.Fault(i18n, "main.requiredVersion", regressionTestSuite.getPath(), requiredVersion.getVersionBuildString(), currentVersion.getVersionBuildString());
        }
        if (this.execMode == null) {
            EnumSet<ExecMode> modes = EnumSet.noneOf(ExecMode.class);
            for (RegressionTestSuite ts3 : testManager.getTestSuites()) {
                ExecMode m = ts3.getDefaultExecMode();
                if (m == null) continue;
                modes.add(m);
            }
            switch (modes.size()) {
                case 0: {
                    this.execMode = ExecMode.OTHERVM;
                    break;
                }
                case 1: {
                    this.execMode = (ExecMode)((Object)modes.iterator().next());
                    break;
                }
                default: {
                    throw new Main.Fault(i18n, "main.cantDetermineExecMode", new Object[0]);
                }
            }
        }
        if (this.testJDK == null) {
            void var5_11;
            String s = System.getenv("JAVA_HOME");
            if (!(s != null && s.length() != 0 || (s = System.getProperty("java.home")) != null && s.length() != 0)) {
                throw new BadArgs(i18n, "main.jdk.not.set", new Object[0]);
            }
            File file = new File(s);
            if (this.compileJDK == null && file.getName().equalsIgnoreCase("jre") && file.getParentFile() != null) {
                File file2 = file.getParentFile();
            }
            this.testJDK = com.sun.javatest.regtest.config.JDK.of(var5_11.toPath());
        }
        JDK_Version testJDK_version = this.checkJDK(this.testJDK);
        if (this.compileJDK != null && !(jDK_Version = this.checkJDK(this.compileJDK)).equals(testJDK_version)) {
            this.out.println("Warning: compileJDK has a different version (" + String.valueOf(jDK_Version) + ") from testJDK (" + String.valueOf(testJDK_version) + ")");
        }
        if (this.isWindows()) {
            if (this.useWindowsSubsystemForLinux == null) {
                this.useWindowsSubsystemForLinux = !this.isCygwinDetected() && this.isWindowsSubsystemForLinuxDetected();
            }
        } else {
            this.useWindowsSubsystemForLinux = false;
        }
        if (!this.jitFlag) {
            this.envVarArgs.add("JAVA_COMPILER=");
        }
        if (this.classPathAppendArg.size() > 0) {
            this.envVarArgs.add("CPAPPEND=" + String.valueOf(Tool.filesToAbsolutePath(this.classPathAppendArg)));
        }
        if (this.reportMode == null) {
            this.reportMode = ReportMode.ALL_EXECUTED;
        }
        if (this.workDirArg == null) {
            this.workDirArg = Path.of("JTwork", new String[0]);
        }
        if (this.reportDirArg == null && this.reportMode != ReportMode.NONE) {
            this.reportDirArg = Path.of("JTreport", new String[0]);
        }
        this.makeDir(this.workDirArg, false);
        testManager.setWorkDirectory(this.workDirArg);
        RegressionTestSuite.setParametersFactory(ts -> {
            try {
                return this.createParameters(testManager, ts);
            }
            catch (BadArgs | Main.Fault ex) {
                throw new TestSuite.Fault(i18n, "main.cantCreateParameters", (Object)ex.getMessage());
            }
        });
        if (this.showGroupsFlag) {
            this.showGroups(testManager);
            return 0;
        }
        if (this.listTestsFlag) {
            this.listTests(testManager);
            return 0;
        }
        this.makeDir(this.workDirArg.resolve("scratch"), true);
        if (this.reportMode != ReportMode.NONE) {
            this.makeDir(this.reportDirArg, false);
            testManager.setReportDirectory(this.reportDirArg);
            if (this.expandedArgs != null) {
                Path path = this.reportDirArg.resolve("text");
                this.makeDir(path, true);
                Path cmdArgsFile = path.resolve("cmdArgs.txt");
                try (BufferedWriter cmdArgsWriter = Files.newBufferedWriter(cmdArgsFile, new OpenOption[0]);){
                    for (String arg : this.expandedArgs) {
                        cmdArgsWriter.append(arg);
                        cmdArgsWriter.newLine();
                    }
                }
                catch (IOException e) {
                    System.err.println("Error writing " + String.valueOf(cmdArgsFile) + ": " + String.valueOf(e));
                }
            }
        }
        Harness.setClassDir(ProductInfo.getJavaTestClassDir());
        Keywords.setAllowNumericKeywords(true);
        if (this.httpdFlag) {
            this.startHttpServer();
        }
        if (multiRun && this.guiFlag) {
            throw new Main.Fault(i18n, "main.onlyOneTestSuiteInGuiMode", new Object[0]);
        }
        this.testStats = new TestStats();
        boolean bl2 = false;
        for (RegressionTestSuite ts4 : testManager.getTestSuites()) {
            RegressionParameters params;
            String[] tests;
            if (multiRun && verbose != null && Tool.verbose.multiRun) {
                this.out.println("Running tests in " + String.valueOf(ts4.getRootDir()));
            }
            if ((tests = (params = this.createParameters(testManager, ts4)).getTests()) != null && tests.length == 0) {
                bl = true;
            }
            this.checkLockFiles(params.getWorkDirectory().getRoot(), "start");
            switch (this.execMode) {
                case AGENTVM: {
                    Agent.Pool p = Agent.Pool.instance(params);
                    if (this.allowSetSecurityManagerFlag) {
                        this.initPolicyFile();
                        p.setSecurityPolicy(this.policyFile.toFile());
                    }
                    if (this.timeoutFactorArg != null) {
                        p.setTimeoutFactor(this.timeoutFactorArg.floatValue());
                    }
                    if (this.maxPoolSize == -1) {
                        int factor = 2;
                        this.maxPoolSize = params.getConcurrency() * factor;
                    }
                    p.setMaxPoolSize(this.maxPoolSize);
                    p.setIdleTimeout(this.poolIdleTimeout);
                    break;
                }
                case OTHERVM: {
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            TestEnvironment.addDefaultPropTable("(system properties)", System.getProperties());
            if (this.guiFlag) {
                this.showTool(params);
                return 0;
            }
            try {
                boolean quiet = multiRun && (verbose == null || !Tool.verbose.multiRun);
                this.testStats.addAll(this.batchHarness(params, quiet));
            }
            finally {
                this.checkLockFiles(params.getWorkDirectory().getRoot(), "done");
            }
            if (verbose == null || !Tool.verbose.multiRun) continue;
            this.out.println();
        }
        if (multiRun) {
            if (verbose != null && Tool.verbose.multiRun) {
                this.out.println("Overall summary:");
            }
            this.testStats.showResultStats(this.out);
            if (this.reportMode != ReportMode.NONE) {
                RegressionReporter r = new RegressionReporter(this.out);
                r.report(testManager);
            }
            if (!this.reportOnlyFlag) {
                this.out.println("Results written to " + String.valueOf(Tool.canon(this.workDirArg.toFile())));
            }
        }
        return this.testStats.counts[2] > 0 ? 3 : (this.testStats.counts[1] > 0 ? 2 : (this.testStats.counts[0] == 0 && !bl ? 1 : (this.errors != 0 ? 5 : 0)));
    }

    JDK_Version checkJDK(JDK jdk) throws Main.Fault {
        if (!jdk.exists()) {
            throw new Main.Fault(i18n, "main.jdk.not.found", jdk);
        }
        JDK jtregJDK = com.sun.javatest.regtest.config.JDK.of(System.getProperty("java.home"));
        Path jtregJava = jtregJDK.getProg("java", true);
        Path jdkJava = jdk.getProg("java", true);
        if (!jdkJava.getFileName().equals(jtregJava.getFileName())) {
            throw new Main.Fault(i18n, "main.incompatibleJDK", jdk, jtregJDK);
        }
        JDK_Version v = jdk.getJDKVersion(new SearchPath(this.jtreg_jar, this.javatest_jar), this.out::println);
        if (v == null) {
            throw new Main.Fault(i18n, "main.jdk.unknown.version", jdk);
        }
        if (v.compareTo(JDK_Version.V1_1) <= 0) {
            throw new Main.Fault(i18n, "main.jdk.unsupported.version", jdk, v.name());
        }
        return v;
    }

    void showGroups(TestManager testManager) throws Main.Fault {
        for (RegressionTestSuite ts : testManager.getTestSuites()) {
            this.out.println(i18n.getString("main.tests.suite", (Object)ts.getRootDir()));
            try {
                Set<String> selected = testManager.getGroups(ts);
                GroupManager gm = ts.getGroupManager(this.out);
                TreeSet<String> gset = new TreeSet<String>(new NaturalComparator(false));
                if (selected.isEmpty()) {
                    gset.addAll(gm.getGroups());
                } else {
                    for (String g : gm.getGroups()) {
                        if (!selected.contains(g)) continue;
                        gset.add(g);
                    }
                }
                if (gset.isEmpty()) {
                    this.out.println(i18n.getString("main.groups.nogroups"));
                    continue;
                }
                for (String g : gset) {
                    try {
                        Set<Path> files = gm.getFiles(g);
                        this.out.print(g);
                        this.out.print(":");
                        TreeSet<String> fset = new TreeSet<String>(new NaturalComparator(false));
                        for (Path path : files) {
                            fset.add(ts.getRootDir().toURI().relativize(path.toUri()).getPath());
                        }
                        for (String string : fset) {
                            this.out.print(" ");
                            this.out.print(string);
                        }
                        this.out.println();
                    }
                    catch (GroupManager.InvalidGroup ex) {
                        this.out.println(i18n.getString("tm.invalidGroup", (Object)g));
                    }
                }
            }
            catch (IOException e) {
                throw new Main.Fault(i18n, "main.cantReadGroups", ts.getRootDir(), e);
            }
        }
    }

    void listTests(TestManager testManager) throws BadArgs, Main.Fault {
        int total = 0;
        for (RegressionTestSuite ts : testManager.getTestSuites()) {
            int count = 0;
            this.out.println(i18n.getString("main.tests.suite", (Object)ts.getRootDir()));
            RegressionParameters params = this.createParameters(testManager, ts);
            Iterator<TestResult> iter = this.getResultsIterator(params);
            while (iter.hasNext()) {
                TestResult tr = iter.next();
                this.out.println(tr.getTestName());
                ++count;
            }
            this.out.println(i18n.getString("main.tests.found", (Object)count));
            total += count;
        }
        if (testManager.isMultiRun()) {
            this.out.println(i18n.getString("main.tests.total", (Object)total));
        }
    }

    private static List<String> expandAtFiles(String[] args) throws Main.Fault {
        ArrayList<String> newArgs = new ArrayList<String>();
        for (String arg : args) {
            if (arg.length() > 1 && arg.charAt(0) == '@') {
                if ((arg = arg.substring(1)).charAt(0) == '@') {
                    newArgs.add(arg);
                    continue;
                }
                Tool.loadCmdFile(arg, newArgs);
                continue;
            }
            newArgs.add(arg);
        }
        return newArgs;
    }

    private static void loadCmdFile(String name, List<String> args) throws Main.Fault {
        BufferedReader r;
        try {
            r = new BufferedReader(new FileReader(name));
        }
        catch (FileNotFoundException e) {
            throw new Main.Fault(i18n, "main.cantOpenFile", name);
        }
        try {
            StreamTokenizer st = new StreamTokenizer(r);
            st.resetSyntax();
            st.wordChars(32, 255);
            st.whitespaceChars(0, 32);
            st.commentChar(35);
            st.quoteChar(34);
            st.quoteChar(39);
            while (st.nextToken() != -1) {
                args.add(st.sval);
            }
        }
        catch (IOException e) {
            throw new Main.Fault(i18n, "main.cantRead", name, e);
        }
        finally {
            try {
                ((Reader)r).close();
            }
            catch (IOException iOException) {}
        }
    }

    public int[] getTestStats() {
        return this.testStats.counts;
    }

    void findSystemJarFiles() throws Main.Fault {
        if (this.javatest_jar == null) {
            throw new Main.Fault(i18n, "main.cantFind.javatest.jar", new Object[0]);
        }
        if (this.jtreg_jar == null) {
            throw new Main.Fault(i18n, "main.cantFind.jtreg.jar", new Object[0]);
        }
        Path libDir = this.jtreg_jar.getParent();
        JarManager jarManager = new JarManager(libDir);
        this.asmtoolsPath = jarManager.getPath("asmtools");
        this.help.addVersionHelper(out -> {
            for (Path f : this.asmtoolsPath.asList()) {
                try (JarFile jf = new JarFile(f.toFile());){
                    JarEntry e = jf.getJarEntry("org/openjdk/asmtools/util/productinfo.properties");
                    if (e == null) continue;
                    InputStream in = jf.getInputStream(e);
                    try {
                        Properties p = new Properties();
                        p.load(in);
                        String v = p.getProperty("PRODUCT_VERSION");
                        String s = p.getProperty("PRODUCT_NAME_LONG") + ", version " + v + " " + p.getProperty("PRODUCT_MILESTONE") + " " + p.getProperty("PRODUCT_BUILDNUMBER") + " (" + p.getProperty("PRODUCT_DATE") + ")";
                        out.println(s);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        });
        this.testngPath = jarManager.getPath("testng");
        this.help.addPathVersionHelper("TestNG", this.testngPath);
        this.junitPath = jarManager.getPath("junit");
        this.help.addPathVersionHelper("JUnit", this.junitPath);
    }

    void initPolicyFile() throws Main.Fault {
        Path pfile = this.workDirArg.resolve("jtreg.policy");
        try (BufferedWriter pout = Files.newBufferedWriter(pfile, new OpenOption[0]);){
            String LINESEP = System.getProperty("line.separator");
            for (Path f : List.of(this.jtreg_jar, this.javatest_jar)) {
                pout.write("grant codebase \"" + String.valueOf(f.toUri().toURL()) + "\" {" + LINESEP);
                pout.write("    permission java.security.AllPermission;" + LINESEP);
                pout.write("};" + LINESEP);
            }
        }
        catch (IOException e) {
            throw new Main.Fault(i18n, "main.cantWritePolicyFile", e);
        }
        this.policyFile = pfile;
    }

    private void makeDir(Path dir, boolean quiet) throws Main.Fault {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            return;
        }
        if (!quiet) {
            this.out.println("Directory \"" + String.valueOf(dir) + "\" not found: creating");
        }
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            Main.Fault f = new Main.Fault(i18n, "main.cantCreateDir", dir);
            f.initCause(e);
            throw f;
        }
    }

    private static List<Path> pathToFiles(String path) {
        ArrayList<Path> files = new ArrayList<Path>();
        for (String f : path.split(File.pathSeparator)) {
            if (f.length() <= 0) continue;
            files.add(Path.of(f, new String[0]));
        }
        return files;
    }

    private static SearchPath filesToAbsolutePath(List<Path> files) {
        SearchPath p = new SearchPath();
        for (Path f : files) {
            p.append(Tool.getNormalizedFile(f.toFile()).toPath());
        }
        return p;
    }

    private RegressionParameters createParameters(TestManager testManager, RegressionTestSuite testSuite) throws BadArgs, Main.Fault {
        try {
            Path rd;
            RegressionParameters rp = new RegressionParameters("regtest", testSuite, this.out::println);
            WorkDirectory workDir = testManager.getWorkDirectory(testSuite);
            rp.setWorkDirectory(workDir);
            rp.setFile(workDir.getFile("config.jti"));
            rp.setRetainArgs(this.retainArgs);
            rp.setTests(testManager.getTests(testSuite));
            List<String> testQueries = testManager.getTestQueries(testSuite);
            if (!testQueries.isEmpty()) {
                rp.setTestQueries(testQueries);
            }
            if (this.userKeywordExpr != null || this.extraKeywordExpr != null) {
                String expr = this.userKeywordExpr == null ? this.extraKeywordExpr : (this.extraKeywordExpr == null ? this.userKeywordExpr : "(" + this.userKeywordExpr + ") & " + this.extraKeywordExpr);
                rp.setKeywordsExpr(expr);
            }
            rp.setExcludeLists(this.excludeListArgs.toArray(new Path[0]));
            rp.setMatchLists(this.matchListArgs.toArray(new Path[0]));
            if (this.priorStatusValuesArg == null || this.priorStatusValuesArg.length() == 0) {
                rp.setPriorStatusValues(null);
            } else {
                boolean[] b = new boolean[]{this.priorStatusValuesArg.contains("pass"), this.priorStatusValuesArg.contains("fail"), this.priorStatusValuesArg.contains("erro"), this.priorStatusValuesArg.contains("notr")};
                rp.setPriorStatusValues(b);
            }
            if (this.concurrencyArg != null) {
                try {
                    int c = this.concurrencyArg.equals("auto") ? Runtime.getRuntime().availableProcessors() : Integer.parseInt(this.concurrencyArg);
                    rp.setConcurrency(c);
                }
                catch (NumberFormatException e) {
                    throw new BadArgs(i18n, "main.badConcurrency", new Object[0]);
                }
            }
            if (this.timeoutFactorArg != null) {
                try {
                    rp.setTimeoutFactor(this.timeoutFactorArg.floatValue());
                }
                catch (NumberFormatException e) {
                    throw new BadArgs(i18n, "main.badTimeoutFactor", new Object[0]);
                }
            }
            if (this.timeoutHandlerClassName != null) {
                rp.setTimeoutHandler(this.timeoutHandlerClassName);
            }
            if (this.timeoutHandlerPathArg != null) {
                rp.setTimeoutHandlerPath(this.timeoutHandlerPathArg);
            }
            if (this.timeoutHandlerTimeoutArg != 0L) {
                rp.setTimeoutHandlerTimeout(this.timeoutHandlerTimeoutArg);
            }
            if (this.testThreadFactory != null) {
                rp.setTestThreadFactory(this.testThreadFactory);
            }
            if (this.testThreadFactoryPathArg != null) {
                rp.setTestThreadFactoryPath(this.testThreadFactoryPathArg);
            }
            if ((rd = testManager.getReportDirectory(testSuite)) != null) {
                rp.setReportDir(rd);
            }
            if (this.exclusiveLockArg != null) {
                rp.setExclusiveLock(this.exclusiveLockArg);
            }
            if (!rp.isValid()) {
                throw new Main.Fault(i18n, "main.badParams", rp.getErrorMessage());
            }
            if (this.testVMOpts.size() > 0) {
                rp.setTestVMOptions(this.testVMOpts);
            }
            if (this.testCompilerOpts.size() > 0) {
                rp.setTestCompilerOptions(this.testCompilerOpts);
            }
            if (this.testJavaOpts.size() > 0) {
                rp.setTestJavaOptions(this.testJavaOpts);
            }
            if (this.testDebugOpts.size() > 0) {
                rp.setTestDebugOptions(this.testDebugOpts);
            }
            rp.setCheck(this.checkFlag);
            rp.setExecMode(this.execMode);
            rp.setEnvVars(this.getEnvVars());
            rp.setCompileJDK(this.compileJDK != null ? this.compileJDK : this.testJDK);
            rp.setTestJDK(this.testJDK);
            if (this.ignoreKind != null) {
                rp.setIgnoreKind(this.ignoreKind);
            }
            if (this.junitPath != null) {
                rp.setJUnitPath(this.junitPath);
            }
            if (this.testngPath != null) {
                rp.setTestNGPath(this.testngPath);
            }
            if (this.asmtoolsPath != null) {
                rp.setAsmToolsPath(this.asmtoolsPath);
            }
            if (this.timeLimitArg != null) {
                try {
                    rp.setTimeLimit(Integer.parseInt(this.timeLimitArg));
                }
                catch (NumberFormatException e) {
                    throw new BadArgs(i18n, "main.badTimeLimit", new Object[0]);
                }
            }
            if (this.nativeDirArg != null) {
                rp.setNativeDir(this.nativeDirArg);
            }
            rp.setUseWindowsSubsystemForLinux(this.useWindowsSubsystemForLinux);
            rp.initExprContext();
            return rp;
        }
        catch (Interview.Fault f) {
            throw new Main.Fault(i18n, "main.cantOpenTestSuite", testSuite.getRootDir(), f);
        }
        catch (JDK.Fault f) {
            throw new Main.Fault(i18n, "main.cantGetJDKProperties", this.testJDK, f.getMessage());
        }
    }

    private static File canon(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return Tool.getNormalizedFile(file);
        }
    }

    private static Harness.Observer getObserver(List<Path> observerPath, String observerClassName) throws Main.Fault {
        try {
            Class<?> observerClass;
            if (observerPath == null) {
                observerClass = Class.forName(observerClassName);
            } else {
                URL[] urls = new URL[observerPath.size()];
                int u = 0;
                for (Path f : observerPath) {
                    try {
                        urls[u++] = f.toUri().toURL();
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                URLClassLoader loader = new URLClassLoader(urls);
                observerClass = loader.loadClass(observerClassName);
            }
            return observerClass.asSubclass(Harness.Observer.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            throw new Main.Fault(i18n, "main.obsvrType", Harness.Observer.class.getName(), observerClassName);
        }
        catch (ClassNotFoundException e) {
            throw new Main.Fault(i18n, "main.obsvrNotFound", observerClassName);
        }
        catch (ReflectiveOperationException e) {
            throw new Main.Fault(i18n, "main.obsvrFault", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestStats batchHarness(RegressionParameters params, boolean quiet) throws Main.Fault, Harness.Fault, InterruptedException {
        boolean reportRequired = this.reportMode != ReportMode.NONE && !Boolean.getBoolean("javatest.noReportRequired");
        try {
            boolean ok;
            TestStats stats = new TestStats();
            ElapsedTimeHandler elapsedTimeHandler = null;
            if (this.reportOnlyFlag) {
                Iterator<TestResult> iter = this.getResultsIterator(params);
                while (iter.hasNext()) {
                    TestResult tr = iter.next();
                    stats.add(tr);
                }
                ok = stats.isOK();
            } else if (this.showStream != null) {
                TestResult tr = null;
                Iterator<TestResult> iter = this.getResultsIterator(params);
                while (iter.hasNext()) {
                    if (tr != null) {
                        this.out.println("More than one test specified");
                        tr = null;
                        break;
                    }
                    tr = iter.next();
                }
                if (tr != null && tr.getFile() == null && params.getWorkDirectory().getFile(tr.getWorkRelativePath()).exists()) {
                    try {
                        tr = new TestResult(params.getWorkDirectory(), tr.getWorkRelativePath());
                    }
                    catch (TestResult.Fault f) {
                        this.out.println("Cannot reload results for test " + tr.getTestName());
                    }
                }
                if (tr == null) {
                    this.out.println("No test specified");
                    ok = false;
                } else if (tr.getStatus().isNotRun()) {
                    this.out.println("Test has not been run");
                    ok = false;
                } else {
                    try {
                        String stream;
                        String section;
                        tr.getProperty("sections");
                        int sep = this.showStream.indexOf("/");
                        if (sep == -1) {
                            section = null;
                            stream = this.showStream;
                        } else {
                            section = this.showStream.substring(0, sep);
                            stream = this.showStream.substring(sep + 1);
                        }
                        for (int i = 0; i < tr.getSectionCount(); ++i) {
                            String text;
                            TestResult.Section s = tr.getSection(i);
                            if (section != null && !section.equals(s.getTitle()) || (text = s.getOutput(stream)) == null) continue;
                            this.out.println("### Section " + s.getTitle());
                            this.out.println(text);
                        }
                        ok = true;
                    }
                    catch (TestResult.Fault f) {
                        this.out.println("Cannot reload test results: " + f.getMessage());
                        ok = false;
                    }
                }
                quiet = true;
            } else {
                BackupPolicy backupPolicy = this.createBackupPolicy();
                Harness h = new Harness();
                h.setBackupPolicy(backupPolicy);
                if (this.xmlFlag) {
                    this.out.println("XML output " + (this.xmlVerifyFlag ? "with verification to " : " to ") + params.getWorkDirectory().getPath());
                    h.addObserver(new XMLWriter.XMLHarnessObserver(this.xmlVerifyFlag, this.out, this.err));
                }
                if (this.observerClassName != null) {
                    h.addObserver(Tool.getObserver(this.observerPathArg, this.observerClassName));
                }
                if (verbose != null) {
                    new VerboseHandler(verbose, this.out, this.err).register(h);
                }
                stats.register(h);
                h.addObserver(new BasicObserver(){

                    @Override
                    public void error(String msg) {
                        Tool.this.error(msg);
                    }
                });
                if (reportRequired) {
                    elapsedTimeHandler = new ElapsedTimeHandler();
                    elapsedTimeHandler.register(h);
                }
                if (params.getTestJDK().hasModules()) {
                    this.initModuleHelper(params.getWorkDirectory());
                }
                File versionFile = params.getWorkDirectory().getSystemFile("jtreg.version");
                try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(versionFile)));){
                    this.help.showVersion(out);
                }
                catch (IOException e) {
                    this.err.println(i18n.getString("main.errorReportingVersion", (Object)e));
                }
                String[] tests = params.getTests();
                ok = tests != null && tests.length == 0 || h.batch(params);
                Agent.Pool.flush(params);
                try {
                    Agent.Logger.close(params);
                }
                catch (IOException e) {
                    this.err.println(i18n.getString("main.errorClosingAgentLog", (Object)e));
                }
                Lock.get(params).close();
            }
            if (!quiet) {
                stats.showResultStats(this.out);
            }
            if (reportRequired) {
                TestFilter tf;
                ParameterFilter pf;
                RegressionReporter r = new RegressionReporter(this.out);
                if (this.reportOnlyFlag) {
                    pf = new ParameterFilter();
                    pf.update(params);
                    tf = pf;
                } else {
                    switch (this.reportMode.ordinal()) {
                        default: {
                            throw new IllegalStateException();
                        }
                        case 1: {
                            pf = new ParameterFilter();
                            pf.update(params);
                            tf = pf;
                            break;
                        }
                        case 3: {
                            boolean[] statusValues = new boolean[]{true, true, true, false};
                            tf = new StatusFilter(statusValues, params.getWorkDirectory().getTestResultTable());
                            break;
                        }
                        case 4: {
                            tf = new AllTestsFilter();
                            break;
                        }
                        case 2: {
                            try {
                                RegressionParameters reportParams = new RegressionParameters("regtest", params.getTestSuite(), this.out::println);
                                reportParams.setWorkDirectory(params.getWorkDirectory());
                                reportParams.setTests(params.getTests());
                                ParameterFilter pf2 = new ParameterFilter();
                                pf2.update(reportParams);
                                tf = pf2;
                                break;
                            }
                            catch (Interview.Fault e) {
                                throw new Main.Fault(i18n, "main.cantCreateReportParameters", e);
                            }
                        }
                    }
                }
                r.report(params, elapsedTimeHandler, stats, tf, quiet);
            }
            if (!this.reportOnlyFlag && !quiet) {
                this.out.println("Results written to " + params.getWorkDirectory().getPath());
            }
            if (!ok && !quiet) {
                this.err.println(i18n.getString("main.testsFailed"));
            }
            TestStats testStats = stats;
            return testStats;
        }
        finally {
            this.out.flush();
            this.err.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initModuleHelper(WorkDirectory wd) {
        String[] classes;
        File patchDir = wd.getFile("patches");
        File javaBaseDir = new File(patchDir, "java.base");
        for (String c : classes = new String[]{"java/lang/JTRegModuleHelper.class"}) {
            File f = new File(javaBaseDir, c);
            if (f.exists()) continue;
            InputStream from = null;
            OutputStream to = null;
            try {
                int n;
                from = this.getClass().getClassLoader().getResourceAsStream(c);
                if (from == null) {
                    this.out.println("Cannot find class " + c + " to init patch directory");
                    continue;
                }
                f.getParentFile().mkdirs();
                to = new FileOutputStream(f);
                byte[] buf = new byte[8192];
                while ((n = from.read(buf, 0, buf.length)) != -1) {
                    to.write(buf, 0, n);
                }
            }
            catch (IOException t) {
                this.out.println("Cannot init module patch directory: " + String.valueOf(t));
            }
            finally {
                try {
                    if (from != null) {
                        from.close();
                    }
                    if (to != null) {
                        to.close();
                    }
                }
                catch (IOException e) {
                    this.out.println("Cannot init module patch directory: " + String.valueOf(e));
                }
            }
        }
    }

    private Iterator<TestResult> getResultsIterator(InterviewParameters params) {
        TestResultTable trt = params.getWorkDirectory().getTestResultTable();
        trt.waitUntilReady();
        String[] tests = params.getTests();
        TestFilter[] filters = params.getFilters();
        if (tests == null) {
            return trt.getIterator(filters);
        }
        if (tests.length == 0) {
            return Collections.emptyIterator();
        }
        return trt.getIterator(tests, filters);
    }

    private void showTool(final InterviewParameters params) throws BadArgs {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Frame startup = this.showStartup();
                Timer t = new Timer(1000, e -> {
                    this.showGUI();
                    startup.dispose();
                });
                t.setRepeats(false);
                t.start();
            }

            Frame showStartup() {
                Version v = Version.getCurrent();
                String title = String.format("%s %s %s %s", v.product, v.version, v.milestone, v.build);
                URL logo = this.getClass().getResource("jtlogo.png");
                String copyright = i18n.getString("help.copyright.txt").replace("\n", " ");
                return new Startup(title, logo, "", title, copyright).show();
            }

            void showGUI() {
                Desktop d = new Desktop();
                ExecToolManager m = (ExecToolManager)d.getToolManager(ExecToolManager.class);
                if (m == null) {
                    throw new AssertionError((Object)"Cannot find ExecToolManager");
                }
                m.startTool(params);
                d.setVisible(true);
            }
        });
    }

    private BackupPolicy createBackupPolicy() {
        return new BackupPolicy(){
            private final int numBackupsToKeep = Integer.getInteger("javatest.backup.count", 5);
            private final String[] ignoreExtns = StringArray.split(System.getProperty("javatest.backup.ignore", ".jtr"));

            @Override
            public int getNumBackupsToKeep(File file) {
                return this.numBackupsToKeep;
            }

            @Override
            public boolean isBackupRequired(File file) {
                if (this.ignoreExtns != null) {
                    for (String ignoreExtn : this.ignoreExtns) {
                        if (!file.getPath().endsWith(ignoreExtn)) continue;
                        return false;
                    }
                }
                return true;
            }
        };
    }

    private void startHttpServer() {
        HttpdServer server = new HttpdServer();
        Thread thr = new Thread(server);
        PageGenerator.setSWName(ProductInfo.getName());
        DateFormat df = DateFormat.getDateInstance(1);
        Date dt = ProductInfo.getBuildDate();
        String date = dt != null ? df.format(dt) : i18n.getString("main.noDate");
        PageGenerator.setSWBuildDate(date);
        PageGenerator.setSWVersion(ProductInfo.getVersion());
        thr.start();
    }

    private Map<String, String> getEnvVars() {
        TreeMap<String, String> envVars = new TreeMap<String, String>();
        OS os = OS.current();
        if (os.family.equals("windows")) {
            this.addEnvVars(envVars, DEFAULT_WINDOWS_ENV_VARS);
            this.addEnvVars(envVars, "PATH");
        } else {
            this.addEnvVars(envVars, DEFAULT_UNIX_ENV_VARS);
            this.addEnvVarsByName(envVars, name -> name.startsWith("XDG_"));
            this.addEnvVars(envVars, "PATH=/bin:/usr/bin:/usr/sbin");
        }
        this.addEnvVars(envVars, this.envVarArgs);
        this.addEnvVarsByName(envVars, name -> name.startsWith("JTREG_"));
        return envVars;
    }

    private void addEnvVars(Map<String, String> table, String list) {
        this.addEnvVars(table, list.split(","));
    }

    private void addEnvVars(Map<String, String> table, String[] list) {
        this.addEnvVars(table, List.of(list));
    }

    private void addEnvVars(Map<String, String> table, List<String> list) {
        if (list == null) {
            return;
        }
        for (String s : list) {
            if ((s = s.trim()).length() == 0) continue;
            int eq = s.indexOf("=");
            if (eq == -1) {
                String value = Tool.getEnvironmentVariableOrNull(s);
                if (value == null) continue;
                table.put(s, value);
                continue;
            }
            if (eq <= 0) continue;
            String name = s.substring(0, eq);
            String value = s.substring(eq + 1);
            table.put(name, value);
        }
    }

    private void addEnvVarsByName(Map<String, String> table, Predicate<String> nameFilter) {
        System.getenv().entrySet().stream().filter(e -> nameFilter.test((String)e.getKey())).forEach(e -> table.put((String)e.getKey(), (String)e.getValue()));
    }

    private static String getEnvironmentVariableOrNull(String name) {
        return System.getenv(name);
    }

    private static String combineKeywords(String kw1, String kw2) {
        return kw1 == null ? kw2 : kw1 + " & " + kw2;
    }

    private boolean isWindows() {
        return OS.current().family.equals("windows");
    }

    private boolean isCygwinDetected() {
        if (this.isWindows()) {
            String PATH = System.getenv("PATH");
            return PATH != null && PATH.matches("(?i).*;[a-z]:[^;]*\\\\cygwin.*");
        }
        return false;
    }

    private boolean isWindowsSubsystemForLinuxDetected() {
        String PATH;
        if (this.isWindows() && (PATH = System.getenv("PATH")) != null) {
            for (Path f : new SearchPath(PATH).asList()) {
                if (!Files.exists(f.resolve("wsl.exe"), new LinkOption[0])) continue;
                return true;
            }
        }
        return false;
    }

    private void error(String msg) {
        this.err.println(i18n.getString("main.error", (Object)msg));
        ++this.errors;
    }

    private void checkLockFiles(File workDir, String msg) {
    }

    private static File getNormalizedFile(File f) {
        return new File(f.getAbsoluteFile().toURI().normalize());
    }

    static {
        DEFAULT_UNIX_ENV_VARS = new String[]{"DBUS_SESSION_BUS_ADDRESS", "DESKTOP_SESSION", "DISPLAY", "GDMSESSION", "GNOME_DESKTOP_SESSION_ID", "GNOME_SHELL_SESSION_MODE", "HOME", "LANG", "LC_ALL", "LC_CTYPE", "LPDEST", "PRINTER", "TZ", "WAYLAND_DISPLAY", "XMODIFIERS"};
        DEFAULT_WINDOWS_ENV_VARS = new String[]{"SystemDrive", "SystemRoot", "TMP", "TEMP", "TZ", "windir"};
        i18n = I18NResourceBundle.getBundleForClass(Tool.class);
    }

    public static enum ReportMode {
        NONE,
        EXECUTED,
        FILES,
        ALL_EXECUTED,
        ALL;

    }
}

