/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.tool;

import com.sun.javatest.exec.ContextManager;
import com.sun.javatest.exec.JavaTestMenuManager;
import com.sun.javatest.regtest.tool.Version;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class RegressionContextManager
extends ContextManager {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(RegressionContextManager.class);

    @Override
    public JavaTestMenuManager getMenuManager() {
        return new RegressionMenuManager();
    }

    static class RegressionMenuManager
    extends JavaTestMenuManager {
        RegressionMenuManager() {
        }

        @Override
        public JMenuItem[] getMenuItems(int position) {
            switch (position) {
                case 15: {
                    return this.createHelpAboutItems();
                }
            }
            return super.getMenuItems(position);
        }

        JMenuItem[] createHelpAboutItems() {
            JMenuItem mi = new JMenuItem("About jtreg");
            mi.addActionListener(e -> this.showAbout((JComponent)e.getSource()));
            return new JMenuItem[]{mi};
        }

        void showAbout(JComponent parent) {
            Version v = Version.getCurrent();
            String title = String.format("%s %s %s %s", v.product, v.version, v.milestone, v.build);
            String copyright = i18n.getString("help.copyright.txt");
            ArrayList<String> content = new ArrayList<String>();
            content.add(title);
            content.addAll(List.of(copyright.split("\n")));
            URL logoURL = this.getClass().getResource("jtlogo.png");
            Image logoImage = Toolkit.getDefaultToolkit().getImage(logoURL);
            ImageIcon logo = new ImageIcon(logoImage);
            JOptionPane.showMessageDialog(parent, content.toArray(), "Regression Test Harness for the OpenJDK platform: jtreg", 1, logo);
        }
    }
}

