/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.report;

import com.sun.javatest.Harness;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.regtest.report.BasicObserver;
import com.sun.javatest.regtest.report.Verbose;
import java.io.PrintWriter;

public class VerboseHandler {
    private static final String VERBOSE_TEST_SEP = "--------------------------------------------------";
    private static final String LINESEP = System.getProperty("line.separator");
    private final Verbose verbose;
    private final PrintWriter out;
    private final PrintWriter err;
    private boolean doneSeparator;

    public VerboseHandler(Verbose verbose, PrintWriter out, PrintWriter err) {
        this.verbose = verbose;
        this.out = out;
        this.err = err;
    }

    public void register(Harness h) {
        h.addObserver(new BasicObserver(){

            @Override
            public synchronized void startingTest(TestResult tr) {
                VerboseHandler.this.startingTest(tr);
            }

            @Override
            public synchronized void finishedTest(TestResult tr) {
                VerboseHandler.this.finishedTest(tr);
            }
        });
    }

    private void startingTest(TestResult tr) {
        if (this.verbose.isDefault()) {
            try {
                TestDescription td = tr.getDescription();
                this.out.println("runner starting test: " + td.getRootRelativeURL());
            }
            catch (TestResult.Fault e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private void finishedTest(TestResult tr) {
        Verbose.Mode m;
        switch (tr.getStatus().getType()) {
            case 0: {
                m = this.verbose.passMode;
                break;
            }
            case 1: {
                m = this.verbose.failMode;
                break;
            }
            case 2: {
                m = this.verbose.errorMode;
                break;
            }
            default: {
                m = Verbose.Mode.NONE;
            }
        }
        switch (m) {
            case NONE: {
                break;
            }
            case DEFAULT: {
                try {
                    TestDescription td = tr.getDescription();
                    if (this.verbose.time) {
                        this.printElapsedTimes(tr);
                    }
                    this.out.println("runner finished test: " + td.getRootRelativeURL());
                    this.out.println(tr.getStatus());
                }
                catch (TestResult.Fault e) {
                    e.printStackTrace(System.err);
                }
                break;
            }
            case SUMMARY: {
                this.printSummary(tr, this.verbose.time);
                break;
            }
            case BRIEF: {
                this.printBriefOutput(tr, this.verbose.time);
                break;
            }
            case FULL: {
                this.printFullOutput(tr);
            }
        }
    }

    private void printSummary(TestResult tr, boolean times) {
        try {
            TestDescription td = tr.getDescription();
            Object msg = tr.getStatus().isPassed() ? "Passed: " : (tr.getStatus().isFailed() ? "FAILED: " : (tr.getStatus().isError() ? "Error:  " : "Unexpected status: "));
            msg = (String)msg + td.getRootRelativeURL();
            this.out.println((String)msg);
            if (times) {
                this.printElapsedTimes(tr);
            }
        }
        catch (TestResult.Fault e) {
            e.printStackTrace(System.err);
        }
    }

    private void printBriefOutput(TestResult tr, boolean times) {
        if (!this.doneSeparator) {
            this.out.println(VERBOSE_TEST_SEP);
            this.doneSeparator = true;
        }
        try {
            TestDescription td = tr.getDescription();
            this.out.println("TEST: " + td.getRootRelativeURL());
            if (times) {
                this.printElapsedTimes(tr);
            }
            this.out.println("TEST RESULT: " + String.valueOf(tr.getStatus()));
        }
        catch (TestResult.Fault e) {
            e.printStackTrace(System.err);
        }
        this.out.println(VERBOSE_TEST_SEP);
    }

    private void printFullOutput(TestResult tr) {
        if (!this.doneSeparator) {
            this.out.println(VERBOSE_TEST_SEP);
            this.doneSeparator = true;
        }
        try {
            TestDescription td = tr.getDescription();
            this.out.println("TEST: " + td.getRootRelativeURL());
            String testJDK = this.getTestJDK(tr);
            if (testJDK != null) {
                this.out.println("TEST JDK: " + testJDK);
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 1; i < tr.getSectionCount(); ++i) {
                String[] outputNames;
                TestResult.Section section = tr.getSection(i);
                sb.append(LINESEP);
                sb.append("ACTION: ").append(section.getTitle());
                sb.append(" -- ").append(section.getStatus()).append(LINESEP);
                sb.append("REASON: ").append(this.getReason(section)).append(LINESEP);
                sb.append("TIME:   ").append(this.getElapsedTime(section));
                sb.append(" seconds").append(LINESEP);
                block11: for (String name : outputNames = section.getOutputNames()) {
                    String output = section.getOutput(name);
                    switch (name) {
                        case "System.out": {
                            sb.append("STDOUT:").append(LINESEP).append(output);
                            continue block11;
                        }
                        case "System.err": {
                            sb.append("STDERR:").append(LINESEP).append(output);
                            continue block11;
                        }
                        default: {
                            sb.append(name).append(":").append(LINESEP).append(output);
                        }
                    }
                }
            }
            this.out.println(sb.toString());
            this.out.println("TEST RESULT: " + String.valueOf(tr.getStatus()));
            this.out.println(VERBOSE_TEST_SEP);
        }
        catch (TestResult.Fault e) {
            e.printStackTrace(System.err);
        }
    }

    private void printElapsedTimes(TestResult tr) {
        StringBuilder sb = new StringBuilder();
        try {
            for (int i = 1; i < tr.getSectionCount(); ++i) {
                TestResult.Section section = tr.getSection(i);
                sb.append("  ").append(section.getTitle()).append(": ");
                sb.append(this.getElapsedTime(section)).append(" seconds").append(LINESEP);
            }
            this.out.print(sb.toString());
        }
        catch (TestResult.ReloadFault f) {
            f.printStackTrace(System.err);
        }
    }

    private String getReason(TestResult.Section section) {
        String msg = section.getOutput("messages");
        int posStart = msg.indexOf("reason: ") + "reason: ".length();
        int posEnd = msg.indexOf(LINESEP, posStart);
        return msg.substring(posStart, posEnd);
    }

    private String getElapsedTime(TestResult.Section section) {
        String msg = section.getOutput("messages");
        int posStart = msg.indexOf("elapsed time (seconds): ") + "elapsed time (seconds): ".length();
        int posEnd = msg.indexOf(LINESEP, posStart);
        return msg.substring(posStart, posEnd);
    }

    private String getTestJDK(TestResult tr) {
        try {
            return tr.getProperty("testJDK");
        }
        catch (TestResult.Fault f) {
            f.printStackTrace(System.err);
            return null;
        }
    }
}

