/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.agent.JDK_Version;
import com.sun.javatest.regtest.agent.TestNGRunner;
import com.sun.javatest.regtest.config.Locations;
import com.sun.javatest.regtest.config.ParseException;
import com.sun.javatest.regtest.exec.BuildAction;
import com.sun.javatest.regtest.exec.MainAction;
import com.sun.javatest.regtest.exec.RegressionScript;
import com.sun.javatest.regtest.exec.TestRunException;
import com.sun.javatest.regtest.util.FileUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TestNGAction
extends MainAction {
    public static final String NAME = "testng";
    boolean userSpecified = false;
    private static final Path TESTNG_RESULTS_XML = Path.of("testng-results.xml", new String[0]);

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void init(Map<String, String> opts, List<String> args, String reason, RegressionScript script) throws ParseException {
        this.userSpecified = reason.startsWith("User specified action: run ");
        boolean importsJUnit = script.getTestDescription().getParameter("importsJUnit") != null;
        this.init(opts, args, reason, script, TestNGRunner.class, script.getTestResult().getTestName(), Boolean.toString(importsJUnit));
        if (importsJUnit) {
            this.othervmOverrideReasons.add("test uses TestNG/JUnit mixed mode");
        }
    }

    @Override
    protected Status build() throws TestRunException {
        if (this.userSpecified) {
            return super.build();
        }
        JDK_Version v = this.script.getCompileJDKVersion();
        HashMap<String, String> buildOpts = new HashMap<String, String>();
        if (v.compareTo(JDK_Version.V1_6) >= 0) {
            buildOpts.put("implicit", "none");
        }
        Locations locations = this.script.locations;
        LinkedHashSet<String> buildArgs = new LinkedHashSet<String>(this.script.getLibBuildArgs());
        if (buildArgs.isEmpty()) {
            buildArgs.addAll(this.listModules(locations.absLibSrcList(Locations.LibLocn.Kind.SYS_MODULE)));
            buildArgs.addAll(this.listModules(locations.absLibSrcList(Locations.LibLocn.Kind.USER_MODULE)));
            buildArgs.addAll(this.listClasses(locations.absLibSrcList(Locations.LibLocn.Kind.PACKAGE)));
        }
        try {
            Path testSrcDir = locations.absTestSrcDir();
            switch (locations.getDirKind(testSrcDir)) {
                case PACKAGE: {
                    buildArgs.addAll(this.listClasses(List.of(testSrcDir)));
                    break;
                }
                case SYS_MODULE: 
                case USER_MODULE: {
                    buildArgs.addAll(this.listModules(List.of(testSrcDir)));
                }
            }
        }
        catch (Locations.Fault e) {
            return Status.error(e.getMessage());
        }
        BuildAction ba = new BuildAction();
        return ba.build(buildOpts, new ArrayList<String>(buildArgs), "Named class compiled on demand", this.script);
    }

    private List<String> listClasses(List<Path> roots) {
        ArrayList<String> classes = new ArrayList<String>();
        for (Path root : roots) {
            this.listClasses(root, null, classes);
        }
        return classes;
    }

    private void listClasses(Path dir, String pkg, List<String> classes) {
        for (Path f : FileUtils.listFiles(dir)) {
            String f_name = f.getFileName().toString();
            if (Files.isDirectory(f, new LinkOption[0])) {
                this.listClasses(f, (String)(pkg == null ? f_name : pkg + "." + f_name), classes);
                continue;
            }
            if (!f_name.endsWith(".java")) continue;
            String c_name = f_name.substring(0, f_name.length() - 5);
            classes.add((String)(pkg == null ? c_name : pkg + "." + c_name));
        }
    }

    private Set<String> listModules(List<Path> roots) {
        LinkedHashSet<String> modules = new LinkedHashSet<String>();
        for (Path root : roots) {
            for (Path f : FileUtils.listFiles(root)) {
                if (!Files.isDirectory(f, new LinkOption[0])) continue;
                modules.add(String.valueOf(f.getFileName()) + "/*");
            }
        }
        return modules;
    }

    @Override
    public void endAction(Status s) {
        super.endAction(s);
        if (this.script.isCheck()) {
            return;
        }
        this.script.getTestNGSummaryReporter().add(this.script.getTestResult(), this.section);
        String jtrPath = this.script.getTestResult().getWorkRelativePath();
        String tngPath = jtrPath.replaceAll("\\.jtr$", ".testng-results.xml");
        this.script.saveScratchFile(TESTNG_RESULTS_XML, Path.of(tngPath, new String[0]));
    }
}

