/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Script;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.regtest.agent.JDK_Version;
import com.sun.javatest.regtest.agent.MainWrapper;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.ExecMode;
import com.sun.javatest.regtest.config.Expr;
import com.sun.javatest.regtest.config.IgnoreKind;
import com.sun.javatest.regtest.config.JDK;
import com.sun.javatest.regtest.config.JDKOpts;
import com.sun.javatest.regtest.config.Locations;
import com.sun.javatest.regtest.config.Modules;
import com.sun.javatest.regtest.config.ParseException;
import com.sun.javatest.regtest.config.RegressionEnvironment;
import com.sun.javatest.regtest.config.RegressionParameters;
import com.sun.javatest.regtest.config.RegressionTestSuite;
import com.sun.javatest.regtest.exec.Action;
import com.sun.javatest.regtest.exec.Agent;
import com.sun.javatest.regtest.exec.AppletAction;
import com.sun.javatest.regtest.exec.BuildAction;
import com.sun.javatest.regtest.exec.CleanAction;
import com.sun.javatest.regtest.exec.CompileAction;
import com.sun.javatest.regtest.exec.DriverAction;
import com.sun.javatest.regtest.exec.IgnoreAction;
import com.sun.javatest.regtest.exec.JUnitAction;
import com.sun.javatest.regtest.exec.Lock;
import com.sun.javatest.regtest.exec.MainAction;
import com.sun.javatest.regtest.exec.ScratchDirectory;
import com.sun.javatest.regtest.exec.ShellAction;
import com.sun.javatest.regtest.exec.TestNGAction;
import com.sun.javatest.regtest.exec.TestRunException;
import com.sun.javatest.regtest.exec.TimeoutHandlerProvider;
import com.sun.javatest.regtest.report.SummaryReporter;
import com.sun.javatest.regtest.tool.Version;
import com.sun.javatest.regtest.util.FileUtils;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.File;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;

public class RegressionScript
extends Script {
    private static final Pattern namePattern = Pattern.compile("\\$\\{([A-Za-z0-9._]+)}");
    private static float cacheJavaTestTimeoutFactor = -1.0f;
    private int nextSerial = 0;
    List<Agent> agents = new ArrayList<Agent>();
    private static String version;
    private static final String LINESEP;
    private static final String CANT_INSTANTIATE = "Unable to instantiate: ";
    private static final String NOT_EXT_ACTION = " does not extend Action";
    private static final String ILLEGAL_ACCESS_INIT = "Illegal access to init method: ";
    private static final String BAD_ACTION = "Bad action for script: ";
    private final Map<String, Class<?>> actionTable = new HashMap();
    private TestResult testResult;
    private RegressionEnvironment regEnv;
    private RegressionParameters params;
    private RegressionTestSuite testSuite;
    private PrintWriter msgPW;
    Set<String> defaultModules;
    Set<String> systemModules;
    private boolean useBootClassPath;
    private boolean usePatchModules;
    private boolean useModulePath;
    private ExecMode defaultExecMode;
    private boolean needJUnit;
    private boolean needTestNG;
    private Modules modules;
    private ScratchDirectory scratchDirectory;
    Locations locations;

    /*
     * Exception decompiling
     */
    @Override
    public Status run(String[] argv, TestDescription td, TestEnvironment env) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void printJDKInfo(PrintWriter pw, String label, JDK jdk, List<String> opts) {
        pw.print(label);
        pw.print(": ");
        pw.println(jdk.getAbsoluteHomeDirectory());
        String v = jdk.getVersionText(opts, pw::println);
        if (v.length() > 0) {
            pw.println(v);
        }
    }

    public static Set<File> getSourceFiles(RegressionParameters p, TestDescription td) {
        Consumer<String> logger = System.err::println;
        try {
            RegressionScript tmp = new RegressionScript();
            tmp.params = p;
            tmp.td = td;
            tmp.locations = new Locations(p, td, logger);
            tmp.modules = new Modules(p, td);
            tmp.defaultModules = p.getTestJDK().getDefaultModules(p, logger);
            tmp.systemModules = p.getTestJDK().getSystemModules(p, logger);
            String actions = td.getParameter("run");
            LinkedList<Action> actionList = tmp.parseActions(actions, false);
            TreeSet<File> files = new TreeSet<File>();
            while (!actionList.isEmpty()) {
                Action action = actionList.remove();
                Set<File> a = action.getSourceFiles();
                if (a == null) continue;
                files.addAll(a);
            }
            return files;
        }
        catch (TestSuite.Fault | Expr.Fault | Locations.Fault | Modules.Fault | ParseException e) {
            return Collections.emptySet();
        }
        catch (ParseActionsException shouldNotHappen) {
            throw new Error(shouldNotHappen);
        }
    }

    LinkedList<Action> parseActions(String actions, boolean stopOnError) throws ParseActionsException, ParseException, TestSuite.Fault, Expr.Fault {
        LinkedList<Action> actionList = new LinkedList<Action>();
        String[] runCmds = StringUtils.splitTerminator(LINESEP, actions);
        this.populateActionTable();
        Expr.Context exprContext = this.params.getExprContext();
        Map<String, String> testProps = this.getTestProperties();
        for (String runCmd : runCmds) {
            String[] tokens = StringUtils.splitWS(runCmd);
            String[] verbopts = StringUtils.splitSeparator("/", tokens[1]);
            String verb = verbopts[0];
            LinkedHashMap<String, String> opts = new LinkedHashMap<String, String>();
            for (int i = 1; i < verbopts.length; ++i) {
                String[] keyValue = StringUtils.splitEqual(verbopts[i]);
                opts.put(keyValue[0], keyValue[1]);
            }
            ArrayList<String> args = new ArrayList<String>(Arrays.asList(tokens).subList(2, tokens.length));
            Class<?> c = null;
            try {
                c = this.actionTable.get(verb);
                if (c == null) {
                    if (!stopOnError) continue;
                    throw new ParseActionsException(BAD_ACTION + verb);
                }
                Action action = (Action)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                action.init(opts, this.processArgs(args, exprContext, testProps), this.getReason(tokens), this);
                actionList.add(action);
            }
            catch (IllegalAccessException e) {
                if (!stopOnError) continue;
                throw new ParseActionsException(ILLEGAL_ACCESS_INIT + String.valueOf(c));
            }
            catch (ReflectiveOperationException e) {
                if (!stopOnError) continue;
                throw new ParseActionsException(CANT_INSTANTIATE + String.valueOf(c) + NOT_EXT_ACTION);
            }
        }
        return actionList;
    }

    boolean enablePreview() {
        String ep = this.td.getParameter("enablePreview");
        return ep != null && ep.equals("true");
    }

    private List<String> processArgs(List<String> args, Expr.Context c, Map<String, String> testProps) throws TestSuite.Fault, Expr.Fault, ParseException {
        if (!this.testSuite.getAllowSmartActionArgs(this.td)) {
            return args;
        }
        boolean fast = true;
        for (String arg : args) {
            fast = fast && !arg.contains("${");
        }
        if (fast) {
            return args;
        }
        ArrayList<String> newArgs = new ArrayList<String>();
        for (String arg : args) {
            newArgs.add(RegressionScript.evalNames(arg, c, testProps));
        }
        return newArgs;
    }

    private static String evalNames(String arg, Expr.Context c, Map<String, String> testProps) throws Expr.Fault, ParseException {
        Matcher m = namePattern.matcher(arg);
        StringBuilder sb = null;
        int pos = 0;
        while (m.find(pos)) {
            String name;
            String value;
            if (sb == null) {
                sb = new StringBuilder();
            }
            String string = value = testProps.containsKey(name = m.group(1)) ? testProps.get(name) : c.get(name);
            if ("null".equals(value)) {
                throw new ParseException("unset property " + name);
            }
            sb.append(arg, pos, m.start());
            sb.append(value);
            pos = m.end();
        }
        if (sb == null) {
            return arg;
        }
        sb.append(arg.substring(pos));
        return sb.toString();
    }

    @Override
    protected int getTestTimeout() {
        return 0;
    }

    protected int getActionTimeout(int time) {
        int DEFAULT_ACTION_TIMEOUT = 120;
        return this.isTimeoutsEnabled() ? (int)((float)(time < 0 ? 120 : time) * this.getTimeoutFactor()) : 0;
    }

    protected float getTimeoutFactor() {
        if (cacheJavaTestTimeoutFactor == -1.0f) {
            float value = 1.0f;
            try {
                String f;
                String string = f = this.regEnv == null ? null : this.regEnv.lookup("javatestTimeoutFactor")[1];
                if (f != null) {
                    value = Float.parseFloat(f);
                }
            }
            catch (TestEnvironment.Fault | NumberFormatException exception) {
                // empty catch block
            }
            cacheJavaTestTimeoutFactor = value;
        }
        return cacheJavaTestTimeoutFactor;
    }

    protected boolean isTimeoutsEnabled() {
        return this.getTestDebugOptions().isEmpty();
    }

    @Override
    protected void setAlarm(int timeout) {
        super.setAlarm(timeout);
    }

    private void populateActionTable() {
        this.addAction("applet", AppletAction.class);
        this.addAction("build", BuildAction.class);
        this.addAction("clean", CleanAction.class);
        this.addAction("compile", CompileAction.class);
        this.addAction("driver", DriverAction.class);
        this.addAction("ignore", IgnoreAction.class);
        this.addAction("junit", JUnitAction.class);
        this.addAction("main", MainAction.class);
        this.addAction("shell", ShellAction.class);
        this.addAction("testng", TestNGAction.class);
    }

    private void addAction(String actionName, Class<? extends Action> actionClass) {
        this.actionTable.put(actionName, actionClass);
    }

    private String getReason(String[] cmd) {
        Object retVal;
        String reason;
        StringBuilder sb = new StringBuilder();
        switch (reason = cmd[0]) {
            case "ASSUMED_ACTION": {
                for (int i = 1; i < cmd.length; ++i) {
                    sb.append(cmd[i]).append(" ");
                }
                retVal = "Assumed action based on file name: run " + String.valueOf(sb);
                break;
            }
            case "USER_SPECIFIED": {
                for (int i = 1; i < cmd.length; ++i) {
                    sb.append(cmd[i]).append(" ");
                }
                retVal = "User specified action: run " + String.valueOf(sb);
                break;
            }
            default: {
                retVal = "Unknown";
            }
        }
        return retVal;
    }

    Map<String, String> getEnvVars() {
        return this.params.getEnvVars();
    }

    boolean isCheck() {
        return this.params.isCheck();
    }

    List<String> getTestVMOptions() {
        return this.params.getTestVMOptions();
    }

    List<String> getTestToolVMOptions() {
        return this.params.getTestToolVMOptions();
    }

    List<String> getTestVMJavaOptions() {
        return this.params.getTestVMJavaOptions();
    }

    List<String> getTestDebugOptions() {
        return this.params.getTestDebugOptions();
    }

    List<String> getTestCompilerOptions() {
        return this.params.getTestCompilerOptions();
    }

    List<String> getTestJavaOptions() {
        return this.params.getTestJavaOptions();
    }

    IgnoreKind getIgnoreKind() {
        return this.params.getIgnoreKind();
    }

    Path getNativeDir() {
        return this.params.getNativeDir();
    }

    Version getRequiredVersion() {
        return this.params.getTestSuite().getRequiredVersion();
    }

    Modules getModules() {
        return this.modules;
    }

    Set<String> getLibBuildArgs() throws TestRunException {
        try {
            return this.testSuite.getLibBuildArgs(this.td);
        }
        catch (TestSuite.Fault e) {
            throw new TestRunException(e.getMessage(), e);
        }
    }

    Pattern getIgnoreRefLinesPattern() throws TestRunException {
        try {
            return this.params.getRefIgnoreLinesPattern();
        }
        catch (PatternSyntaxException e) {
            throw new TestRunException(e.getMessage(), e);
        }
    }

    String getTestQuery() {
        String testName = this.testResult.getTestName();
        return this.params.getTestQuery(testName);
    }

    Path absTestWorkFile(String name) {
        return this.locations.absTestWorkFile(name);
    }

    Path absTestSrcDir() {
        return this.locations.absTestSrcDir();
    }

    Path absTestClsDir() {
        return this.locations.absTestClsDir();
    }

    Path absTestScratchDir() {
        return this.scratchDirectory.dir.toPath().toAbsolutePath();
    }

    Path absTestClsTopDir() {
        return this.locations.absBaseClsDir();
    }

    private boolean useBootClassPath(Path classdir) throws TestClassException {
        try {
            String rel = this.locations.absBaseClsDir().toUri().relativize(classdir.toFile().toURI()).getPath();
            return this.testSuite.useBootClassPath(rel);
        }
        catch (TestSuite.Fault f) {
            throw new TestClassException(f.toString());
        }
    }

    Map<PathKind, SearchPath> getCompilePaths(Locations.LibLocn libLocn, boolean multiModule, String module) throws TestRunException {
        SearchPath bcp = new SearchPath();
        SearchPath cp = new SearchPath();
        SearchPath mp = new SearchPath();
        SearchPath msp = new SearchPath();
        SearchPath pp = new SearchPath();
        SearchPath sp = new SearchPath();
        if (libLocn == null || libLocn.name == null) {
            if (multiModule) {
                msp.append(this.locations.absTestSrcDir());
            } else {
                Path testSrcDir = this.locations.absTestSrcDir(module);
                sp.append(testSrcDir);
                cp.append(testSrcDir);
            }
        }
        if (!multiModule) {
            cp.append(this.locations.absTestClsDir());
        }
        if (this.useModulePath()) {
            mp.append(this.locations.absTestModulesDir());
        }
        if (this.usePatchModules()) {
            pp.append(this.locations.absTestPatchDir());
        }
        if (libLocn != null) {
            if (multiModule) {
                msp.append(libLocn.absSrcDir);
            } else if (module != null) {
                sp.append(libLocn.absSrcDir.resolve(module));
            }
        }
        if (module == null) {
            sp.append(this.locations.absLibSrcList(Locations.LibLocn.Kind.PACKAGE));
        }
        cp.append(this.locations.absLibClsList(Locations.LibLocn.Kind.PACKAGE));
        cp.append(this.locations.absLibSrcJarList());
        if (this.useModulePath()) {
            mp.append(this.locations.absLibClsList(Locations.LibLocn.Kind.USER_MODULE));
        }
        if (this.usePatchModules()) {
            pp.append(this.locations.absLibClsList(Locations.LibLocn.Kind.SYS_MODULE));
        }
        if (multiModule) {
            if (this.needJUnit || this.needTestNG) {
                if (this.needJUnit) {
                    this.params.getJUnitPath().asList().forEach(xva$0 -> mp.append((Path)xva$0));
                }
                if (this.needTestNG) {
                    this.params.getTestNGPath().asList().forEach(xva$0 -> mp.append((Path)xva$0));
                }
            }
        } else {
            if (this.needJUnit) {
                cp.append(this.params.getJUnitPath());
            }
            if (this.needTestNG) {
                cp.append(this.params.getTestNGPath());
            }
        }
        JDK jdk = this.getCompileJDK();
        cp.append(jdk.getJDKClassPath());
        Map<String, String> envVars = this.getEnvVars();
        String cpa = envVars.get("CPAPPEND");
        if (cpa != null) {
            cpa = cpa.replace('/', File.separatorChar);
            cp.append(cpa);
        }
        EnumMap<PathKind, SearchPath> map = new EnumMap<PathKind, SearchPath>(PathKind.class);
        if (!bcp.isEmpty()) {
            map.put(PathKind.BOOTCLASSPATH_APPEND, bcp);
        }
        if (!cp.isEmpty()) {
            map.put(PathKind.CLASSPATH, cp);
        }
        if (!mp.isEmpty()) {
            map.put(PathKind.MODULEPATH, mp);
        }
        if (!msp.isEmpty()) {
            map.put(PathKind.MODULESOURCEPATH, msp);
        }
        if (!pp.isEmpty()) {
            map.put(PathKind.PATCHPATH, pp);
        }
        if (!sp.isEmpty()) {
            map.put(PathKind.SOURCEPATH, sp);
        }
        return map;
    }

    Map<PathKind, SearchPath> getExecutionPaths(boolean multiModule, String module, boolean testOnBootClassPath, boolean include_jtreg) throws TestRunException {
        SearchPath bcp = new SearchPath();
        SearchPath cp = new SearchPath();
        SearchPath mp = new SearchPath();
        SearchPath pp = new SearchPath();
        SearchPath tp = testOnBootClassPath ? bcp : cp;
        tp.append(this.locations.absTestClsDir());
        tp.append(this.locations.absTestSrcDir());
        if (this.hasTestPatchMods()) {
            pp.append(this.locations.absTestPatchDir());
        }
        if (this.hasTestUserMods()) {
            mp.append(this.locations.absTestModulesDir());
        }
        if (testOnBootClassPath) {
            bcp.append(this.locations.absLibClsList(Locations.LibLocn.Kind.PACKAGE));
            bcp.append(this.locations.absLibSrcJarList());
        } else {
            for (Locations.LibLocn libLocn : this.locations.getLibs()) {
                if (libLocn.kind != Locations.LibLocn.Kind.PACKAGE) continue;
                SearchPath p = this.useBootClassPath(libLocn.absClsDir) ? bcp : cp;
                p.append(libLocn.absClsDir);
                p.append(libLocn.absSrcDir);
            }
            cp.append(this.locations.absLibSrcJarList());
        }
        if (this.useModulePath()) {
            mp.append(this.locations.absLibClsList(Locations.LibLocn.Kind.USER_MODULE));
        }
        if (this.usePatchModules()) {
            pp.append(this.locations.absLibClsList(Locations.LibLocn.Kind.SYS_MODULE));
        }
        if (multiModule) {
            if (this.needJUnit || this.needTestNG) {
                if (this.needJUnit) {
                    this.params.getJUnitPath().asList().forEach(xva$0 -> mp.append((Path)xva$0));
                }
                if (this.needTestNG) {
                    this.params.getTestNGPath().asList().forEach(xva$0 -> mp.append((Path)xva$0));
                }
            }
        } else {
            SearchPath fp;
            SearchPath searchPath = fp = !bcp.isEmpty() || this.usePatchModules() ? bcp : cp;
            if (this.needJUnit) {
                fp.append(this.params.getJUnitPath());
            }
            if (this.needTestNG) {
                fp.append(this.params.getTestNGPath());
            }
        }
        JDK jdk = this.getCompileJDK();
        tp.append(jdk.getJDKClassPath());
        Map<String, String> envVars = this.getEnvVars();
        String cpa = envVars.get("CPAPPEND");
        if (cpa != null) {
            cpa = cpa.replace('/', File.separatorChar);
            cp.append(cpa);
        }
        if (include_jtreg) {
            (testOnBootClassPath ? bcp : cp).append(this.getJavaTestClassPath());
        }
        EnumMap<PathKind, SearchPath> map = new EnumMap<PathKind, SearchPath>(PathKind.class);
        if (!bcp.isEmpty()) {
            map.put(PathKind.BOOTCLASSPATH_APPEND, bcp);
        }
        if (!cp.isEmpty()) {
            map.put(PathKind.CLASSPATH, cp);
        }
        if (!mp.isEmpty()) {
            map.put(PathKind.MODULEPATH, mp);
        }
        if (!pp.isEmpty()) {
            map.put(PathKind.PATCHPATH, pp);
        }
        return map;
    }

    boolean useBootClassPath() {
        return this.useBootClassPath;
    }

    boolean usePatchModules() {
        return this.usePatchModules;
    }

    boolean hasTestPatchMods() {
        Path testModulesDir = this.locations.absTestPatchDir();
        if (Files.isDirectory(testModulesDir, new LinkOption[0])) {
            for (Path f : FileUtils.listFiles(testModulesDir)) {
                if (!Files.isDirectory(f, new LinkOption[0])) continue;
                return true;
            }
        }
        return false;
    }

    boolean useModulePath() {
        return this.useModulePath;
    }

    boolean hasTestUserMods() {
        Path testModulesDir = this.locations.absTestModulesDir();
        if (Files.isDirectory(testModulesDir, new LinkOption[0])) {
            for (Path f : FileUtils.listFiles(testModulesDir)) {
                if (!Files.isDirectory(f, new LinkOption[0])) continue;
                return true;
            }
        }
        return false;
    }

    ExecMode getExecMode() {
        return this.defaultExecMode;
    }

    SearchPath getJavaTestClassPath() {
        return this.params.getJavaTestClassPath();
    }

    boolean isJUnitRequired() {
        return this.needJUnit;
    }

    SearchPath getJUnitPath() {
        return this.params.getJUnitPath();
    }

    boolean isTestNGRequired() {
        return this.needTestNG;
    }

    SearchPath getTestNGPath() {
        return this.params.getTestNGPath();
    }

    SearchPath getAsmToolsPath() {
        return this.params.getAsmToolsPath();
    }

    SummaryReporter getTestNGSummaryReporter() {
        return SummaryReporter.forTestNG(this.workDir);
    }

    SummaryReporter getJUnitSummaryReporter() {
        return SummaryReporter.forJUnit(this.workDir);
    }

    Lock getLockIfRequired() throws TestRunException {
        try {
            if (!this.testSuite.needsExclusiveAccess(this.td)) {
                return null;
            }
        }
        catch (TestSuite.Fault e) {
            throw new TestRunException("Can't determine if lock required", e);
        }
        return Lock.get(this.params);
    }

    int getNextSerial() {
        return this.nextSerial++;
    }

    PrintWriter getMessageWriter() {
        return this.msgPW;
    }

    TimeoutHandlerProvider getTimeoutHandlerProvider() throws TestRunException {
        try {
            return this.params.getTimeoutHandlerProvider();
        }
        catch (MalformedURLException e) {
            throw new TestRunException("Can't get timeout handler provider", e);
        }
    }

    String getTestThreadFactory() {
        return this.params.getTestThreadFactory();
    }

    String getTestThreadFactoryPath() {
        return this.params.getTestThreadFactoryPath();
    }

    JDK getTestJDK() {
        return this.params.getTestJDK();
    }

    JDK_Version getTestJDKVersion() {
        return this.getTestJDK().getVersion(this.params, this.msgPW::println);
    }

    Path getJavaProg() {
        return this.params.getTestJDK().getJavaProg();
    }

    JDK getCompileJDK() {
        return this.params.getCompileJDK();
    }

    JDK_Version getCompileJDKVersion() {
        return this.getCompileJDK().getVersion(this.params, this.msgPW::println);
    }

    Path getJavacProg() {
        return this.params.getCompileJDK().getJavacProg();
    }

    Map<String, String> getTestProperties() {
        SearchPath pp;
        LinkedHashMap<String, String> p = new LinkedHashMap<String, String>(this.params.getBasicTestProperties());
        String testName = this.testResult.getTestName();
        p.put("test.name", testName);
        String testQuery = this.params.getTestQuery(testName);
        if (testQuery != null) {
            p.put("test.query", testQuery);
        }
        p.put("test.file", this.locations.absTestFile().toString());
        p.put("test.src", this.locations.absTestSrcDir().toString());
        p.put("test.src.path", this.toString(this.locations.absTestSrcPath()));
        p.put("test.classes", this.locations.absTestClsDir().toString());
        p.put("test.class.path", this.toString(this.locations.absTestClsPath()));
        if (this.getExecMode() == ExecMode.AGENTVM) {
            SearchPath path = new SearchPath().append(this.locations.absTestClsDir()).append(this.locations.absTestSrcDir()).append(this.locations.absLibClsList(Locations.LibLocn.Kind.PACKAGE)).append(this.locations.absLibSrcJarList());
            p.put("test.class.path.prefix", path.toString());
        }
        if (!this.modules.isEmpty()) {
            p.put("test.modules", this.modules.toString());
        }
        if (this.usePatchModules()) {
            pp = new SearchPath();
            pp.append(this.locations.absLibClsList(Locations.LibLocn.Kind.SYS_MODULE));
            p.put("test.patch.path", pp.toString());
        }
        if (this.useModulePath()) {
            pp = new SearchPath();
            pp.append(this.locations.absLibClsList(Locations.LibLocn.Kind.USER_MODULE));
            p.put("test.module.path", pp.toString());
        }
        if (this.enablePreview()) {
            p.put("test.enable.preview", "true");
        }
        p.put("test.root", this.getTestRootDir().getPath());
        return Collections.unmodifiableMap(p);
    }

    private String toString(List<Path> files) {
        return files.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator));
    }

    File getTestRootDir() {
        return this.params.getTestSuite().getRootDir();
    }

    Agent getAgent(JDK jdk, SearchPath classpath, List<String> testVMOpts, String testThreadFactory, String testThreadFactoryPath) throws Agent.Fault {
        JDKOpts vmOpts = new JDKOpts();
        vmOpts.addAll("-classpath", classpath.toString());
        vmOpts.addAll(testVMOpts);
        if (testThreadFactory != null) {
            vmOpts.add("-D" + MainWrapper.TEST_THREAD_FACTORY + "=" + testThreadFactory);
        }
        if (this.params.getTestJDK().hasModules()) {
            vmOpts.addAllPatchModules(new SearchPath(this.params.getWorkDirectory().getFile("patches").toPath()));
        }
        for (Agent agent : this.agents) {
            if (!agent.matches(this.absTestScratchDir().toFile(), jdk, vmOpts.toList())) continue;
            return agent;
        }
        HashMap<String, String> envVars = new HashMap<String, String>(this.getEnvVars());
        SearchPath cp = new SearchPath().append(jdk.getJDKClassPath()).append(this.getJavaTestClassPath());
        envVars.put("CLASSPATH", cp.toString());
        Agent.Pool p = Agent.Pool.instance(this.params);
        Agent agent = p.getAgent(this.absTestScratchDir().toFile(), jdk, vmOpts.toList(), envVars, testThreadFactory, testThreadFactoryPath);
        this.agents.add(agent);
        return agent;
    }

    void closeAgent(Agent agent) {
        agent.close();
        this.agents.remove(agent);
    }

    void closeAgents() {
        for (Agent agent : this.agents) {
            agent.close();
        }
        this.agents.clear();
    }

    void releaseAgents() {
        if (!this.agents.isEmpty()) {
            Agent.Pool pool = Agent.Pool.instance(this.params);
            for (Agent agent : this.agents) {
                pool.save(agent);
            }
        }
    }

    boolean useWindowsSubsystemForLinux() {
        return this.params.useWindowsSubsystemForLinux();
    }

    void saveScratchFile(Path file, Path dest) {
        this.scratchDirectory.retainFile(file.toFile(), dest.toFile());
    }

    private static String getVersion() {
        if (version == null) {
            StringBuilder sb = new StringBuilder();
            Version v = Version.getCurrent();
            sb.append(v.product == null ? "jtreg" : v.product);
            if (v.version != null) {
                sb.append(' ').append(v.version);
            }
            if (v.milestone != null) {
                sb.append(' ').append(v.milestone);
            }
            if (v.build != null) {
                sb.append(' ').append(v.build);
            }
            version = sb.toString();
        }
        return version;
    }

    static {
        LINESEP = System.getProperty("line.separator");
    }

    static class ParseActionsException
    extends Exception {
        static final long serialVersionUID = -3369214582449830917L;

        ParseActionsException(String msg) {
            super(msg);
        }
    }

    public static class TestClassException
    extends TestRunException {
        private static final long serialVersionUID = -5087319602062056951L;

        public TestClassException(String msg) {
            super("Test Class Exception: " + msg);
        }
    }

    static enum PathKind {
        BOOTCLASSPATH_APPEND,
        CLASSPATH,
        MODULEPATH,
        MODULESOURCEPATH,
        PATCHPATH,
        SOURCEPATH;

    }
}

